let pageState = {
	isScheduleDataAvailable:false,
	isPaymentHistoryDataAvailable:false,
	isSecuritiesDataAvailable:false,
	isGuarantorsDataAvailable:false
}

const getCookie = (name) => {
    let cookieValue = null;
    if (document.cookie && document.cookie !== '') {
        const cookies = document.cookie.split(';');
        for (let i = 0; i < cookies.length; i++) {
            const cookie = cookies[i].trim();
            // Does this cookie string begin with the name we want?
            if (cookie.substring(0, name.length + 1) === (name + '=')) {
                cookieValue = decodeURIComponent(cookie.substring(name.length + 1));
                break;
            }
        }
    }
    return cookieValue;
}

const csrftoken = getCookie('csrftoken');

//request data should be an object containing the Url and any other data need to make request
const getRequest = async (requestData) => {

    const requiredData = {
        method: 'GET',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRFToken': csrftoken,
        },
    }

    try{
        const response = await fetch(requestData.url, requiredData)
        const data = await response.json()
		if('status' in data){
			if(data.status === 'success'){
				return {
					'status':'success',
					'data': data
				}
			}else{
				return {
					'status':'failed',
				}
			}
		}else{
			return {
				'status':'failed',
			}
		}
    }catch(error){
        return {
            'status':'failed',
        }
    }
}

const scheduleDisplayResetter = () =>{
	document.querySelector('#loadedSchedules').style.display = 'none'
	document.querySelector('#spinnerSchedules').style.display = 'flex'
	document.querySelector('#errorSchedules').style.display = 'none'
}


const getScheduleData = async () =>{
	let reqData = {
		url:`${globalState.baseUrl}/new-loans/loan-schedule/${globalState.theId}/`
	}

	document.querySelector('#loadedSchedules').style.display = 'none'
	document.querySelector('#spinnerSchedules').style.display = 'flex'
	document.querySelector('#errorSchedules').style.display = 'none'

	let response = await getRequest(reqData)
	if(response.status === 'success'){
		document.querySelector('#loadedSchedules').innerHTML = response.data.data
		document.querySelector('#loadedSchedules').style.display = 'block'
		document.querySelector('#spinnerSchedules').style.display = 'none'
		pageState = {...pageState, isScheduleDataAvailable:true}
	}else{
		document.querySelector('#loadedSchedules').style.display = 'none'
		document.querySelector('#spinnerSchedules').style.display = 'none'
		document.querySelector('#errorSchedules').style.display = 'flex'
		showToast('Failed', 'Please try again later', 'error')
	}
}


//initial load of the schedules
$(document).ready(function(){
	getScheduleData()
});


const refreshSchedules = () =>{
	getScheduleData()
}

const refreshPaymentHistory = () =>{
	getPaymentHistoryData()
}

const refreshSecurities = () =>{
	getSecuritiesData()
}

const refreshGuarantors = () =>{
	getGuarantorsData()
}


const onChangeTab = (tab) =>{
	if(tab === 'schedule'){
		if(!pageState.isScheduleDataAvailable){
			getScheduleData()
		}
	}else if(tab === 'paymentHistory'){
		if(!pageState.isPaymentHistoryDataAvailable){
			getPaymentHistoryData()
		}
	}else if(tab === 'securities'){
		if(!pageState.isSecuritiesDataAvailable){
			getSecuritiesData()
		}
	}else if(tab === 'guarantors'){
		if(!pageState.isGuarantorsDataAvailable){
			getGuarantorsData()
		}
	}
}

const getPaymentHistoryData = async () =>{
	let reqData = {
		url:`${globalState.baseUrl}/new-loans/payment-history/${globalState.theId}/`
	}

	document.querySelector('#loadedPaymentHistory').style.display = 'none'
	document.querySelector('#spinnerPaymentHistory').style.display = 'flex'
	document.querySelector('#errorPaymentHistory').style.display = 'none'

	let response = await getRequest(reqData)
	if(response.status === 'success'){
		document.querySelector('#loadedPaymentHistory').innerHTML = response.data.data
		document.querySelector('#loadedPaymentHistory').style.display = 'block'
		document.querySelector('#spinnerPaymentHistory').style.display = 'none'
		pageState = {...pageState, isPaymentHistoryDataAvailable:true}
	}else{
		document.querySelector('#loadedPaymentHistory').style.display = 'none'
		document.querySelector('#spinnerPaymentHistory').style.display = 'none'
		document.querySelector('#errorPaymentHistory').style.display = 'flex'
		showToast('Failed', 'Please try again later', 'error')
	}
}

const getSecuritiesData = async () =>{
	let reqData = {
		url:`${globalState.baseUrl}/new-loans/loan-payment-security/${globalState.theId}/`
	}

	document.querySelector('#loadedSecurities').style.display = 'none'
	document.querySelector('#spinnerSecurities').style.display = 'flex'
	document.querySelector('#errorSecurities').style.display = 'none'

	let response = await getRequest(reqData)
	if(response.status === 'success'){
		document.querySelector('#loadedSecurities').innerHTML = response.data.data
		document.querySelector('#loadedSecurities').style.display = 'block'
		document.querySelector('#spinnerSecurities').style.display = 'none'
		pageState = {...pageState, isSecuritiesDataAvailable:true}
	}else{
		document.querySelector('#loadedSecurities').style.display = 'none'
		document.querySelector('#spinnerSecurities').style.display = 'none'
		document.querySelector('#errorSecurities').style.display = 'flex'
		showToast('Failed', 'Please try again later', 'error')
	}
}

const getGuarantorsData = async () =>{
	let reqData = {
		url:`${globalState.baseUrl}/new-loans/loan-guarantors/${globalState.theId}/`
	}

	document.querySelector('#loadedGuarantors').style.display = 'none'
	document.querySelector('#spinnerGuarantors').style.display = 'flex'
	document.querySelector('#errorGuarantors').style.display = 'none'

	let response = await getRequest(reqData)
	if(response.status === 'success'){
		document.querySelector('#loadedGuarantors').innerHTML = response.data.data
		document.querySelector('#loadedGuarantors').style.display = 'block'
		document.querySelector('#spinnerGuarantors').style.display = 'none'
		pageState = {...pageState, isGuarantorsDataAvailable:true}
	}else{
		document.querySelector('#loadedGuarantors').style.display = 'none'
		document.querySelector('#spinnerGuarantors').style.display = 'none'
		document.querySelector('#errorGuarantors').style.display = 'flex'
		showToast('Failed', 'Please try again later', 'error')
	}
}

