let state = {
    current_acc_type:'',
    current_charge:'',
    baseUrl: global_state.baseUrl ,
    accTypesJson:JSON.parse(global_state.accTypesJson) ,
    transactionChargesJson:JSON.parse(global_state.transactionChargesJson)
}

state = {...state, current_charge: 'Deposit charge', current_acc_type: global_state.firstId}
console.log(state.current_charge)
console.log(state.current_acc_type)
let addButton = '#addButton' + state.current_acc_type
// console.log(addButton)
// console.log(document.querySelector(addButton))
// document.querySelector(addButton).innerHTML = 'Add '+ state.current_charge


// #### setting the current tab and current account type
// onPressing tab check current active link and update state update button html
function checkCurrentTab(theId){
    console.log(theId)
    let returnValue
    $(theId).each(function (){
        if ($(this).hasClass('active')) {
            // console.log($(this).attr('href').toString())
            returnValue = $(this).attr('href').replace(/[0-9]/g, '')
        }
    });
    return returnValue
}

function onChangeThePercOrAmt(){
    document.querySelector('#charge_range_varry').value = 0
    if(document.querySelector('#amt_percentage_varry').value === 'p'){
        //set attribute
        document.querySelector('#charge_range_varry').setAttribute("maxlength", "3");
    }else{
        document.querySelector('#charge_range_varry').setAttribute("maxlength", "255");
    }
}


function onChangeThePercOrAmtFlat(){
    document.querySelector('#charge_for_flat').value = 0
    if(document.querySelector('#amt_percentage_flat').value === 'p'){
        //set attribute
        document.querySelector('#charge_for_flat').setAttribute("maxlength", "3");
    }else{
        document.querySelector('#charge_for_flat').setAttribute("maxlength", "255");
    }
}

function onChangeThePercOrAmtFlatEdit(){
    console.log('nigggaaa')
    document.querySelector('#edit_charge_for_flat').value = 0
    if(document.querySelector('#edit_amt_percentage_flat').value === 'p'){
        //set attribute
        document.querySelector('#edit_charge_for_flat').setAttribute("maxlength", "3");
    }else{
        document.querySelector('#edit_charge_for_flat').setAttribute("maxlength", "255");
    }
}

function onClickCollapseButton(current_acc_type){
    let currentDefaultLi = '#defaultTab'+current_acc_type+' li a'
    let thecurrent_charge_type = checkCurrentTab(currentDefaultLi)
    // #remove '#' and '_'
    thecurrent_charge_type = thecurrent_charge_type.replace('#','')
    thecurrent_charge_type = thecurrent_charge_type.replace('_',' ')
    state = {...state, current_acc_type: current_acc_type, current_charge: thecurrent_charge_type}
    // console.log(state.current_acc_type, state.current_charge)
    let addButton = '#addButton' + state.current_acc_type
    document.querySelector(addButton).innerHTML = 'Add '+ state.current_charge
}

function thousandSeprator(m) {
    if (m !== "" || m !== undefined || m !== 0 || m !== "0" || m !== null) {
        let intergerSide
        if(m.toString().includes('.')){
            let theAmount = m.toString().split(".")
            intergerSide = theAmount[0].replace(/[^\d.]+/g, "").replace(/\B(?=(\d{3})+(?!\d))/g, ",");
            intergerSide = intergerSide +'.'+ theAmount[1]
        }else{
            intergerSide = m.toString().replace(/[^\d.]+/g, "").replace(/\B(?=(\d{3})+(?!\d))/g, ",");
        }
      return intergerSide
    } else {
      return m;
    }
}


function onTabChange(charge_type){
    thecurrent_charge_type = charge_type.replace('#','')
    thecurrent_charge_type = thecurrent_charge_type.replace('_',' ')
    state = {...state, current_charge: thecurrent_charge_type}
    let addButton = '#addButton' + state.current_acc_type
    document.querySelector(addButton).innerHTML = 'Add '+ state.current_charge
    console.log(state)
}

function onClickAdd(){
    // console.log('click add running')
    document.querySelector('#modalTitle').innerHTML = 'Add new  ' + state.current_charge
    document.querySelector('#modalAddButton').innerHTML = 'Add ' + state.current_charge

    // #### setting the minimum and maximum amts
    // set minnimum
    let d = 'Deposit charge'
    let w = 'Withdraw charge'
    let t = 'Transfer charge'
    let newTransactCharges
    if(state.current_charge === 'Deposit charge'){
        newTransactCharges = state.transactionChargesJson.filter((charge)=>{
            if(parseInt(charge.account_type_id)===parseInt(state.current_acc_type)&& charge.charge_type==='d'){
                return charge
            }
        })
    }else if(state.current_charge === 'Withdraw charge'){
        newTransactCharges = state.transactionChargesJson.filter((charge)=>{
            if(parseInt(charge.account_type_id)===parseInt(state.current_acc_type)&& charge.charge_type==='w'){
                return charge
            }
        })
    }else{
        newTransactCharges = state.transactionChargesJson.filter((charge)=>{
            if(parseInt(charge.account_type_id)===parseInt(state.current_acc_type)&& charge.charge_type==='t'){
                return charge
            }
        })
    }

    // #determine the current start value
    theCurrentStartValue = 0
    if(newTransactCharges.length>0){
        console.log(newTransactCharges)
        lastChargeObj = newTransactCharges.at(-1)
        console.log(lastChargeObj)
        lastEndValue = parseFloat(lastChargeObj.end)
        theCurrentStartValue = lastEndValue + 1
    }

    //check if current account type has variation enabled
    let theVariation = false
    state.accTypesJson.forEach((theType)=>{
        if(parseInt(theType.id)=== parseInt(state.current_acc_type)){
            if(state.current_charge === 'Deposit charge'){
                theVariation = theType.deposit_charge_vary
            }else if(state.current_charge === 'Withdraw charge'){
                theVariation = theType.withdraw_charge_vary
            }else{
                theVariation = theType.transfer_charge_vary
            }
        }
    })

    // console.log(theVariation)

    if(theVariation){
        document.querySelector('#flat_charge').style.display = 'none'
        document.querySelector('#varry_div').style.display = 'block'
    }else{
        document.querySelector('#varry_div').style.display = 'none'
        document.querySelector('#flat_charge').style.display = 'block'
    }

    // console.log(state)

    document.querySelector('#minimum_amt').value = thousandSeprator(parseFloat(theCurrentStartValue))
    document.querySelector('#maximum_amt').placeholder = `Enter maximum not less than ${thousandSeprator(parseFloat(theCurrentStartValue)+1)}`
}

function handleSubmit(){
    // ### do the check
    let theVariation = false
    state.accTypesJson.forEach((theType)=>{
        if(parseInt(theType.id)=== parseInt(state.current_acc_type)){
            if(state.current_charge === 'Deposit charge'){
                theVariation = theType.deposit_charge_vary
            }else if(state.current_charge === 'Withdraw charge'){
                theVariation = theType.withdraw_charge_vary
            }else{
                theVariation = theType.transfer_charge_vary
            }
        }
    })

    // console.log(theVariation)

    let callSubmit =true

    if(theVariation){
        let charge_range = document.querySelector('#charge_range_varry')
        let minimum_amt = document.querySelector('#minimum_amt')
        let maximum_amt = document.querySelector('#maximum_amt')
        let amt_percentage_varry = document.querySelector('#amt_percentage_varry')

        // console.log(minimum_amt.value)
        // console.log(maximum_amt.value)


        if(charge_range.value.trim() === '' || minimum_amt.value.trim() === ''|| maximum_amt.value.trim() ===''|| amt_percentage_varry.value ===''){
            new PNotify( {
                title: "Error", text: 'All field must be filled', type: 'error'
            });
            callSubmit =false
        }
        if(minimum_amt.value.trim() !== '' && maximum_amt.value !==''){
            if(parseFloat(minimum_amt.value.replace(/,/g,'')) > parseFloat(maximum_amt.value.replace(/,/g,''))){
                // console.log('it has passed')
                new PNotify( {
                    title: "Error", text: 'Maximum amount should be greater than minimum amount', type: 'error'
                });
                callSubmit =false
            }
        }
        if(amt_percentage_varry.value !== ''){
            if(amt_percentage_varry.value ==='p'){
                if(parseFloat(charge_range.value) > parseFloat(100)){
                    new PNotify( {
                        title: "Error", text: 'Please provide a valid percentage', type: 'error'
                    });
                    callSubmit =false
                }

            }

        }

        if(callSubmit){
            let theCharge
            if(state.current_charge === 'Deposit charge'){
                theCharge='d'
            }else if(state.current_charge === 'Withdraw charge'){
                theCharge='w'
            }else{
                theCharge='t'
            }
            // console.log(document.querySelector('#submitting'))

            doAddTransactionCharge(theCharge, 'varry')
        }

    }else{
        let charge_range = document.querySelector('#charge_for_flat')
        let amt_percentage_flat = document.querySelector('#amt_percentage_flat')

        if(charge_range.value.trim() === '' || amt_percentage_flat.value === ''){
            new PNotify( {
                title: "Error", text: 'All field must be filled', type: 'error'
            });
            callSubmit =false
        }else if(amt_percentage_flat.value !== ''){
            if(amt_percentage_flat.value ==='p'){
                if(parseFloat(charge_range.value.replace(/,/g,'')) > parseFloat(100)){
                    new PNotify( {
                        title: "Error", text: 'Please provide a valid percentage', type: 'error'
                    });
                    callSubmit =false
                }
            }
        }

        //check if there is an existing flat charge
        state.transactionChargesJson.forEach


        if(callSubmit){
            let theCharge
            if(state.current_charge === 'Deposit charge'){
                theCharge='d'
            }else if(state.current_charge === 'Withdraw charge'){
                theCharge='w'
            }else{
                theCharge='t'
            }

            //check if there is an existing flat charge
            const currentCharges = state.transactionChargesJson.filter((charge)=>{
                if(charge.charge_type === theCharge && parseInt(charge.account_type_id) === parseInt(state.current_acc_type)){
                    return charge
                }
            })

            if(currentCharges.length>0){
                new PNotify( {
                    title: "Error", text: 'There can only be one flat charge. Please change variation settings in savings products', type: 'error'
                });
            }else{
                doAddTransactionCharge(theCharge, 'flat')
            }

        }
    }
}


function doAddTransactionCharge(charge_type, variation){
    // console.log(charge_type)
    // console.log('running the adding')
    let theSubmitData
    if(variation === 'flat'){
        theSubmitData ={
            'is_charge_percentage':document.querySelector('#amt_percentage_flat').value,
            'charge_range': parseFloat(document.querySelector('#charge_for_flat').value.replace(/,/g,'')),
            'charge_type': charge_type,
            'csrfmiddlewaretoken' : $("input[name=csrfmiddlewaretoken]").val()
        }
    }else{
        theSubmitData ={
            'start': parseFloat(document.querySelector('#minimum_amt').value.replace(/,/g,'')),
            'end': parseFloat(document.querySelector('#maximum_amt').value.replace(/,/g,'')),
            'charge_range': parseFloat(document.querySelector('#charge_range_varry').value.replace(/,/g,'')),
            'charge_type': charge_type,
            'is_charge_percentage':document.querySelector('#amt_percentage_varry').value,
            'csrfmiddlewaretoken' : $("input[name=csrfmiddlewaretoken]").val()
        }

    }

    document.querySelector('#submitting').style.display = 'block'
    document.querySelector('#modalAddButton').style.display = 'none'
    // console.log(document.querySelector('#submitting'))
    let baseUrl = global_state.baseUrl
    // console.log(baseUrl+'/add-transaction-charges/'+state.current_acc_type.toString())
    $.ajax({
        type: "POST",
        url:baseUrl+'/add-transaction-charges/'+state.current_acc_type.toString(),
        data: theSubmitData,

        dataType: 'json',
        success: function (data) {

          if (data.addition === 'successful') {
              console.log(data)
              document.querySelector('#replaceBody').innerHTML = data.updatedTemplate
                document.querySelector('#submitting').style.display = 'none'
                document.querySelector('#modalAddButton').style.display = 'block'
                $('#addChargeModal').modal('hide')
                new PNotify( {
                    title: "Added", text: 'Transaction charge was added successfully', type: 'success'
                });
              state = {...state, transactionChargesJson:data.transactionChargesJson }
              document.querySelector('#maximum_amt').value = ''
              document.querySelector('#charge_range_varry').value = '0'
              // document.querySelector('#charge_range_varry').value = ''

              state = {...state, current_charge: 'Deposit charge', current_acc_type: global_state.firstId}

          }else if(data.addition === 'failed'){
                if(data.details==='Please first refresh to get updated savings products settings'){
                    new PNotify( {
                        title: "Not allowed", text: 'Please first refresh this page to get updated information', type: 'error'
                    });
                    document.querySelector('#submitting').style.display = 'none'
                    document.querySelector('#modalAddButton').style.display = 'block'
                }


            }

        }

        ,
        error: function(){
            console.log('there is an error')
            new PNotify( {
                title: "Connection failed", text: 'Please try again later', type: 'error'
            });
            document.querySelector('#submitting').style.display = 'none'
        }
    });
}

function setEditData(id){

    $('#editTransactionCharge').modal('show')
    // console.log(data)
    let editObj = ''
    state.transactionChargesJson.forEach((charge)=>{
        if(parseInt(charge.id) === parseInt(id) ){
            editObj = charge
        }
    })

    // console.log(editObj)

    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    let theVariation = false
    console.log(state.accTypesJson)
    state.accTypesJson.forEach((theType)=>{
        if(parseInt(theType.id)=== parseInt(editObj.account_type_id)){
            if(editObj.charge_type === 'd'){
                theVariation = theType.deposit_charge_vary
            }else if(editObj.charge_type === 'w'){
                theVariation = theType.withdraw_charge_vary
            }else{
                theVariation = theType.transfer_charge_vary
            }
        }
    })

    if(theVariation){
        document.querySelector('#edit_minimum_amt').value = thousandSeprator(parseFloat(editObj.start))
        document.querySelector('#edit_maximum_amt').value = thousandSeprator(parseFloat(editObj.end))
        document.querySelector('#edit_charge_range').value = thousandSeprator(parseFloat(editObj.charge))
        document.querySelector('#edit_flat_charge').style.display = 'none'

        if(editObj.is_charge_percentage){
            document.querySelector('#edit_amt_percentage_varry').value = 'p'
        }else{
            document.querySelector('#edit_amt_percentage_varry').value = 'a'
        }


        document.querySelector('#edit_varry_div').style.display = 'block'

    }else{
        document.querySelector('#edit_varry_div').style.display = 'none'
        document.querySelector('#edit_flat_charge').style.display = 'block'
        if(editObj.is_charge_percentage){
            document.querySelector('#edit_amt_percentage_flat').value = 'p'
        }else{
            document.querySelector('#edit_amt_percentage_flat').value = 'a'
        }
        document.querySelector('#edit_charge_for_flat').value = thousandSeprator(parseFloat(editObj.charge))

    }
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++



    if (editObj !== ''){


        // #set button value to id
        document.querySelector('#update_button_after_edit').value = id.toString()
    }
}

function handleEditSubmit(event){

    let editObj = ''
    state.transactionChargesJson.forEach((charge)=>{
        if(parseInt(charge.id) === parseInt(document.querySelector('#update_button_after_edit').value) ){
            editObj = charge
        }
    })

    // console.log(editObj)

    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    let theVariation = false
    // console.log(state.accTypesJson)
    state.accTypesJson.forEach((theType)=>{
        if(parseInt(theType.id)=== parseInt(editObj.account_type_id)){
            if(editObj.charge_type === 'd'){
                theVariation = theType.deposit_charge_vary
            }else if(editObj.charge_type === 'w'){
                theVariation = theType.withdraw_charge_vary
            }else{
                theVariation = theType.transfer_charge_vary
            }
        }
    })


    // console.log(theVariation)

    let callSubmit =true
    let theId = document.querySelector('#update_button_after_edit').value

    if(theVariation){
        let charge_range = document.querySelector('#edit_charge_range')
        let minimum_amt = document.querySelector('#edit_minimum_amt')
        let maximum_amt = document.querySelector('#edit_maximum_amt')
        let amt_percentage_varry = document.querySelector('#edit_amt_percentage_varry')


        if(charge_range.value.trim() === '' || minimum_amt.value.trim() === ''|| maximum_amt.value.trim() ===''|| amt_percentage_varry.value ===''){
            new PNotify( {
                title: "Error", text: 'All field must be filled', type: 'error'
            });
            callSubmit =false
        }

        if(minimum_amt.value.trim() !== '' && maximum_amt.value !==''){
            if(parseFloat(minimum_amt.value.replace(/,/g,'')) > parseFloat(maximum_amt.value.replace(/,/g,''))){
                console.log('it has passed')
                new PNotify( {
                    title: "Error", text: 'Maximum amount should be greater than minimum amount', type: 'error'
                });
                callSubmit =false
            }
        }


        if(amt_percentage_varry.value !== ''){
            if(amt_percentage_varry.value ==='p'){
                if(parseFloat(charge_range.value.replace(/,/g,'')) > parseFloat(100)){
                    new PNotify( {
                        title: "Error", text: 'Please provide a valid percentage', type: 'error'
                    });
                    callSubmit =false
                }
            }
        }

        // console.log(callSubmit)
        if(callSubmit){
            doUpdateTransactionCharge(theId, 'varry')
        }

    }else{
        let charge_range = document.querySelector('#edit_charge_for_flat')
        let amt_percentage_flat = document.querySelector('#edit_amt_percentage_flat')

        if(charge_range.value === '' || amt_percentage_flat.value === ''){
            new PNotify( {
                title: "Error", text: 'All field must be filled', type: 'error'
            });
            callSubmit =false
        }else if(amt_percentage_flat.value !== ''){
            if(amt_percentage_flat.value ==='p'){
                if(parseFloat(charge_range.value.replace(/,/g,'')) > parseFloat(100)){
                    new PNotify( {
                        title: "Error", text: 'Please provide a valid percentage', type: 'error'
                    });
                    callSubmit =false
                }
            }

        }


        if(callSubmit){
            doUpdateTransactionCharge(theId, 'flat')
        }
    }
}

function doUpdateTransactionCharge(id, variation){

    let baseUrl = global_state.baseUrl

    let theSubmitData
    if(variation === 'flat'){
        theSubmitData ={
            'is_charge_percentage':document.querySelector('#edit_amt_percentage_flat').value,
            'charge_range': parseFloat(document.querySelector('#edit_charge_for_flat').value.replace(/,/g,'')),
            // 'charge_type': charge_type,
            'csrfmiddlewaretoken' : $("input[name=csrfmiddlewaretoken]").val()
        }
    }else{
        theSubmitData ={
            'start': parseFloat(document.querySelector('#edit_minimum_amt').value.replace(/,/g,'')),
            'end': parseFloat(document.querySelector('#edit_maximum_amt').value.replace(/,/g,'')),
            'charge_range': parseFloat(document.querySelector('#edit_charge_range').value.replace(/,/g,'')),
            // 'charge_type': charge_type,
            'is_charge_percentage':document.querySelector('#edit_amt_percentage_varry').value,
            'csrfmiddlewaretoken' : $("input[name=csrfmiddlewaretoken]").val()
        }

    }

    $.ajax({
        type: "POST",
        url:baseUrl+'/edit-transaction-charge/'+id.toString(),
        data: theSubmitData,

        dataType: 'json',
        success: function (data) {

          if (data.update === 'successful') {
              // console.log(data)
              document.querySelector('#replaceBody').innerHTML = data.updatedTemplate
                document.querySelector('#submitting').style.display = 'none'
                document.querySelector('#update_button_after_edit').style.display = 'block'
                $('#editTransactionCharge').modal('hide')
                new PNotify( {
                    title: "Updated", text: 'Transaction charge has been updated successfully', type: 'success'
                });
              state = {...state, transactionChargesJson:data.transactionChargesJson }
              console.log(state.current_charge)
              console.log(state.current_acc_type)
              state = {...state, current_charge: 'Deposit charge', current_acc_type: global_state.firstId}
              console.log(state.current_charge)
              console.log(state.current_acc_type)

          }else if (data.update === 'failed'){
              if(data.detail == 'Start and end should be small than the last maximum amount'){
                  document.querySelector('#submitting').style.display = 'none'
                    document.querySelector('#update_button_after_edit').style.display = 'block'
                    // $('#editTransactionCharge').modal('hide')
                    new PNotify( {
                        title: "Update failed", text: 'Minimum and maximum amount should be smaller than the last maximum amount of the last range', type: 'error'
                    });

              }else{
                  // document.querySelector('#replaceBody').innerHTML = data.updatedTemplate
                document.querySelector('#submitting').style.display = 'none'
                document.querySelector('#update_button_after_edit').style.display = 'block'
                // $('#editTransactionCharge').modal('hide')
                new PNotify( {
                    title: "Update failed", text: 'Transaction charge range already exists', type: 'error'
                });
              // state = {...state, transactionChargesJson:data.transactionChargesJson }

              }

          }
        },
        error: function(){
            console.log('there is an error')
            new PNotify( {
                title: "Connection failed", text: 'Please try again later', type: 'error'
            });
            document.querySelector('#submitting').style.display = 'none'
        }
    });
}