// console.log('This is another file')
// console.log(state.testVariable)


function addDays(date, days) {
  var result = new Date(date);
  result.setDate(result.getDate() + days);
  return result;
}

function setYearEndDate(){
    //check if start date is complete
    start_date = document.querySelector('#startDate').value
    console.log(start_date)
    // var date_regex = /^(0[1-9]|1[0-2])\/(0[1-9]|1\d|2\d|3[01])\/(19|20)\d{2}$/;
    var regex_date = /^\d{4}\-\d{1,2}\-\d{1,2}$/;
    if ((regex_date.test(start_date))) {

        // console.log
        // if year is divisible by 4 then 365 else 364
        let add_days = 364
        if(parseInt(start_date.substring(0, 4))%4 === 0){
            add_days=365
        }

        let endYearDate = addDays(start_date, add_days)
        // console.log('end date')
        // console.log(endYearDate.toISOString().split('T')[0])
        document.querySelector('#endDate').value = endYearDate.toISOString().split('T')[0]
    }
}

function setYearEndDateEdit(){
    //check if start date is complete
    start_date = document.querySelector('#edit_start_date').value
    // var date_regex = /^(0[1-9]|1[0-2])\/(0[1-9]|1\d|2\d|3[01])\/(19|20)\d{2}$/;
    var regex_date = /^\d{4}\-\d{1,2}\-\d{1,2}$/;
    if ((regex_date.test(start_date))) {
        let add_days = 364
        if(parseInt(start_date.substring(0, 4))%4 === 0){
            add_days=365
        }

        let endYearDate = addDays(start_date, add_days)
        // console.log('end date')
        // console.log(endYearDate.toISOString().split('T')[0])
        document.querySelector('#edit_end_date').value = endYearDate.toISOString().split('T')[0]
    }
}

function setEditData(id, data){
    // console.log(data)
    // console.log(id)
    $('#editFinancialYear').modal('show')
    // console.log(data)
    let editObj = ''
    data.forEach((year)=>{
        if(parseInt(year.id) === parseInt(id) ){
            editObj = year
        }
    })
    if (editObj !== ''){
        document.querySelector('#edit_name').value = editObj.name
        document.querySelector('#edit_start_date').value = editObj.start_date
        document.querySelector('#edit_end_date').value = editObj.end_date
        // #set button value to id
        document.querySelector('#update_button_after_edit').value = id.toString()
    }
}

function updateTable(data){
    let currentIndex = 0

    document.querySelector('#types_table_rows').innerHTML = ''

    data.forEach((year)=>{
        //create tree element
        let newTr = document.createElement('tr');
        //create counter and set value
        let new_td_number = document.createElement('td');
        currentIndex = currentIndex +1
        new_td_number.innerHTML = currentIndex
        newTr.appendChild(new_td_number)
        //create name td and set value
        let new_td_name = document.createElement('td');
        new_td_name.innerHTML = year.name
        newTr.appendChild(new_td_name)
        //setting start date
        let new_td_start_date = document.createElement('td');
        new_td_start_date.innerHTML = year.start_date
        newTr.appendChild(new_td_start_date)
        //setting end date
        let new_td_end_date = document.createElement('td');
        new_td_end_date.innerHTML = year.end_date
        newTr.appendChild(new_td_end_date)


        // #create button
        let editButton = document.createElement('button');
        editButton.innerHTML = '<i class="fa fa-solid fa-pencil"></i> Edit'
        editButton.classList.add("btn")
        editButton.classList.add("btn-info")
        editButton.classList.add("mr-3")
        editButton.addEventListener("click", setEditData.bind(event,year.id, data))
        let button_td = document.createElement('td');

        let theEndDate = Date.parse(year.end_date)
        let theCurrentDate = Date.parse(new Date())

        if(theCurrentDate<theEndDate){
            button_td.appendChild(editButton)
        }

        let deleteButton = document.createElement('button');
        deleteButton.innerHTML = '<i class="fa fa-solid fa-trash"></i> Delete'

        deleteButton.classList.add("btn")
        deleteButton.classList.add("btn-danger")
        deleteButton.classList.add("mr-3")

        let linkWrapper = document.createElement('a');
        linkWrapper.href = finance_state.baseUrl + '/'+ 'delete-financial-year'+ '/' + year.id
        linkWrapper.appendChild(deleteButton)
        button_td.appendChild(linkWrapper)

        newTr.appendChild(button_td)

        document.querySelector('#types_table_rows').appendChild(newTr)
    })
}


function doUpdateYear(id){
    let baseUrl = document.querySelector('#baseUrl').value
    $.ajax({
        type: "POST",
        url:baseUrl+'update-financial-year/'+id.toString(),
        data: {
          'name': document.querySelector('#edit_name').value,
          'start_date': document.querySelector('#edit_start_date').value,
          'end_date': document.querySelector('#edit_end_date').value,
            'csrfmiddlewaretoken' : $("input[name=csrfmiddlewaretoken]").val()
        },
        dataType: 'json',
        success: function (data) {
          if (data.update === 'success') {
              new PNotify( {
                title: "Updated", text: 'Financial year updated successfully', type: 'success'
                });
              updateTable(data.financialYearsJson)
              document.querySelector('#submitting').style.display = 'none'
              $('#editFinancialYear').modal('hide')
          }else if(data.detail === 'date range in use'){
              new PNotify( {
                title: "Error", text: 'Given range of dates already exist to another year', type: 'error'
            });
            document.querySelector('#submitting').style.display = 'none'
          }
          else{
            new PNotify( {
                title: "Error", text: 'Account type name already exists', type: 'error'
            });
            document.querySelector('#submitting').style.display = 'none'
          }
        },
        error: function(){
            console.log('there is an error')
            new PNotify( {
                title: "Connection failed", text: 'Please try again later', type: 'error'
            });
            document.querySelector('#submitting').style.display = 'none'
        }
    });
}




function handleEditSubmit(event){
    // event.preventDefault()
    // #check if all the required fields are available


    if(document.querySelector('#edit_name').value.trim() ===''|| document.querySelector('#edit_start_date').value.trim()===''||document.querySelector('#edit_end_date').value.trim()===''){
        new PNotify( {
            title: "Fields missing", text: 'All fields must have values', type: 'error'
        });
    }else{
        let theId = document.querySelector('#update_button_after_edit').value
        // console.log(theId)
        document.querySelector('#submitting').style.display = 'block'
        doUpdateYear(theId)
    }
}

document.querySelector('#edit_form').addEventListener("submit", handleEditSubmit);

function doSearch(){
    console.log(document.querySelector('#baseUrl').value + 'search-financial-year')
    $.ajax({
        type: "POST",
        url: document.querySelector('#baseUrl').value + 'search-financial-year',
        data: {
            'search_text' : document.querySelector('#search_acc').value,
            'csrfmiddlewaretoken' : $("input[name=csrfmiddlewaretoken]").val()
        },
        success: searchSuccess,
        dataType: 'html'
    });
}


function searchSuccess(data, textStatus, jqXHR)
{
    document.getElementById("types_table_rows").innerHTML=data;
    // {$('#search-results').html(data)}
}

