import calendar
import datetime
import re

from django.db.models import Sum

from accounts.models import Branch
from loans.models import Loans, LoanTypes, IntervalChoices, UploadLoans, ApplicationAccountOrLoanType, LoanCharges, \
    LoanTopups
from loans.utils.amortisation import loan_payment_details
from loans.utils.loan_number_creation import get_new_loan_number
from loans.utils.loan_details import update_loan_summary_details
from transactions.models import Account, Transactions, AccountCategory
import datetime
from pandas import Timestamp
import pandas as pd


def trim_lower_case_dictionary_keys(dictionary):
    trimmed_dict = {}
    for key, value in dictionary.items():
        trimmed_key = key.strip().lower()
        trimmed_dict[trimmed_key] = str(value).strip()
    return trimmed_dict

def trim_lower_case_list_keys(list):
    new_list = []
    for the_key in list:
        new_list.append(the_key.strip().lower())
    return new_list

def get_date_key(list):
    date_key = ''
    for the_key in list:
        if the_key.strip().lower() == 'date':
            date_key = the_key
    return date_key


def check_loan_top_up_fields_xlsx(data, apply_charges_from ):
    fields = ['loan number', 'requested amount', 'charge', 'date', 'duration']
    fields_missing = []
    for field in fields:
        if field == 'charge':
            if apply_charges_from == 'excel':
                if not field in data:
                    fields_missing.append(field)
        else:
            if not field in data:
                fields_missing.append(field)
    return fields_missing

def create_loan_upload_record(values_submitted, data_count, branch_data, user_data ):
    loan_upload_obj = UploadLoans.objects.create(
        file_name='',
        file=values_submitted['upload_file'],
        total_records=data_count,
        branch_id=branch_data,
        upload_date=values_submitted['udate'],
        added_by_id=user_data
    )
    return loan_upload_obj


def get_top_up_upload_submitted_values(request) -> dict:
    return{
        'upload_file': request.FILES['top_proof'],
        'udate': datetime.datetime.strptime(request.POST['top_udate'], '%Y-%m-%d').date(),
        'credited': request.POST['top_credited'],
        'narration':request.POST['top_narration'],
        # 'charge_application': request.POST['top_charge_application'],
        'apply_charges_from':request.POST['top_apply_charges_from'],
        'interest_include':request.POST['top_interest_include'],
        'excel_amount_include_charge': request.POST['top_excel_amount_include_charge'],
        'top_charges_debitted_acc': request.POST['top_charges_debitted_acc']
    }


def get_loan_interest_receivables_balance(business_data, loan):
    loan_interest_receivables_acc = Account.objects.filter(name='loan interest receivables', business=business_data)
    if loan_interest_receivables_acc.exists():
        loan_interest_receivables_acc = loan_interest_receivables_acc.first()
    else:
        loan_interest_receivables_acc = Account.objects.create(
            name='loan interest receivables', business=business_data,
            display_name='loan interest receivables',
            category=AccountCategory.objects.filter(name='Account Receivables', business=business_data).first(),
        )
    loan_interest_receivables_debits = Transactions.objects.filter(
        account_dr=loan_interest_receivables_acc, loan=loan
    ).aggregate(Sum('reporting_amount'))['reporting_amount__sum']
    if loan_interest_receivables_debits is None:
        loan_interest_receivables_debits = 0
    loan_interest_receivables_credits = Transactions.objects.filter(
        account_cr=loan_interest_receivables_acc, loan=loan
    ).aggregate(Sum('reporting_amount'))['reporting_amount__sum']
    if loan_interest_receivables_credits is None:
        loan_interest_receivables_credits = 0

    return loan_interest_receivables_debits - loan_interest_receivables_credits



def gen_interval(interval, formula):
    year = datetime.datetime.now().year
    month = datetime.datetime.now().month
    if formula == LoanTypes.LOAN_FORMULA.PER_ANNAM:
        if interval == IntervalChoices.YEARS:
            interval = 1
        elif interval == IntervalChoices.MONTHS:
            interval = 12
        elif interval == IntervalChoices.DAYS:
            days_in_year = (datetime.date(year, 12, 31) - datetime.date(year, 1, 1)).days + 1
            interval = days_in_year
        elif interval == IntervalChoices.WEEKS:
            num_weeks = datetime.date(year, 12, 28).isocalendar()[1]
            interval = num_weeks
    elif formula == LoanTypes.LOAN_FORMULA.PER_MONTH:
        if interval == IntervalChoices.DAYS:
            days_in_month = calendar.monthrange(year, month)[1]
            interval = days_in_month
        elif interval == IntervalChoices.WEEKS:
            num_days = calendar.monthrange(year, month)[1] # num of days in month
            weeks_in_month = (num_days + 6) // 7
            interval = weeks_in_month
        elif interval == IntervalChoices.FORTNIGHT:
            interval = 4
        elif interval == IntervalChoices.MONTHS:
            interval = 1
    elif formula == LoanTypes.LOAN_FORMULA.PER_DAY:
        interval = 1
    return interval

def get_total_interest_flat(loan):
    return loan.amount_approved * loan.rate * loan.approved_duration

def get_receivable_acc_and_loan_interest_receivables_acc(business_data):
    loan_interest_receivables_acc = Account.objects.filter(name='loan interest receivables', business=business_data)
    if loan_interest_receivables_acc.exists():
        loan_interest_receivables_acc = loan_interest_receivables_acc.first()
    else:
        loan_interest_receivables_acc = Account.objects.create(
            name='loan interest receivables', business=business_data,
            display_name='loan interest receivables',
            category=AccountCategory.objects.get(name='Account Receivables', business=business_data),
        )

    receivable_acc = Account.objects.filter(name='Loan Receivables', business=business_data).first()

    return{
        'loan_interest_receivables_acc':loan_interest_receivables_acc,
        'receivable_acc':receivable_acc
    }

def get_or_create_excess_payment_acc(business_data):
    excess_payments_acc = Account.objects.filter(name='suspense account', business=business_data)
    if excess_payments_acc.exists():
        excess_payments_acc = excess_payments_acc.first()
    else:
        excess_payments_acc = Account.objects.create(
            name='suspense account', business=business_data,
            display_name='suspense account',
            category=AccountCategory.objects.get(name='Reserves', business=business_data),
        )
    return excess_payments_acc





def determine_amount_paid_principal_and_interest(business_data, loan, excel_loan):
    rate_in_decimal = loan.rate / 100
    ammortize = loan_payment_details(loan.rate_type, rate_in_decimal, loan.amount_approved, loan.approved_duration, loan.interval, loan.loan_type.formula, acc=loan.account, loan=loan)
    schedules = ammortize.gen_schedules()
    schedules = schedules.to_dict('records')

    loan_interest_receivables_acc = Account.objects.filter(name='loan interest receivables', business=business_data)
    if loan_interest_receivables_acc.exists():
        loan_interest_receivables_acc = loan_interest_receivables_acc.first()
    else:
        # print('THIS IS BUSINESS', business_data)
        loan_interest_receivables_acc = Account.objects.create(
            name='loan interest receivables', business=business_data,
            display_name='loan interest receivables',
            category=AccountCategory.objects.get(name='Account Receivables', business=business_data),
        )
    loan_interest_receivables_acc = loan_interest_receivables_acc

    interest_paid_so_far = Transactions.objects.filter(
        account_cr=loan_interest_receivables_acc, loan=loan
    ).aggregate(Sum('reporting_amount'))['reporting_amount__sum']
    if interest_paid_so_far is None:
        interest_paid_so_far = 0
    # print('interest_paid_so_far', interest_paid_so_far)

    receivable_acc = Account.objects.filter(name='Loan Receivables', business=business_data).first()
    # get transaction

    principal_paid = Transactions.objects.filter(
        account_cr=receivable_acc, loan=loan
    ).aggregate(Sum('reporting_amount'))['reporting_amount__sum']
    if principal_paid is None:
        principal_paid = 0

    principal_trans_amt = 0
    interest_trans_amt = 0
    new_schedules = []
    # print('principal_paid',principal_paid)
    # print('interest_paid_so_far', interest_paid_so_far)

    for schedule in schedules:
        # print('++++++++++++++++++++++ get new schedule ++++++++++++++++++++')
        # print('SCHEDULE BALANCE', schedule['schedule_balance'])
        if int(schedule['schedule_balance']) == 0 :
            # print('BALANCE IS ZERO')
            new_schedules.append({
                'principal':schedule['principal_paid'],
                'interest':schedule['interest_paid'],
                'principal_bal':0,
                'interest_bal': 0,
            })
            interest_paid_so_far = interest_paid_so_far - float(schedule['interest_paid'])
            principal_paid = principal_paid - float(schedule['principal_paid'])
        else:

            if schedule['installment'] >= schedule['schedule_balance']:
                # print('INSTALLMENT AMOUNT >schedule_balance', schedule['schedule_balance'])
                current_principal_bal = 0
                current_interest_bal = 0
                if principal_paid > 0:
                    if principal_paid < schedule['principal_paid']:
                        current_principal_bal = schedule['principal_paid'] - principal_paid
                        principal_paid = 0
                    else:
                        current_principal_bal = 0
                        principal_paid = principal_paid - schedule['principal_paid']
                else:
                    current_principal_bal = schedule['principal_paid']
                    principal_paid = 0
                if interest_paid_so_far > 0:
                    if interest_paid_so_far < schedule['interest_paid']:
                        current_interest_bal = schedule['interest_paid'] - interest_paid_so_far
                        interest_paid_so_far = 0
                    else:
                        current_interest_bal = 0
                        interest_paid_so_far = interest_paid_so_far - schedule['interest_paid']
                else:
                    current_interest_bal = schedule['interest_paid']
                    interest_paid_so_far = 0
                new_schedules.append({
                    'principal': schedule['principal_paid'],
                    'interest': schedule['interest_paid'],
                    'principal_bal': current_principal_bal,
                    'interest_bal': current_interest_bal,
                })

                interest_paid_so_far = interest_paid_so_far - current_interest_bal


    principal_trans_amt = 0
    interest_trans_amt = 0
    amt_paid = float(excel_loan['amount paid'])
    # print('amt_paid', amt_paid)
    # print('new schedules', new_schedules)

    # print('----------------- start-----------------------')

    for schedule in new_schedules:
        print('AMT PAID', amt_paid)
        if amt_paid > 0:
            if schedule['principal_bal'] > 0:
                if amt_paid > schedule['principal_bal']:
                    amt_paid = amt_paid - schedule['principal_bal']
                    principal_trans_amt = principal_trans_amt + schedule['principal_bal']
                else:
                    principal_trans_amt = principal_trans_amt + amt_paid
                    amt_paid = 0
            # else:
            #     amt_paid = amt_paid - schedule['principal']
            #     # principal_trans_amt = principal_trans_amt +schedule['principal']
            # print('AMT AFTER PRINCIPAL', amt_paid )

        if amt_paid > 0:
            if schedule['interest_bal'] > 0:
                if amt_paid > schedule['interest_bal']:
                    amt_paid = amt_paid - schedule['interest_bal']
                    interest_trans_amt = interest_trans_amt + schedule['interest_bal']
                else:
                    interest_trans_amt = amt_paid
                    amt_paid = 0
            # else:
            #     amt_paid = amt_paid - schedule['interest']
            #     # interest_trans_amt = interest_trans_amt + schedule['interest_bal']
        # print('AMT AFTER INTEREST', amt_paid)
        # print('---------------------------------------+++++++++++++++++++++++++', )

    excess_amt = 0

    if amt_paid > 0:
        excess_amt = amt_paid

    # print('principal_trans_amt', principal_trans_amt)
    # print('interest_trans_amt', interest_trans_amt)
    # print('excess_amt', excess_amt)

    return{
        'principal_trans_amt':principal_trans_amt,
        'interest_trans_amt':interest_trans_amt,
        'excess_amt':excess_amt
    }


def get_loan_principal_balance(loan_number, business_data):
    #check if loan -- if it does have a running balance
    the_loan = Loans.objects.filter(loan_number=loan_number)
    if not the_loan.exists() :
        return {
            'status':'failed',
            'detail': 'Loan doesnot exist'
        }
    elif the_loan.first().loan_status == 4:
        return {
            'status': 'failed',
            'detail': 'Loan is already closed'
        }
    the_loan = the_loan.first()
    #get loan receivable acc
    receivable_acc = Account.objects.filter(name='Loan Receivables', business=business_data).first()
    # get transaction
    receivable_acc_debits = Transactions.objects.filter(
        account_dr=receivable_acc, loan=the_loan
    ).aggregate(Sum('reporting_amount'))['reporting_amount__sum']
    if receivable_acc_debits is None:
        receivable_acc_debits = 0
    print('receivable_acc_debits', receivable_acc_debits)
    receivable_acc_credits = Transactions.objects.filter(
        account_cr=receivable_acc, loan=the_loan
    ).aggregate(Sum('reporting_amount'))['reporting_amount__sum']
    if receivable_acc_credits is None:
        receivable_acc_credits = 0
    print('receivable_acc_credits', receivable_acc_credits)
    principal_balance = receivable_acc_debits - receivable_acc_credits

    # if interest_include == 'includes':
    #     interest_balance = get_loan_interest_receivables_balance(business_data, the_loan)
    #     principal_balance = principal_balance + interest_balance

    return {
        'status': 'success',
        'principal_balance': principal_balance,
        'loan': the_loan,
        'receivable_acc':receivable_acc
    }

def correct_interest_rem(business_data, loan, branch_data):
    ln_interest_rec_acc = Account.objects.filter(name='loan interest receivables', business=business_data)
    if ln_interest_rec_acc:
        ln_interest_rec_acc = ln_interest_rec_acc.first()
    else:
        ln_interest_rec_acc = Account.objects.create(
            name='loan interest receivables', business=business_data,
            display_name='loan interest receivables',
            category=AccountCategory.objects.get(name='Account Receivables', business=business_data),
        )
    ln_interest_revenue_acc = Account.objects.filter(name='Loan Interest',
                                                     business=business_data).first()

    loan_interest_receivable_debits = Transactions.objects.filter(loan=loan, account_dr=ln_interest_rec_acc)
    # print('total debits', loan_interest_receivable_debits)
    if loan_interest_receivable_debits:
        loan_interest_receivable_debits = \
        loan_interest_receivable_debits.aggregate(total_debits=Sum('reporting_amount'))['total_debits']
    else:
        loan_interest_receivable_debits = 0

    loan_interest_receivable_credits = Transactions.objects.filter(loan=loan,
                                                                   account_cr=ln_interest_rec_acc)
    # print('total credits', loan_interest_receivable_credits)
    if loan_interest_receivable_credits:
        loan_interest_receivable_credits = \
        loan_interest_receivable_credits.aggregate(total_credits=Sum('reporting_amount'))['total_credits']
    else:
        loan_interest_receivable_credits = 0

    print('loan_interest_receivable_debits', loan_interest_receivable_debits, loan_interest_receivable_credits)
    if loan_interest_receivable_debits > loan_interest_receivable_credits:
        Transactions.objects.create(
            account_cr=ln_interest_rec_acc,
            account_dr=ln_interest_revenue_acc,
            loan=loan,
            transaction_type='uncorrected interest',
            narration='uncorrected interest',
            tx_date=datetime.datetime.today().date(),
            branch=branch_data,
            reporting_amount=(loan_interest_receivable_debits - loan_interest_receivable_credits)
        )
        print('transaction created')

def close_old(old_loan_data,interest_balance, values_submitted, business_data, branch_data ):
    opening_reserve_acc = Account.objects.filter(name='Opening Reserves', business=business_data).first()
    loan_receivable_acc = old_loan_data['receivable_acc']
    #transaction for closing the principal
    trans_principal = Transactions.objects.create(
        account_cr=loan_receivable_acc,
        account_dr=opening_reserve_acc,
        reporting_amount=old_loan_data['principal_balance'],
        branch_id= branch_data,
        loan=old_loan_data['loan'],
        transaction_type= 'Loan repayment'
    )
    print('trans_principal', trans_principal)
    old_loan_amt = old_loan_data['principal_balance']
    #transaction for closing the interest
    if values_submitted['interest_include'] == 'yes':
        #THIS PART NEEDS SERIOUS REVIEW
        interest_data = interest_balance
        print('interest_data', interest_data)

        loan_interest_receivables_acc = Account.objects.filter(name='loan interest receivables', business=business_data)
        if loan_interest_receivables_acc.exists():
            loan_interest_receivables_acc = loan_interest_receivables_acc.first()
        else:
            loan_interest_receivables_acc = Account.objects.create(
                name='loan interest receivables', business=business_data,
                display_name='loan interest receivables',
                category=AccountCategory.objects.filter(name='Account Receivables', business=business_data).first(),
            )

        trans_interest = Transactions.objects.create(
            account_cr=loan_interest_receivables_acc,
            account_dr=opening_reserve_acc,
            reporting_amount=interest_data,
            branch_id= branch_data,
            loan = old_loan_data['loan'],
            transaction_type='Loan interest'
        )
        # print('trans_interest', trans_interest)
        print(f'current Principal:{old_loan_data["principal_balance"]}, interest closed:{interest_data}')
        old_loan_amt = old_loan_data['principal_balance'] + interest_data
    else:
        branch_data = Branch.objects.get(id=branch_data)
        correct_interest_rem(business_data, old_loan_data['loan'], branch_data)

    #actually close the loan
    Loans.objects.filter(id=old_loan_data['loan'].id).update(
        loan_status = 4
    )

    print('OLD LOAN AMOUN||', old_loan_amt)

    return {
        'old_loan_amt': old_loan_amt,
        'loan': old_loan_data['loan'],
        'opening_reserve_acc': opening_reserve_acc,
        'loan_receivable_acc': loan_receivable_acc,
        'principal_balance':old_loan_amt
    }



def new_loan_transactions(new_loan, excel_loan, values_submitted, loan_receivable_acc, business_data, branch_data, old_loan_principal_bal, opening_reserve_acc):

    loan_charges_acc = Account.objects.filter(name='Loan Charges', business=business_data)[0]

    if values_submitted['apply_charges_from'] == 'system':
        charges = ApplicationAccountOrLoanType.objects.filter(loan_type=new_loan.loan_type,
                                                                  general_charge__status=1,
                                                                  general_charge__application="l")
        for charge in charges:
            ispercentage = charge.general_charge.is_percentage
            if ispercentage == 1:
                chargeamount = int(
                    charge.general_charge.amount * float(new_loan.amount_approved)) / 100
            else:
                chargeamount = charge.general_charge.amount

            LoanCharges.objects.create(
                amount=float(chargeamount),
                charge_id=charge.general_charge.id,
                loan=new_loan
            )
            savecharge = Transactions.objects.create(reporting_amount=float(chargeamount),
                                                     transaction_type=charge.general_charge.charge,
                                                     narration=charge.general_charge.charge,
                                                     account_cr=loan_charges_acc,
                                                     account_dr_id=values_submitted['top_charges_debitted_acc'],
                                                     tx_date=values_submitted['udate'],
                                                     loan=new_loan,
                                                     branch_id=branch_data)
            # branchdata(request)
    else:
        savecharge = Transactions.objects.create(reporting_amount=float(str(excel_loan['charge']).replace(',', '')),
                                                 transaction_type='loan charge',
                                                 narration=f'loan charge',
                                                 account_cr=loan_charges_acc,
                                                 account_dr_id=values_submitted['top_charges_debitted_acc'],
                                                 tx_date=values_submitted['udate'],
                                                 loan=new_loan,
                                                 branch_id=branch_data)

    new_reporting_amt =float(str(excel_loan['requested amount']).replace(',',''))
    #check if charges are for system or from excel
    if values_submitted['excel_amount_include_charge'] == 'includes':
        new_reporting_amt = new_reporting_amt - float(str(excel_loan['charge']).replace(',', ''))
    loan_transaction = Transactions.objects.create(reporting_amount=new_reporting_amt,
                                                   narration=values_submitted['narration'],
                                                   account_cr_id=values_submitted['credited'],
                                                   account_dr=loan_receivable_acc,
                                                   tx_date=values_submitted['udate'],
                                                   loan=new_loan,
                                                   transaction_type='give loan',
                                                   branch_id=branch_data
                                                   )
    # debitting new loan with old loan balance
    debit_new_loan = Transactions.objects.create(reporting_amount=old_loan_principal_bal,
                                                 narration=values_submitted['narration'],
                                                 account_cr=opening_reserve_acc,
                                                 account_dr=loan_receivable_acc,
                                                 tx_date=values_submitted['udate'],
                                                 loan=new_loan,
                                                 transaction_type='give loan',
                                                 branch_id=branch_data
                                                 )


def create_top_up_loan(old_loan_amt_data, excel_loan, branch_data, loan_upload_obj, user_data, values_submitted, business_data):
    # print('EXCEL DATE', excel_loan['date'])
    timestamp = Timestamp(excel_loan['date'])
    formatted_string = timestamp.strftime('%Y-%m-%d')
    excel_date = datetime.datetime.strptime(formatted_string, '%Y-%m-%d').date()
    # print('EXCEL DATE 2222', excel_date)
    excel_duration = [int(s) for s in re.findall(
        r'\b\d+\b', excel_loan['duration'])][0]
    print('EXCEL DURATION', excel_duration)
    new_loan =Loans.objects.create(
        account=old_loan_amt_data['loan'].account,
        branch_id = branch_data,
        applicant = old_loan_amt_data['loan'].applicant,
        amount_requested = old_loan_amt_data['old_loan_amt'] + float(excel_loan['requested amount']),
        amount_approved = old_loan_amt_data['old_loan_amt'] + float(excel_loan['requested amount']),
        rate = old_loan_amt_data['loan'].rate,
        rate_type = old_loan_amt_data['loan'].rate_type,
        loan_type = old_loan_amt_data['loan'].loan_type,
        requested_on = excel_date,
        approved_on = excel_date,
        schedule_start = excel_date,
        requested_duration = excel_duration,
        approved_duration = excel_duration,
        loan_status = 3,
        is_topup = True,
        charges_paid = True,
        interval = old_loan_amt_data['loan'].interval,
        approved_by_id = user_data,
        added_by_id = user_data,
        upload = loan_upload_obj,
        loan_number = get_new_loan_number(),
        topped_up_loan = old_loan_amt_data['loan'].id
    )

    #update the summary details
    the_actual_loan = Loans.objects.get(id=new_loan.id)
    if the_actual_loan.loan_status == 3:
        update_loan_summary_details(the_actual_loan)

    LoanTopups.objects.create(
        closed_loan=old_loan_amt_data['loan'],
        topup_loan = new_loan,
        branch_id = branch_data,
        added_by_id = user_data,
        approved = True,
    )


    #transactions
    loan_receivable_acc = old_loan_amt_data['loan_receivable_acc']
    opening_reserve_acc = old_loan_amt_data['opening_reserve_acc']
    new_loan_transactions(new_loan, excel_loan, values_submitted, loan_receivable_acc, business_data, branch_data, old_loan_amt_data['principal_balance'], opening_reserve_acc )



def check_multiple_loan_top_up_fields_xlsx(data, apply_charges_from ):
    fields = ['initial loan number', 'requested amount', 'charge', 'date', 'duration']
    fields_missing = []
    for field in fields:
        if field == 'charge':
            if apply_charges_from == 'excel':
                if not field in data:
                    fields_missing.append(field)
        else:
            if not field in data:
                fields_missing.append(field)
    return fields_missing


def create_top_up_loan_multiple(old_loan_amt_data, excel_loan, branch_data, loan_upload_obj, user_data, values_submitted, business_data):
    print('EXCEL DATE', excel_loan['date'])
    timestamp = Timestamp(excel_loan['date'])
    formatted_string = timestamp.strftime('%Y-%m-%d')
    excel_date = datetime.datetime.strptime(formatted_string, '%Y-%m-%d').date()
    print('EXCEL DATE 2222', excel_date)
    excel_duration = [int(s) for s in re.findall(
        r'\b\d+\b', excel_loan['duration'])][0]
    print('EXCEL DURATION', excel_duration)
    new_loan =Loans.objects.create(
        account=old_loan_amt_data['loan'].account,
        branch_id = branch_data,
        applicant = old_loan_amt_data['loan'].applicant,
        amount_requested = old_loan_amt_data['old_loan_amt'] + float(excel_loan['requested amount']),
        amount_approved = old_loan_amt_data['old_loan_amt'] + float(excel_loan['requested amount']),
        rate = old_loan_amt_data['loan'].rate,
        rate_type = old_loan_amt_data['loan'].rate_type,
        loan_type = old_loan_amt_data['loan'].loan_type,
        requested_on = excel_date,
        approved_on = excel_date,
        schedule_start = excel_date,
        requested_duration = excel_duration,
        approved_duration = excel_duration,
        loan_status = 3,
        is_topup = True,
        charges_paid = True,
        interval = old_loan_amt_data['loan'].interval,
        approved_by_id = user_data,
        added_by_id = user_data,
        upload = loan_upload_obj,
        loan_number = get_new_loan_number(),
        topped_up_loan = old_loan_amt_data['loan'].id
    )

    LoanTopups.objects.create(
        closed_loan=old_loan_amt_data['loan'],
        topup_loan = new_loan,
        branch_id = branch_data,
        added_by_id = user_data,
        approved = True,
    )


    #transactions
    loan_receivable_acc = old_loan_amt_data['loan_receivable_acc']
    opening_reserve_acc = old_loan_amt_data['opening_reserve_acc']
    new_loan_transactions(new_loan, excel_loan, values_submitted, loan_receivable_acc, business_data, branch_data, old_loan_amt_data['principal_balance'], opening_reserve_acc )
    return{
        'new_loan_number':new_loan.loan_number
    }


def get_loan_details_payments(payment):
    # print('the payment',payment)
    reporting_amount = payment['reporting_amount'].sum()
    loan_fine = payment[payment['transaction_type'] == 'Loan fines']['reporting_amount'].sum()
    loan_principal_paid = payment[payment['transaction_type'] == 'Loan repayment']['reporting_amount'].sum()
    loan_interest_paid = payment[payment['transaction_type'] == 'Loan interest']['reporting_amount'].sum()
    id_value = payment['id'].iloc[0]
    date_added_value = payment['tx_date'].iloc[0]
    if not loan_fine:
        loan_fine = 0
    return pd.Series({
        'id':id_value,
        'date_added':date_added_value,
        'reporting_amount': reporting_amount,
        'loan_fine': loan_fine,
        'principal_paid':loan_principal_paid,
        'interest_paid': loan_interest_paid
    })






















