from loans.models import Loans
import datetime
import random
import string

def generate_loan_number():
    #get current year last digits
    current_year = datetime.datetime.now().year
    current_year_last_2_char = str(current_year)[-2:]
    # random mixture of digits and characters 6
    characters = string.digits + string.ascii_uppercase  # Digits (0-9) + Uppercase letters (A-Z)
    random_mixture = ''.join(random.choices(characters, k=6))
    return current_year_last_2_char + random_mixture

def get_new_loan_number():
    number_exits = True
    loan_number = ''
    while number_exits:
        loan_number = generate_loan_number()
        if not Loans.objects.filter(loan_number=loan_number).exists():
            number_exits = False
    return loan_number

# def get_new_loan_number():
#     loan_number = generate_loan_number()
#     if Loans.objects.filter(loan_number=loan_number).exists():
#         return get_new_loan_number()
#     return loan_number