import json
import pandas as pd
import copy
import ast
from datetime import *
from dateutil.relativedelta import relativedelta
from math import ceil, floor
from django.db.models import Q, F, FloatField, Case, When, Sum

from transactions.models import Transactions, Account
from loans.models import Loans, LoanCharges
from sacco.utils import (
    businessdata,
    branchdata,
)


#NOTE: the_loan is an obj for Loans model
def get_loan_amounts_paid(the_loan):
    
    #total principal paid
    total_principal = Transactions.objects.filter(loan=the_loan, transaction_type='Loan repayment').aggregate(total=Sum("reporting_amount"))['total']
    if total_principal is None:
        total_principal = 0
    total_interest = Transactions.objects.filter(loan=the_loan, transaction_type='Loan interest').aggregate(total=Sum("reporting_amount"))['total']
    if total_interest is None:
        total_interest = 0

    total_fines = Transactions.objects.filter(loan=the_loan, transaction_type='Loan fines').aggregate(total=Sum("reporting_amount"))['total']
    if total_interest is None:
        total_fines = 0
    
    return{
        'total_principal':total_principal,
        'total_interest': total_interest,
        'total_fines': total_fines
    }

def get_total_charges(the_loan):
    #ORIGINAL IN MAIN MFUKO
    # actualchargesx = the_loan.charges
    # totalcharges = 0
    # try:
    #     actualcharges = json.loads(actualchargesx)
    #     for chg in actualcharges:
    #         chargeamount = chg["amount"]
    #         totalcharges = totalcharges + chargeamount

    # except:
    #     totalcharges = 0

    totalcharges = LoanCharges.objects.filter(loan=the_loan).aggregate(total=Sum("amount"))['total']
    if totalcharges is None:
        totalcharges = 0

    return totalcharges


def determine_loan_principal(the_loan):
    #get the loan receivables account for business
    ln_receivables_acc = Account.objects.get(name="Loan Receivables", business=the_loan.branch.business)

    given_principal = Transactions.objects.filter(loan=the_loan, account_dr=ln_receivables_acc).aggregate(total=Sum("reporting_amount"))['total']
    if given_principal is None:
        given_principal = 0
    return given_principal

def determine_disbursed_amount(the_loan):
    disbursed_principal = Transactions.objects.filter(loan=the_loan, transaction_type='give loan').aggregate(total=Sum("reporting_amount"))['total']
    if disbursed_principal is None:
        disbursed_principal = 0
    return disbursed_principal
    

def get_loan_interval(the_loan):
    if the_loan.interval is not None:
        typeinterval = the_loan.interval
    else:
        typeinterval = the_loan.loan_type.interval
    return typeinterval


def determine_interest_percentage(the_loan, formula, loan_interval):
    if formula == 5:
        interest = the_loan.rate / 100

    if formula == 1:
        if loan_interval == 3:
            interest = (the_loan.rate / 100) / 12

        if loan_interval == 0:
            interest = (the_loan.rate / 100) / 365

        if loan_interval == 1:
            interest = (the_loan.rate / 100) / 52

        if loan_interval == 2:
            interest = (the_loan.rate / 100) / 26

        if loan_interval == 4:
            interest = the_loan.rate / 100

    if formula == 2:
        if loan_interval == 3:
            interest = the_loan.rate / 100

        if loan_interval == 0:
            interest = (the_loan.rate / 100) / 30

        if loan_interval == 1:
            interest = (the_loan.rate / 100) / 4

        if loan_interval == 2:
            interest = (the_loan.rate / 100) / 2

        if loan_interval == 4:
            interest = (the_loan.rate / 100) * 12

    if formula == 3:
        if loan_interval == 3:
            interest = (the_loan.rate / 100) * 4

        if loan_interval == 0:
            interest = (the_loan.rate / 100) * 7

        if loan_interval == 1:
            interest = the_loan.rate / 100

        if loan_interval == 2:
            interest = (the_loan.rate / 100) * 2

        if loan_interval == 4:
            interest = (the_loan.rate / 100) * 52

    if formula == 4:
        if loan_interval == 3:
            interest = (the_loan.rate / 100) * 30

        if loan_interval == 0:
            interest = the_loan.rate / 100

        if loan_interval == 1:
            interest = (the_loan.rate / 100) * 7

        if loan_interval == 2:
            interest = (the_loan.rate / 100) * 14

        if loan_interval == 4:
            interest = (the_loan.rate / 100) * 365
    
    return interest

def determine_duration_sizes(the_loan, loan_interval):
    duration = the_loan.approved_duration
    # =====================IF INTERVAL IS MONTHLY =========================
    if loan_interval == 3:
        to_add = relativedelta(months=1)
        try:
            all_duration = relativedelta(months=duration)
        except Exception as exp:
            print(str(exp))

    # =====================IF INTERVAL IS DAILY =========================

    if loan_interval == 0:
        to_add = relativedelta(days=1)
        all_duration = relativedelta(days=duration)

    # =====================IF INTERVAL IS WEEKLY =========================

    if loan_interval == 1:
        to_add = relativedelta(weeks=1)
        all_duration = relativedelta(weeks=duration)

    # =====================IF INTERVAL IS BI-WEEKLY =========================

    if loan_interval == 2:
        to_add = relativedelta(weeks=2)
        all_duration = relativedelta(weeks=duration * 2)

    # =====================IF INTERVAL IS YEARLY =========================

    if loan_interval == 4:
        to_add = relativedelta(years=1)
        all_duration = relativedelta(years=int(duration))
    
    return {
        'to_add': to_add,
        'all_duration': all_duration
    }

def flat_rate_schedules(the_loan, to_add, interest_size, totals_paid, given_principal, all_duration ):
    nextinterest = 0
    cumrative_payments = 0
    approved_amount = the_loan.amount_approved
    duration = the_loan.approved_duration
    interest = interest_size
    paidamount = totals_paid['total_principal'] + totals_paid['total_interest']
    appdate = the_loan.schedule_start
    principal = given_principal
    decimals=5
    cumrative_payments = 0

    #interests paid
    if totals_paid['total_interest'] > 0:
        intpaid = 1
    else:
        intpaid = 0

    # today's date
    nowdate = datetime.today().date()

    if the_loan.rate_type == 1:
        days = []
        schedules = approved_amount / duration
        interestperschedue = approved_amount * interest
        payable = interestperschedue + schedules
        # ========================================GET PAID SCHEDULES=========================
        paidschedules = paidamount / payable
        paidschedules = floor(paidschedules)

        # ====================================Balance for the next schedule=======================
        nextbal = paidamount - (payable * paidschedules)
        nextintallment = payable - nextbal

        # print('NeXT INSTALL ', nextintallment, 'bal ', nextbal)
        if 1 > nextintallment > 0:
            nextintallment = payable + nextintallment
            nextschedule = paidschedules + 2
        else:
            nextschedule = paidschedules + 1

        # print('to_add', to_add)

        to_add = to_add[0]
        edate = appdate + to_add
        # print(appdate)
        date1 = edate
        totalpayable = payable * duration

        totalinterest = totalpayable - principal

        totalinterest = round(totalinterest, decimals)

        totalpayable = round(totalpayable, decimals)

        rbalance = totalpayable

        date2 = date1 + all_duration
        m = 1

        total_interest_paid = totals_paid['total_interest']
        total_principal_paid = totals_paid['total_principal']

        try:
            principalbalance = principal

            sch_date = date1
            # while date1 < date2:

            while m <= duration:
                pbalance = 0

                if intpaid == m or intpaid > m:
                    actualinterest = 0
                else:
                    actualinterest = interestperschedue

                rbalance = rbalance - payable
                rbalance = rbalance
                if m == nextschedule:
                    isnext = 1
                    spaid = nextbal
                    sbalance = nextintallment

                elif m < nextschedule:
                    isnext = 0
                    spaid = payable
                    sbalance = 0

                else:
                    isnext = 2
                    spaid = 0
                    sbalance = payable


                principalbalance = principalbalance - schedules

                #determine how much has been paid on interest and principal
                if float(total_principal_paid) > float(schedules):
                    current_principal_paid = schedules
                    current_principal_bal = 0
                else:
                    current_principal_paid = total_principal_paid
                    current_principal_bal = float(schedules) - current_principal_paid

                total_principal_paid = total_principal_paid - current_principal_paid


                days.append(
                    {
                        'schedule_date' : date1.strftime("%Y-%m-%d"),
                        'total_paid': round(spaid, decimals),
                        'schedule_balance':round(sbalance, decimals),
                        'principal_balance':round(principalbalance, decimals),
                        'installment':round(payable, decimals),
                        'principal_per_schedule': schedules,
                        'interestperschedue': interestperschedue,
                        'current_principal_paid': current_principal_paid,
                        'current_principal_bal': current_principal_bal
                    }
                )

                payable = round(payable, decimals)
                schedules = round(schedules, decimals)
                interestperschedue = round(interestperschedue, decimals)
                if date1.weekday() == 5:
                    date1 = date1 + to_add + relativedelta(days=1)
                    date2 = date2 + relativedelta(days=1)

                else:
                    date1 = date1 + to_add

                sfine = 0

                m = m + 1
        except Exception as erp:
            print("ERROR %", str(erp))
    return days



def reducing_balance_schedules(the_loan, to_add, interest_size, totals_paid, given_principal, all_duration):
    total_interest_paid = totals_paid['total_interest']
    total_principal_paid = totals_paid['total_principal']

    if the_loan.rate_type == 2:
        in_date = ""
        loan_dict = {}
        data = []
        days = []

        to_add = to_add[0]
        approved_amount = the_loan.amount_approved
        duration = the_loan.approved_duration
        interest = interest_size
        paidamount = totals_paid['total_principal'] + totals_paid['total_interest']
        appdate = the_loan.schedule_start
        principal = given_principal
        decimals = 5
        cumrative_payments = 0
        # today's date
        nowdate = datetime.today().date()

        #interests paid
        if totals_paid['total_interest'] > 0:
            intpaid = 1
        else:
            intpaid = 0

        edate = appdate + to_add
        date1 = edate
        principals = 0
        date2 = date1 + all_duration
        runningbal = approved_amount
        if principal == 0:
            print('principal was zero')
            principal = the_loan.approved_amount
        if interest > 0:
            numilator = (
                principal
                * interest
                * (
                    (pow((1 + interest), duration))
                    / (pow((1 + interest), duration) - 1)
                )
            )
        else:
            numilator = principal / duration

        if numilator == 0:
            print(principal, interest)
        
        payable = numilator

        totalpayable = payable * duration

        totalpayable = totalpayable

        rprincipal = 0
        rbalance = principal
        # ========================================GET PAID SCHEDULES=========================

        paidschedules = paidamount / payable
        paidschedules = floor(paidschedules)

        # print('PAID SCHEDULES ARE ', paidschedules, 'Paid Is ', paidamount, 'Payabale is ', payable)

        # ====================================Balance for the next schedule=======================
        nextbal = paidamount - (payable * paidschedules)
        # nextintallment = payable + float(totaladjustments) - nextbal
        # removed the original total adjustments
        nextintallment = payable - nextbal
        # print('NeXT INSTALL ',nextintallment, 'bal ',nextbal )
        if nextintallment < 1 and nextintallment > 0:
            nextintallment = payable + nextintallment
            nextschedule = paidschedules + 2
        else:
            nextschedule = paidschedules + 1
        m = 1
        isnext = 0
        sfine = 0
        sch_date = date1

        if the_loan.sub_intervals == True:
            if the_loan.interval == 4:
                pricipalperschdule = principal / duration
                paymentperiod = []
                remainingprincipal = principal
                rem_principal = principal

                # gettotalinterest
                totalinterest = 0
                for a in range(0, int(duration)):
                    perinterest = rem_principal * interest
                    yearlypayable = rem_principal + perinterest
                    rem_principal = rem_principal - pricipalperschdule
                    totalinterest = totalinterest + perinterest

                pbalance = principal
                sch_date = date1
                # while date1 < date2:
                while m <= duration:
                    date3 = date1 - relativedelta(years=1)
                    runningbal = principal + totalinterest
                    for a in range(0, int(duration)):
                        generalint = remainingprincipal * interest
                        generalpayable = pricipalperschdule + generalint
                        interestperschedue = generalint / 12
                        interestperschedue = round(interestperschedue, 2)
                        payable = generalpayable / 12
                        rprincipal = payable - interestperschedue
                        # rprincipal = round(rprincipal, decimals)

                        paidschedules = paidamount / payable
                        paidschedules = floor(paidschedules)

                        for sched in range(0, 12):
                            nextbal = paidamount - (payable * paidschedules)
                            nextintallment = payable - nextbal
                            if nextintallment < 1 and nextintallment > 0:
                                nextintallment = payable + nextintallment
                                nextschedule = paidschedules + 2
                            else:
                                nextschedule = paidschedules + 1

                            sfine = 0
                            sfines = 0
                            if m == nextschedule:
                                isnext = 1
                                if nextbal < 1:
                                    spaid = 0
                                else:
                                    spaid = round(nextbal, decimals)
                                sbalance = round(
                                    ##--- Original line
                                    # nextintallment + totaladjustments, decimals
                                    ##--- New line
                                    nextintallment , decimals
                                )

                            elif m < nextschedule:
                                isnext = 0
                                spaid = round(payable, decimals)
                                sbalance = 0

                            else:
                                isnext = 2
                                spaid = 0
                                sbalance = round(payable, decimals)

                            days.append(date1.strftime("%Y-%m-%d"))

                            # if date1 < nowdate and isnext > 0:
                            #     for loanfine in loanfines:
                            #         fineamount = loanfine.general_charge.amount
                            #         if (
                            #             loanfine.general_charge.is_percentage
                            #             == True
                            #         ):
                            #             sfines = (fineamount / 100) * payable
                            #         else:
                            #             sfines = fineamount

                            #         sfine = float(sfine) + float(sfines)
                            # else:
                            #     sfine = 0
                            sfine = 0

                            sfine = round(sfine, decimals)

                            runningbal = runningbal - payable
                            rbalance = round(runningbal, decimals)

                            if intpaid == m or intpaid > m:
                                actualinterest = 0

                            else:
                                actualinterest = interestperschedue

                            pbalance = pbalance - rprincipal
                            if spaid > 1:
                                cumrative_payments = cumrative_payments + spaid

                            else:
                                cumrative_payments = 0

                            loan_dict[in_date] = date3.strftime("%Y-%m-%d")
                            loan_dict[rprincipal] = rprincipal
                            loan_dict[rbalance] = rbalance
                            loan_dict[isnext] = isnext
                            loan_dict[interestperschedue] = interestperschedue
                            loan_dict[spaid] = spaid
                            loan_dict[sbalance] = sbalance
                            loan_dict[actualinterest] = actualinterest
                            data.append(
                                [
                                    round(rprincipal, decimals),
                                    loan_dict[in_date],
                                    loan_dict[round(rbalance, decimals)],
                                    loan_dict[
                                        round(interestperschedue, decimals)
                                    ],
                                    loan_dict[round(isnext, decimals)],
                                    loan_dict[round(spaid, decimals)],
                                    loan_dict[round(sbalance, decimals)],
                                    loan_dict[actualinterest],
                                    sfine,
                                    round(payable, decimals),
                                    round(pbalance, decimals),
                                    round(cumrative_payments, decimals),
                                ]
                            )

                            if date1.weekday() != 5:
                                date1 = date1 + to_add
                            else:
                                date1 = date1 + to_add + relativedelta(days=1)
                                date2 = date2 + relativedelta(days=1)

                            # date1 = sch_date + m * to_add
                            date3 = sch_date + relativedelta(months=m)
                            m = m + 1

                            sfine = 0

                        remainingprincipal = (
                            remainingprincipal - pricipalperschdule
                        )
                ## -- original
                # generalbalance = (totalpayable + totaladjustments) - (
                #     adjustment_down - adjustment_added
                # )
                generalbalance = totalpayable 

                # -------- review this ------------------
                try:
                    if generalbalance == 0 or generalbalance < 1:
                        generalbalance = 0
                        the_loan.loan_status = 4

                except:
                    pass
                generalbalance = round(generalbalance, decimals)
                the_loan.balance = generalbalance
                the_loan.save()
                # ------------- end review -------------------

            # print('PRINCIPAL Five', principal)

            if the_loan.interval == 3:
                # print('I AM IN THE MONTH')
                pricipalperschdule = principal / duration
                paymentperiod = []
                remainingprincipal = principal
                rem_principal = principal
                segments = ceil(duration / 12)
                actualyears = floor(duration / 12)
                halfyear = duration - (actualyears * 12)

                totalinterest = 0
                for a in range(0, int(actualyears)):
                    perinterest = rem_principal * interest * 12
                    # print('CUMLATIVE INT',perinterest )
                    yearlypayable = rem_principal + perinterest
                    rem_principal = rem_principal - pricipalperschdule * 12
                    totalinterest = totalinterest + perinterest
                    paymentperiod.append(12)
                # ====FOR THE BALANCE OF MONTH==========================

                if halfyear > 0:
                    perinterest = rem_principal * interest * halfyear
                    totalinterest = totalinterest + perinterest
                    paymentperiod.append(halfyear)
                # print('PERIODS ', halfyear)
                pbalance = principal
                date3 = date1
                # print('runningbal ', runningbal)
                # print('totalinterest ', totalinterest)
                runningbal = principal + totalinterest
                index = 0
                for a in paymentperiod:
                    if a < 12:
                        generalint = remainingprincipal * interest
                    else:
                        generalint = remainingprincipal * interest * (a / 12)
                    generalpayable = pricipalperschdule + generalint
                    interestperschedue = generalint
                    interestperschedue = interestperschedue
                    payable = generalpayable
                    rprincipal = payable - interestperschedue

                    paidschedules = paidamount / payable
                    paidschedules = floor(paidschedules)

                    for sched in range(0, int(a)):
                        nextbal = paidamount - (payable * paidschedules)
                        nextintallment = payable - nextbal

                        if nextintallment < 1 and nextintallment > 0:
                            nextintallment = payable + nextintallment
                            nextschedule = paidschedules + 2
                        else:
                            nextschedule = paidschedules + 1

                        sfine = 0
                        sfines = 0
                        if m == nextschedule:
                            isnext = 1
                            if nextbal < 1:
                                spaid = 0
                            else:
                                spaid = nextbal
                            sbalance = nextintallment

                        elif m < nextschedule:
                            isnext = 0
                            spaid = payable
                            sbalance = 0

                        else:
                            isnext = 2
                            spaid = 0
                            sbalance = payable

                        days.append(date1.strftime("%Y-%m-%d"))

                        # if date1 < nowdate and isnext > 0:
                        #     for loanfine in loanfines:
                        #         fineamount = loanfine.general_charge.amount
                        #         if (
                        #             loanfine.general_charge.is_percentage
                        #             == True
                        #         ):
                        #             sfines = (fineamount / 100) * payable
                        #         else:
                        #             sfines = fineamount

                        #         sfine = float(sfine) + float(sfines)
                        # else:
                        #     sfine = 0

                        sfine = 0

                        sfine = round(sfine, decimals)

                        runningbal = runningbal - payable
                        rbalance = runningbal
                        if intpaid == m or intpaid > m:
                            actualinterest = 0

                        else:
                            actualinterest = interestperschedue

                        pbalance = pbalance - rprincipal
                        if spaid > 0:
                            cumrative_payments = cumrative_payments + spaid

                        else:
                            cumrative_payments = 0

                        loan_dict[in_date] = date3.strftime("%Y-%m-%d")
                        loan_dict[rprincipal] = rprincipal
                        loan_dict[rbalance] = rbalance
                        loan_dict[isnext] = isnext
                        loan_dict[interestperschedue] = interestperschedue
                        loan_dict[spaid] = spaid
                        loan_dict[sbalance] = sbalance
                        loan_dict[actualinterest] = actualinterest
                        if rbalance < 1:
                            rbalance = 0

                        if rprincipal < 1:
                            rprincipal = 0

                        if pbalance < 1:
                            pbalance = 0

                        data.append(
                            [
                                round(rprincipal, decimals),
                                loan_dict[in_date],
                                round(rbalance, decimals),
                                round(interestperschedue, decimals),
                                loan_dict[round(isnext, decimals)],
                                round(spaid, decimals),
                                round(sbalance, decimals),
                                round(actualinterest, decimals),
                                sfine,
                                round(payable, decimals),
                                round(pbalance, decimals),
                                round(cumrative_payments, decimals),
                            ]
                        )
                        date3 = sch_date + relativedelta(months=m)
                        date1 = sch_date + m * to_add
                        m = m + 1
                        sfine = 0
                        # date1 = date1 + to_add
                        # date1 = sch_date + m * to_add
                        # date3 = date3 + relativedelta(months=1)

                    index = index + 1
                    remainingprincipal = (
                        remainingprincipal - pricipalperschdule * 12
                    )

        else:
            pbalance = principal
            sch_date = date1

            ## --original
            # generalbalance = (totalpayable + totaladjustments - paidamount) - (
            #     adjustment_down - adjustment_added
            # )
            ##--New
            generalbalance = (totalpayable - paidamount) 
            try:
                if generalbalance == 0 or generalbalance < 1:
                    generalbalance = 0
                    the_loan.loan_status = 4

            except:
                pass
            generalbalance = round(generalbalance, decimals)
            the_loan.balance = generalbalance
            the_loan.save()

            expectedinterest = 0
            # while date1 < date2:
            while m <= duration:
                sfine = 0
                sfines = 0
                if m == nextschedule or (
                    m == duration and paidschedules == duration
                ):
                    isnext = 1

                    spaid = round(nextbal, decimals)
                    sbalance = round(nextintallment, decimals)

                elif m < nextschedule:
                    isnext = 0
                    spaid = round(payable, decimals)
                    sbalance = 0

                else:
                    isnext = 2
                    spaid = 0
                    sbalance = round(payable, decimals)

                days.append(date1.strftime("%Y-%m-%d"))

                # print(nowdate)
                # print(date1)
                # if date1 < nowdate and isnext > 0:
                #     for loanfine in loanfines:
                #         fineamount = loanfine.general_charge.amount
                #         if loanfine.general_charge.is_percentage == True:
                #             sfines = (fineamount / 100) * payable
                #         else:
                #             sfines = fineamount

                #         sfine = float(sfine) + float(sfines)
                # else:
                #     sfine = 0
                sfine = 0

                sfine = round(sfine, decimals)

                interestperschedue = rbalance * interest
                interestperschedue = interestperschedue

                expectedinterest = expectedinterest + interestperschedue
                if interest > 0:
                    rbalance = principal * (
                        (pow((1 + interest), duration) - pow((1 + interest), m))
                        / (pow((1 + interest), duration) - 1)
                    )
                else:
                    rbalance = rbalance - payable
                if intpaid == m or intpaid > m:
                    actualinterest = 0

                else:
                    actualinterest = interestperschedue

                rprincipal = payable - interestperschedue
                rprincipal = rprincipal

                rbalance = rbalance

                pbalance = pbalance - rprincipal
                if spaid > 0:
                    cumrative_payments = cumrative_payments + spaid

                else:
                    cumrative_payments = 0

                loan_dict[in_date] = date1.strftime("%Y-%m-%d")
                loan_dict[rprincipal] = rprincipal
                loan_dict[rbalance] = rbalance
                loan_dict[isnext] = isnext
                loan_dict[interestperschedue] = interestperschedue
                loan_dict[spaid] = spaid
                loan_dict[sbalance] = sbalance
                loan_dict[actualinterest] = actualinterest

                if float(total_principal_paid) > float(rprincipal):
                    current_principal_paid = rprincipal
                    current_principal_bal = 0
                else:
                    current_principal_paid = total_principal_paid
                    current_principal_bal = float(rprincipal) - current_principal_paid

                total_principal_paid = total_principal_paid - current_principal_paid


                data.append(
                    {
                        'schedule_date':loan_dict[in_date],
                        'total_paid': round(spaid, decimals),
                        'schedule_balance':round(sbalance, decimals),
                        'principal_balance':round(pbalance, decimals),
                        'installment':round(payable, decimals),
                        'principal_per_schedule':round(rprincipal, decimals),
                        'interestperschedue':round(interestperschedue, decimals),
                        'current_principal_paid': current_principal_paid,
                        'current_principal_bal': current_principal_bal
                    }
                )
                date1 = sch_date + m * to_add
                m = m + 1
                sfine = 0

                # date1 = date1 + to_add

                # //principal = rprincipal

        if the_loan.sub_intervals == True:
            totalinterest = round(totalinterest, decimals)
            totalpayable = approved_amount + totalinterest
        else:
            totalinterest = round(totalpayable - principal, decimals)
        
        ## --original
        # generalbalance = (totalpayable + totaladjustments - paidamount) - (
        #     adjustment_down - adjustment_added
        # )
        ## -- New
        generalbalance = (totalpayable - paidamount) 

        
        try:
            if generalbalance == 0 or generalbalance < 1:
                generalbalance = 0
                the_loan.loan_status = 4

        except:
            pass
        generalbalance = round(generalbalance, decimals)
        the_loan.balance = generalbalance
        the_loan.save()

        #
        totalpayable = round(totalpayable, decimals)
    
    #final schedules
    return data


#NOTE: the_loan is an obj for Loans model
def get_all_loan_details(the_loan):
    formula = the_loan.loan_type.formula
    approved_amount = the_loan.amount_approved

    #total amount paid
    totals_paid = get_loan_amounts_paid(the_loan)
    total_charges = get_total_charges(the_loan)
    #determine the principal for the loan
    given_principal = determine_loan_principal(the_loan)
    disbursed_amt = determine_disbursed_amount(the_loan)
    
    # the interval
    loan_interval = get_loan_interval(the_loan)
    # the formulae
    formula = the_loan.loan_type.formula
    # interest size
    interest_size = determine_interest_percentage(the_loan, formula, loan_interval)
    #Duration sizes
    duration_sizes = determine_duration_sizes(the_loan, loan_interval)
    to_add = duration_sizes['to_add'],
    all_duration = duration_sizes['all_duration']
    if the_loan.rate_type == 1:
        the_schedules = flat_rate_schedules(the_loan, to_add, interest_size, totals_paid, given_principal, all_duration)
    elif the_loan.rate_type == 2:
        the_schedules = reducing_balance_schedules(the_loan, to_add, interest_size, totals_paid, given_principal, all_duration)
    else:
        the_schedules = []
    
    schedules_df = pd.DataFrame(the_schedules)
    schedules_list = schedules_df.to_dict(orient='records')
    total_interest_required = schedules_df['interestperschedue'].sum()

    decimals = 2

    if the_loan.applicant is not None:
        if the_loan.applicant.biodata is not None:
            the_name = the_loan.applicant.biodata.name
        else:
            the_name = the_loan.applicant.name
    else:
        the_name = ''

    return{
        'id': str(the_loan.id),
        'loan_number': str(the_loan.loan_number),
        'name': the_name,
        'schedule_start': str(the_loan.schedule_start),
        'approved_principal': round(the_loan.amount_approved, decimals),
        'principal_amt': round(given_principal, decimals),
        'disbursed_amount': round(disbursed_amt, decimals),
        'interest_required': round(total_interest_required, decimals),
        'loan_payable': round(total_interest_required + the_loan.amount_approved, decimals),
        'principal_paid': round(totals_paid['total_principal'], decimals),
        'interest_paid': round(totals_paid['total_interest'], decimals),
        'principal_balance': round((given_principal - totals_paid['total_principal']), decimals),
        'interest_balance': round((total_interest_required - totals_paid['total_interest']), decimals),
        'loan_balance': round(((total_interest_required + the_loan.amount_approved) - (totals_paid['total_principal']+totals_paid['total_interest'])), decimals),
        'is_error': 'no',
        'error': '',
        'ammotization': schedules_list,
        'loan_officer_names': the_loan.officer.biodata.name if the_loan.officer is not None else '',
        'loan_officer_id': the_loan.officer.id if the_loan.officer is not None else '',
        'contact': str(the_loan.applicant.biodata.contact),
    }


def update_loan_summary_details(the_loan):
    if the_loan.loan_status >=3:
        try:
            the_details = get_all_loan_details(the_loan)
            Loans.objects.filter(id=the_loan.id).update(
                loan_summary_details=json.dumps(the_details)
            )
            
        except Exception as e:
            # import traceback
            # print("The line where the error occurred:")
            # traceback.print_exc()
            
            Loans.objects.filter(id=the_loan.id).update(
                loan_summary_details=json.dumps({
                    'id': str(the_loan.id),
                    'name': '',
                    'schedule_start': '',
                    'approved_principal': 0,
                    'principal_amt': 0,
                    'disbursed_amount': 0,
                    'interest_required': 0,
                    'loan_payable': 0,
                    'principal_paid': 0,
                    'interest_paid': 0,
                    'principal_balance': 0,
                    'interest_balance': 0,
                    'loan_balance': 0,
                    'is_error': 'yes',
                    'error': str(e),
                    'ammotization': [],
                    'loan_officer_names': '',
                    'loan_officer_id': '',
                    'contact': '',
                })
            )
    else:
        Loans.objects.filter(id=the_loan.id).update(
            loan_summary_details=json.dumps({
                'id': str(the_loan.id),
                'name': '',
                'schedule_start': '',
                'approved_principal': 0,
                'principal_amt': 0,
                'disbursed_amount': 0,
                'interest_required': 0,
                'loan_payable': 0,
                'principal_paid': 0,
                'interest_paid': 0,
                'principal_balance': 0,
                'interest_balance': 0,
                'loan_balance': 0,
                'is_error': 'yes',
                'error': '',
                'ammotization': [],
                'loan_officer_names': '',
                'loan_officer_id': '',
                'contact': '',
            })
        )


def calculate_days_difference(date):
    today = pd.Timestamp.now().normalize()
    date = pd.Timestamp(date)
    return (today - date).days

def determine_paginator_numbers(page):
    the_start_number = ((page * 10) - 10)
    the_end_number = the_start_number + 10
    return{
        'the_start_number':the_start_number,
        'the_end_number': the_end_number
    }

def calculate_amount_due(row):
    # schedules = ast.literal_eval(row['ammotization'])
    schedules = row['ammotization']
    amount_due = 0
    last_date_found = None
    current_date = datetime.now().date()
    total_days_overdue = 0
    for schedule in schedules:
        schedule_date = datetime.strptime(schedule['schedule_date'], '%Y-%m-%d').date()
        if schedule_date < current_date and schedule['schedule_balance'] > 0:
            amount_due += schedule['schedule_balance']
            last_date_found = schedule_date
            total_days_overdue += (current_date - last_date_found).days
    return amount_due, last_date_found, total_days_overdue


def calculate_amount_due_PAR(row):
    """
    NOTE : The amount due is principal due
    """
    schedules = row['ammotization']
    amount_due = 0
    last_date_found = None
    current_date = datetime.now().date()
    total_days_overdue = 0
    for schedule in schedules:
        schedule_date = datetime.strptime(schedule['schedule_date'], '%Y-%m-%d').date()
        if schedule_date < current_date and schedule['schedule_balance'] > 0:
            amount_due += schedule['current_principal_bal']
            last_date_found = schedule_date
            total_days_overdue += (current_date - last_date_found).days
    return amount_due, last_date_found, total_days_overdue





def calculate_amount_due_schedules(row):
    # schedules = ast.literal_eval(row['ammotization'])
    schedules = row['ammotization']
    current_date = datetime.now().date()
    overdue_schedules = []
    for schedule in schedules:
        schedule_date = datetime.strptime(schedule['schedule_date'], '%Y-%m-%d').date()
        if schedule_date < current_date and schedule['schedule_balance'] > 0:
            amount_due = schedule['schedule_balance']
            last_date_found = schedule_date
            total_days_overdue = (current_date - last_date_found).days
            overdue_schedules.append({
                'payment_date': last_date_found,
                'days_overdue': total_days_overdue,
                'expected_amount': amount_due
            })

    return overdue_schedules


def get_aging_report_data(request):
    #determine the pagination range
    # paginator_numbers = determine_paginator_numbers(page)
    # the_start_number = paginator_numbers['the_start_number']
    # the_end_number = paginator_numbers['the_end_number']

    all_loans = list(Loans.objects.filter(loan_status=3, branch_id=branchdata(request)).values_list('loan_summary_details', flat=True))
    df = pd.DataFrame(eval(item) for item in all_loans)
    df = df[df['is_error'] == 'no']

    #INDIVIDUAL ARREARS
    df_individual_arrears = copy.deepcopy(df)
    df_individual_arrears['amount_due'], df_individual_arrears['last_date_found'], df_individual_arrears['total_days_overdue'] = zip(*df_individual_arrears.apply(calculate_amount_due, axis=1))
    # print(df_individual_arrears)

    #OVERDUE PAYMENTS
    df_overdue_payments = copy.deepcopy(df)
    df_overdue_payments['overdue_payments'] = df.apply(calculate_amount_due_schedules, axis=1)
    # print(df_overdue_payments)
    

    #CREATE DAYS CATEGORIES DATA    
    df['days_difference'] = df['schedule_start'].apply(calculate_days_difference)
    # # Define the bins
    bins = [-1, 30, 60, 90, float('inf')]  # 0-30, 31-60, 61-90, and more than 90 days

    # # Create a new column 'Days_Group' to represent the bins
    df['Days_Group'] = pd.cut(df['days_difference'], bins=bins, labels=['0-30', '31-60', '61-90', '90+']) 
    # # Group the loans based on the bins
    grouped_loans = df.groupby('Days_Group')
    
    all_loans = {}
    for group, group_data in grouped_loans:
        #the key
        if '+' in group:
            the_key = f"the_{group.replace('+', '_')}"
        else:
            the_key = f"the_{group.replace('-', '_')}"
        

        all_loans[the_key] = group_data['loan_balance'].sum()

    for key in all_loans.keys():
        print(key)

    return {
        'df_individual_arrears': df_individual_arrears,
        'df_overdue_payments': df_overdue_payments,
        'all_loans': all_loans
    }


def generate_custom_context(the_loan, request):
    """
    the_loan: model object for loans model
    """
    # determine the savings required
    percentage = 0
    mandatory_saving = False
    if request.user.staff.biodata.business.custom_modules.filter(name='loan percent saving').exists():
        if the_loan.savings_percentage_balance is not None:
            percentage = float(the_loan.savings_percentage_balance)
        else:
            percentage = 0
        mandatory_saving = True

    #amount needed
    if the_loan.loan_status >=2:
        # if approved use the approved amount
        amt_needed = round((percentage*the_loan.amount_approved)/100, 2)
    else:
        amt_needed = round((percentage*the_loan.amount_requested)/100, 2)

    return{
        'allow_mandatory_saving': mandatory_saving,
        'saving_needed': amt_needed
    }

        





