from transactions.models import Transactions
from .models import Loans
import datetime
import random
import string
import pandas as pd

def generate_loan_number():
    #get current year last digits
    current_year = datetime.datetime.now().year
    current_year_last_2_char = str(current_year)[-2:]
    # random mixture of digits and characters 6
    characters = string.digits + string.ascii_uppercase  # Digits (0-9) + Uppercase letters (A-Z)
    random_mixture = ''.join(random.choices(characters, k=6))
    return current_year_last_2_char + random_mixture

def get_new_loan_number():
    number_exits = True
    loan_number = ''
    while number_exits:
        loan_number = generate_loan_number()
        if not Loans.objects.filter(loan_number=loan_number).exists():
            number_exits = False
    return loan_number

def get_loan_repayment_upload_submitted_values(request):
    return {
        'upload_file': request.FILES['proof'],
        'udate': datetime.datetime.strptime(request.POST['udate'], '%Y-%m-%d').date(),
        'narration': request.POST['narration'],
        'debit_acc': request.POST['debited'],
    }

def check_loan_repayment_fields_xlsx(data):
    fields = ['loan number', 'requested amount', 'charge', 'date', 'duration']
    fields_missing = []
    for field in fields:
        if not field in data:
            fields_missing.append(field)
    return fields_missing

def reverse_old_loan_and_transactions(new_loan):
    old_loan_id = new_loan.topped_up_loan
    old_loan_obj = Loans.objects.filter(id=old_loan_id)
    if old_loan_obj.exists():
        Loans.objects.filter(id=old_loan_id).update(loan_status=3)
        # delete the transaction that closes off the loan and interest
        # trans_type = Loan interest, Loan repayment, old loan - be for the same day
        old_loan_transactions = Transactions.objects.filter(
            transaction_type__in=['Loan interest', 'Loan repayment'],
            loan_id=old_loan_id,
            date_added=new_loan.created_date
        ).order_by('-id')[:2]
        containsLoanInterest = False
        containsLoanRepayment = False
        # check if both contains loan interest and Loan repayment
        for trans in old_loan_transactions:
            if trans.transaction_type == 'Loan interest':
                containsLoanInterest = True
            if trans.transaction_type == 'Loan repayment':
                containsLoanRepayment = True
        if containsLoanInterest and containsLoanRepayment:
            old_loan_transactions.delete()
        else:
            Transactions.objects.filter(
                transaction_type__in=['Loan repayment'],
                loan_id=old_loan_id,
                date_added=new_loan.created_date
            ).order_by('-id')[:1].delete()
def reverse_new_loan_and_transactions(new_loan):
    Transactions.objects.filter(loan=new_loan).delete()
    Loans.objects.filter(id=new_loan.id).delete()


