from django.urls import path
from loans import views
from loans import exports
from loans.exports import ApplicationsPdf
from loans.views import MemberLoansView, UploadDetails, LoanUploadsView, LoanReceipt, TopupReport, LoanInterest, \
    LoanBalancesView, LoanReports, ExportLoansBalancesExcel, LoanTopUploadsView, ResolveBouncedLoansView, \
    LoanRepaymentUploadsView, ReverseLoanRepaymentsUploadView, ChangeLoanDurationView, ExportLoanReports, AgingReports, UpdateLoanOfficer,\
    AgentsDisburseReportView, PortifolioAtRiskView
    

urlpatterns = [
    path('cleared-loans/', views.ClearedLoans.as_view(), name='cleared_loans'),
    path('loan-types/', views.LoanTypesView.as_view(), name='loan_types'),
    path('loan-type/<int:pk>/', views.LoanTypeDetail.as_view(), name='loan_type_detail'),
    path('loan-applications/', views.AppliedLoansView.as_view(), name='loan_applications'),
    path('loan-details/<int:pk>/', views.LoanDetails.as_view(), name='loan_details'),
    path('edit-running-loansa/<int:pk>/', views.EditRunningLoanView.as_view(), name='edit_running_loans'),
    path('other-loans/<int:pk>/', views.OtherLoans.as_view(), name='other_loans'),
    path('apply-loan/', views.ApplyLoan.as_view(), name='apply_loan'),
    path('check-loantype/<int:pk>/', views.CheckType.as_view(), name='check_loan'),
    path('getdetails/<int:loantype>/', views.Getdetail.as_view(), name='get_detail'),
    path('running-loans/', views.RunningLoans.as_view(), name='running_loans'),
    path('other-running-loans/', views.OtherLoanReports.as_view(), name='other_loans_report'),
    path('other-running-loans-export/', views.OtherLoanReportsExcel.as_view(), name='other_loans_report_excel'),
    path('loan-settings/', views.LoanSettingsView.as_view(), name='loan_settings'),
    path('loan-calculator/', views.LoanCalculator.as_view(), name='loan_calculator'),
    path('check-loan/<int:account>/', views.ChekLoan.as_view(), name='check_loan'),
    path('member/loans/<int:pk>/', MemberLoansView.as_view(), name='member_loans'),
    path('upload-details/<int:pk>/', UploadDetails.as_view(), name='upload_details'),
    path('applications-pdf/', ApplicationsPdf.as_view(), name='applications_pdf'),
    path('applications-excel/', exports.export_application, name='applications_excel'),
    path('loan-receipt/<int:rec>/', LoanReceipt.as_view(), name='loan_receipt'),
    path('loan-uploads/', LoanUploadsView.as_view(), name='loan_uploads'),
    path('loan-topups/', TopupReport.as_view(), name='loan_topups'),
    path('loan-interest/', LoanInterest.as_view(), name='loan_interest'),
    path('balances/', LoanBalancesView.as_view(), name='loan_balances'),
    path('export_loan_balances/', ExportLoansBalancesExcel.as_view(), name='export_loan_balances'),
    path('reports/', LoanReports.as_view(), name='loan_reports'),
    path('reports/', LoanReports.as_view(), name='loan_reports'),
    path('export-reports/', ExportLoanReports.as_view(), name='export_loan_reports'),
    path('aging-reports/', AgingReports.as_view(), name='loan_aging_report'),

    path('upload-loan-topups/',LoanTopUploadsView.as_view(), name='upload_loan_topups'),
    path('revolve-bounced-loans/',ResolveBouncedLoansView.as_view(), name='revolve_bounced_loans'),
    path('loan-repayment-uploads/', LoanRepaymentUploadsView.as_view(), name='loan_repayment_uploads'),
    path('reverse-repayment-upload/<int:pk>/', ReverseLoanRepaymentsUploadView.as_view(), name='reverse_repayment_upload'),
    path('change-loan-duration/<int:pk>/', ChangeLoanDurationView.as_view(), name='change_loan_duration'),
    path('update-loan-officer/<int:pk>/', UpdateLoanOfficer.as_view(), name='update_loan_officer'),

    # New reports
    path('agents-loan-disbursement-report/', AgentsDisburseReportView.as_view(), name='agents_loan_disbursement_report'),
    path('portifolio-at-risk/', PortifolioAtRiskView.as_view(), name='portifolio_at_risk'),
    
    
    
]

