import asyncio
from urllib.parse import urlparse

from asgiref.sync import sync_to_async, async_to_sync
from django.http import JsonResponse, HttpRequest
from django.shortcuts import render

from loans.new_views.test_server import main_site

def run_coroutine_threadsafe(coroutine, loop):
    future = asyncio.run_coroutine_threadsafe(coroutine, loop)
    return future.result()

def get_current_url(request: HttpRequest) -> str:
    return request.build_absolute_uri()


def one(request, room_name):
    current_url = get_current_url(request)
    parsed_url = urlparse(current_url)
    host = parsed_url.hostname
    print(host)

    try:
        loop = asyncio.get_event_loop()
    except RuntimeError as e:
        print('No current event loop in thread. Creating a new event loop.')
        loop = asyncio.new_event_loop()
        asyncio.set_event_loop(loop)

    if loop.is_running():
        asyncio.create_task(main_site())
    else:
        loop.run_until_complete(main_site())

    # Other view logic here
    # return reirect()
    return render(request, 'includes/threechat.html', context={'room_name': room_name})

# one_sync = async_to_sync(one)

def test_me(request, name):

    meso_type = "renderDeployments"
    message = 'am from outside'

    return JsonResponse({'status': 'ok'})
