from __future__ import annotations

import re
import traceback
from datetime import *
from math import ceil, floor
from typing import Any

from dateutil.parser import parse
from dateutil.relativedelta import relativedelta
from django.contrib.auth.decorators import login_required
from django.db.models.functions import Coalesce
from django.shortcuts import render, get_object_or_404
from django.http import HttpResponseRedirect, HttpResponse, Http404
from django.urls import reverse_lazy
from django.utils.decorators import method_decorator
from django.shortcuts import render
from django.views import View
from django.views.generic import TemplateView

from accounts.models import User, Business, Biodata

from accounts.permission_mixin import BusinessUserMixin
from sacco.decorators import can_do_this
from sacco.models import Member, LoanSettings, CurrencySetting, NotiSettings, ActivityLog
from django.db.models import Sum, Count, Q, When, FloatField, F
from loans.models import *
import random

from sacco.views import PermView
# from transactions.models import AccountCategory

# from sacco.utils import *
from django.contrib import messages

# Create your views here.
# from transactions.reports import today

from loans.models import LoanTopups, ApplicationAccountOrLoanType, LoanTypes, Loans, Loansecurities

from sacco.decorators import can_do_this
# from sacco.models import AccountBroker, SaccoSmsSettings
from sacco.utils import businessdata, branchdata, userdata, checkAndSendMessage, sendTransEmail
# from transactions.models import Account, Transactions


class LoanTypesView(PermView):
    deco_role = 'add_loan_product'
    perm_name = 'edit_loan_product'
    template_name = 'new_loans/loan_types.html'

    def get(self, request, *args, **kwargs):
        title = 'Loan Products'
        loantypes = LoanTypes.objects.filter(business=businessdata(request), is_active=True).order_by('-id')
        http = 'http://'
        if request.is_secure():
            http = 'https://'

        baseUrl = request.headers['HOST']
        baseUrl = http + baseUrl

        return render(request, self.template_name, locals())

    def post(self, request, *args, **kwargs):
        name = request.POST['name']
        maxamount = request.POST['maxamount']
        interest = request.POST['interest']
        excused = request.POST['excused']
        formula = request.POST['formula']
        warning_days = request.POST['warningd']
        maximum_securities = request.POST['maximum_securities']
        security_ratio = request.POST['security_ratio']
        maximum_period = request.POST['maximum_period']
        product_behaviour = request.POST['product_behaviour']
        product_behaviour = True if product_behaviour == 'standalone' else False
        if formula == 'per_annum':
            formula = 1
        elif formula == 'per_month':
            formula = 2
        elif formula == 'per_week':
            formula = 3
        elif formula == 'per_day':
            formula = 4


        LoanTypes.objects.create(name=name, max_loan=maxamount, interest_rate=interest, excuse_d=excused,
                                 warning_d=warning_days, maximum_securities=maximum_securities,
                                 security_ratio=security_ratio, business_id=businessdata(request),
                                 added_by_id=userdata(request), formula=formula,
                                maximum_period=maximum_period, is_standalone=product_behaviour)

        messages.success(request, 'success', extra_tags='Loan type created successfully')
        return HttpResponseRedirect(reverse_lazy('loan_types_new'))

class LoanTypesEditView(PermView):
    deco_role = 'add_loan_product'
    perm_name = 'edit_loan_product'
    template_name = 'new_loans/loan_types.html'

    def post(self, request, pk, *args, **kwargs):
        name = request.POST['edit_name']
        maxamount = request.POST['edit_maxamount']
        interest = request.POST['edit_interest']
        excused = request.POST['edit_excused']
        formula = request.POST['edit_formula']
        warning_days = request.POST['edit_warningd']
        maximum_securities = request.POST['edit_maximum_securities']
        security_ratio = request.POST['edit_security_ratio']
        maximum_period = request.POST['edit_maximum_period']
        product_behaviour = request.POST['edit_product_behaviour']
        product_behaviour = True if product_behaviour == 'standalone' else False
        if formula == 'per_annum':
            formula = 1
        elif formula == 'per_month':
            formula = 2
        elif formula == 'per_week':
            formula = 3
        elif formula == 'per_day':
            formula = 4

        LoanTypes.objects.filter(id=int(pk)).update(name=name, max_loan=maxamount, interest_rate=interest, excuse_d=excused,
                                 warning_d=warning_days, maximum_securities=maximum_securities,
                                 security_ratio=security_ratio, business_id=businessdata(request),
                                 added_by_id=userdata(request), formula=formula,
                                 maximum_period=maximum_period, is_standalone=product_behaviour)

        messages.success(request, 'success', extra_tags='Loan type Edited successfully')
        return HttpResponseRedirect(reverse_lazy('loan_types_new'))

class LoanTypesDeleteView(PermView):
    deco_role = 'add_loan_product'
    perm_name = 'edit_loan_product'
    template_name = 'new_loans/loan_types.html'

    def get(self, request, pk, *args, **kwargs):
        LoanTypes.objects.filter(id=int(pk)).update(is_active = False)
        messages.success(request, 'success', extra_tags='Loan type Deleted successfully')
        return HttpResponseRedirect(reverse_lazy('loan_types_new'))


# ====WHEN THE POST IS MADE==========================
# @can_do_this
# def post(self, request, *args, **kwargs):
#
#     form_type = request.POST['form_type']
#     if form_type == "1":
#         name = request.POST['name']
#         maxamount = request.POST['maxamount']
#         interest = request.POST['interest']
#         excused = request.POST['excused']
#         formula = request.POST['formula']
#         warning_days = request.POST['warningd']
#         maximum_securities = request.POST['maximum_securities']
#         security_ratio = request.POST['security_ratio']
#         payInterval = request.POST['interval']
#         subSchedule = request.POST['subSchedule']
#         maximum_period = request.POST['maximum_period']
#
#         # =========== INSERTING LOAN TYPES INTO THE DATABASE ============
#         LoanTypes.objects.create(name=name, max_loan=maxamount, interest_rate=interest, excuse_d=excused,
#                                  warning_d=warning_days, maximum_securities=maximum_securities,
#                                  security_ratio=security_ratio, business_id=businessdata(request),
#                                  added_by_id=userdata(request), interval=payInterval, formula=formula,
#                                  sub_intervals=subSchedule, maximum_period=maximum_period)
#
#         messages.success(request, 'success', extra_tags='Loan type created successfully')
#
#     # ======== EDITING LOAN TYPE ===============
#     if form_type == "2":
#         name = request.POST['name']
#         typeid = request.POST['typeid']
#         maxamount = request.POST['maxamount']
#         interest = request.POST['interest']
#         formula = request.POST['formula']
#         excused = request.POST['excused']
#         warning_days = request.POST['warningd']
#         maximum_securities = request.POST['maximum_securities']
#         security_ratio = request.POST['security_ratio']
#         pinterval = request.POST['interval']
#         maximum_period = request.POST['maximum_period']
#
#         # ===== INSERTING LOAN TYPES INTO THE DATABASE ========
#         edittypes = LoanTypes.objects.filter(id=typeid)
#         for edittype in edittypes:
#             edittype.name = name
#             edittype.max_loan = maxamount
#             edittype.interest_rate = interest
#             edittype.formula = formula
#             edittype.excuse_d = excused
#             edittype.warning_d = warning_days
#             edittype.maximum_securities = maximum_securities
#             edittype.security_ratio = security_ratio
#             edittype.interval = pinterval
#             edittype.maximum_period = maximum_period
#             edittype.save()
#             messages.success(request, 'success', extra_tags='Loan type Edited successfully')
#
#     # ========= DELETING LOAN TYPES INTO THE DATABASE ============
#     if form_type == "3":
#         typeid = request.POST['typeid']
#         deletetypes = LoanTypes.objects.filter(id=typeid)
#         for deletetype in deletetypes:
#             deletetype.is_active = False
#
#             deletetype.save()
#             messages.success(request, 'success', extra_tags='Loan type Deleted successfully')
#
#     # ========== ADD LOAN SETTINGS ================
#     if form_type == "settings":
#         typeid = request.POST['typeid']
#         messages.success(request, 'success', extra_tags='Loan type Deleted successfully')
#     return HttpResponseRedirect(reverse_lazy('loan_types'))