import datetime

from django.contrib import messages
from django.db import transaction
from django.db.models import Sum
from django.http import HttpResponseRedirect
from django.shortcuts import get_object_or_404
from django.urls import reverse
from django.views import View

from loans.forms.payment_forms import RepayLoanForm, DeleteRepaymentForm
from loans.models import Loans, LoanFinePayments
from sacco.models import ActivityLog, AccountBroker, CurrencySetting, NotiSettings, SaccoSmsSettings
from sacco.utils import branch_id, biz_data, biz_staff, checkAndSendMessage, sendTransEmail
from transactions.models import Transactions, Account, AccountCategory


class RepayLoanView(View):

    @transaction.atomic
    def post(self, request, pk):
        loan = Loans.objects.prefetch_related('loan_fines_custom', 'loan_fine_pay').get(id=pk)
        # print(loan.account.balance)
        form = RepayLoanForm(self.request.POST, loan=loan, user=self.request.user)
        if form.is_valid():
            amount = form.cleaned_data.get('amount')
            narrative = form.cleaned_data.get('narration')
            fineamount = form.cleaned_data.get('fineamount')
            ddate = form.cleaned_data.get('d_date')
            debited_account = form.cleaned_data.get('debited')
            interestamount = form.cleaned_data.get('interestamount')
            principalbalance = form.cleaned_data.get('principalbalance')

            user = self.request.user
            business = biz_data(user)
            staff = biz_staff(user)
            branch = branch_id(user)
            memberledger = Account.objects.filter(member_id=loan.account_id)[0]
            applicant = AccountBroker.objects.filter(the_account=loan.account_id).first()

            if debited_account == 'm':
                if applicant.the_account.balance < amount:
                    messages.error(request, 'error', extra_tags='Insufficient member balance')
                    return HttpResponseRedirect(reverse('new_loan_details', args=[loan.id]))

            if debited_account == 'm':
                debited = memberledger.id
            else:
                debited = debited_account

            principalamount = amount - float(interestamount) - float(fineamount)

            credited = Account.objects.filter(name='Loan Receivables', business=business).first()

            if principalamount > principalbalance:
                principaldifference = principalamount - principalbalance
                interestamount = interestamount + principaldifference
                principalamount = principalbalance

            if loan.repayment_method == 2 or debited_account == 'm':
                try:
                    # ================CHECK LOAN BALANCE=================================
                    currentbalance = float(applicant.the_account.balance)

                    newbalance = currentbalance - amount
                    if currentbalance >= amount:
                        applicant.the_account.balance = newbalance
                        applicant.the_account.save()
                    else:
                        messages.error(request, 'Insufficient balance',
                                       extra_tags=f'Member has insufficient funds to pay {amount} as loan repayment')
                        return HttpResponseRedirect(request.META.get("HTTP_REFERER"))

                except Exception as bal:
                    # traceback.print_exc()
                    messages.error(request, 'Something went wrong',
                                   extra_tags=f'The system could not process the loan repayment of {amount}')

            receipt = datetime.datetime.now().strftime("%y%m%d%H%M%S")

            # ==========================Save loan transaction=======================
            # Check if the ledgers exist=====================
            checkrecievables = Account.objects.filter(name='Loan Receivables', business=business).exists()
            checkinterest = Account.objects.filter(name='Loan interests', business=business).exists()
            checkfines = Account.objects.filter(name='Loan Fines', business=business).exists()
            checkinterestrecievables = Account.objects.filter(name='Loan interest receivables',
                                                              business=business).exists()

            rcategeory = AccountCategory.objects.filter(name='Account Receivables', business=business).first()

            if checkfines:
                finesaccount = Account.objects.filter(name='Loan Fines', business=business).first()
            else:
                finescat = AccountCategory.objects.filter(name='Loan incomes', business=business).first()
                finesaccount = Account.objects.create(name='Loan Fines', business=business, category_id=finescat.id,
                                                      added_by=staff)

            if float(fineamount) > 0:
                # if the custom fine is greater than 0 then pay that
                this_loan_fines = loan.loan_fines_custom.all()
                # this_loan_fines = LoanFines.objects.filter(loan_id=loanid)
                query_fines = this_loan_fines.aggregate(Sum('amount', default=0.00))['amount__sum']
                # print('total_fines', total_fines)
                query_fines_paid = loan.loan_fine_pay.all().aggregate(Sum('amount', default=0.0))['amount__sum']
                # query_fines_paid = LoanFinePayments.objects.filter(loan_id=loanid).aggregate(Sum('amount'))
                # total_fine_paid = query_fines_paid['amount__sum'] or 0
                # print('total_fine_paid', total_fine_paid)
                unpaid_fines = query_fines - query_fines_paid

                if unpaid_fines > 0:
                    LoanFinePayments.objects.create(
                        loan=loan,
                        amount=float(fineamount),
                        added_by=staff,
                    )
                    Transactions.objects.create(reporting_amount=fineamount,
                                                                    narration=f'payment of {fineamount} as Loan Fines',
                                                                    account_dr_id=debited,
                                                                    account_cr_id=finesaccount.id, loan=loan,
                                                                    tx_date=ddate, receipt=receipt,
                                                                    transaction_type='Loan Fines',
                                                                    added_by=staff,
                                                                    branch_id=branch)
                # else just create a the fines transaction
                else:
                    Transactions.objects.create(reporting_amount=fineamount,
                                                                    narration=f'payment of {fineamount} as Loan Fines',
                                                                    account_dr_id=debited,
                                                                    account_cr_id=finesaccount.id, loan=loan,
                                                                    tx_date=ddate, receipt=receipt,
                                                                    transaction_type='Loan Fines',
                                                                    added_by=staff,
                                                                    branch=branch)

            if not checkinterest:
                rcategeory2 = AccountCategory.objects.filter(name='Loan incomes', business=business).first()
                Account.objects.create(name='Loan interests', business=business,
                                                      category_id=rcategeory2.id, added_by=staff)

            if not checkrecievables:

                Account.objects.create(name='Loan Receivables', business=business, category_id=rcategeory.id,
                                       added_by=staff)

            if not checkinterestrecievables:
                Account.objects.create(name='Loan interest receivables',
                                                              business=business,
                                                              category_id=rcategeory.id,
                                                              added_by=staff)

            intrestaccount = Account.objects.filter(name='Loan interest receivables', business=business).first()

            repayment_trans = Transactions.objects.create(reporting_amount=principalamount,
                                                          narration=f'Loan payment of {principalamount} as principal' if not narrative else narrative,
                                                          account_dr_id=debited, account_cr_id=credited.id,
                                                          loan=loan, tx_date=ddate, receipt=receipt,
                                                          transaction_type='Loan repayment',
                                                          added_by=staff,
                                                          branch_id=branch)

            # ============ RECORD INTEREST =================
            if float(interestamount) > 0:
                Transactions.objects.create(reporting_amount=interestamount,
                                                             narration=f'payment of {interestamount} as Loan interest',
                                                             account_dr_id=debited, account_cr_id=intrestaccount.id,
                                                             loan=loan, tx_date=ddate, receipt=receipt,
                                                             transaction_type='Loan interest',
                                                             added_by=staff,
                                                             branch_id=branch)

                ln_interest_rec_acc = Account.objects.filter(name='loan interest receivables',
                                                             business=business)
                if ln_interest_rec_acc:
                    ln_interest_rec_acc = ln_interest_rec_acc.first()
                else:
                    ln_interest_rec_acc = Account.objects.create(
                        name='loan interest receivables', business=business,
                        display_name='loan interest receivables',
                        category=AccountCategory.objects.filter(name='Account Receivables', business=business).first(),
                    )

                ln_interest_revenue_acc = Account.objects.filter(name='Loan Interest',
                                                                 business=business).first()

                Transactions.objects.create(reporting_amount=interestamount,
                                                           narration=f'Expected interest of {interestamount}',
                                                           account_dr=ln_interest_rec_acc,
                                                           account_cr=ln_interest_revenue_acc,
                                                           loan=loan, tx_date=ddate,
                                                           transaction_type='Expected interest',
                                                           added_by=staff,
                                                           branch_id=branch)
                # print('Exp_interest', Exp_interest)

            # ========= UPDATE LOAN BALANCE ================================
            oldbalance = loan.balance or 0
            print('am old', oldbalance)
            print('am amount', amount)
            newbalance_afterpayment = oldbalance - amount

            if newbalance_afterpayment < 0:
                newbalance_afterpayment = 0

            loan.balance = newbalance_afterpayment
            loan.save()

            messages.success(request, 'success',
                             extra_tags=f'Loan payment recorded successfully. Principal of {principalamount}, Interest of {interestamount} and Fines of {fineamount}')
            payer_account = Account.objects.filter(member=loan.account).first()
            # ==== SEND NOTIFICATIONS ===============
            template_file_link = 'sacco/emails/transactional.html'
            currency = CurrencySetting.objects.filter(business=business).first()
            notify_type = NotiSettings.objects.filter(business=business).first()
            smsSettingsObj = SaccoSmsSettings.objects.get(when_to_send='On loan payment', business=business)
            email = applicant.members.biodata.email
            mail_receiver = applicant.members.biodata.name
            message = f'From: {business.short_name}\n Dear customer, a payment of {currency.currency} {amount} to service your loan has been processed successfully. Principal Paid {currency.currency} {principalamount}. Interest Paid {interestamount}. TXN ID {repayment_trans.txno}'
            html_body = f'<p>Dear {mail_receiver},</p>Your loan repayment request with the following details has been processed successfully.<br/>Transaction Number: {repayment_trans.txno}<br/>Amount: {currency.currency}{amount} <br/>Description: {repayment_trans.narration} <br/>Principal Amount: {principalamount} <br/>Interest Amount: {interestamount} <br/>Date: {repayment_trans.tx_date} <p>Please call our contact centre on +{business.contact} in case you require further details.</p>'
            if smsSettingsObj.status:
                if notify_type.notification_type == 1:  # Send by SMS only
                    if applicant.members.biodata.contact:
                        checkAndSendMessage(user, message, applicant.members.biodata.contact,
                                            applicant.members.biodata.name, account=payer_account)
                elif notify_type.notification_type == 2:  # Send by Email only
                    if applicant.members.biodata.email:
                        sendTransEmail(template_file_link, html_body, business.name, 'Successful Loan repayment',
                                       email)

                elif notify_type.notification_type == 3:  # Send by both SMS and Email
                    if applicant.members.biodata.contact:
                        checkAndSendMessage(user, message, applicant.members.biodata.contact,
                                            applicant.members.biodata.name, account=payer_account)

                    if applicant.members.biodata.email:
                        sendTransEmail(template_file_link, html_body, business.name, 'Successful Loan repayment',
                                       email)

            return HttpResponseRedirect(reverse('new_loan_details', args=[loan.id]))

        else:
            messages.error(request, 'error', extra_tags=form.errors)
        return HttpResponseRedirect(reverse('new_loan_details', args=[loan.id]))


class DeleteRepaymentView(View):
    def post(self, request, pk, receipt):
        loan = get_object_or_404(Loans, id=pk)
        form = DeleteRepaymentForm(self.request.POST)
        print(form.data)
        if form.is_valid():
            print('jhdfjhfd')
            cleaned_data = form.cleaned_data
            trans = Transactions.objects.filter(loan=loan, receipt=receipt)
            trans.delete()
            message = f"{request.user.staff.biodata.name} deleted a loan repayment transaction  of {cleaned_data['amount']} Made on {cleaned_data['tdate']} Amount {cleaned_data['amount']}]. Reason being {cleaned_data['reason']}"
            ActivityLog.objects.create(actor=request.user, title=request.user.staff.biodata.name,
                                       action_type='DELETE',
                                       remarks=message,
                                       branch_id=branch_id(request.user))
            messages.success(request, 'success', extra_tags='Successfully deleted payment')
        else:
            print('fjkdfjk')
            messages.error(request, 'error', extra_tags='Failed to delete')
        return HttpResponseRedirect(reverse('new_loan_details', args=[loan.id]))
