# Generated by Django 4.2.6 on 2024-06-21 11:43

from django.db import migrations, models
import django.db.models.deletion
import utils.file_uploads


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('sacco', '0001_initial'),
        ('accounts', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='GeneralCharge',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('charge', models.CharField(max_length=255, verbose_name='Charge Name')),
                ('application', models.CharField(choices=[('l', 'Loans'), ('r', 'Registration'), ('s', 'Shares'), ('o', 'Others')], default='d', max_length=1)),
                ('amount', models.FloatField(default=0)),
                ('is_percentage', models.BooleanField(default=False)),
                ('is_fine', models.BooleanField(default=False)),
                ('status', models.BooleanField(default=False)),
                ('date_added', models.DateField(auto_now_add=True)),
                ('execution_period', models.CharField(blank=True, choices=[('d', 'Daily'), ('w', 'Weekly'), ('m', 'Monthly'), ('y', 'Yearly')], default='d', max_length=1, null=True)),
                ('execution_period_number', models.IntegerField(blank=True, default=0, null=True)),
                ('is_revenue', models.CharField(choices=[('YES', 'Yes'), ('NO', 'No')], default='YES', max_length=4)),
                ('added_by', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='accounts.staff')),
                ('business', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='general_charges', to='accounts.business')),
            ],
        ),
        migrations.CreateModel(
            name='Loans',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('amount_requested', models.FloatField(blank=True, null=True)),
                ('amount_approved', models.FloatField(default=0.0)),
                ('rate', models.FloatField(default=0.0)),
                ('rate_type', models.IntegerField(choices=[(1, 'Flat rate'), (2, 'Reducing Balance')], default=1)),
                ('repayment_method', models.IntegerField(choices=[(1, 'By Cash'), (2, 'By member Account')], default=1)),
                ('requested_on', models.DateField(blank=True, null=True)),
                ('approved_on', models.DateField(blank=True, null=True)),
                ('schedule_start', models.DateField(blank=True, null=True)),
                ('charges', models.TextField(blank=True, null=True)),
                ('requested_duration', models.FloatField(blank=True, null=True)),
                ('approved_duration', models.FloatField(blank=True, null=True)),
                ('deductibles', models.FloatField(blank=True, null=True)),
                ('loan_status', models.IntegerField(choices=[(0, 'Applied'), (1, 'Appraised'), (2, 'Approved'), (3, 'Disbursed'), (4, 'Closed'), (5, 'Rejected'), (6, 'WaivedOff'), (7, 'WrittenOff'), (8, 'ToppedUp')], default=0)),
                ('is_topup', models.BooleanField(blank=True, default=False, null=True)),
                ('charges_paid', models.BooleanField(blank=True, default=False, null=True)),
                ('balance', models.FloatField(blank=True, null=True)),
                ('interest', models.FloatField(blank=True, null=True)),
                ('principal', models.FloatField(blank=True, null=True)),
                ('interval', models.IntegerField(blank=True, choices=[(0, 'Days'), (1, 'Weeks'), (2, 'Fortnight'), (3, 'Months'), (4, 'Years')], null=True)),
                ('created_date', models.DateTimeField(auto_now_add=True)),
                ('voucher', models.CharField(blank=True, max_length=255, null=True, verbose_name='Loan Voucher Number')),
                ('sub_intervals', models.BooleanField(default=False)),
                ('loan_number', models.CharField(blank=True, max_length=255, null=True, verbose_name='Loan number')),
                ('topped_up_loan', models.BigIntegerField(blank=True, null=True)),
                ('group_guaratorship', models.BooleanField(default=False)),
                ('loan_summary_details', models.TextField(blank=True, null=True)),
                ('savings_rem_balance', models.FloatField(blank=True, null=True)),
                ('savings_percentage_balance', models.FloatField(blank=True, null=True)),
                ('account', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='members', to='sacco.memberaccount')),
                ('added_by', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='addedBy', to='accounts.staff')),
                ('applicant', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='applicant', to='sacco.member')),
                ('approved_by', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='approvedBy', to='accounts.staff')),
                ('branch', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='accounts.branch')),
                ('financial_year', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='sacco.financialyear')),
                ('group_guarantor', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='individual_group_guarantor', to='sacco.member')),
            ],
            options={
                'verbose_name': 'Loan',
                'verbose_name_plural': 'Loans',
                'db_table': 'loans',
            },
        ),
        migrations.CreateModel(
            name='LoanTypes',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255)),
                ('max_loan', models.FloatField(verbose_name='Maximum Loan')),
                ('interest_rate', models.FloatField()),
                ('excuse_d', models.IntegerField(verbose_name='Excuse days')),
                ('warning_d', models.IntegerField(verbose_name='Warning days')),
                ('formula', models.IntegerField(blank=True, choices=[(1, 'Per Annum'), (2, 'Per Month'), (3, 'Per Week'), (4, 'Per Day')], default=1, null=True)),
                ('maximum_period', models.IntegerField(blank=True, default=None, null=True, verbose_name='Maximum Period')),
                ('maximum_securities', models.IntegerField(default=1)),
                ('security_ratio', models.IntegerField(default=150)),
                ('is_active', models.BooleanField(default=True)),
                ('sub_intervals', models.BooleanField(default=False)),
                ('date_added', models.DateField(auto_now_add=True)),
                ('interval', models.IntegerField(blank=True, choices=[(0, 'Days'), (1, 'Weeks'), (2, 'Fortnight'), (3, 'Months'), (4, 'Years')], default=0, null=True)),
                ('synced', models.BooleanField(default=False, verbose_name='Synced to the portal')),
                ('is_standalone', models.BooleanField(default=False)),
                ('added_by', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='sacco_staff', to='accounts.staff')),
                ('business', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='accounts.business')),
            ],
            options={
                'verbose_name': 'Loan Type',
                'verbose_name_plural': 'Loan Types',
                'db_table': 'loan_types',
            },
        ),
        migrations.CreateModel(
            name='UploadLoans',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('file_name', models.CharField(blank=True, max_length=255, null=True)),
                ('file', models.FileField(blank=True, null=True, upload_to=utils.file_uploads.loan_files)),
                ('total_records', models.IntegerField(blank=True, null=True)),
                ('upload_date', models.DateField(blank=True, null=True)),
                ('created_date', models.DateTimeField(auto_now_add=True)),
                ('failed_loans', models.TextField(blank=True, null=True)),
                ('total_failed_loans', models.IntegerField(blank=True, null=True)),
                ('added_by', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='accounts.staff')),
                ('branch', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='accounts.branch')),
                ('loan_type', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='loans.loantypes')),
            ],
            options={
                'verbose_name': 'Upload Loan',
                'verbose_name_plural': 'Uploads Loans',
                'db_table': 'upload_loans',
            },
        ),
        migrations.CreateModel(
            name='LoanUpload',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('file_name', models.CharField(blank=True, max_length=255, null=True)),
                ('file', models.FileField(blank=True, null=True, upload_to=utils.file_uploads.loan_files)),
                ('created_date', models.DateTimeField(auto_now_add=True)),
                ('added_by', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='accounts.staff')),
                ('loan', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='docs', to='loans.loans')),
            ],
            options={
                'verbose_name': 'Loan Upload',
                'verbose_name_plural': 'Loan Uploads',
                'db_table': 'loan_uploads',
            },
        ),
        migrations.CreateModel(
            name='LoanTopups',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('approved', models.BooleanField(blank=True, default=True, null=True)),
                ('created_date', models.DateTimeField(auto_now_add=True)),
                ('added_by', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='accounts.staff')),
                ('branch', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='accounts.branch')),
                ('closed_loan', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='closed_loan', to='loans.loans')),
                ('topup_loan', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='topup_loan', to='loans.loans')),
            ],
            options={
                'verbose_name': 'Loan Topup',
                'verbose_name_plural': 'Loan Topups',
                'db_table': 'loan_topups',
            },
        ),
        migrations.CreateModel(
            name='Loansecurities',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(blank=True, max_length=255, null=True)),
                ('value', models.FloatField(blank=True, null=True)),
                ('description', models.TextField(blank=True, null=True)),
                ('file', models.FileField(upload_to='loan_uploads')),
                ('created_date', models.DateTimeField(auto_now_add=True)),
                ('added_by', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='accounts.staff')),
                ('loan', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='securities', to='loans.loans')),
            ],
            options={
                'verbose_name': 'Loan Security',
                'verbose_name_plural': 'Loan Securities',
                'db_table': 'loan_securities',
            },
        ),
        migrations.AddField(
            model_name='loans',
            name='loan_type',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='loans.loantypes'),
        ),
        migrations.AddField(
            model_name='loans',
            name='officer',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='accounts.staff'),
        ),
        migrations.AddField(
            model_name='loans',
            name='upload',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='upload', to='loans.uploadloans'),
        ),
        migrations.CreateModel(
            name='LoanRepaymentUpload',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('narration', models.TextField()),
                ('total_records_added', models.FloatField()),
                ('total_records_failed', models.FloatField()),
                ('transactions_created', models.TextField()),
                ('failed_loans', models.TextField()),
                ('date_added', models.DateField(auto_now_add=True)),
                ('file', models.FileField(upload_to='loan repayments')),
                ('branch', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='repayment_branch', to='accounts.branch')),
            ],
            options={
                'verbose_name': 'Repayment upload',
                'verbose_name_plural': 'Repayment uploads',
                'db_table': 'repayment_upload',
            },
        ),
        migrations.CreateModel(
            name='LoanOrAccountOrShareBroker',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('the_type', models.CharField(choices=[('l', 'Loan type'), ('a', 'account type'), ('s', 'share')], default='d', max_length=1)),
                ('account_type', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='sacco.accounttypes')),
                ('loan_type', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='loans.loantypes')),
            ],
            options={
                'verbose_name': 'Loan or account or share broker',
                'verbose_name_plural': 'Loan or account or share brokers',
                'db_table': 'loan_or_account_or_share_broker',
            },
        ),
        migrations.CreateModel(
            name='Loanguarantors',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_date', models.DateTimeField(auto_now_add=True)),
                ('added_by', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='accounts.staff')),
                ('biodata', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='accounts.biodata')),
                ('group', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='group_guarantors', to='sacco.member')),
                ('loan', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='guarantors', to='loans.loans')),
            ],
            options={
                'verbose_name': 'Loan Guarantor',
                'verbose_name_plural': 'Loan Guarantors',
                'db_table': 'loan_guarantors',
            },
        ),
        migrations.CreateModel(
            name='LoanFines',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('amount', models.FloatField(default=0)),
                ('narration', models.TextField(null=True)),
                ('created_date', models.DateTimeField(auto_now_add=True)),
                ('added_by', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='accounts.staff')),
                ('loan', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='loan_fines_custom', to='loans.loans')),
            ],
            options={
                'verbose_name': 'Loan Fines',
                'verbose_name_plural': 'Loan Fines',
                'db_table': 'loan_fines',
            },
        ),
        migrations.CreateModel(
            name='LoanFinePayments',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('amount', models.FloatField(default=0)),
                ('created_date', models.DateTimeField(auto_now_add=True)),
                ('added_by', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='accounts.staff')),
                ('loan', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='loan_fine_pay', to='loans.loans')),
            ],
            options={
                'verbose_name': 'Loan Fine Payments',
                'verbose_name_plural': 'Loan Fine Payments',
                'db_table': 'loan_fine_payments',
            },
        ),
        migrations.CreateModel(
            name='LoanCharges',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('amount', models.FloatField()),
                ('charge', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='loans.generalcharge')),
                ('loan', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='loan_charges', to='loans.loans')),
            ],
            options={
                'verbose_name': 'Loan charge',
                'verbose_name_plural': 'Loan charges',
                'db_table': 'loan_charges',
            },
        ),
        migrations.CreateModel(
            name='BouncedLoansUpload',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('narration', models.TextField()),
                ('total_records_added', models.FloatField()),
                ('total_records_failed', models.FloatField()),
                ('transactions_created', models.TextField()),
                ('failed_loans', models.TextField()),
                ('date_added', models.DateField(auto_now_add=True)),
                ('file', models.FileField(upload_to='bounced loans')),
                ('branch', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='bounced_branch', to='accounts.branch')),
            ],
            options={
                'verbose_name': 'bounced loan upload',
                'verbose_name_plural': 'bounced loan uploads',
                'db_table': 'bounced_loan_upload',
            },
        ),
        migrations.CreateModel(
            name='ApplicationAccountOrLoanType',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('account_type', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='sacco.accounttypes')),
                ('general_charge', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='applications', to='loans.generalcharge')),
                ('loan_type', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='application_account_loan_type', to='loans.loantypes')),
            ],
            options={
                'verbose_name': 'application account or loan or share type',
                'verbose_name_plural': 'application account or loan or share types',
                'db_table': 'application_account_or_loan_type',
            },
        ),
    ]
