from django import forms

from sacco.models import LoanSettings
from sacco.utils import businessdata


class LoanSettingsForm(forms.Form):
    min_guarantors = forms.IntegerField()
    top_up_limit = forms.IntegerField()
    non_member = forms.CharField()
    decimals = forms.IntegerField()
    documents = forms.CharField()
    fines = forms.CharField()
    min_approvals = forms.IntegerField()
    use_shares = forms.CharField()

    def __init__(self, *args, **kwargs):
        self.request = kwargs.pop('request', None)
        super(LoanSettingsForm, self).__init__(*args, **kwargs)

    def clean_non_member(self) -> bool:
        non_member = self.cleaned_data['non_member']
        if non_member == '1': # allow non members
            return True
        return False

    def clean_fines(self) -> bool:
        fines = self.cleaned_data['fines']
        if fines == '1': # allow automatic
            return True
        return False

    def clean_documents(self) -> bool:
        documents = self.cleaned_data['documents']
        if documents == '1': # allow minute uploads
            return True
        return False

    def clean_use_shares(self) -> bool:
        documents = self.cleaned_data['use_shares']
        if documents == '1': # allow to use shares
            return True
        return False

    def save(self):
        cleaned_data = self.cleaned_data
        min_guarantors = cleaned_data['min_guarantors']
        min_approvals = cleaned_data['min_approvals']
        decimals = cleaned_data['decimals']
        top_up_limit = cleaned_data['top_up_limit']
        documents = cleaned_data['documents']
        fines = cleaned_data['fines']
        non_members = cleaned_data['non_member']
        loan, created = LoanSettings.objects.update_or_create(business_id=businessdata(self.request))
        if created:
            loan.min_approvals = min_approvals
            loan.minimum_guarantors = min_guarantors
            loan.decimals = decimals
            loan.top_up_limit = top_up_limit
            loan.upload_minutes = documents
            loan.fines_on = fines
            loan.allow_others = non_members
            loan.save()
        else:
            loan.min_approvals = min_approvals
            loan.minimum_guarantors = min_guarantors
            loan.decimals = decimals
            loan.top_up_limit = top_up_limit
            loan.upload_minutes = documents
            loan.fines_on = fines
            loan.allow_others = non_members
            loan.save()
        return cleaned_data


