import calendar
import json
import re
from datetime import *
import datetime
from math import ceil, floor

from datetime import date
from dateutil.relativedelta import relativedelta
from django.contrib.auth.decorators import login_required
from django.shortcuts import render, get_object_or_404
from django.http import HttpResponseRedirect, HttpResponse
from django.urls import reverse_lazy
from django.utils.decorators import method_decorator
from django.shortcuts import render
from django.views import View

from accounts.permission_mixin import BusinessUserMixin
from sacco.models import Member, LoanSettings
from django.db.models import Sum, Count, Q
from loans.models import *
import random

from transactions.models import Account, AccountCategory, Transactions

from sacco.utils import *
from django.contrib import messages

# Create your views here.
from transactions.reports import today


@method_decorator(login_required, name='dispatch')
class LoanSettingsView(View):
    template_name = 'loans/loan_settings.html'

    def get(self, request, *args, **kwargs):
        title = 'Loan settings'
        try:
            loansettings = LoanSettings.objects.filter(business=businessdata(request))[0]
            # print(loansettings)
        except Exception as ex:
            loansetings = LoanSettings.objects.filter(business=businessdata(request))
            # print(str(ex))
        return render(request, self.template_name, locals())

    def post(self, request, *args, **kwargs):
        min_guarantors = request.POST['min_guarantors']
        max_guarantors = request.POST['max_guarantors']
        formula = request.POST['formula']
        non_member = request.POST['non_member']

        decimals = request.POST['decimals']
        documents = request.POST['documents']
        fines = request.POST['fines']

        if non_member == "1":
            non_members = True

        else:
            non_members = False

        if fines == "1":
            fine = True

        else:
            fine = False

        if documents == "1":
            document = True

        else:
            document = False

        #         ===============================SAVE SETTINGS=========================
        try:
            editsetings = LoanSettings.objects.filter(business=businessdata(request))[0]

            editsetings.minimum_guarantors = min_guarantors
            editsetings.maximum_guarantors = max_guarantors
            editsetings.decimals = decimals
            editsetings.formula = formula
            editsetings.allow_others = non_members
            editsetings.allow_uploads = document
            editsetings.fines_on = fine

            editsetings.save()
            messages.success(request, 'success', extra_tags='Loan settings saved successfully')


        except:
            savesetting = LoanSettings.objects.create(minimum_guarantors=min_guarantors,
                                                      maximum_guarantors=max_guarantors,
                                                      decimals=decimals,
                                                      formula=formula,
                                                      allow_others=non_members,
                                                      allow_uploads=document,
                                                      fines_on=fine,
                                                      business_id=businessdata(request))

            messages.success(request, 'success', extra_tags='Loan type created successfully')

        return HttpResponseRedirect(reverse_lazy('loan_settings'))


# applied loans
@method_decorator(login_required, name='dispatch')
class AppliedLoansView(View):
    template_name = 'loans/applied_loans.html'

    def get(self, request, *args, **kwargs):
        title = 'Loan Applications'
        try:
            filter = int(request.GET['filter'])
            loanApplications = Loans.objects.raw(
                "SELECT l. *, b.the_account_id as accountid, b.members_id as memberid, a.acc_number, m.biodata_id, m.id, c.name AS member_name FROM account_broker b, member_accounts a, sacco_member m, biodata c, loans l where b.the_account_id = a.id and b.business_id = %s and b.members_id = m.id and m.biodata_id = c.id and l.account_id = a.id and l.branch_id = %s and l.loan_status = %s" % (
                    businessdata(request), branchdata(request), filter))
            if filter == 0:
                title = 'Pending Loan application'

            if filter == 1:
                title = 'Loan application submitted to the committee for action'

            if filter == 2:
                title = 'Approved Loan application pending dusbursment'

        except:

            loanApplications = Loans.objects.raw(
                "SELECT l. *, b.the_account_id as accountid, b.members_id as memberid, a.acc_number, m.biodata_id, m.id, c.name AS member_name FROM account_broker b, member_accounts a, sacco_member m, biodata c, loans l where b.the_account_id = a.id and b.business_id = %s and b.members_id = m.id and m.biodata_id = c.id and l.account_id = a.id and l.branch_id = %s and (l.loan_status = 0 or l.loan_status = 1 or l.loan_status = 2)" % (
                    businessdata(request), branchdata(request)))

        return render(request, self.template_name, locals())

    #     ========================LOAN APPLICATION FILTERS =====================================
    def post(self, request, *args, **kwargs):
        filter = int(request.POST['filter'])

        # loanApplications = Loans.objects.filter(loan_status=0, branch=branchdata(request))
        return HttpResponseRedirect(reverse_lazy('loan_applications'))


# running loans
@method_decorator(login_required, name='dispatch')
class RunningLoans(View):
    template_name = 'loans/running_loans.html'

    def get(self, request, *args, **kwargs):
        title = 'Running Loans'
        loanApplications = Loans.objects.raw(
            "SELECT l. *, b.the_account_id as accountid, b.members_id as memberid, a.acc_number, m.biodata_id, m.id, c.name AS member_name FROM account_broker b, member_accounts a, sacco_member m, biodata c, loans l where b.the_account_id = a.id and b.business_id = %s and b.members_id = m.id and m.biodata_id = c.id and l.account_id = a.id and l.branch_id = %s and (l.loan_status = 3)" % (
                businessdata(request), branchdata(request)))
        return render(request, self.template_name, locals())


@method_decorator(login_required, name='dispatch')
class ClearedLoans(View):
    template_name = 'loans/cleared_loans.html'

    def get(self, request, *args, **kwargs):
        title = 'Cleared Applications'
        loanApplications = Loans.objects.raw(
            "SELECT l. *, b.the_account_id as accountid, b.members_id as memberid, a.acc_number, m.biodata_id, m.id, c.name AS member_name FROM account_broker b, member_accounts a, sacco_member m, biodata c, loans l where b.the_account_id = a.id and b.business_id = %s and b.members_id = m.id and m.biodata_id = c.id and l.account_id = a.id and l.branch_id = %s and (l.loan_status = 4)" % (
                businessdata(request), branchdata(request)))
        return render(request, self.template_name, locals())


# ==========NEW LOAN APPLICATION============================
@method_decorator(login_required, name='dispatch')
class ApplyLoan(View):
    template_name = 'loans/apply_loan.html'

    def get(self, request, *args, **kwargs):
        title = 'Loan Application'
        loantypes = LoanTypes.objects.filter(business=businessdata(request), is_active=True)
        members_accts = Member.objects.raw(
            "SELECT  b.the_account_id as accountid,b.members_id as memberid,a.acc_number,m.biodata_id,m.id, c.name AS member_name FROM account_broker b, member_accounts a, sacco_member m, biodata c where b.the_account_id=a.id and b.business_id=%s and b.members_id=m.id and m.biodata_id=c.id" % businessdata(
                request))
        return render(request, self.template_name, locals())

    # =================RECEIVE FORM APPLICATION DATA==============================
    def post(self, request, *args, **kwargs):
        loan_type = request.POST['loan_type']
        account = request.POST['account']
        amount = request.POST['amount']

        amount = amount.replace(',', '')
        adate = request.POST['adate']
        interest = request.POST['interest']
        duration = request.POST['duration']
        rate_type = request.POST['rate_type']
        payment_method = request.POST['payment_method']

        #         ============SAVE LOAN APPLICATION INTO THE DATABASE======================

        loanapply = Loans.objects.create(account_id=account,
                                         branch_id=branchdata(request),
                                         amount_requested=amount,
                                         rate=interest,
                                         rate_type=rate_type,
                                         requested_on=adate,
                                         loan_type_id=loan_type,
                                         requested_duration=duration,
                                         repayment_method=payment_method,
                                         added_by_id=userdata(request)
                                         )
        messages.success(request, 'success', extra_tags='Loan Application submitted successfully')
        return HttpResponseRedirect(reverse_lazy('loan_applications'))


# =============================Loan types start==========================
@method_decorator(login_required, name='dispatch')
class LoanTypesView(View):
    template_name = 'loans/loan_types.html'

    def get(self, request, *args, **kwargs):
        title = 'Loan Products'
        loantypes = LoanTypes.objects.filter(business=businessdata(request), is_active=True)

        return render(request, self.template_name, locals())

    # ====WHEN THE POST IS MADE==========================

    def post(self, request, *args, **kwargs):
        form_type = request.POST['form_type']
        if form_type == "1":
            name = request.POST['name']
            maxamount = request.POST['maxamount']
            interest = request.POST['interest']
            excused = request.POST['excused']
            warningd = request.POST['warningd']
            maximum_securities = request.POST['maximum_securities']
            security_ratio = request.POST['security_ratio']
            pinterval = request.POST['interval']

            #         ===========INSERTING LOAN TYPES INTO THE DATABASE ==========================
            saveloantype = LoanTypes.objects.create(
                name=name,
                max_loan=maxamount,
                interest_rate=interest,
                excuse_d=excused,
                warning_d=warningd,
                maximum_securities=maximum_securities,
                security_ratio=security_ratio,
                business_id=businessdata(request),
                added_by_id=userdata(request),
                interval=pinterval,

            )

            messages.success(request, 'success', extra_tags='Loan type created successfully')

        # =================================EDITING LOAN TYPE===================================

        if form_type == "2":
            name = request.POST['name']
            typeid = request.POST['typeid']
            maxamount = request.POST['maxamount']
            interest = request.POST['interest']
            excused = request.POST['excused']
            warningd = request.POST['warningd']
            maximum_securities = request.POST['maximum_securities']
            security_ratio = request.POST['security_ratio']
            pinterval = request.POST['interval']

            #         ===========INSERTING LOAN TYPES INTO THE DATABASE ==========================
            edittypes = LoanTypes.objects.filter(id=typeid)
            for edittype in edittypes:
                edittype.name = name
                edittype.max_loan = maxamount
                edittype.interest_rate = interest
                edittype.excuse_d = excused
                edittype.warning_d = warningd
                edittype.maximum_securities = maximum_securities
                edittype.security_ratio = security_ratio
                edittype.interval = pinterval
                edittype.save()
                messages.success(request, 'success', extra_tags='Loan type Editted successfully')

        if form_type == "3":
            typeid = request.POST['typeid']

            #         ===========DELETING LOAN TYPES INTO THE DATABASE ==========================

            deletetypes = LoanTypes.objects.filter(id=typeid)
            for deletetype in deletetypes:
                deletetype.is_active = False

                deletetype.save()
                messages.success(request, 'success', extra_tags='Loan type Deleted successfully')

        # =====================ADD LOAN SETTINGS============================================
        if form_type == "settings":
            typeid = request.POST['typeid']
            messages.success(request, 'success', extra_tags='Loan type Deleted successfully')
        return HttpResponseRedirect(reverse_lazy('loan_types'))


# =============================Loan Details==========================
@method_decorator(login_required, name='dispatch')
class LoanDetails(View):
    template_name = 'loans/loan_details.html'

    def get(self, request, pk, *args, **kwargs):
        title = 'Loan Details '
        loanid = pk
        loansid = int(loanid)
        # detail = get_object_or_404(Loans, id=pk)
        # detail = Loans.objects.get(id=pk)
        nowdate = today.strftime("%Y-%m-%d")

        detail = Loans.objects.raw(
            "SELECT l.*, b.the_account_id as accountid, b.members_id as memberid, a.acc_number, m.biodata_id, m.id, c.name AS member_name, year(l.approved_on) as yapp, month(l.approved_on) as appmonth, day(l.approved_on) as appday FROM account_broker b, member_accounts a, sacco_member m, biodata c, loans l where b.the_account_id = a.id and b.business_id = %s and b.members_id = m.id and m.biodata_id = c.id and l.account_id = a.id and l.branch_id = %s and l.id=%s" % (
                businessdata(request), branchdata(request), pk))[0]

        laonacct = Account.objects.filter(name='Loan Receivables', business=businessdata(request))[0]

        if detail.is_topup == True and int(detail.loan_status) < 3:
            title = 'Loan topup application details'

        elif int(detail.loan_status) < 3:
            title = 'Loan application details'

        try:
            paid = Transactions.objects.raw(
                "SELECT SUM(reporting_amount) as tpaid,id from transactions where (transaction_type='Loan repayment' OR transaction_type='Loan interest') AND loan_id= %s " % (
                    loanid))[0]
            paidamount = paid.tpaid

        except:
            paidamount = 0

        #    ========================CLEARED INTERESTS============================================

        try:
            interestspaid = Transactions.objects.filter(loan_id=loanid, transaction_type='Loan interest',
                                                        branch__business_id=businessdata(request))
            intpaid = interestspaid.count()

        except Exception as ex:
            intpaid = 0

        # ===========================================================================================

        try:
            editsetings = LoanSettings.objects.filter(business=businessdata(request))[0]
            decimals = editsetings.decimals
            formula = editsetings.formula
            maxguarantors = editsetings.minimum_guarantors
        except:
            decimals = 0
            formula = 1
            maxguarantors = 2

        securities = Loansecurities.objects.filter(loan=loanid)

        # ======================SEND TO THE VIEW CALCULATED CHARGES======================================

        totalcharges = 0
        print(detail.loan_status)

        if int(detail.loan_status) > 1:
            actualchargesx = detail.charges
            try:
                actualcharges = json.loads(actualchargesx)
                for chg in actualcharges:
                    chargeamount = chg['amount']
                    totalcharges = totalcharges + chargeamount

            except:
                totalcharges = 0


        # ==============================GET CHARGES IF THE CHARGES ARE STILL IN APPLICATION STAGE=======================
        else:
            charges = ApplicationAccountOrLoanType.objects.filter(loan_type=detail.loan_type, general_charge__status=1)
            actualcharges = []
            for charge in charges:

                ispercentage = charge.general_charge.is_percentage
                if ispercentage == 1:
                    chargeamount = (charge.general_charge.amount * detail.amount_approved) / 100

                else:
                    chargeamount = charge.general_charge.amount

                actualcharges.append(
                    {"name": charge.general_charge.charge, "amount": chargeamount}
                )

                totalcharges = totalcharges + chargeamount

        if detail.is_topup == True:
            oldloan=LoanTopups.objects.filter(topup_loan_id=loanid)[0]
            oldbalance = oldloan.closed_loan_id
            totalcharges = totalcharges + oldbalance

        disbusable = detail.amount_approved - totalcharges
        disbusable = round(disbusable, decimals)

        guarantors = Loanguarantors.objects.filter(loan=loanid)
        loantypes = LoanTypes.objects.filter(business=businessdata(request), is_active=True)

        # ==================GET INTEREST IN RELATION TO SETTINGS=====================
        typeinterval = detail.loan_type.interval
        interest = (detail.rate / 100) / 12
        if detail.loan_status == 3:

            maccount = detail.accountid

            # ===================CHECK IF THE LOAN HAS A TOPUP APPLICATION ALREADY=========================
            try:
                checktopup = Loans.objects.filter(account_id=maccount, loan_status__lt=3)[0]
                sometopup = 1
            except:
                sometopup = 0

            try:
                paidamount = round(paidamount, decimals)

            except:
                paidamount = 0

            duration = detail.approved_duration
            appdate = detail.schedule_start
            principal = detail.amount_approved

            if formula == 2:
                interest = (detail.rate / 100)

            if formula == 1:
                if typeinterval == 3:
                    interest = (detail.rate / 100) / 12

                if typeinterval == 0:
                    interest = (detail.rate / 100) / 365

                if typeinterval == 1:
                    interest = (detail.rate / 100) / 52

                if typeinterval == 2:
                    interest = (detail.rate / 100) / 26

                if typeinterval == 4:
                    interest = (detail.rate / 100)

            # ===================GET LOAN REPAYMENTS========================================
            repayments = Transactions.objects.raw(
                "SELECT sum(reporting_amount) as paidamount, id, receipt FROM transactions where loan_id= %s and (transaction_type='Loan repayment' or transaction_type='Loan interest' ) GROUP BY receipt" % (
                    loanid))

            # =====================IF INTERVAL IS MONTHLY =========================
            if typeinterval == 3:
                to_add = relativedelta(months=1)
                all_duration = relativedelta(months=duration)

            # =====================IF INTERVAL IS DAILY =========================

            if typeinterval == 0:
                to_add = relativedelta(days=1)
                all_duration = relativedelta(days=duration)

            # =====================IF INTERVAL IS WEEKLY =========================

            if typeinterval == 1:
                to_add = relativedelta(weeks=1)
                all_duration = relativedelta(weeks=duration)

            # =====================IF INTERVAL IS BI-WEEKLY =========================

            if typeinterval == 2:
                to_add = relativedelta(weeks=2)
                all_duration = relativedelta(weeks=duration * 2)

            # =====================IF INTERVAL IS YEARLY =========================

            if typeinterval == 4:
                to_add = relativedelta(years=1)
                all_duration = relativedelta(years=duration)

            # ================================IF THE INTEREST IS FLAT RATE==========================
            if detail.rate_type == 1:
                in_date = ''

                loan_dict = {}
                days = []
                schedules = round(detail.amount_approved / duration, decimals)
                interestperschedue = round(detail.amount_approved * interest, decimals)
                payable = interestperschedue + schedules
                startyear = detail.yapp
                startmonth = detail.appmonth + 1
                startday = detail.appday

                # ========================================GET PAID SCHEDULES=========================

                paidschedules = paidamount / payable
                paidschedules = floor(paidschedules)

                # ====================================Balance for the next schedule=======================
                nextbal = paidamount - (payable * paidschedules)
                nextintallment = payable - nextbal

                nextschedule = paidschedules + 1
                data = []

                edate = appdate + to_add
                # print(appdate)
                date1 = edate
                totalpayable = payable * duration

                totalpayable = round(totalpayable, decimals)

                rbalance = totalpayable

                date2 = date1 + all_duration
                m = 1

                while date1 < date2:
                    rbalance = rbalance - payable
                    rbalance = round(rbalance, decimals)
                    if m == nextschedule:
                        isnext = 1
                        spaid = round(nextbal, decimals)
                        sbalance = round(nextintallment, decimals)

                    elif m < nextschedule:
                        isnext = 0
                        spaid = round(payable, decimals)
                        sbalance = 0

                    else:
                        isnext = 2
                        spaid = 0
                        sbalance = round(payable, decimals)

                    days.append([date1.strftime("%Y-%m-%d"),
                                 isnext,
                                 spaid,
                                 sbalance,
                                 rbalance
                                 ]
                                )
                    date1 = date1 + to_add

                    # print(principal)

                    m = m + 1

            # =============================================IF THE RATE TYPE IS REDUCING=====================================
            if detail.rate_type == 2:
                in_date = ''
                loan_dict = {}
                data = []
                days = []
                edate = appdate + to_add
                # print(appdate)
                date1 = edate
                principals = 0
                date2 = date1 + all_duration
                runningbal = detail.amount_approved
                schedules = 9
                # interestperschedue = schedules * interest / 100;

                numilator = principal * interest * (
                        (pow((1 + interest), duration)) / (pow((1 + interest), duration) - 1))
                payable = round(numilator, decimals)

                totalpayable = payable * duration

                totalpayable = round(totalpayable, decimals)

                rprincipal = 0
                rbalance = principal
                # ========================================GET PAID SCHEDULES=========================

                paidschedules = paidamount / payable
                paidschedules = floor(paidschedules)

                nextschedule = paidschedules + 1
                # ====================================Balance for the next schedule=======================
                nextbal = paidamount - (payable * paidschedules)
                nextintallment = payable - nextbal

                m = 1
                isnext = 0

                while date1 < date2:

                    if m == nextschedule:
                        isnext = 1
                        spaid = round(nextbal, decimals)
                        sbalance = round(nextintallment, decimals)

                    elif m < nextschedule:
                        isnext = 0
                        spaid = round(payable, decimals)
                        sbalance = 0

                    else:
                        isnext = 2
                        spaid = 0
                        sbalance = round(payable, decimals)

                    days.append(date1.strftime("%Y-%m-%d"))
                    date1 = date1 + to_add

                    interestperschedue = rbalance * interest
                    interestperschedue = round(interestperschedue, decimals)
                    rprincipal = payable - interestperschedue
                    rprincipal = round(rprincipal, decimals)
                    rbalance = principal * ((pow((1 + interest), duration) - pow((1 + interest), m)) / (
                            pow((1 + interest), duration) - 1))

                    if intpaid == m or intpaid > m:
                        actualinterest = 0


                    else:

                        actualinterest = interestperschedue

                    rbalance = round(rbalance, decimals)

                    loan_dict[in_date] = date1.strftime("%Y-%m-%d")
                    loan_dict[rprincipal] = rprincipal
                    loan_dict[rbalance] = rbalance
                    loan_dict[isnext] = isnext
                    loan_dict[interestperschedue] = interestperschedue
                    loan_dict[spaid] = spaid
                    loan_dict[sbalance] = sbalance
                    loan_dict[actualinterest] = actualinterest

                    data.append([loan_dict[rprincipal],
                                 loan_dict[in_date],
                                 loan_dict[rbalance],
                                 loan_dict[interestperschedue],
                                 loan_dict[isnext],
                                 loan_dict[spaid],
                                 loan_dict[sbalance],
                                 loan_dict[actualinterest]
                                 ])
                    m = m + 1

                    # //principal = rprincipal
            generalbalance = totalpayable - paidamount
            try:
                if generalbalance == 0 or generalbalance < 0:
                    detail.loan_status = 4

            except:
                pass
            generalbalance = round(generalbalance, decimals)
            detail.balance = generalbalance
            detail.save()

            totalinterest = totalpayable - detail.amount_approved
            totalinterest = round(totalinterest, decimals)

        totalsecurites = Loansecurities.objects.raw(
            "SELECT id, SUM(value) as totalsecurity from loan_securities where loan_id=%s" % loanid)[0]
        # totalsecurites = Loansecurities.objects.filter(loan_id=loanid).annotate(totalsecurity=Sum('value'))
        nsecurities = Loansecurities.objects.filter(loan_id=loanid).count()
        nguarantors = Loanguarantors.objects.filter(loan_id=loanid).count()
        maxi_securities = detail.loan_type.maximum_securities

        members_accts = Member.objects.filter(biodata__business=businessdata(request), )
        # =============TAKE BANKS======================
        bankaccounts = Account.objects.filter(business=businessdata(request), category__name='Bank')

        return render(request, self.template_name, locals())

    #     ================ CAPTURE LOAN SECURITY FROM THE FORM===========================

    def post(self, request, *args, **kwargs):
        form_type = request.POST['form_type']
        # print("THIS IS THE TYPE " + form_type)
        if form_type == "1":
            name = request.POST['name']
            value = request.POST['value']
            proofs = request.FILES['proof']
            description = request.POST['description']
            loanid = request.POST['loanid']

            savesecurity = Loansecurities.objects.create(loan_id=loanid,
                                                         name=name,
                                                         value=value,
                                                         file=proofs,
                                                         description=description)
            messages.success(request, 'success', extra_tags='Loan Security added successfully')

        if form_type == "editsecurity":
            name = request.POST['name']
            value = request.POST['value']
            description = request.POST['description']
            securityid = request.POST['securityid']
            loanid = request.POST['loanid']
            editsecurities = Loansecurities.objects.filter(id=securityid)
            for editsecurity in editsecurities:
                editsecurity.name = name
                editsecurity.value = value
                editsecurity.description = description
                editsecurity.save()

                messages.success(request, 'success', extra_tags='Loan Security Editted successfully')

        # ===========================DELETE SECURITY=========================================
        if form_type == "deletesecurity":
            securityid = request.POST['securityid']
            loanid = request.POST['loanid']
            deletesecurities = Loansecurities.objects.filter(id=securityid)
            for deletesecurity in deletesecurities:
                deletesecurity.delete()

                messages.success(request, 'success', extra_tags='Loan Security Successfully Deleted')

        # =============================DELETE GUARANTOR=========================

        if form_type == "deleteguarantor":
            guarantorid = request.POST['guarantorid']
            loanid = request.POST['loanid']
            deleteguarantors = Loanguarantors.objects.filter(id=guarantorid)
            for dg in deleteguarantors:
                dg.delete()

                messages.success(request, 'success', extra_tags='Loan Guarantor Successfully Deleted')

        #     =======IF THE POSTED IS FOR GUARANTOR===============================================================

        if form_type == "2":
            guarantor = request.POST['account']
            loanid = request.POST['loanid']
            saveguarantor = Loanguarantors.objects.create(loan_id=loanid, biodata_id=guarantor,
                                                          added_by_id=userdata(request))
            messages.success(request, 'success', extra_tags='Loan guarantor added successfully')

        # ==============================EDIT LOAN APPLICATION ============================

        if form_type == 'editloan':
            loan_type = request.POST['loan_type']
            loanid = request.POST['loanid']
            amount = request.POST['amount']
            adate = request.POST['adate']
            interest = request.POST['interest']
            duration = request.POST['duration']
            payment_method = request.POST['payment_method']

            rate_type = request.POST['rate_type']

            editloans = Loans.objects.filter(id=loanid)
            for editloan in editloans:
                editloan.loan_type_id = loan_type
                editloan.amount_requested = amount
                editloan.requested_on = adate
                editloan.rate = interest
                editloan.rate_type = rate_type
                editloan.requested_duration = duration
                editloan.repayment_method = payment_method
                editloan.save()

        # ==========================        Delete loan application  ================================

        if form_type == 'deleteloan':
            loanid = request.POST['loanid']
            deleteloans = Loans.objects.filter(id=loanid)
            for deleteloan in deleteloans:
                deleteloan.delete()
                messages.success(request, 'success', extra_tags='Loan Application Deleted successfully')
            return HttpResponseRedirect(reverse_lazy('loan_applications'))

        # =====================================================SUBMIT TO COMMITEE===================================

        if form_type == 'approval':
            loanid = request.POST['loanid']
            submitted = Loans.objects.filter(id=loanid)
            for submit in submitted:
                submit.loan_status = 1
                submit.save()
                messages.success(request, 'success', extra_tags='Loan Application Submitted successfully')

        # =====================================================DISBURSE LOAN===================================

        if form_type == 'disburse':
            loanid = request.POST['loanid']
            amount_approved = request.POST['damount']
            ddate = request.POST['d_date']
            credited = request.POST['credited']
            narration = request.POST['narration']
            submitted = Loans.objects.filter(id=loanid)
            for submit in submitted:
                submit.loan_status = 3
                submit.schedule_start = ddate
                submit.save()

                # ==========================Save loan transaction=======================

            # Check if the ledgers exist=====================

            checkrecievables = Account.objects.filter(name='Loan Receivables', business=businessdata(request)).exists()
            checkrecharges = Account.objects.filter(name='Loan Charges', business=businessdata(request)).exists()

            if (checkrecharges):
                pass
            else:
                rcategeory2 = AccountCategory.objects.filter(name='Loan incomes', business=businessdata(request))[0]
                createleger2 = Account.objects.create(name='Loan Charges',
                                                      business_id=businessdata(request),
                                                      category_id=rcategeory2.id,
                                                      added_by_id=userdata(request)
                                                      )

            if (checkrecievables):
                pass
            else:
                rcategeory = AccountCategory.objects.filter(name='Account Receivables', business=businessdata(request))[
                    0]
                createleger = Account.objects.create(name='Loan Receivables',
                                                     business_id=businessdata(request),
                                                     category_id=rcategeory.id,
                                                     added_by_id=userdata(request)
                                                     )

            # =====================GET LEDGER ACCOUNTS============================

            # laonacct = Account.objects.filter(category__name='Account Receivables', business=businessdata(request))[0]
            laonacct = Account.objects.filter(name='Loan Receivables', business=businessdata(request))[0]
            print(laonacct.id)
            print(laonacct.name)
            chargeacct = Account.objects.filter(name='Loan Charges', business=businessdata(request))[0]

            saveloan = Transactions.objects.create(reporting_amount=amount_approved, narration=narration,
                                                   account_cr_id=credited,
                                                   account_dr_id=laonacct.id,
                                                   tx_date=ddate,
                                                   loan_id=loanid,
                                                   transaction_type='give loan',
                                                   branch_id=branchdata(request))

            actualchargesx = submit.charges

            actualcharges = json.loads(actualchargesx)
            for chg in actualcharges:
                chargeamount = chg['amount']
                chargename = chg['name']

                narration = chargename
                savecharge = Transactions.objects.create(reporting_amount=chargeamount, transaction_type='Loan charge',
                                                         narration=narration,
                                                         account_cr_id=chargeacct.id, account_dr_id=laonacct.id,
                                                         tx_date=ddate, loan_id=loanid,
                                                         branch_id=branchdata(request))

            # ================================SAVE LOAN CHARGES=========================================

            messages.success(request, 'success', extra_tags='Loan  Disbursed successfully')

            # =====================================================DISBURSE LOAN===================================

        if form_type == 'repay':
            loanid = request.POST['loanid']
            amount = request.POST['amount']
            ddate = request.POST['d_date']
            debited = request.POST['debited']
            principalamount = request.POST['principalamount']
            interestamount = request.POST['interestamount']
            narration = request.POST['narration']
            credited = Account.objects.filter(name='Loan Receivables', business=businessdata(request))[0]

            receipt = int(random.uniform(1000, 9999))

            # ==========================Save loan transaction=======================

            # Check if the ledgers exist=====================

            checkrecievables = Account.objects.filter(name='Loan Receivables', business=businessdata(request)).exists()
            checkinterest = Account.objects.filter(name='Loan interest', business=businessdata(request)).exists()

            if (checkinterest):
                pass
            else:
                rcategeory2 = AccountCategory.objects.filter(name='Loan incomes', business=businessdata(request))[0]
                createleger2 = Account.objects.create(name='Loan interest',
                                                      business_id=businessdata(request),
                                                      category_id=rcategeory2.id,
                                                      added_by_id=userdata(request)
                                                      )

            if (checkrecievables):
                pass
            else:
                rcategeory = AccountCategory.objects.filter(name='Account Receivables', business=businessdata(request))[
                    0]
                createleger = Account.objects.create(name='Loan Receivables',
                                                     business_id=businessdata(request),
                                                     category_id=rcategeory.id,
                                                     added_by_id=userdata(request)
                                                     )

            intrestaccount = Account.objects.filter(name='Loan interest', business=businessdata(request))[0]

            saveprincipal = Transactions.objects.create(reporting_amount=principalamount,
                                                        narration=narration,
                                                        account_dr_id=debited,
                                                        account_cr_id=credited.id,
                                                        loan_id=loanid,
                                                        tx_date=ddate,
                                                        receipt=receipt,
                                                        transaction_type='Loan repayment',
                                                        added_by_id=userdata(request),
                                                        branch_id=branchdata(request))

            # =========================RECORD INTEREST======================================

            if float(interestamount) > 0:
                saveprinterest = Transactions.objects.create(reporting_amount=interestamount,
                                                             narration=narration,
                                                             account_dr_id=debited,
                                                             account_cr_id=intrestaccount.id,
                                                             loan_id=loanid,
                                                             tx_date=ddate,
                                                             receipt=receipt,
                                                             transaction_type='Loan interest',
                                                             added_by_id=userdata(request),
                                                             branch_id=branchdata(request))

            messages.success(request, 'success', extra_tags='Loan  payment recorded successfully')

        # ================================COMMITTEE ACTION=====================================

        if form_type == 'topup':
            loanid = request.POST['loanid']
            account = request.POST['account']
            amount = request.POST['amount']

            amount = amount.replace(',', '')
            adate = request.POST['d_date']
            interest = request.POST['interest']
            duration = request.POST['duration']
            rate_type = request.POST['rate_type']
            payment_method = request.POST['payment_method']
            loan_type = request.POST['loan_type']




            #         ============SAVE LOAN APPLICATION INTO THE DATABASE======================

            loanapply = Loans.objects.create(account_id=account,
                                             branch_id=branchdata(request),
                                             amount_requested=amount,
                                             rate=interest,
                                             rate_type=rate_type,
                                             requested_on=adate,
                                             loan_type_id=loan_type,
                                             requested_duration=duration,
                                             repayment_method=payment_method,
                                             is_topup=True,
                                             added_by_id=userdata(request)
                                             )

            LoanTopups.objects.create(
                closed_loan_id=loanid,
                topup_loan_id=loanapply.id,

            )

            messages.success(request, 'success', extra_tags='Loan Application submitted successfully')
            return HttpResponseRedirect(reverse_lazy('loan_applications'))

        if form_type == 'com_action':
            loanid = request.POST['loanid']
            comaction = request.POST['comaction']

            actions = Loans.objects.filter(id=loanid)

            for caction in actions:
                if comaction == '1':
                    # ======================SEND TO THE VIEW CALCULATED CHARGES======================================

                    # =========================IF THE LOAN HAS A RUNNING LOAN TO TOPUp=========================
                    if caction.is_topup == True:
                        oldloan = Loans.objects.filter(account_id=caction.account_id, loan_status=3)[0]
                        oldloan.loan_status = 8
                        oldloan.save()

                        #     =================SAVE IN THE TOPUPS TABLE========================


                    charges = ApplicationAccountOrLoanType.objects.filter(loan_type_id=caction.loan_type,
                                                                          general_charge__status=1)
                    # ======================SEND TO THE VIEW CALCULATED CHARGES======================================
                    actualcharges = []
                    totalcharges = 0

                    disbusable = caction.amount_approved - totalcharges

                    amounts_approved = request.POST['a_approved']
                    print(amounts_approved)
                    approved_rate = request.POST['approved_rate']
                    approved_date = request.POST['approved_date']
                    approved_duration = request.POST['approved_duration']

                    for charge in charges:

                        ispercentage = charge.general_charge.is_percentage
                        if ispercentage == 1:
                            chargeamount = (int(charge.general_charge.amount) * int(amounts_approved)) / 100
                            print(charge.general_charge.amount)

                        else:
                            chargeamount = charge.general_charge.amount

                        actualcharges.append(
                            {"name": charge.general_charge.charge, "amount": chargeamount}
                        )

                        totalcharges = totalcharges + chargeamount
                    caction.loan_status = 2
                    caction.charges = json.dumps(actualcharges)
                    caction.approved_duration = approved_duration
                    caction.rate = approved_rate
                    caction.amount_approved = amounts_approved
                    caction.approved_on = approved_date

                    messages.success(request, 'success', extra_tags='Loan Application Approved successfully')
                # ===================== APPPLICATION IS REJECTED=====================
                if comaction == '2':
                    caction.loan_status = 5

                    messages.success(request, 'success', extra_tags='Loan Application Rejected successfully')
                    return HttpResponseRedirect(reverse_lazy('loan_applications'))

                    # ===================== APPPLICATION IS BOUNCED=====================
                if comaction == '3':
                    caction.loan_status = 0

                    messages.success(request, 'success', extra_tags='Loan Application Reverted successfully')
                    return HttpResponseRedirect(reverse_lazy('loan_applications'))

                caction.save()

                # =====================save action==================
        return HttpResponseRedirect(request.META.get("HTTP_REFERER"))
        # return HttpResponseRedirect(reverse_lazy('loan_details', args=loanid))


# ===================CHECK IF IT ALREADY EXISTS=============================
class CheckType(View):

    def get(self, request, *args, **TYkwargs):
        loantype = request.GET['type']
        checktype = LoanTypes.objects.filter(name=loantype, business=businessdata(request)).exists()
        if checktype:

            return HttpResponse(1)
        else:
            return HttpResponse(2)


# ===================LON TYPE DETAILS=============================
class Getdetail(View):

    def get(self, request, loantype, *args, **TYkwargs):
        # loantype = type
        checktype = LoanTypes.objects.filter(id=loantype)[0]
        value1 = checktype.interest_rate
        value2 = checktype.get_interval_display()
        value3 = checktype.interval

        return HttpResponse('%s|%s|%s' % (value1, value2, value3))


# ======================LOAN CALCULATOR============================
@method_decorator(login_required, name='dispatch')
class LoanCalculator(View):
    template_name = 'loans/loan_calculator.html'

    def get(self, request, *args, **kwargs):
        title = 'Loan calculator'
        loantypes = LoanTypes.objects.filter(business=businessdata(request), is_active=True)
        return render(request, self.template_name, locals())

    # =================RECEIVE FORM APPLICATION DATA==============================
    def post(self, request, *args, **kwargs):
        loan_type = request.POST['loan_type']
        title = 'Loan calculator'
        loantypes = LoanTypes.objects.filter(business=businessdata(request), is_active=True)

        amount = request.POST['amount']

        principal = int(amount.replace(',', ''))
        appdate = request.POST['adate']
        appdate = datetime.datetime.strptime(appdate, '%Y-%m-%d')
        interestrate = request.POST['interest']

        interestrate = float(interestrate)
        duration = int(request.POST['duration'])
        rate_type = request.POST['rate_type']
        typeinterval = request.POST['typeinterval']
        typeinterval = int(typeinterval)
        print(rate_type)

        try:
            editsetings = LoanSettings.objects.filter(business=businessdata(request))[0]
            decimals = editsetings.decimals
            formula = editsetings.formula
        except:
            decimals = 0
            formula = 1

        #         ============AMOTIZE THE LOAN TO ESTIMATE THE PAYMENTS======================

        paidamount = 0

        if formula == 2:
            interest = (interestrate / 100)

        if formula == 1:
            if typeinterval == 3:
                interest = (interestrate / 100) / 12

            if typeinterval == 0:
                interest = (interestrate / 100) / 365

            if typeinterval == 1:
                interest = (interestrate.rate / 100) / 52

            if typeinterval == 2:
                interest = (interestrate / 100) / 26

            if typeinterval == 4:
                interest = (interestrate / 100)

        # ===================GET LOAN REPAYMENTS========================================

        # =====================IF INTERVAL IS MONTHLY =========================
        if typeinterval == 3:
            to_add = relativedelta(months=1)
            all_duration = relativedelta(months=duration)

        # =====================IF INTERVAL IS DAILY =========================

        if typeinterval == 0:
            to_add = relativedelta(days=1)
            all_duration = relativedelta(days=duration)

        # =====================IF INTERVAL IS WEEKLY =========================

        if typeinterval == 1:
            to_add = relativedelta(weeks=1)
            all_duration = relativedelta(weeks=duration)

        # =====================IF INTERVAL IS BI-WEEKLY =========================

        if typeinterval == 2:
            to_add = relativedelta(weeks=2)
            all_duration = relativedelta(weeks=duration * 2)

        # =====================IF INTERVAL IS YEARLY =========================

        if typeinterval == 4:
            to_add = relativedelta(years=1)
            all_duration = relativedelta(years=duration)

        # ================================IF THE INTEREST IS FLAT RATE==========================

        if rate_type == '1':
            print('IT IS TYPE 1')
            in_date = ''

            loan_dict = {}
            days = []
            schedules = round(principal / duration, decimals)
            interestperschedue = round(principal * interest, decimals)
            payable = interestperschedue + schedules

            # ========================================GET PAID SCHEDULES=========================

            paidschedules = paidamount / payable
            paidschedules = floor(paidschedules)

            # ====================================Balance for the next schedule=======================
            nextbal = paidamount - (payable * paidschedules)
            nextintallment = payable - nextbal

            nextschedule = paidschedules + 1
            data = []

            edate = appdate + to_add
            # print(appdate)
            date1 = edate
            totalpayable = payable * duration

            rbalance = totalpayable

            date2 = date1 + all_duration
            m = 1

            while date1 < date2:
                rbalance = rbalance - payable
                rbalance = round(rbalance, decimals)
                if m == nextschedule:
                    isnext = 1
                    spaid = round(nextbal, decimals)
                    sbalance = round(nextintallment, decimals)

                elif m < nextschedule:
                    isnext = 0
                    spaid = round(payable, decimals)
                    sbalance = 0

                else:
                    isnext = 2
                    spaid = 0
                    sbalance = round(payable, decimals)

                days.append([date1.strftime("%Y-%m-%d"),
                             isnext,
                             spaid,
                             sbalance,
                             rbalance
                             ]
                            )
                date1 = date1 + to_add

                # print(principal)

                m = m + 1

        # =============================================IF THE RATE TYPE IS REDUCING=====================================

        if rate_type == '2':
            print('IT IS TYPE 2')
            in_date = ''
            loan_dict = {}
            data = []
            days = []
            edate = appdate + to_add
            # print(appdate)
            date1 = edate
            principals = 0
            date2 = date1 + all_duration
            runningbal = principal
            schedules = 9
            # interestperschedue = schedules * interest / 100;

            numilator = principal * interest * (
                    (pow((1 + interest), duration)) / (pow((1 + interest), duration) - 1))
            payable = round(numilator, decimals)

            totalpayable = payable * duration

            rprincipal = 0
            rbalance = principal
            # ========================================GET PAID SCHEDULES=========================

            paidschedules = paidamount / payable
            paidschedules = floor(paidschedules)

            nextschedule = paidschedules + 1
            # ====================================Balance for the next schedule=======================
            nextbal = paidamount - (payable * paidschedules)
            nextintallment = payable - nextbal

            m = 1

            print(typeinterval)

            while date1 < date2:
                days.append(date1.strftime("%Y-%m-%d"))
                date1 = date1 + to_add

                interestperschedue = rbalance * interest
                interestperschedue = round(interestperschedue, decimals)
                rprincipal = payable - interestperschedue
                rprincipal = round(rprincipal, decimals)
                rbalance = principal * ((pow((1 + interest), duration) - pow((1 + interest), m)) / (
                        pow((1 + interest), duration) - 1))

                rbalance = round(rbalance, decimals)

                loan_dict[in_date] = date1.strftime("%Y-%m-%d")
                loan_dict[rprincipal] = rprincipal
                loan_dict[rbalance] = rbalance
                loan_dict[interestperschedue] = interestperschedue

                data.append([loan_dict[rprincipal],
                             loan_dict[in_date],
                             loan_dict[rbalance],
                             loan_dict[interestperschedue],

                             ])
                m = m + 1
            print(data)

        return render(request, self.template_name, locals())


# =================== CHECK IF THE MEMBER ALREADY HAS A LOAN =============================
class ChekLoan(View):

    def get(self, request, account, *args, **TYkwargs):

        try:
            # checkloaan = Loans.objects.filter(Q(account_id=account), Q(loan_status = 3) | Q(loan_status=2) | Q(loan_status=1) )[0]
            checkloaan = Loans.objects.filter(account_id=account, loan_status__lte=3)[0]
            currentloan = checkloaan.loan_status
            rloanid = checkloaan.id

        except:
            currentloan = 10
            rloanid = 0

        return HttpResponse('%s|%s' % (currentloan, rloanid))


class MemberLoansView(BusinessUserMixin, View):
    template_name = 'loans/member_loans.html'

    def get_member(self, request):
        pkey = self.kwargs.get("pk")
        member = get_object_or_404(Member, id=pkey, is_active=True, biodata__business=businessdata(request))
        return member

    def get(self, request, pk, *args, **kwargs):
        member = self.get_member(request)
        title = f'{member.biodata.name} Loans'
        member_accounts = member.accountbroker_set.all()
        accts = []
        for account in member_accounts:
            accts.append(account.the_account)

        return render(request, self.template_name, locals())

    def post(self, request, *args, **kwargs):
        return


# =================================UPLAOD LOANS==========================================
@method_decorator(login_required, name='dispatch')
class LoanUploads(View):
    template_name = 'loans/loan_uploads.html'

    def get(self, request, *args, **kwargs):
        title = 'Loan Uploads'
        bankaccounts = Account.objects.filter(Q(business=businessdata(request)),
                                              (Q(category__name='Bank') | Q(category__name='Reserves')))
        uplaods = UploadLoans.objects.filter(branch_id=branchdata(request))
        loantypes = LoanTypes.objects.filter(business=businessdata(request), is_active=True)

        return render(request, self.template_name, locals())

    # ====WHEN THE POST IS MADE==========================

    def post(self, request, *args, **kwargs):
        formtype = request.POST['form_type']
        if formtype == 'delete':
            pk = request.POST['uploadid']
            upload = UploadLoans.objects.filter(id=pk)[0]
            upload.delete()

        if formtype == 'upload':
            upload_file = request.FILES['proof']
            udate = request.POST['udate']
            loantype = request.POST['loan_type']
            credited = request.POST['credited']
            narration = request.POST['narration']
            lstatus = request.POST['lstatus']
            data = upload_file.read().decode('utf-8')
            rate_type = request.POST['rate_type']
            n = 0

            # you can use the re library --> import re
            rows = re.split('\n', data)  # splits along new line

            nloans = 0
            # === RECORD THE UPLOAD=========================
            bupload = UploadLoans.objects.create(upload_date=udate,
                                                 file=upload_file,
                                                 loan_type_id=loantype,
                                                 branch_id=branchdata(request),
                                                 added_by_id=userdata(request)
                                                 )

            for index, row in enumerate(rows):
                n = n + 1

                cells = row.split(',')

                if n > 1:
                    try:
                        actualcharges = []
                        accn = cells[0]
                        date = cells[1]

                        nloans = nloans + 1
                        memberacct = cells[0]
                        approvedon = cells[1]
                        amount = cells[2]
                        amount = float(amount.replace(',', ''))
                        intrate = cells[3]

                        intrate = [int(s) for s in re.findall(r'\b\d+\b', intrate)][0]
                        duration = cells[4]
                        duration = [int(s) for s in re.findall(r'\b\d+\b', duration)][0]


                        # ===================ADD CHARGES TO THE LOAN============================================

                        if int(lstatus) == 1:
                            charges = ApplicationAccountOrLoanType.objects.filter(loan_type=loantype,
                                                                                  general_charge__status=1)

                            for charge in charges:

                                ispercentage = charge.general_charge.is_percentage
                                if ispercentage == 1:
                                    chargeamount = int(charge.general_charge.amount * amount) / 100

                                else:
                                    chargeamount = charge.general_charge.amount

                                actualcharges.append(
                                    {"name": charge.general_charge.charge, "amount": chargeamount}
                                )



                        getmemberid = MemberAccount.objects.filter(acc_number=memberacct,
                                                                   account_type__business_id=businessdata(request))[
                            0]
                        recordloan = Loans.objects.create(account_id=getmemberid.id,
                                                          amount_requested=amount,
                                                          amount_approved=amount,
                                                          rate=intrate,
                                                          rate_type=rate_type,
                                                          requested_on=approvedon,
                                                          approved_on=approvedon,
                                                          schedule_start=approvedon,
                                                          requested_duration=duration,
                                                          approved_duration=duration,
                                                          loan_status=3,
                                                          branch_id=branchdata(request),
                                                          upload_id=bupload.id,
                                                          loan_type_id=loantype,
                                                          charges=json.dumps(actualcharges)
                                                          )

                        #     RECORD TRANSACTION===================================

                        checkrecievables = Account.objects.filter(name='Loan Receivables',
                                                                  business=businessdata(request)).exists()
                        checkrecharges = Account.objects.filter(name='Loan Charges',
                                                                business=businessdata(request)).exists()

                        if (checkrecharges):
                            pass
                        else:
                            rcategeory2 = AccountCategory.objects.filter(name='Loan incomes', business=businessdata(request))[0]
                            createleger2 = Account.objects.create(name='Loan Charges',
                                                                  business_id=businessdata(request),
                                                                  category_id=rcategeory2.id,
                                                                  added_by_id=userdata(request)
                                                                  )

                        if (checkrecievables):
                            pass
                        else:
                            rcategeory = AccountCategory.objects.filter(name='Account Receivables',
                                                                        business=businessdata(request))[
                                0]
                            createleger = Account.objects.create(name='Loan Receivables',
                                                                 business_id=businessdata(request),
                                                                 category_id=rcategeory.id,
                                                                 added_by_id=userdata(request)
                                                                 )

                        # =====================GET LEDGER ACCOUNTS============================

                        # laonacct = Account.objects.filter(category__name='Account Receivables', business=businessdata(request))[0]
                        laonacct = Account.objects.filter(name='Loan Receivables', business=businessdata(request))[
                            0]
                        print(laonacct.id)
                        print(laonacct.name)
                        chargeacct = Account.objects.filter(name='Loan Charges', business=businessdata(request))[0]

                        saveloan = Transactions.objects.create(reporting_amount=amount,
                                                               narration=narration,
                                                               account_cr_id=credited,
                                                               account_dr_id=laonacct.id,
                                                               tx_date=approvedon,
                                                               loan_id=recordloan.id,
                                                               transaction_type='give loan',
                                                               branch_id=branchdata(request))

                        actualchargesx = recordloan.charges

                        try:
                            actualcharges = json.loads(actualchargesx)
                            for chg in actualcharges:
                                chargeamount = chg['amount']
                                chargename = chg['name']

                                narration = chargename
                                savecharge = Transactions.objects.create(reporting_amount=chargeamount,
                                                                         transaction_type='Loan charge',
                                                                         narration=narration,
                                                                         account_cr_id=chargeacct.id,
                                                                         account_dr_id=laonacct.id,
                                                                         tx_date=approvedon,
                                                                         loan_id=recordloan,
                                                                         branch_id=branchdata(request))
                        except Exception as exx:
                            print(str(exx))




                    except Exception as lex:
                        print(str(lex))

                bupload.total_records = nloans
                bupload.save()

            messages.success(request, 'success', extra_tags='Loans uploaded successfully')

        # =================================EDITING LOAN TYPE===================================

        return HttpResponseRedirect(reverse_lazy('loan_uploads'))


@method_decorator(login_required, name='dispatch')
class UploadDetails(View):
    template_name = 'loans/upload_details.html'

    def get(self, request, pk, *args, **kwargs):
        title = 'Uload details '
        loanid = pk
        loansid = int(loanid)
        # detail = get_object_or_404(Loans, id=pk)
        # detail = Loans.objects.get(id=pk)
        nowdate = today.strftime("%Y-%m-%d")

        loanApplications = Loans.objects.raw(
            "SELECT l. *, b.the_account_id as accountid, b.members_id as memberid, a.acc_number, m.biodata_id, m.id, c.name AS member_name FROM account_broker b, member_accounts a, sacco_member m, biodata c, loans l where b.the_account_id = a.id and b.business_id = %s and b.members_id = m.id and m.biodata_id = c.id and l.account_id = a.id and l.branch_id = %s and l.upload_id = %s" % (
            businessdata(request), branchdata(request), pk))
        # print(loanApplications)
        # return HttpResponseRedirect(reverse_lazy('upload_details'))
        return render(request, self.template_name, locals())
