from django.contrib import admin

from sacco.models import LoanSettings
from .models import GeneralCharge, ApplicationAccountOrLoanType
from loans.models import Loans, LoanTypes, Loanguarantors, LoanCharges, LoanRepaymentUpload, BouncedLoansUpload, LoanUpload, UploadLoans

# Register your models here.
admin.site.register(GeneralCharge)
admin.site.register(ApplicationAccountOrLoanType)

@admin.register(Loans)
class LoansAdmin(admin.ModelAdmin):
    list_display = ['loan_status', 'loan_type', 'branch', 'schedule_start']
    list_filter = ['loan_status', 'schedule_start']


admin.site.register(LoanTypes)
admin.site.register(Loanguarantors)
admin.site.register(LoanSettings)
admin.site.register(LoanCharges)
admin.site.register(LoanRepaymentUpload)
admin.site.register(BouncedLoansUpload)
admin.site.register(LoanUpload)
admin.site.register(UploadLoans)

