import string
from random import randint
import phonenumbers
from phonenumbers.phonenumberutil import region_code_for_number
import secrets

from commons.logger import logger

accs = string.digits
member_accounts = ''.join(secrets.choice(accs) for i in range(8))


def random_with_N_digits(n):
    range_start = 10 ** (n - 1)
    range_end = (10 ** n) - 1
    return randint(range_start, range_end)


def ug_dial(phone):
    if phone.startswith('0'):
        phone = phone.replace('0', '256', 1)
    elif phone.startswith('+256'):
        phone = phone.replace('+256', '256', 1)
    else:
        phone = '256' + str(phone)
    return phone


def proper_dial(phone, code):
    try:
        print('code', code)
        number_input = phonenumbers.parse(phone, code)
        c_code = number_input.country_code
        c_national = number_input.national_number
        final_number = str(c_code) + str(c_national)
        return final_number
    except Exception as e:
        logger.error(str(e))
        print(e)
        return None


def dial_country_code(phone):
    try:
        if phone is not None:
            plus = '+'
            intl_dial = plus + str(phone)
            z = phonenumbers.parse(intl_dial)

            return region_code_for_number(z)
    except Exception as e:
        logger.error(str(e))
        return 'Error in Code'
    return phone


def convert_national(phone):
    plus = '+'
    intl_dial = plus + str(phone)

    z = phonenumbers.parse(intl_dial)
    source = z.country_code_source
    national = z.national_number
    final_number = str(source) + str(national)
    return final_number
