import datetime
import sys

from PIL import Image
from io import BytesIO

from django.core.files.uploadedfile import InMemoryUploadedFile


def bio_photo(instance, filename):
    ts = datetime.datetime.now().timestamp()
    ext = filename.split('.')[-1]
    if instance.pk:
        filename = '{}.{}.{}'.format(ts, instance.pk, ext)
    else:
        filename = '{}.{}'.format(ts, ext)
    return '/'.join(['bio_photos', filename])


def bio_files(instance, filename):
    ts = datetime.datetime.now().timestamp()
    ext = filename.split('.')[-1]
    if instance.pk:
        filename = '{}.{}.{}'.format(ts, instance.pk, ext)
    else:
        filename = '{}.{}'.format(ts, ext)
    return '/'.join(['bio_files', filename])


def loan_files(instance, filename):
    file_name = instance.file_name
    ext = filename.split('.')[-1]
    if instance.pk:
        filename = '{}.{}.{}'.format(file_name, instance.pk, ext)
    else:
        filename = '{}.{}'.format(file_name, ext)
    return '/'.join(['loan_files', filename])


def sig_files(instance, filename):
    ts = datetime.datetime.now().timestamp()
    ext = filename.split('.')[-1]
    if instance.pk:
        filename = '{}.{}.{}'.format(ts, instance.pk, ext)
    else:
        filename = '{}.{}'.format(ts, ext)
    return '/'.join(['sign_files', filename])


def logo_files(instance, filename):
    lg = datetime.datetime.now().timestamp()
    ext = filename.split('.')[-1]
    if instance.pk:
        filename = '{}.{}.{}'.format(lg, instance.pk, ext)
    else:
        filename = '{}.{}'.format(lg, ext)
    return '/'.join(['logos', filename])


def certificate_files(instance, filename):
    certificate = datetime.datetime.now().timestamp()
    ext = filename.split('.')[-1]
    if instance.pk:
        filename = '{}.{}.{}'.format(certificate, instance.pk, ext)
    else:
        filename = '{}.{}'.format(certificate, ext)
    return '/'.join(['certificates', filename])


def make_thubnail(file):
    img = Image.open(file)
    if img.format == 'PNG':
        img = img.convert('RGB')
    img.thumbnail((140, 140), Image.ANTIALIAS)
    output = BytesIO()
    img.save(output, 'JPEG')
    newFile = InMemoryUploadedFile(output, None, 'temp.jpg', 'image/jpeg', sys.getsizeof(output), None)
    return newFile
