import requests
import json

def currenciesJson():

    urlCurrencies = 'https://restcountries.com/v3.1/all'
    responseCurrencies = requests.request("GET", urlCurrencies)

    responseCurrencies = json.loads(responseCurrencies.content)

    the_currencies = []
    curr = []
    repeating_curr = []

    #adding the common ones
    common_currencies = [
        {
            'country': 'Europe',
            'currency': 'EUR'
        },
        {
            'country': 'United states of America',
            'currency': 'USD'
        },
        {
            'country': 'West African CFA franc',
            'currency': 'XOF'
        },
        {
            'country': 'Danish krone',
            'currency': 'DKK'
        },
        {
            'country': 'Central African CFA franc',
            'currency': 'XAF'
        },
        {
            'country': 'Australian dollar',
            'currency': 'AUD'
        },
        {
            'country': 'New Zealand dollar',
            'currency': 'NZD'
        },
        {
            'country': 'Eastern Caribbean dollar',
            'currency': 'XCD'
        },
        {
            'country': 'Netherlands Antillean guilder',
            'currency': 'ANG'
        },
        {
            'country': 'Norwegian krone',
            'currency': 'NOK'
        },
        {
            'country': 'Swiss franc',
            'currency': 'CHF'
        },
        {
            'country': 'Algerian dinar',
            'currency': 'DZD'
        },
        {
            'country': 'Egyptian pound',
            'currency': 'EGP'
        },
        {
            'country': 'CFP franc',
            'currency': 'XPF'
        },
        {
            'country': 'Pound sterling',
            'currency': 'GBP'
        },
    ]

    for comm_country in common_currencies:
        dictionary = {
            'country': comm_country['country'],
            'currency': comm_country['currency']
        }
        the_currencies.append((dictionary))


    common_list = ['EUR', 'USD', 'XOF', '', 'DKK', 'XAF', 'AUD', 'NZD', 'XCD', 'ANG', 'NOK', 'CHF', 'DZD', 'EGP', 'XPF', 'GBP']

    for country in responseCurrencies:
        countryName = country['name']['common']
        try:
            currencyCode = list(country['currencies'].keys())[0]
        except:
            currencyCode = ''

        dictionary = {
            'country': countryName,
            'currency': currencyCode
        }

        if currencyCode in common_list:
            print('dont add')
        else:
            the_currencies.append((dictionary))


    json_string = json.dumps(the_currencies)
    with open('allCurrencies.json', 'w') as outfile:
        outfile.write(json_string)


currenciesJson()