from django.urls import path

from transactions import reports, views, downloads, make_transactions, fixed_assets

urlpatterns = [
    path('general-ledger/', reports.general_ledger, name='gl'),
    path('individual-ledger/', reports.individual_gl, name='igl'),
    path('reconcile-account/', reports.reconcile_gl, name='reconcile_gl'),
    path('update-reconciliation/<int:id>/', reports.update_reconciliation, name='update_reconciliation'),
    path('trial-balance/', reports.trial_balance, name='tb'),
    path('report/<str:report>/', reports.balance_sheet, name='balance_sheet'),
    path('json/', views.generate_json, name='getjson'),
    path('search_members/', views.search_members, name='search_members'),
    path('member-statement/', reports.member_statement, name='member_statement'),
    path('closing-balances/', reports.closing_balances, name='closing_balances'),

    # coa
    path('chart-of-accounts/', views.chart_of_accounts, name='chart_of_accounts'),
    path('get_reserve_list/<int:id>/', views.get_reserve_list, name='get_reserve_list'),
    path('get_eul/<int:id>/', views.get_eul, name='get_eul'),

    # popups
    path('new-account/<str:category>/<str:name>/<str:js_id>/', views.new_account_popup, name='new-account'),
    path('new-fixed-assets-location/', fixed_assets.new_asset_location_popup, name='fixed-asset locations'),
    # transactions
    path('new/', make_transactions.make_transactions, name='new_transaction'),
    path('loan-repayment/', make_transactions.make_transactions_loans, name='trans_loan_repayment'),
    path('make-final-transactions/', make_transactions.make_final_transactions, name='make_final_transactions'),
    
    path('expenses/new/', make_transactions.make_expenses, name='make_expenses'),
    path('edit-expensese/<int:id>', make_transactions.update_expense, name='edit_expense'),
    path('delete-expensese/<int:pk>', make_transactions.delete_expense, name='delete_expense'),
    path('get_acc/', make_transactions.get_acc, name='get_acc'),
    path('make_list/', make_transactions.make_expense_list, name='make_expense_list'),

    # Fixed Assets
    path('fixed-assets/', fixed_assets.fixed_assets_register, name='fixed-assets'),
    path('fixed-assets/<int:id>/', fixed_assets.fixed_assets_details, name='fixed-assets-details'),
    path('fixed-assets/add/', fixed_assets.add_fixed_assets, name='fixed-assets'),
    path('fixed-assets/existing/', fixed_assets.add_existing_fixed_assets, name='existing_fixed-assets'),

    path('fixed-assets/transfer/<int:id>/', fixed_assets.fixed_asset_transfer, name='transfer-fixed-assets'),
    path('fixed-assets/update/<int:id>/', fixed_assets.fixed_asset_update, name='update-fixed-assets'),
    path('fixed-assets/depreciate/<int:id>/', fixed_assets.fixed_asset_depreciate, name='depreciate-fixed-assets'),
    path('fixed-assets/dispose/<int:id>/', fixed_assets.fixed_asset_disposal, name='dispose-fixed-assets'),
    path('fixed-assets/location/', fixed_assets.asset_location, name='fixed-asset locations'),
    path('fixed-assets/report/', fixed_assets.general_report, name='fixed-asset report'),
    path('getdr/', make_transactions.get_acc, name='getdr'),

    path('fixed-assets/location/add/', fixed_assets.add_asset_location, name=' add fixed-asset location'),
    path('fixed-assets/location/edit/', fixed_assets.edit_asset_location, name='edit fixed-asset location'),

    path('export-gl/', downloads.export_gl, name='export_gl'),
    path('export-gl-pdf/', downloads.pdf_gl, name='export_gl'),

    path('export-individual-gl/', downloads.export_individual_gl, name='export_individual_gl'),
    path('pdf-individual-gl/', downloads.pdf_individual_gl, name='pdf_individual_gl'),

    path('export-tb/', downloads.export_tb, name='export_tb'),
    path('pdf-tb/', downloads.pdf_tb, name='pdf_tb'),

    path('export-bs/', downloads.export_bs, name='export_bs'),
    path('pdf-bs/', downloads.pdf_bs, name='pdf_bs'),

    path('export-is/', downloads.export_is, name='export_is'),
    path('pdf-is/', downloads.pdf_is, name='pdf_is'),

    path('pdf-member-statement/', downloads.pdf_member_statement, name='pdf_member_statement'),

    path('delete-transaction/<int:pk>', make_transactions.delete_transaction, name='delete_transaction'),
    path('delete-transaction-daily-report/<int:pk>', make_transactions.delete_transaction_daily_report, name='delete_transaction'),
    
    path('reverse-transaction/<int:pk>', make_transactions.reverse_transaction, name='reverse_transaction'),
    # path('testjson/', views.test_json, name='getjson'),
]
