import traceback
from datetime import datetime, date
from django.contrib import messages
from django.contrib.auth.decorators import login_required
from django.db.models import Q, Sum, Case, When, FloatField, F
from django.http import HttpResponseRedirect, HttpResponse
from django.shortcuts import render

from accounts.models import Branch
from accounts.perm_deco import user_in_business, user_has_perm
from loans.utils.loan_details import get_business_loans_context_data
from sacco.decorators import can_do_this
from sacco.models import FinancialYear, AccountBroker, MemberAccount
from transactions.models import Account, Transactions, AccountCategory
from django.core.paginator import Paginator, PageNotAnInteger, EmptyPage

today = datetime.today().date()


def this_business(user):
    bus = user.staff.branch.business
    return bus


def this_branch(user):
    branch = user.staff.branch
    return branch


def this_staff(user):
    staff = user.staff
    return staff


@login_required
@user_in_business
def this_financial_year(request):
    try:
        dates = FinancialYear.objects.filter(status=True, business=this_business(request.user)).last()
        return dates
    except:
        return None


@login_required
@user_in_business
def this_financial_year_multi_business(request):
    try:
        dates = FinancialYear.objects.filter(status=True, business=this_business(request.user)).last()
        return dates
    except:
        return None



@login_required
@user_in_business
def make_tb(request):
    business_context = get_business_loans_context_data(request)
    if business_context['branch'] is None:  # here u are in the central view
        # show the business this person is attached to
        the_current_branch = this_branch(request.user)
    else:
        the_current_branch = business_context['branch']
    bran = the_current_branch
    if request.method == "POST":
        if 'financial_year' in request.POST:
            fy = request.POST['financial_year']
            if fy == "custom":
                if 'start_date' in request.POST:
                    start_date = request.POST['start_date']
                else:
                    dates = FinancialYear.objects.filter(status=True, business=this_business(request.user)).last()
                    start_date = dates.start_date

                if 'end_date' in request.POST:
                    end_date = request.POST['end_date']
                else:
                    dates = FinancialYear.objects.filter(status=True, business=this_business(request.user)).last()
                    end_date = datetime.today().date()

            else:
                try:
                    dates = FinancialYear.objects.filter(id=fy, business=this_business(request.user)).last()
                    start_date = dates.start_date
                    end_date = dates.end_date
                except Exception as ex:
                    messages.error(request, "Financial Year Not Found")
                    return HttpResponseRedirect("/transactions/trial-balance/")

        else:
            if 'start_date' in request.POST:
                start_date = request.POST['start_date']
            else:
                dates = FinancialYear.objects.filter(status=True, business=this_business(request.user)).last()
                start_date = dates.start_date

            if 'end_date' in request.POST:
                end_date = request.POST['end_date']
            else:
                dates = FinancialYear.objects.filter(status=True, business=this_business(request.user)).last()
                end_date = datetime.today().date()


        if 'report_for' in request.POST:
            report_for = request.POST['report_for']
            if report_for == "business":
                pass
            else:
                the_current_branch = Branch.objects.get(id=report_for)
        else:
            the_current_branch = the_current_branch
    else:
        try:
            dates = FinancialYear.objects.filter(status=True, business=this_business(request.user)).last()

            start_date = dates.start_date
            end_date = datetime.today().date()
            # bran = the_current_branch

        except Exception as ex:
            messages.error(request, "Financial Year Not Found")
            return HttpResponseRedirect("/transactions/trial-balance/")

    tb = []
    re = []

    # get P&L ledgers
    retained_earnings_frm_acc_dep_accs = 0
    try:
        # accounts = accounts.objects.filter(business=request.user.business, category__type='pl', )
        # accounts = Account.objects.raw(query)
        accounts = Account.objects.filter(business=the_current_branch.business,
                                          category__in=(AccountCategory.objects.filter(
                                              Q(cat_type='income', business=the_current_branch.business) | Q(
                                                  cat_type='expenses',
                                                  business=the_current_branch.business))))

        for acc in accounts:
            # print('IF WE REACH HERE')
            # query the sum of revenues from start date to end date
            # get dr sum
            dr_sum = 0
            cr_sum = 0
            gl = Transactions.objects.filter(account_dr=acc, tx_date__range=(start_date, end_date), branch=the_current_branch)
            gl2 = Transactions.objects.filter(account_cr=acc, tx_date__range=(start_date, end_date), branch=the_current_branch)
            for a in gl:
                dr_sum = dr_sum + a.reporting_amount
            # print("%s dr = %s" % (acc.name, dr_sum))

            for a in gl2:
                cr_sum = cr_sum + a.reporting_amount
            # print("%s cr = %s" % (acc.name, cr_sum))

            # difference
            # if acc.name == 'Loan Interest':
            #     print(f'{acc.business.name}')
            #     print(f'acc name:{acc.name}, acc_id:{acc.id}')
            #     print( f'dr_sum:{dr_sum} cr_sum:{cr_sum}')

            # add to trial balance
            # if accounts type is dr, add to dr, if cr add to cr
            if acc.category.dr_cr == 'dr':
                # print('ACC DR', acc)
                diference = dr_sum - cr_sum
                if diference >= 0:

                    obj = {
                        'account': acc,
                        'is_members': False,
                        'is_retained_earning': False,
                        'amount_dr': diference,
                        'amount_cr': 0,
                        'is_negative': False
                    }
                    tb.append(obj)
                else:
                    diference = diference * -1

                    obj = {
                        'account': acc,
                        'is_members': False,
                        'is_retained_earning': False,
                        'amount_dr': 0,
                        'amount_cr': diference,
                        'is_negative': True
                    }
                    tb.append(obj)
                # print('OBJ acc DR', obj)

            elif acc.category.dr_cr == 'cr':
                # print('ACC CR', acc)
                diference = cr_sum - dr_sum
                if diference >= 0:

                    obj = {
                        'account': acc,
                        'is_members': False,
                        'is_retained_earning': False,
                        'amount_dr': 0,
                        'amount_cr': diference,
                        'is_negative': False
                    }
                    tb.append(obj)
                else:
                    diference = diference * -1

                    obj = {
                        'account': acc,
                        'is_members': False,
                        'is_retained_earning': False,
                        'amount_dr': diference,
                        'amount_cr': 0,
                        'is_negative': True
                    }
                    tb.append(obj)

    except Exception as ex:
        # print(str(ex))
        traceback.print_exc()
        pass

        # get Non P&L Ledgers and None Members
    try:

        accounts = Account.objects.filter(Q(business=the_current_branch.business),
                                          ~Q(category__in=(AccountCategory.objects.filter(
                                              Q(cat_type='income', business=the_current_branch.business) |
                                              Q(cat_type='expenses', business=the_current_branch.business)))),
                                          ~Q(category__name='Members')
                                          )
        for acc in accounts:

            # query the sum of revenues from start date to end date
            # get dr sum
            dr_sum = 0
            cr_sum = 0
            gl = Transactions.objects.filter(account_dr=acc, tx_date__lte=end_date, branch=the_current_branch)
            gl2 = Transactions.objects.filter(account_cr=acc, tx_date__lte=end_date, branch=the_current_branch)
            for a in gl:
                dr_sum = dr_sum + a.reporting_amount
            # print("%s dr = %s" % (acc.name, dr_sum))

            for a in gl2:
                cr_sum = cr_sum + a.reporting_amount
                # print('final cr sum', cr_sum)
            # print("%s cr = %s" % (acc.name, cr_sum))

            # difference

            # add to trial balance
            # if accounts type is dr, add to dr, if cr add to cr
            if acc.category.dr_cr == 'dr' and acc.category.name !='Accumulating Depreciation Account':
                # print('ACC', acc, dr_sum, cr_sum )
                if acc.category.name == 'Fixed Assets':
                    diference = dr_sum
                else:
                    diference = dr_sum - cr_sum

                # diference = dr_sum - cr_sum 330107


                if diference >= 0:
                    # newv = TrialBalance.objects.create(
                    #     user=request.user,
                    #     account=acc,
                    #     amount_dr =diference
                    # )
                    obj = {
                        'account': acc,
                        'is_members': False,
                        'is_retained_earning': False,
                        'amount_dr': diference,
                        'amount_cr': 0,
                        'is_negative': False
                    }
                    tb.append(obj)
                    if acc.category.name == 'Fixed Assets':
                        #create the Asset depreciation account
                        # difference = cr_sum
                        retained_earnings_frm_acc_dep_accs = retained_earnings_frm_acc_dep_accs + cr_sum
                        # print('retained_earnings_frm_acc_dep_accs', retained_earnings_frm_acc_dep_accs, acc.id)
                        Acc_dep_acc=Account.objects.filter(related_to=acc.id, category__name='Accumulating Depreciation Account')[0]
                        # print('Acc_dep_acc', Acc_dep_acc.id)
                        tb.append({
                            'account':Acc_dep_acc,
                            'is_members': False,
                            'is_retained_earning': False,
                            'amount_dr': cr_sum,
                            'amount_cr': 0,
                            'is_negative': True
                        })

                else:
                    diference = diference * -1
                    # newv = TrialBalance.objects.create(
                    #     user=request.user,
                    #     account=acc,
                    #     amount_cr=diference,
                    #     is_negative=True
                    # )
                    obj = {
                        'account': acc,
                        'is_members': False,
                        'is_retained_earning': False,
                        'amount_dr': 0,
                        'amount_cr': diference,
                        'is_negative': True
                    }
                    tb.append(obj)

            elif acc.category.dr_cr == 'cr':
                diference = cr_sum - dr_sum
                if diference >= 0:

                    obj = {
                        'account': acc,
                        'is_members': False,
                        'is_retained_earning': False,
                        'amount_dr': 0,
                        'amount_cr': diference,
                        'is_negative': False
                    }
                    tb.append(obj)
                else:
                    diference = diference * -1
                    # newv = TrialBalance.objects.create(
                    #     user=request.user,
                    #     account=acc,
                    #     amount_dr=diference,
                    #     is_negative=True
                    # )
                    obj = {
                        'account': acc,
                        'is_members': False,
                        'is_retained_earning': False,
                        'amount_dr': diference,
                        'amount_cr': 0,
                        'is_negative': True
                    }
                    tb.append(obj)

    except Exception as e:
        # print(str(e))
        traceback.print_exc()
        pass

    # get Members alone
    try:
        members_total = 0
        accounts = Account.objects.filter(Q(business=the_current_branch.business),
                                          ~Q(category__in=(AccountCategory.objects.filter(
                                              Q(cat_type='income', business=the_current_branch.business) |
                                              Q(cat_type='expenses', business=the_current_branch.business)))),
                                          Q(category__name='Members')
                                          )
        for acc in accounts:
            # query the sum of revenues from start date to end date
            # get dr sum
            dr_sum = 0
            cr_sum = 0
            gl = Transactions.objects.filter(account_dr=acc, tx_date__lte=end_date, branch=the_current_branch)
            gl2 = Transactions.objects.filter(account_cr=acc, tx_date__lte=end_date, branch=the_current_branch)
            for a in gl:
                dr_sum = dr_sum + a.reporting_amount
            # print("%s dr = %s" % (acc.name, dr_sum))

            for a in gl2:
                cr_sum = cr_sum + a.reporting_amount
            # print("%s cr = %s" % (acc.name, cr_sum))

            # difference

            # add to trial balance
            # if accounts type is dr, add to dr, if cr add to cr
            diference = cr_sum - dr_sum
            members_total += diference

        if diference >= 0:

            obj = {
                'account': None,
                'is_members': True,
                'is_retained_earning': False,
                'amount_dr': 0,
                'amount_cr': members_total,
                'is_negative': False
            }
            tb.append(obj)
        else:
            diference = diference * -1
            # newv = TrialBalance.objects.create(
            #     user=request.user,
            #     account=acc,
            #     amount_dr=diference,
            #     is_negative=True
            # )
            obj = {
                'account': None,
                'is_members': True,
                'is_retained_earning': False,
                'amount_dr': members_total,
                'amount_cr': 0,
                'is_negative': True
            }
            tb.append(obj)

    except Exception as e:
        # print(str(e))
        pass

    # get retained Earnings
    try:
        accounts = Account.objects.filter(business=the_current_branch.business,
                                          category__in=(AccountCategory.objects.filter(
                                              Q(cat_type='income', business=the_current_branch.business) | Q(
                                                  cat_type='expenses',
                                                  business=the_current_branch.business))))
        for acc in accounts:
            # print('acc', acc)

            # query the sum of revenues from start date to end date
            # get dr sum
            dr_sum = 0
            cr_sum = 0
            gl = Transactions.objects.filter(account_dr=acc, tx_date__lt=start_date, branch=the_current_branch)
            gl2 = Transactions.objects.filter(account_cr=acc, tx_date__lt=start_date, branch=the_current_branch)
            for a in gl:
                dr_sum = dr_sum + a.reporting_amount
            # print("%s dr = %s" % (acc.name, dr_sum))

            for a in gl2:
                cr_sum = cr_sum + a.reporting_amount

            # print('ACC-JUST', a, dr_sum, cr_sum)
            # print("%s cr = %s" % (acc.name, cr_sum))

            # difference

            # add to trial balance
            # if accounts type is dr, add to dr, if cr add to cr
            if acc.category.dr_cr == 'dr':
                diference = dr_sum - cr_sum

                obj = {
                    'account': acc,
                    'amount_dr': diference,
                    'amount_cr': 0
                }
                re.append(obj)

            elif acc.category.dr_cr == 'cr':
                diference = cr_sum - dr_sum

                obj = {
                    'account': acc,
                    'amount_dr': 0,
                    'amount_cr': diference
                }
                re.append(obj)
            # -1(sum(dr)-sum(cr)) retained earnings
        try:
            ret = re
            total_dr = 0
            total_cr = 0

            for rec in ret:
                # print('RECT acc', rec['account'])
                # print('exc')
                total_dr = total_dr + rec['amount_dr']
                total_cr = total_cr + rec['amount_cr']
                # print('TOTALS', total_dr, total_cr)

            retained_earnings = -1 * (total_dr - total_cr)
            # print('RETAINED EARNINGS', retained_earnings)

            # print("retained earnings = %s" % (retained_earnings))

            if retained_earnings >= 0:

                obj = {
                    'account': '',
                    'is_members': False,
                    'is_retained_earning': True,
                    'amount_dr': 0,
                    'amount_cr': retained_earnings,
                    'is_negative': False
                }
                tb.append(obj)
            else:
                retained_earnings = retained_earnings * -1

                obj = {
                    'account': '',
                    'is_members': False,
                    'is_retained_earning': True,
                    'amount_dr': retained_earnings,
                    'amount_cr': 0,
                    'is_negative': False
                }
                tb.append(obj)

        except Exception as ex:
            print(str(ex))
    except Exception as ex:
        # print(str(ex))
        pass

    new_tb = []
    for b in tb:
        if b['amount_dr'] == 0 and b['amount_cr'] == 0:
            pass
        else:
            new_tb.append(b)

    # tb = TrialBalance.objects.filter(user=request.user)
    gtotal_dr = 0
    gtotal_cr = 0
    for a in tb:
        gtotal_dr += a['amount_dr']
        gtotal_cr += a['amount_cr']
    start_date = datetime.strptime(str(start_date), "%Y-%m-%d").date()
    end_date = datetime.strptime(str(end_date), "%Y-%m-%d").date()
    tbxm = {"tb": new_tb, "total_dr": gtotal_dr, "total_cr": gtotal_cr, 'start_date': start_date, "end_date": end_date}
    return tbxm


@login_required
def trial_balance(request):
    if this_financial_year(request):
        context = make_tb(request)

        return render(request, "transactions/trial_balance.html", context)
    else:
        messages.error(request, "Financial Year not set")
        return HttpResponseRedirect(request.META.get("HTTP_REFERER"))


def make_bs(request, report):
    business_context = get_business_loans_context_data(request)
    if business_context['branch'] is None:  # here u are in the central view
        # show the business this person is attached to
        the_current_branch = this_branch(request.user)
    else:
        the_current_branch = business_context['branch']

    if 'report_for' in request.POST:
        report_for = request.POST['report_for']
        if report_for == "business":
            pass
        else:
            the_current_branch = Branch.objects.get(id=report_for)

    # get Trial Balance
    # print('WE ARE HERE - bs')
    tb_vanues = make_tb(request)


    tb = tb_vanues['tb']
    # print('tb_first value', tb[0])
    # print(tb)
    # filter to get only assets
    bs = []
    inc = []
    try:
        for a in tb:
            # print("is_members ============================ %s" % a['is_members'])
            if not a['is_retained_earning']:
                if not a['is_members']:
                    if a['account'].category.cat_type == "assets":
                        # print('AA', a)
                        # print('NAME', a['account'].display_name)
                        # print('dr cr isNegative', a['amount_dr'], a['amount_cr'], a['is_negative'],a['account'].category.name)
                        # add it to bs
                        #if its a fixed asset
                        if a['account'].category.name == 'Fixed Assets':
                            amt = a['amount_dr']
                        else:
                            amt = a['amount_dr'] + a['amount_cr']


                        if a['account'].category.name == 'Accumulating Depreciation Account':
                            a['is_negative'] = True

                        #original
                        # amt = a['amount_dr'] + a['amount_cr']
                        if a['is_negative']:
                            amt = -1 * amt

                        bs_obj = {
                            "account": a['account'],
                            "amount": amt,
                            "is_asset": True,
                            "is_liability": False,
                            "is_retained_earnings": False
                        }
                        # print('BS_OBJ', bs_obj)
                        bs.append(bs_obj)
                    elif a['account'].category.cat_type == "liability":
                        amt = a['amount_dr'] + a['amount_cr']
                        if a['is_negative']:
                            amt = -1 * amt

                        # nbsheet = BalanceSheet.objects.create(
                        #     user=request.user,
                        #     account=a.account,
                        #     amount=amt,
                        #     is_liability=True
                        # )
                        if a['is_members'] == True:
                            bs_obj = {
                                "account": a['account'],
                                "amount": amt,
                                "is_asset": False,
                                "is_liability": True,
                                "is_members": True,
                                "is_retained_earnings": False
                            }
                            bs.append(bs_obj)
                        else:
                            bs_obj = {
                                "account": a['account'],
                                "amount": amt,
                                "is_asset": False,
                                "is_liability": True,
                                "is_members": False,
                                "is_retained_earnings": False
                            }
                            bs.append(bs_obj)
                    elif a['account'].category.cat_type == "income" or a['account'].category.cat_type == "expenses":
                        if a['account'].category.dr_cr == "dr":
                            amt = a['amount_dr'] + a['amount_cr']
                            if a['is_negative']:
                                amt = -1 * amt

                            if a['account'].category.cat_type == "income":
                                is_obj = {
                                    "account": a['account'],
                                    "amount": amt,
                                    "is_revenue": True,
                                    "is_pl": False,
                                    "is_expense": False,
                                    "is_cost_of_sales": False
                                }
                            else:
                                is_obj = {
                                    "account": a['account'],
                                    "amount": amt,
                                    "is_revenue": False,
                                    "is_pl": False,
                                    "is_expense": True,
                                    "is_cost_of_sales": False
                                }
                            inc.append(is_obj)
                        elif a['account'].category.dr_cr == "cr":
                            # print(f"DR:{a['amount_dr']} CR:{a['amount_cr']}")
                            amt = a['amount_dr'] + a['amount_cr']

                            if a['is_negative']:
                                amt = -1 * amt
                            if a['account'].category.cat_type == "income":
                                print(f"========={a['account']} Part 2================")
                                is_obj = {
                                    "account": a['account'],
                                    "amount": amt,
                                    "is_revenue": True,
                                    "is_pl": False,
                                    "is_expense": False,
                                    "is_cost_of_sales": False
                                }
                            else:
                                is_obj = {
                                    "account": a['account'],
                                    "amount": amt,
                                    "is_revenue": False,
                                    "is_pl": False,
                                    "is_expense": True,
                                    "is_cost_of_sales": False
                                }

                            inc.append(is_obj)
                else:
                    if a['is_members'] == True:
                        amt = a['amount_dr'] + a['amount_cr']
                        if a['is_negative']:
                            amt = -1 * amt
                        bs_obj = {
                            "account": None,
                            "amount": amt,
                            "is_asset": False,
                            "is_liability": True,
                            "is_members": True,
                            "is_retained_earnings": False
                        }
                        bs.append(bs_obj)

    except Exception as ex:
        traceback.print_exc()
        pass

    # bs_assets = BalanceSheet.objects.filter(user=request.user, is_asset=True)
    # bs_liability = BalanceSheet.objects.filter(user=request.user, is_liability=True)

    # get sum
    total_assets = 0
    total_liabilities = 0
    for s in bs:
        if s['is_asset']:
            total_assets = total_assets + s['amount']
        if s['is_liability']:
            total_liabilities += s['amount']

    # get is now
    # is_revenue = IncomeStatement.objects.filter(user=request.user, is_revenue=True)
    # is_expense = IncomeStatement.objects.filter(user=request.user, is_expense=True)
    # is_cost_of_sales = IncomeStatement.objects.filter(user=request.user, is_cost_of_sales=True)

    # get sum
    total_revenue = 0
    total_expenses = 0
    total_cost_of_sales = 0
    # print('THE INC', inc)
    for s in inc:
        if s['is_revenue']:
            total_revenue = total_revenue + s['amount']
        if s['is_expense']:
            total_expenses = total_expenses + s['amount']
        if s['is_cost_of_sales']:
            total_cost_of_sales += s['amount']

    gross_profit = total_revenue - total_cost_of_sales

    profit_loss = gross_profit - total_expenses

    # save profit_loss to db
    # IncomeStatement.objects.create(
    #     user=request.user,
    #     amount=profit_loss,
    #     is_pl=True
    # )
    is_obj = {
        "account": None,
        "amount": profit_loss,
        "is_revenue": False,
        "is_pl": True,
        "is_expense": False,
        "is_cost_of_sales": False
    }

    inc.append(is_obj)

    # make retained earnings in BS
    try:
        # get retained earnings from TB
        # re = TrialBalance.objects.get(Q(user=request.user), Q(is_retained_earning=True))
        tb_re = 0
        for re in tb:
            if re['is_retained_earning']:
                tb_re = re['amount_cr'] + re['amount_dr']
    except Exception as ex:
        # print(str(ex))
        tb_re = 0

    # sum tb_re to profit_loss
    new_retained_earnings = tb_re + profit_loss

    # print("new rt=%s" % new_retained_earnings)
    # save to BS

    # BalanceSheet.objects.create(
    #     user=request.user,
    #     amount=new_retained_earnings,
    #     is_liability=True,
    #     is_retained_earnings=True
    # )
    bs_obj = {
        "account": None,
        "amount": new_retained_earnings,
        "is_asset": False,
        "is_liability": True,
        "is_retained_earnings": True
    }
    bs.append(bs_obj)
    # print(bs)
    if report == 'bs':
        bsa = []
        bsl = []
        for b in bs:
            # print("mbsl >>>>>>>>>>> %s" % bsl)
            if b['is_asset']:
                bsa.append(b)
            if b['is_liability']:
                bsl.append(b)

        # get sum
        total_assets = 0
        for s in bsa:
            total_assets += s['amount']

        total_liabilities = 0
        for s in bsl:
            total_liabilities += s['amount']
        # get bs now
        return {'assets': bsa, 'liabilities': bsl, 'total_assets': total_assets,
                'total_liabilities': total_liabilities, "start_date": tb_vanues['start_date'],
                "end_date": tb_vanues['end_date']}
    elif report == 'is':
        # isr = IncomeStatement.objects.filter(user=request.user, is_revenue=True)
        # ise = IncomeStatement.objects.filter(user=request.user, is_expense=True)
        # isc = IncomeStatement.objects.filter(user=request.user, is_cost_of_sales=True)
        # print("revenues count is %s" % isr.count())

        # get sum
        total_r = 0
        total_e = 0
        total_c = 0

        isr = []
        ise = []
        isc = []

        for s in inc:

            if s['is_revenue']:
                isr.append(s)
                total_r = total_r + s['amount']
            if s['is_expense']:
                ise.append(s)
                total_e = total_e + s['amount']

            if s['is_cost_of_sales']:
                isc.append(s)
                total_c = total_c + s['amount']

        gross_profit = total_revenue - total_cost_of_sales
        profit_lossx = gross_profit - total_expenses

        # print('THE REVENUES',isr)
        # get bs now
        return {'revenues': isr, 'expenses': ise, 'cost_of_sales': isc, 'total_revenues': total_r,
                'total_expenses': total_e, 'total_cos': total_c, 'profit_loss': profit_lossx,
                'gross_profit': gross_profit, "start_date": tb_vanues['start_date'], "end_date": tb_vanues['end_date']}

    elif report == 'expenses':

        total_e = 0

        ise = []

        for s in inc:

            if s['is_expense']:
                ise.append(s)
                total_e = total_e + s['amount']

        # get bs now
        return {'expenses': ise, 'total_expenses': total_e, "start_date": tb_vanues['start_date'],
                "end_date": tb_vanues['end_date']}
    elif report == 'revenues':
        # get sum
        total_r = 0

        isr = []

        for s in inc:
            if s['is_revenue']:
                isr.append(s)
                total_r = total_r + s['amount']
        # get bs now
        return {'revenues': isr, 'total_revenues': total_r, "start_date": tb_vanues['start_date'],
                "end_date": tb_vanues['end_date'], 'the_current_branch':the_current_branch}


@login_required
def balance_sheet(request, report):
    if this_financial_year(request):
        business_context = get_business_loans_context_data(request)
        if business_context['branch'] is None:  # here u are in the central view
            # show the business this person is attached to
            the_current_branch = this_branch(request.user)
        else:
            the_current_branch = business_context['branch']
        if 'report_for' in request.POST:
            report_for = request.POST['report_for']
            if report_for == "business":
                pass
            else:
                the_current_branch = Branch.objects.get(id=report_for)
        context = make_bs(request, report)
        context['the_current_branch'] = the_current_branch

        if report == 'bs':
            return render(request, "transactions/balance_sheet.html", context)
        elif report == 'is':
            return render(request, "transactions/income_statement.html", context)
        elif report == 'expenses':
            return render(request, "transactions/expenses.html", context)
        elif report == 'revenues':
            return render(request, "transactions/revenues.html", context)
        else:
            return HttpResponseRedirect("/")
    else:
        messages.error(request, "Financial Year not set")
        return HttpResponseRedirect("/")


@login_required
@user_in_business
@user_has_perm("View Financial Reports")
def general_ledger(request):
    business_context = get_business_loans_context_data(request)
    if this_financial_year(request):
        global bran
        if request.method == "POST":
            if 'financial_year' in request.POST:
                fy = request.POST['financial_year']
                if fy == "custom":
                    if 'start_date' in request.POST:
                        start_date = request.POST['start_date']
                    else:
                        dates = FinancialYear.objects.filter(status=True, business=this_business(request.user)).last()
                        start_date = dates.start_date

                    if 'end_date' in request.POST:
                        end_date = request.POST['end_date']
                    else:
                        dates = FinancialYear.objects.filter(status=True, business=this_business(request.user)).last()
                        end_date = datetime.today().date()

                else:
                    try:
                        dates = FinancialYear.objects.filter(id=fy, business=this_business(request.user)).last()
                        start_date = dates.start_date
                        end_date = dates.end_date
                    except Exception as ex:
                        messages.error(request, "Financial Year Not Found")
                        return HttpResponseRedirect("/transactions/trial-balance/")
            else:
                if 'start_date' in request.POST:
                    start_date = request.POST['start_date']
                else:
                    dates = FinancialYear.objects.filter(status=True, business=this_business(request.user)).last()
                    start_date = dates.start_date

                if 'end_date' in request.POST:
                    end_date = request.POST['end_date']
                else:
                    dates = FinancialYear.objects.filter(status=True, business=this_business(request.user)).last()
                    end_date = datetime.today().date()

            if 'report_for' in request.POST:
                report_for = request.POST['report_for']
                if report_for == "business":
                    pass
                else:
                    # bran = Branch.objects.get(Q(business=this_business(request.user)), Q(id=report_for))
                    bran = Branch.objects.get(id=report_for)
            else:
                # print('--- setting basing on the context --')
                if business_context['branch'] is None: # here u are in the central view
                    # show the business this person is attached to
                    bran = this_branch(request.user)
                else:
                    bran = business_context['branch']
        else:
            try:
                dates = FinancialYear.objects.filter(status=True, business=this_business(request.user)).last()

                start_date = dates.start_date
                end_date = datetime.today().date()
                # bran = this_branch(request.user)

                if business_context['branch'] is None: # here u are in the central view
                    # show the business this person is attached to
                    bran = this_branch(request.user)
                else:
                    bran = business_context['branch']

            except Exception as ex:
                # print(str(ex))
                messages.error(request, "Financial Year Not Found")
                return HttpResponseRedirect("/transactions/general-ledger/")

        # print('CURRENT BRANCH', bran.name)
        if 'q' in request.GET:
            query = request.GET['q'] # represents Name of a member/ acc number
            if query is None or query == "":
                gl = Transactions.objects.filter(tx_date__range=(start_date, end_date), branch=bran)
            else:
                accbr = AccountBroker.objects.filter(
                    Q(business=this_business(request.user), members__biodata__name__icontains=query))

                mb = MemberAccount.objects.filter(Q(acc_number__contains=query) |
                                                  Q(id__in=accbr))

                gl = Transactions.objects.filter(Q(tx_date__range=(start_date, end_date), branch=bran),
                                                 Q(
                                                     Q(txno__icontains=query) |
                                                     Q(transaction_type__icontains=query) |
                                                     Q(reporting_amount__icontains=query) |
                                                     Q(narration__icontains=query) |
                                                     Q(account_dr__name__icontains=query) |
                                                     Q(account_cr__name__icontains=query) |
                                                     Q(account_dr__member__in=mb) |
                                                     Q(account_cr__member__in=mb)
                                                 )
                                                 )
            page = request.GET.get('page', 1)
            p = Paginator(gl, 10)

            try:
                txs = p.page(page)
            except PageNotAnInteger:
                txs = p.page(1)
            except EmptyPage:
                txs = p.page(p.num_pages)

            start_date = datetime.strptime(str(start_date), "%Y-%m-%d").date()
            end_date = datetime.strptime(str(end_date), "%Y-%m-%d").date()
            response = render(request, "transactions/gl_search_results.html",
                              {"general_ledgers": txs, "query": query, "start_date": start_date, "end_date": end_date})
            return HttpResponse(response)
        if 'query' in request.GET:
            # print('query is there')
            query = request.GET.get('query', None)
            # print(query)
            if query is None or query == "":
                gl = Transactions.objects.filter(tx_date__range=(start_date, end_date), branch=bran)
            else:
                accbr = AccountBroker.objects.filter(
                    Q(business=this_business(request.user), members__biodata__name__icontains=query))

                mb = MemberAccount.objects.filter(Q(acc_number__contains=query) |
                                                  Q(id__in=accbr))

                gl = Transactions.objects.filter(Q(tx_date__range=(start_date, end_date), branch=bran),
                                                 Q(
                                                     Q(txno__icontains=query) |
                                                     Q(transaction_type__icontains=query) |
                                                     Q(reporting_amount__icontains=query) |
                                                     Q(narration__icontains=query) |
                                                     Q(account_dr__name__icontains=query) |
                                                     Q(account_cr__name__icontains=query) |
                                                     Q(account_dr__member__in=mb) |
                                                     Q(account_cr__member__in=mb)
                                                 )
                                                 )
            page = request.GET.get('page', 1)
            p = Paginator(gl, 10)

            try:
                txs = p.page(page)
            except PageNotAnInteger:
                txs = p.page(1)
            except EmptyPage:
                txs = p.page(p.num_pages)

            start_date = datetime.strptime(str(start_date), "%Y-%m-%d").date()
            end_date = datetime.strptime(str(end_date), "%Y-%m-%d").date()
            response = render(request, "transactions/general_ledger.html",
                              {"general_ledger": txs, "query": query, "start_date": start_date,
                               "end_date": end_date, 'bran':bran})
            return response
        else:
            gl = Transactions.objects.filter(tx_date__range=(start_date, end_date), branch=bran)
            page = request.GET.get('page', 1)
            p = Paginator(gl, 10)

            try:
                txs = p.page(page)
            except PageNotAnInteger:
                txs = p.page(1)
            except EmptyPage:
                txs = p.page(p.num_pages)

            start_date = datetime.strptime(str(start_date), "%Y-%m-%d").date()
            end_date = datetime.strptime(str(end_date), "%Y-%m-%d").date()
            return render(request, "transactions/general_ledger.html",
                          {"general_ledger": txs, "start_date": start_date, "end_date": end_date, 'bran':bran})

    else:
        messages.error(request, "Financial Year not set")
        return HttpResponseRedirect(request.META.get("HTTP_REFERER"))


@login_required
@user_in_business
@user_has_perm("Manage Financial Reports")
def make_Individual_gl(request):
    business_context = get_business_loans_context_data(request)
    if business_context['branch'] is None:  # here u are in the central view
        # show the business this person is attached to
        the_current_branch = this_branch(request.user)
    else:
        the_current_branch = business_context['branch']
    if 'report_for' in request.POST:
        report_for = request.POST['report_for']
        if report_for == "business":
            pass
        else:
            the_current_branch = Branch.objects.get(id=report_for)
    all_accounts = Account.objects.filter(Q(business=the_current_branch.business),
                                          ~Q(category__name="Members")).order_by("name")
    # clear table first
    il = []

    r_balance = 0

    financial_year = this_financial_year(request)

    if request.method == "POST":

        if 'financial_year' in request.POST:
            fy = request.POST['financial_year']
            if fy == "custom":
                # print('custom')
                if 'start_date' in request.POST:
                    st_date = request.POST['start_date']
                else:
                    # print("not default")
                    dates = FinancialYear.objects.filter(status=True, business=this_business(request.user)).last()
                    st_date = dates.start_date

                # print('START DATE', st_date)


                if 'end_date' in request.POST:
                    en_date = request.POST['end_date']
                else:
                    dates = FinancialYear.objects.filter(status=True, business=this_business(request.user)).last()
                    en_date = datetime.today().date()

            else:
                dates = FinancialYear.objects.filter(status=True, business=this_business(request.user)).last()
                st_date = dates.start_date
                en_date = datetime.today().date()

        else:
            if 'start_date' in request.POST:
                st_date = request.POST['start_date']
            else:
                dates = FinancialYear.objects.filter(status=True, business=this_business(request.user)).last()
                st_date = dates.start_date

            if 'end_date' in request.POST:
                en_date = request.POST['end_date']
            else:
                dates = FinancialYear.objects.filter(status=True, business=this_business(request.user)).last()
                en_date = datetime.today().date()

        date_from = request.GET.get('date_from')
        date_to = request.GET.get('date_to')
        # print('DATE FROM', date_from)

        #DONT FORGET TO CHCEK IF THEY ARE VALID DATES
        if date_from is not None:
            # print('PASSED HERE')
            st_date = date_from

            if date_to is not None:
                # print('PASSED HERE part 2')
                en_date = date_to
            else:
                en_date = today
        # print('START AND END DATE',st_date, en_date)

        bran=the_current_branch
        if 'report_for' in request.POST:
            report_for = request.POST['report_for']
            if report_for == "business":
                pass
            else:
                bran = the_current_branch
        else:
            bran = the_current_branch

        # print('the current branch', the_current_branch)

        id = request.POST['id']
        # print('Got id =', id)
        if id == "0" or id is None or id == "":
            if st_date is None and en_date is None:
                gl = Transactions.objects.filter(
                    Q(account_dr__category__name="Members", tx_date__range=(st_date, en_date),
                      branch=bran) | Q(account_cr__category__name="Members",
                                                            tx_date__range=(st_date, en_date),
                                                            branch=bran))
            elif st_date is None and en_date is not None:
                gl = Transactions.objects.filter(
                    (Q(account_dr__category__name="Members") | Q(account_cr__category__name="Members")),
                    Q(tx_date__lte=en_date), Q(branch=bran)
                )
            elif st_date is not None and en_date is None:
                gl = Transactions.objects.filter(
                    (Q(account_dr__category__name="Members") | Q(account_cr__category__name="Members")),
                    Q(tx_date__gte=st_date), Q(branch=bran)
                )
                ob_gl_dr = Transactions.objects.filter(
                    Q(account_dr__category__name="Members"), Q(tx_date__lt=st_date), Q(branch=bran)
                )
                ob_gl_cr = Transactions.objects.filter(
                    Q(account_cr__category__name="Members"), Q(tx_date__lt=st_date), Q(branch=bran)
                )
                ob_cr = 0
                ob_dr = 0
                total_ob = 0
                for x in ob_gl_dr:
                    ob_dr += x.reporting_amount

                for x in ob_gl_cr:
                    ob_cr += x.reporting_amount

                total_ob = ob_cr - ob_dr
                r_balance = total_ob

                obj = {
                    'gl': None,
                    'account_dr': None,
                    'account_cr': None,
                    'amount_cr': r_balance,
                    'amount_dr': 0,
                    'is_opening_balance': True,
                    'balance': r_balance

                }
                il.append(obj)

            elif st_date is not None and en_date is not None:
                gl = Transactions.objects.filter(
                    (Q(account_dr__category__name="Members") | Q(account_cr__category__name="Members")),
                    Q(tx_date__range=(st_date, en_date)), Q(branch=bran)
                )
                ob_gl_dr = Transactions.objects.filter(
                    Q(account_dr__category__name="Members"), Q(tx_date__lt=st_date),
                    Q(branch=bran))
                ob_gl_cr = Transactions.objects.filter(
                    Q(account_cr__category__name="Members"), Q(tx_date__lt=st_date),
                    Q(branch=bran))
                ob_cr = 0
                ob_dr = 0
                total_ob = 0
                for x in ob_gl_dr:
                    ob_dr += x.reporting_amount

                for x in ob_gl_cr:
                    ob_cr += x.reporting_amount

                total_ob = ob_cr - ob_dr
                r_balance = total_ob
                obj = {
                    'gl': None,
                    'account_dr': None,
                    'account_cr': None,
                    'amount_cr': r_balance,
                    'amount_dr': 0,
                    'is_opening_balance': True,
                    'balance': r_balance

                }
                il.append(obj)

            for g in gl:
                # for each result, check if its dr or cr
                if g.account_dr.category.name == "Members":
                    r_balance = r_balance - g.reporting_amount
                    # record to temp
                    obj = {
                        'gl': g,
                        'account_dr': g.account_dr,
                        'account_cr': g.account_cr,
                        'amount_cr': 0,
                        'amount_dr': g.reporting_amount,
                        'is_opening_balance': False,
                        'balance': r_balance

                    }
                    il.append(obj)

                if g.account_cr.category.name == "Members":
                    r_balance = r_balance + g.reporting_amount
                    # record to temp
                    obj = {
                        'gl': g,
                        'account_dr': g.account_dr,
                        'account_cr': g.account_cr,
                        'amount_cr': g.reporting_amount,
                        'amount_dr': 0,
                        'is_opening_balance': False,
                        'balance': r_balance

                    }
                    il.append(obj)

            totalcr = 0
            totaldr = 0
            for i in il:
                totalcr += i['amount_cr']
                totaldr += i['amount_dr']
            start_date = datetime.strptime(str(st_date), "%Y-%m-%d").date()
            end_date = datetime.strptime(str(en_date), "%Y-%m-%d").date()
            context = {'individual_gl': il, 'account': "Members", 'accounts': all_accounts, 'total_cr': totalcr,
                       "total_dr": totaldr,
                       'start_date': start_date, "end_date": end_date}

            return context
        else:
            account = Account.objects.get(id=id)
            # get gl where account is this
            if st_date is None and en_date is None:
                gl = Transactions.objects.filter(
                    Q(account_dr=account, financial_year=this_financial_year(request)) | Q(account_cr=account,
                                                                                           financial_year=this_financial_year(
                                                                                               request)))
            elif st_date is None and en_date is not None:
                gl = Transactions.objects.filter(
                    (Q(account_dr=account) | Q(account_cr=account)), Q(tx_date__lte=en_date)
                )
            elif st_date is not None and en_date is None:
                gl = Transactions.objects.filter(
                    (Q(account_dr=account) | Q(account_cr=account)), Q(tx_date__gte=st_date)
                )
                ob_gl_dr = Transactions.objects.filter(
                    Q(account_dr=account), Q(tx_date__lt=st_date)
                )
                ob_gl_cr = Transactions.objects.filter(
                    Q(account_cr=account), Q(tx_date__lt=st_date)
                )
                ob_cr = 0
                ob_dr = 0
                total_ob = 0
                for x in ob_gl_dr:
                    ob_dr += x.reporting_amount

                for x in ob_gl_cr:
                    ob_cr += x.reporting_amount
                if account.category.dr_cr == 'cr':
                    total_ob = ob_cr - ob_dr
                    r_balance = total_ob

                    obj = {
                        'gl': None,
                        'account_dr': None,
                        'account_cr': None,
                        'amount_cr': r_balance,
                        'amount_dr': 0,
                        'is_opening_balance': True,
                        'balance': r_balance

                    }
                    il.append(obj)
                else:
                    total_ob = ob_dr - ob_cr
                    r_balance = total_ob
                    obj = {
                        'gl': None,
                        'account_dr': None,
                        'account_cr': None,
                        'amount_cr': 0,
                        'amount_dr': r_balance,
                        'is_opening_balance': True,
                        'balance': r_balance

                    }
                    il.append(obj)

            elif st_date is not None and en_date is not None:
                gl = Transactions.objects.filter(
                    (Q(account_dr=account) | Q(account_cr=account)),
                    Q(tx_date__range=(st_date, en_date))
                )
                ob_gl_dr = Transactions.objects.filter(
                    Q(account_dr=account), Q(tx_date__lt=st_date)
                )
                ob_gl_cr = Transactions.objects.filter(
                    Q(account_cr=account), Q(tx_date__lt=st_date)
                )
                ob_cr = 0
                ob_dr = 0
                total_ob = 0
                for x in ob_gl_dr:
                    ob_dr += x.reporting_amount

                for x in ob_gl_cr:
                    ob_cr += x.reporting_amount
                if account.category.dr_cr == 'cr':
                    total_ob = ob_cr - ob_dr
                    r_balance = total_ob
                    obj = {
                        'gl': None,
                        'account_dr': None,
                        'account_cr': None,
                        'amount_cr': r_balance,
                        'amount_dr': 0,
                        'is_opening_balance': True,
                        'balance': r_balance

                    }
                    il.append(obj)
                    # new = IndividualGl.objects.create(
                    #     business=request.user.branch,
                    #     amount_cr=r_balance,
                    #     is_opening_balance=True,
                    #     balance=r_balance
                    # )
                else:
                    total_ob = ob_dr - ob_cr
                    r_balance = total_ob
                    obj = {
                        'gl': None,
                        'account_dr': None,
                        'account_cr': None,
                        'amount_cr': 0,
                        'amount_dr': r_balance,
                        'is_opening_balance': True,
                        'balance': r_balance

                    }
                    il.append(obj)
                    # new = IndividualGl.objects.create(
                    #     business=request.user.branch,
                    #     amount_dr=r_balance,
                    #     is_opening_balance=True,
                    #     balance=r_balance
                    # )

            if account.category.dr_cr == 'cr':
                for g in gl:
                    # for each result, check if its dr or cr
                    if g.account_dr == account:
                        r_balance = r_balance - g.reporting_amount
                        # record to temp
                        obj = {
                            'gl': g,
                            'account_dr': g.account_dr,
                            'account_cr': g.account_cr,
                            'amount_cr': 0,
                            'amount_dr': g.reporting_amount,
                            'is_opening_balance': False,
                            'balance': r_balance

                        }
                        il.append(obj)
                        # new = IndividualGl.objects.create(
                        #     business=request.user.branch,
                        #     gl=g,
                        #     account_dr=g.account_dr,
                        #     account_cr=g.account_cr,
                        #     amount_dr=g.reporting_amount,
                        #     balance=r_balance
                        # )

                    if g.account_cr == account:
                        r_balance = r_balance + g.reporting_amount
                        # record to temp
                        obj = {
                            'gl': g,
                            'account_dr': g.account_dr,
                            'account_cr': g.account_cr,
                            'amount_cr': g.reporting_amount,
                            'amount_dr': 0,
                            'is_opening_balance': False,
                            'balance': r_balance

                        }
                        il.append(obj)
                        # new = IndividualGl.objects.create(
                        #     business=request.user.branch,
                        #     gl=g,
                        #     account_dr=g.account_dr,
                        #     account_cr=g.account_cr,
                        #     amount_cr=g.reporting_amount,
                        #     balance=r_balance
                        # )
            else:
                for g in gl:
                    # for each result, check if its dr or cr
                    if g.account_dr == account:
                        r_balance = r_balance + g.reporting_amount
                        # record to temp
                        obj = {
                            'gl': g,
                            'account_dr': g.account_dr,
                            'account_cr': g.account_cr,
                            'amount_cr': 0,
                            'amount_dr': g.reporting_amount,
                            'is_opening_balance': False,
                            'balance': r_balance

                        }
                        il.append(obj)
                        # new = IndividualGl.objects.create(
                        #     business=request.user.branch,
                        #     gl=g,
                        #     account_dr=g.account_dr,
                        #     account_cr=g.account_cr,
                        #     amount_dr=g.reporting_amount,
                        #     balance=r_balance
                        # )

                    if g.account_cr == account:
                        r_balance = r_balance - g.reporting_amount
                        # record to temp
                        obj = {
                            'gl': g,
                            'account_dr': g.account_dr,
                            'account_cr': g.account_cr,
                            'amount_cr': g.reporting_amount,
                            'amount_dr': 0,
                            'is_opening_balance': False,
                            'balance': r_balance

                        }
                        il.append(obj)
                        # new = IndividualGl.objects.create(
                        #     business=request.user.branch,
                        #     gl=g,
                        #     account_dr=g.account_dr,
                        #     account_cr=g.account_cr,
                        #     amount_cr=g.reporting_amount,
                        #     balance=r_balance
                        # )
            # Now return the values
            # igl = IndividualGl.objects.filter(business=request.user.branch)
            # totals = IndividualGl.objects.raw(
            #     "SELECT *, sum(amount_dr)as totaldr, sum(amount_cr)as totalcr from production_individualgl where business_id=%s" % (
            #         request.user.branch.id))[0]
            totalcr = 0
            totaldr = 0
            for i in il:
                totalcr += i['amount_cr']
                totaldr += i['amount_dr']

            st_date = datetime.strptime(str(st_date), "%Y-%m-%d").date()
            en_date = datetime.strptime(str(en_date), "%Y-%m-%d").date()
            context = {'individual_gl': il, 'account': account, 'accounts': all_accounts, 'total_cr': totalcr,
                       "total_dr": totaldr,
                       'start_date': st_date, "end_date": en_date}
            return context


def make_Individual_gl_assets(request):
    business_context = get_business_loans_context_data(request)
    if business_context['branch'] is None:  # here u are in the central view
        # show the business this person is attached to
        the_current_branch = this_branch(request.user)
    else:
        the_current_branch = business_context['branch']
    # clear table first
    il = []

    r_balance = 0

    # financial_year = this_financial_year(request)

    if request.method == "POST":

        if 'financial_year' in request.POST:
            fy = request.POST['financial_year']
            if fy == "custom":
                # print('custom')
                if 'start_date' in request.POST:
                    st_date = request.POST['start_date']
                else:
                    # print("not default")
                    dates = FinancialYear.objects.filter(status=True, business=this_business(request.user)).last()
                    st_date = dates.start_date

                if 'end_date' in request.POST:
                    en_date = request.POST['end_date']
                else:
                    dates = FinancialYear.objects.filter(status=True, business=this_business(request.user)).last()
                    en_date = datetime.today().date()

            else:
                if 'start_date' in request.POST:
                    st_date = request.POST['start_date']
                else:
                    # print("not default")
                    dates = FinancialYear.objects.filter(status=True, business=this_business(request.user)).last()
                    st_date = dates.start_date

                if 'end_date' in request.POST:
                    en_date = request.POST['end_date']
                else:
                    dates = FinancialYear.objects.filter(status=True, business=this_business(request.user)).last()
                    en_date = datetime.today().date()
        else:
            if 'start_date' in request.POST:
                st_date = request.POST['start_date']
            else:
                dates = FinancialYear.objects.filter(status=True, business=this_business(request.user)).last()
                st_date = dates.start_date

            if 'end_date' in request.POST:
                en_date = request.POST['end_date']
            else:
                dates = FinancialYear.objects.filter(status=True, business=this_business(request.user)).last()
                en_date = datetime.today().date()

        if 'report_for' in request.POST:
            report_for = request.POST['report_for']
            if report_for == "business":
                pass
            else:
                bran = Branch.objects.get(id=report_for)
        else:
            bran = the_current_branch

    else:
        st_date = datetime.today().date()
        en_date = datetime.today().date()

    accountx = Account.objects.filter(Q(business=the_current_branch.business),
                                      Q(Q(category__name='Bank') | Q(category__name='Cash') | Q(
                                          category__name='Mobile Money')))

    for account in accountx:
        # get gl where account is this

        if st_date is not None:
            ob_cr = 0
            ob_dr = 0
            total_ob = 0
            ob = Transactions.objects.filter(branch=the_current_branch, tx_date__lt=st_date).aggregate(
                t_cash=Sum(
                    Case(
                        When(account_dr=account, then=F('reporting_amount')),
                        default=0, output_field=FloatField()))
                       - Sum(
                    Case(
                        When(account_cr=account, then=F('reporting_amount')),
                        default=0, output_field=FloatField()))
            )

            total_ob = ob['t_cash']
            r_balance += total_ob
            obj = {
                'gl': None,
                'ob_narrative': 'Opening Balance %s (%s)' % (account.name, account.category.name),
                'account_dr': None,
                'account_cr': None,
                'amount_cr': 0,
                'amount_dr': total_ob,
                'is_opening_balance': True,
                'balance': r_balance

            }
            il.append(obj)

    for account in accountx:
        # get gl where account is this
        if st_date is None and en_date is None:
            gl = Transactions.objects.filter(
                Q(account_dr=account, financial_year=this_financial_year(request)) | Q(account_cr=account,
                                                                                       financial_year=this_financial_year(
                                                                                           request)))
        elif st_date is None and en_date is not None:
            gl = Transactions.objects.filter(
                (Q(account_dr=account) | Q(account_cr=account)), Q(tx_date__lte=en_date)
            )
        elif st_date is not None and en_date is None:
            gl = Transactions.objects.filter(
                (Q(account_dr=account) | Q(account_cr=account)), Q(tx_date__gte=st_date)
            )

        elif st_date is not None and en_date is not None:
            gl = Transactions.objects.filter(
                (Q(account_dr=account) | Q(account_cr=account)),
                Q(tx_date__range=(st_date, en_date))
            )

        for g in gl:
            # for each result, check if its dr or cr
            isob = False

            if g.account_dr == account:
                r_balance = r_balance + g.reporting_amount
                # record to temp
                obj = {
                    'gl': g,
                    'account_dr': g.account_dr,
                    'account_cr': g.account_cr,
                    'amount_cr': 0,
                    'amount_dr': g.reporting_amount,
                    'is_opening_balance': isob,
                    'balance': r_balance

                }
                il.append(obj)

            if g.account_cr == account:
                r_balance = r_balance - g.reporting_amount
                # record to temp
                obj = {
                    'gl': g,
                    'account_dr': g.account_dr,
                    'account_cr': g.account_cr,
                    'amount_cr': g.reporting_amount,
                    'amount_dr': 0,
                    'is_opening_balance': isob,
                    'balance': r_balance

                }
                il.append(obj)

    totalcr = 0
    totaldr = 0
    for i in il:
        totalcr += i['amount_cr']
        totaldr += i['amount_dr']

    st_date = datetime.strptime(str(st_date), "%Y-%m-%d").date()
    en_date = datetime.strptime(str(en_date), "%Y-%m-%d").date()
    context = {'individual_gl': il, 'account': accountx, 'total_cr': totalcr,
               "total_dr": totaldr,
               'start_date': st_date, "end_date": en_date}

    return context



@login_required
@user_in_business
@user_has_perm("View Financial Reports")
def individual_gl(request):
    if this_financial_year(request):
        business_context = get_business_loans_context_data(request)
        the_selected_branch = request.POST.get('the_selected_branch', None)
        if business_context['branch'] is None:  # here u are in the central view
            # show the business this person is attached to
            the_current_branch = this_branch(request.user)
            if the_selected_branch is not None and the_selected_branch == str(the_current_branch.id):
                the_current_branch = Branch.objects.get(id=the_selected_branch)

        else:
            the_current_branch = business_context['branch']

        if 'report_for' in request.POST:
            report_for = request.POST['report_for']
            # print('FISRT REPORT FOR', report_for)
            if report_for == "business":
                pass
            else:
                # print('ARE WE HERE YET', report_for)
                the_current_branch = Branch.objects.get(id=report_for)
                if the_selected_branch is not None and the_selected_branch == str(the_current_branch.id):
                    the_current_branch = Branch.objects.get(id=the_selected_branch)

        if request.method == "POST":
            id = request.POST['id']

            # print('Got id =', id)
            print(id, the_selected_branch, the_current_branch.id)
            if id == "0" or id is None or id == "" or the_selected_branch is None or the_selected_branch != str(the_current_branch.id):

                all_accounts = Account.objects.filter(Q(business=the_current_branch.business),
                                                      ~Q(category__name="Members")).order_by("display_name")
                # print('ALL ACCOUNTS', all_accounts) # using the display name

                # messages.info(request, "Please select a ledger to display")
                return render(request, "transactions/individual_ledger.html",
                              {'accounts': all_accounts, 'the_current_branch': the_current_branch})

            context = make_Individual_gl(request)

            individual_ledger = context['individual_gl']
            page = request.GET.get('page', 1)
            p = Paginator(individual_ledger, 100)

            try:
                individual_gl = p.page(page)
            except PageNotAnInteger:
                individual_gl = p.page(1)
            except EmptyPage:
                individual_gl = p.page(p.num_pages)

            context['individual_gl']=individual_gl
            context['the_current_branch'] = the_current_branch

            return render(request, "transactions/individual_ledger.html", context)
        else:
            all_accounts = Account.objects.filter(Q(business=the_current_branch.business),
                                                  ~Q(category__name="Members")).order_by("display_name")
            # print('ALL ACCOUNTS', all_accounts) # using the display name

            # messages.info(request, "Please select a ledger to display")
            return render(request, "transactions/individual_ledger.html", {'accounts': all_accounts, 'the_current_branch':the_current_branch})
    else:
        messages.error(request, "Financial Year not set")
        return HttpResponseRedirect(request.META.get("HTTP_REFERER"))


@login_required
@user_in_business
@user_has_perm("View Financial Reports")
def make_member_statement(request):
    # business_context = get_business_loans_context_data(request)
    # if business_context['branch'] is None:  # here u are in the central view
    #     # show the business this person is attached to
    #     the_current_branch = this_branch(request.user)
    # else:
    #     the_current_branch = business_context['branch']
    if this_financial_year(request):
        if request.method == "POST":

            context = make_Individual_gl(request)

            total_deposits = 0
            total_withdraws = 0
            total_charges = 0
            total_interests = 0
            opening_balance = 0
            closing_balance = 0

            data = context['individual_gl']
            for n in data:
                # opening balances
                if n['is_opening_balance']:
                    opening_balance += n['amount_cr']
                else:
                    if n['gl'].account_dr.name == "Opening Reserves":
                        opening_balance += n['amount_cr']
                    else:
                        # deposits
                        if n['gl'].account_dr.category.cat_type == "assets":
                            total_deposits += n['amount_cr']
                        # withdraws
                        if n['gl'].account_cr.category.cat_type == "assets":
                            total_withdraws += n['amount_dr']
                        # charges
                        if n['gl'].account_cr.category.cat_type == "income":
                            total_charges += n['amount_dr']
                        # interests
                        if n['gl'].account_dr.category.cat_type == "expense":
                            total_interests += n['amount_cr']
            # closing balance
            closing_balance = opening_balance + total_deposits + total_interests - total_withdraws - total_charges

            context['opening_balance'] = opening_balance
            context['total_deposits'] = total_deposits
            context['total_withdraws'] = total_withdraws
            context['total_charges'] = total_charges
            context['total_interests'] = total_interests
            context['closing_balance'] = closing_balance
            return context
        else:

            return {}
    else:
        return {}


@login_required
@user_in_business
@user_has_perm("Manage Financial Reports")
def make_closing_balances(request):
    business_context = get_business_loans_context_data(request)
    if business_context['branch'] is None:  # here u are in the central view
        # show the business this person is attached to
        the_current_branch = this_branch(request.user)
    else:
        the_current_branch = business_context['branch']

    if this_financial_year(request):

        context = make_Individual_gl_assets(request)

        total_debits = 0
        total_credits = 0

        opening_balance = 0
        closing_balance = 0

        data = context['individual_gl']

        for n in data:
            # opening balances
            if n['is_opening_balance']:
                opening_balance += n['amount_dr']
            else:
                if n['gl'].account_dr.name == "Opening Reserves":
                    opening_balance += n['amount_dr']
                else:
                    # credits
                    if n['gl'].account_cr.category.cat_type == "assets":
                        total_credits += n['amount_cr']
                    # debits
                    if n['gl'].account_dr.category.cat_type == "assets":
                        total_debits += n['amount_dr']

        # closing balance
        closing_balance = opening_balance + total_debits - total_credits

        context['opening_balance'] = opening_balance
        context['total_debits'] = total_debits
        context['total_credits'] = total_credits

        context['closing_balance'] = closing_balance
        return context

    else:
        return {}


@login_required
@user_in_business
@user_has_perm("View Financial Reports")
def member_statement(request):

    if this_financial_year(request):
        if request.method == "POST":

            context = make_member_statement(request)

            return render(request, "transactions/member_statement.html", context)
        else:

            return render(request, "transactions/member_statement.html")
    else:
        messages.error(request, "Financial Year not set")
        return HttpResponseRedirect(request.META.get("HTTP_REFERER"))


@login_required
@user_in_business
@user_has_perm("View Financial Reports")
def closing_balances(request):
    if this_financial_year(request):
        context = make_closing_balances(request)
        # return HttpResponse(context['individual_gl'])
        return render(request, "transactions/closing_balances.html", context)
    else:
        messages.error(request, "Financial Year not set")
        return HttpResponseRedirect("/")


@login_required
@user_in_business
@user_has_perm("Manage Financial Reports")
def reconcile_gl(request):
    business_context = get_business_loans_context_data(request)
    if business_context['branch'] is None:  # here u are in the central view
        # show the business this person is attached to
        the_current_branch = this_branch(request.user)
    else:
        the_current_branch = business_context['branch']
    if this_financial_year(request):

        if request.method == "POST":
            context = make_Individual_gl(request)
            return render(request, "transactions/account_reconciliation.html", context)
        else:
            all_accounts = Account.objects.filter(Q(business=the_current_branch.business),
                                                  ~Q(category__name="Members")).order_by("name")
            return render(request, "transactions/account_reconciliation.html", {'accounts': all_accounts})
    else:
        messages.error(request, "Financial Year not set")
        return HttpResponseRedirect(request.META.get("HTTP_REFERER"))


@login_required
@user_in_business
@user_has_perm("Manage Financial Reports")
def update_reconciliation(request, id):
    if request.method == "POST":
        transaction_id = request.POST['tx_id']
        amount = request.POST['amount']
        tx_date = request.POST['date']
        dr_account_id = request.POST['dr_account']
        cr_account_id = request.POST['cr_account']
        narration = request.POST['narration']

        # get id
        scene_account = Account.objects.get(id=id)

        # start by validating the accounts
        try:
            dr_account = Account.objects.get(id=dr_account_id)
        except:
            # Debid account does not exist
            return HttpResponse("1")

        try:
            cr_account = Account.objects.get(id=cr_account_id)
        except:
            # Credit account does not exist
            return HttpResponse("2")

        # check if the account in scene matches any of the provided accounts
        if id == cr_account.id or id == dr_account.id:
            pass
        else:
            return HttpResponse("2")

        # check if this transaction exists
        try:
            transaction = Transactions.objects.get(
                Q(account_dr=scene_account, id=transaction_id) |
                Q(account_cr=scene_account, id=transaction_id)
            )
        except:
            return HttpResponse("3")

        try:
            # first capture the previous records
            # otxdate = ,
            ndate = date(transaction.tx_date.year, transaction.tx_date.month, transaction.tx_date.day)
            # print(ndate)
            oamount = transaction.reporting_amount
            onarration = transaction.narration

            # update the transaction
            transaction.account_cr = cr_account
            transaction.account_dr = dr_account
            transaction.reporting_amount = amount
            transaction.tx_date = str(tx_date)
            transaction.narration = str(narration)
            transaction.original_amount = float(oamount)
            transaction.original_date = ndate.strftime("%Y-%m-%d")
            transaction.original_narration = onarration
            transaction.reconciled_by = request.user.staff
            transaction.save()
            return HttpResponse("200")
        except Exception as ex:
            # print(str(ex))
            traceback.print_exc()
            return HttpResponse("4")

    else:
        return HttpResponse("0")
