# Generated by Django 4.2.6 on 2023-12-09 13:28

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('sacco', '0001_initial'),
        ('accounts', '0001_initial'),
        ('loans', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='Account',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('code', models.CharField(blank=True, max_length=20, null=True)),
                ('name', models.CharField(max_length=225)),
                ('display_name', models.CharField(blank=True, default='', max_length=255, null=True)),
                ('eul', models.IntegerField(blank=True, null=True)),
                ('related_to', models.IntegerField(blank=True, null=True)),
                ('date_added', models.DateTimeField(auto_now=True)),
                ('added_by', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='accounts.staff')),
                ('business', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='accounts', to='accounts.business')),
            ],
            options={
                'db_table': 'accounts',
            },
        ),
        migrations.CreateModel(
            name='FixedAsset',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255)),
                ('acquisition_date', models.DateField()),
                ('particulars', models.TextField(blank=True, null=True)),
                ('asset_number', models.CharField(blank=True, max_length=255, null=True)),
                ('purchase_price', models.FloatField(default=0)),
                ('working_condition', models.CharField(default='Excellent', max_length=255)),
                ('date_added', models.DateTimeField(auto_now=True)),
                ('account', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='gl_acc', to='transactions.account')),
                ('added_by', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='accounts.staff')),
                ('branch', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='accounts.branch')),
            ],
        ),
        migrations.CreateModel(
            name='FixedAssetLocation',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(blank=True, max_length=255, null=True)),
                ('address', models.TextField(blank=True, null=True)),
                ('details', models.TextField(blank=True, null=True)),
                ('date_added', models.DateTimeField(auto_now=True)),
                ('added_by', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='accounts.staff')),
                ('branch', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='accounts.branch')),
            ],
        ),
        migrations.CreateModel(
            name='SharesTransactions',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('shares', models.FloatField(default=0)),
                ('date', models.DateField(blank=True, null=True)),
                ('narration', models.TextField(null=True)),
                ('synced', models.BooleanField(default=False, verbose_name='Synced to the portal')),
                ('branch', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='accounts.branch')),
                ('buyer', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='shares_buyer', to='sacco.member')),
                ('seller', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='shares_seller', to='sacco.member')),
            ],
            options={
                'verbose_name': 'Shares Transactions',
                'db_table': 'shares_transaction',
            },
        ),
        migrations.CreateModel(
            name='Transactions',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('txno', models.CharField(blank=True, max_length=225, null=True)),
                ('daily_no', models.IntegerField(blank=True, null=True)),
                ('receipt', models.CharField(blank=True, max_length=255, null=True)),
                ('transaction_type', models.CharField(max_length=255, null=True)),
                ('narration', models.TextField(null=True)),
                ('tx_date', models.DateField(blank=True, null=True)),
                ('reporting_amount', models.FloatField(blank=True, null=True)),
                ('reference', models.CharField(blank=True, max_length=255, null=True, verbose_name='Transaction Ref No.')),
                ('original_narration', models.TextField(blank=True, null=True)),
                ('original_date', models.DateTimeField(blank=True, null=True)),
                ('original_amount', models.FloatField(blank=True, null=True)),
                ('date_added', models.DateTimeField(auto_now=True)),
                ('paid_by', models.CharField(blank=True, max_length=250, null=True)),
                ('is_reversed', models.BooleanField(default=False)),
                ('account_cr', models.ForeignKey(null=True, on_delete=django.db.models.deletion.PROTECT, related_name='account_cr', to='transactions.account')),
                ('account_dr', models.ForeignKey(null=True, on_delete=django.db.models.deletion.PROTECT, related_name='account_dr', to='transactions.account')),
                ('added_by', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='txn_made_by', to='accounts.staff')),
                ('branch', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='transactions', to='accounts.branch')),
                ('financial_year', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, to='sacco.financialyear')),
                ('fixed_asset', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='transactions.fixedasset')),
                ('loan', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='loan_trans', to='loans.loans')),
                ('reconciled_by', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='reconciled_by', to='accounts.staff')),
                ('shares', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='transactions.sharestransactions')),
            ],
            options={
                'verbose_name': 'Transaction',
                'verbose_name_plural': 'Transactions',
                'db_table': 'transactions',
                'ordering': ['tx_date'],
            },
        ),
        migrations.CreateModel(
            name='FixedAssetMovement',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('date', models.DateField(blank=True, null=True)),
                ('is_purchase', models.BooleanField(default=False)),
                ('is_disposal', models.BooleanField(default=False)),
                ('is_transfer', models.BooleanField(default=False)),
                ('is_update', models.BooleanField(default=False)),
                ('is_depreciation', models.BooleanField(default=False)),
                ('sale_price', models.FloatField(default=0)),
                ('condition', models.CharField(blank=True, max_length=255, null=True)),
                ('description', models.TextField(blank=True, null=True)),
                ('date_added', models.DateTimeField(auto_now=True)),
                ('added_by', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='accounts.staff')),
                ('asset', models.ForeignKey(null=True, on_delete=django.db.models.deletion.PROTECT, to='transactions.fixedasset')),
                ('branch', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='accounts.branch')),
                ('buyer', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, to='transactions.account')),
                ('gl', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='transactions.transactions')),
                ('location_from', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='location_from', to='transactions.fixedassetlocation')),
                ('location_to', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='location_to', to='transactions.fixedassetlocation')),
            ],
        ),
        migrations.AddField(
            model_name='fixedasset',
            name='gl',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='transactions.transactions'),
        ),
        migrations.AddField(
            model_name='fixedasset',
            name='supplier',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='supplierx', to='transactions.account'),
        ),
        migrations.CreateModel(
            name='AuditTrail',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('date_added', models.DateTimeField(auto_now_add=True)),
                ('log_action', models.CharField(max_length=255)),
                ('description', models.TextField(blank=True, null=True)),
                ('link', models.TextField()),
                ('branch', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='accounts.branch')),
                ('staff', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='accounts.staff')),
            ],
            options={
                'verbose_name': 'Audit Trails',
                'db_table': 'audit_trails',
            },
        ),
        migrations.CreateModel(
            name='AccountLogs',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('timestamp', models.DateTimeField(auto_now_add=True)),
                ('narration', models.TextField()),
                ('account', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='logs', to='transactions.account')),
            ],
            options={
                'db_table': 'account_logs',
            },
        ),
        migrations.CreateModel(
            name='AccountCategory',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255)),
                ('dr_cr', models.CharField(blank=True, choices=[('dr', 'Debit'), ('cr', 'Credit')], max_length=20, null=True)),
                ('cat_class', models.CharField(blank=True, default='', max_length=255, null=True)),
                ('cat_type', models.CharField(blank=True, choices=[('liability', 'Liability'), ('assets', 'Assets'), ('expenses', 'Expenses'), ('income', 'Income'), ('equity', 'Equity')], max_length=20, null=True)),
                ('date_added', models.DateTimeField(auto_now=True)),
                ('added_by', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='accounts.staff')),
                ('business', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='accounts.business')),
            ],
            options={
                'verbose_name_plural': 'Account Categories',
                'db_table': 'account_category',
            },
        ),
        migrations.AddField(
            model_name='account',
            name='category',
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='transactions.accountcategory'),
        ),
        migrations.AddField(
            model_name='account',
            name='member',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='account', to='sacco.memberaccount'),
        ),
    ]
