import datetime
import json

from django.contrib import messages
from django.contrib.auth.decorators import login_required
from django.db.models import Q, Sum
from django.http import HttpResponse, HttpResponseRedirect
from django.shortcuts import render, get_object_or_404
from django.urls import reverse_lazy
from django.views import View
from django.views.decorators.csrf import csrf_exempt

from accounts.models import Business, User
from accounts.permission_mixin import BusinessUserMixin
from loans.models import Loans, LoanFines, LoanFinePayments
from loans.utils.loan_details import get_business_loans_context_data
from sacco.constants import DELETE, REVERSE
from sacco.models import ActivityLog, AccountBroker
from sacco.reports import ExpensesReport
from sacco.utils import branch_id, businessdata, userdata, branchdata
from transactions.models import Account, Transactions, AccountCategory
from transactions.reports import this_financial_year, this_branch, this_business


@login_required
def make_transactions(request):
    business_context = get_business_loans_context_data(request)
    if business_context['branch'] is None:
        messages.error(
            request, "error",
            extra_tags="Action not allowed in the central view. Please logout and login into the respective branch"
        )
        return HttpResponseRedirect(reverse_lazy('index'))

    if request.method == "POST":
        txn_date = request.POST["date"]
        action = request.POST["action"]
        if "refno" in request.POST:
            refno = request.POST["refno"]
        else:
            refno = None
        account_dr_id = request.POST["account_dr"]
        account_cr_id = request.POST["account_cr"]
        amount = request.POST["amount"].replace(",", "")
        if len(request.POST["narration"]) > 0:
            narration = request.POST["narration"]
        else:
            narration = None

        try:
            account_dr = Account.objects.get(id=account_dr_id)
        except:
            return HttpResponse("1")

        try:
            account_cr = Account.objects.get(id=account_cr_id)
        except:
            return HttpResponse("2")

        try:
            if narration is None:
                narration = "%s (dr: %s, cr: %s)" % (
                    action,
                    account_dr.name,
                    account_cr.name,
                )

            txn = Transactions.objects.create(
                transaction_type=action,
                receipt=refno,
                account_dr=account_dr,
                account_cr=account_cr,
                narration=narration,
                financial_year=this_financial_year(request),
                tx_date=txn_date,
                reporting_amount=amount,
                added_by=request.user.staff,
                branch=business_context['branch'],
            )
            return HttpResponse("/transactions/new/")
        except Exception as ex:
            return HttpResponse("3")

    else:
        return render(request, "transactions/make_transactions.html")
    

@login_required
def make_final_transactions(request):
    business_context = get_business_loans_context_data(request)

    if business_context['branch'] is None:
        messages.error(
            request, "error",
            extra_tags="Action not allowed in the central view. Please logout and login into the respective branch"
        )
        return HttpResponseRedirect(request.META.get("HTTP_REFERER"))
    
    txn_date = request.POST["date"]
    refno = None
    account_dr_id = request.POST["account_dr"]
    account_cr_id = request.POST["account_cr"]
    is_final_transaction = request.POST["is_final_transaction"]
    amount = request.POST["amount"].replace(",", "")
    if len(request.POST["narration"]) > 0:
        narration = request.POST["narration"]
    else:
        narration = None

    if is_final_transaction == 'yes':
        is_final_transaction = True
    else:
        is_final_transaction = False

    try:
        account_dr = Account.objects.get(id=account_dr_id)
    except Exception as e:
        # print('ERROR', e)
        messages.error(request, "Account issue", extra_tags=f"There is an issue with the selected account",)
        return HttpResponseRedirect(request.META.get("HTTP_REFERER"))
        

    try:
        account_cr = Account.objects.get(id=account_cr_id)
    except Exception as e:
        print('ERROR', e)
        messages.error(request, "Account issue", extra_tags=f"There is an issue with the selected account",)
        return HttpResponseRedirect(request.META.get("HTTP_REFERER"))
        
    try:
        if narration is None:
            narration = "%s (dr: %s, cr: %s)" % (
                'End of day transaction',
                account_dr.name,
                account_cr.name,
            )

        txn = Transactions.objects.create(
            transaction_type='End of day transaction',
            receipt=refno,
            account_dr=account_dr,
            account_cr=account_cr,
            narration=narration,
            financial_year=this_financial_year(request),
            tx_date=txn_date,
            reporting_amount=amount,
            added_by=request.user.staff,
            branch=business_context['branch'],
            is_final_transaction = is_final_transaction
        )
        messages.success(request, "Success", extra_tags=f"Transaction successfully added",)
        return HttpResponseRedirect(request.META.get("HTTP_REFERER"))
    except Exception as e:
        print('ERROR', e)
        messages.error(request, "Account issue", extra_tags=f"There is an issue with the selected account",)
        return HttpResponseRedirect(request.META.get("HTTP_REFERER"))


@login_required
def make_transactions_loans(request):
    business_context = get_business_loans_context_data(request)
    if business_context['branch'] is None:
        messages.error(
            request, "error",
            extra_tags="Action not allowed in the central view. Please logout and login into the respective branch"
        )
        return HttpResponseRedirect(request.META.get("HTTP_REFERER"))

    if request.method == "POST":
        loanid = request.POST["loanid"]
        loandetail = Loans.objects.filter(id=loanid)
        if not loandetail.exists():
            messages.error(
                request,
                "Invalid loan",
                extra_tags=f"Loan doesnot exist",
            )
            return HttpResponseRedirect(request.META.get("HTTP_REFERER"))
        loandetail = loandetail.first()
        amount = request.POST["amount"]
        narrative = request.POST["narration"]
        amount = float(amount.replace(",", ""))
        ddate = request.POST["d_date"]
        debited_account = request.POST["debited"]
        memberledger = Account.objects.filter(member_id=loandetail.account_id).first()

        if debited_account == "m":
            debited = memberledger.id
        else:
            debited = debited_account

        fineamount = request.POST["fineamount"]
        fineamount = float(fineamount.replace(",", ""))
        business = business_context['branch'].business
        user = User.objects.filter(staff_id=userdata(request)).first()
        applicant = AccountBroker.objects.filter(
            the_account=loandetail.account_id
        ).first()
        interestamount = request.POST["interestamount"]
        interestamount = float(interestamount.replace(",", ""))
        principalamount = amount - float(interestamount) - float(fineamount)
        principalbalance = float(request.POST["principalbalance"].replace(",", ""))
        credited = Account.objects.filter(
            name="Loan Receivables", business=business
        ).first()

        if principalamount > principalbalance:
            principaldifference = principalamount - principalbalance
            interestamount = interestamount + principaldifference
            principalamount = principalbalance

        if loandetail.repayment_method == 2 or debited_account == "m":
            try:
                # ================CHECK LOAN BALANCE=================================
                currentbalance = float(applicant.the_account.balance)

                newbalance = currentbalance - amount
                if currentbalance >= amount:
                    applicant.the_account.balance = newbalance
                    applicant.the_account.save()
                else:
                    messages.error(
                        request,
                        "Insufficient balance",
                        extra_tags=f"Member has insufficient funds to pay {amount} as loan repayment",
                    )
                    return HttpResponseRedirect(request.META.get("HTTP_REFERER"))

            except Exception as bal:
                messages.error(
                    request,
                    "Something went wrong",
                    extra_tags=f"The system could not process the loan repayment of {amount}",
                )
                return HttpResponseRedirect(request.META.get("HTTP_REFERER"))

        receipt = datetime.datetime.now().strftime("%y%m%d%H%M%S")

        # ==========================Save loan transaction=======================
        # Check if the ledgers exist=====================
        checkrecievables = Account.objects.filter(
            name="Loan Receivables", business=business
        ).exists()
        checkinterest = Account.objects.filter(
            name="Loan interests", business=business
        ).exists()
        checkfines = Account.objects.filter(
            name="Loan Fines", business=business
        ).exists()
        checkinterestrecievables = Account.objects.filter(
            name="Loan interest receivables", business=business
        ).exists()

        rcategeory = AccountCategory.objects.filter(
            name="Account Receivables", business=business
        ).first()

        if checkfines:
            finesaccount = Account.objects.filter(
                name="Loan Fines", business=business
            ).first()
        else:
            finescat = AccountCategory.objects.filter(
                name="Loan incomes", business=business
            ).first()
            finesaccount = Account.objects.create(
                name="Loan Fines",
                business=business,
                category_id=finescat.id,
                added_by_id=userdata(request),
            )

        if float(fineamount) > 0:
            # if the custom fine is greater than 0 then pay that
            this_loan_fines = LoanFines.objects.filter(loan_id=loanid)
            query_fines = this_loan_fines.aggregate(Sum("amount"))
            total_fines = query_fines["amount__sum"] or 0
            # print('total_fines', total_fines)
            query_fines_paid = LoanFinePayments.objects.filter(
                loan_id=loanid
            ).aggregate(Sum("amount"))
            total_fine_paid = query_fines_paid["amount__sum"] or 0
            # print('total_fine_paid', total_fine_paid)
            unpaid_fines = total_fines - total_fine_paid

            if unpaid_fines > 0:
                LoanFinePayments.objects.create(
                    loan_id=loanid,
                    amount=float(fineamount),
                    added_by_id=userdata(request),
                )
                fines_transaction = Transactions.objects.create(
                    reporting_amount=fineamount,
                    narration=f"payment of {fineamount} as Loan Fines",
                    account_dr_id=debited,
                    account_cr_id=finesaccount.id,
                    loan_id=loanid,
                    tx_date=ddate,
                    receipt=receipt,
                    transaction_type="Loan Fines",
                    added_by_id=userdata(request),
                    branch=business_context['branch'],
                )
            # else just create a the fines transaction
            else:
                fines_transaction = Transactions.objects.create(
                    reporting_amount=fineamount,
                    narration=f"payment of {fineamount} as Loan Fines",
                    account_dr_id=debited,
                    account_cr_id=finesaccount.id,
                    loan_id=loanid,
                    tx_date=ddate,
                    receipt=receipt,
                    transaction_type="Loan Fines",
                    added_by_id=userdata(request),
                    branch=business_context['branch'],
                )

        if checkinterest:
            pass
        else:
            rcategeory2 = AccountCategory.objects.filter(
                name="Loan incomes", business=business
            ).first()
            createleger2 = Account.objects.create(
                name="Loan interests",
                business=business,
                category_id=rcategeory2.id,
                added_by_id=userdata(request),
            )

        if checkrecievables:
            pass
        else:
            Account.objects.create(
                name="Loan Receivables",
                business=business,
                category_id=rcategeory.id,
                added_by_id=userdata(request),
            )

        if checkinterestrecievables:
            pass
        else:
            createintrestaccount = Account.objects.create(
                name="Loan interest receivables",
                business=business_context['branch'].business,
                category_id=rcategeory.id,
                added_by_id=userdata(request),
            )

        intrestaccount = Account.objects.filter(
            name="Loan interest receivables", business=business
        ).first()

        repayment_trans = Transactions.objects.create(
            reporting_amount=principalamount,
            narration=f"Loan payment of {principalamount} as principal"
            if not narrative
            else narrative,
            account_dr_id=debited,
            account_cr_id=credited.id,
            loan_id=loanid,
            tx_date=ddate,
            receipt=receipt,
            transaction_type="Loan repayment",
            added_by_id=userdata(request),
            branch=business_context['branch'],
        )

        # ============ RECORD INTEREST =================
        if float(interestamount) > 0:
            interest_trans = Transactions.objects.create(
                reporting_amount=interestamount,
                narration=f"payment of {interestamount} as Loan interest",
                account_dr_id=debited,
                account_cr_id=intrestaccount.id,
                loan_id=loanid,
                tx_date=ddate,
                receipt=receipt,
                transaction_type="Loan interest",
                added_by_id=userdata(request),
                branch=business_context['branch'],
            )

            business_data = business_context['branch'].business.id
            ln_interest_rec_acc = Account.objects.filter(
                name="loan interest receivables", business=business_data
            )
            if ln_interest_rec_acc:
                ln_interest_rec_acc = ln_interest_rec_acc.first()
            else:
                # print("Loan interest acc")
                ln_interest_rec_acc = Account.objects.create(
                    name="loan interest receivables",
                    business=business_data,
                    display_name="loan interest receivables",
                    category=AccountCategory.objects.get(
                        name="Account Receivables", business=business_data
                    ),
                )

            ln_interest_revenue_acc = Account.objects.filter(
                name="Loan Interest", business=business_context['branch'].business
            ).first()

            Exp_interest = Transactions.objects.create(
                reporting_amount=interestamount,
                narration=f"Expected interest of {interestamount}",
                account_dr=ln_interest_rec_acc,
                account_cr=ln_interest_revenue_acc,
                loan_id=loanid,
                tx_date=ddate,
                transaction_type="Expected interest",
                added_by_id=userdata(request),
                branch=business_context['branch'],
            )
            # print('Exp_interest', Exp_interest)

        # ========= UPDATE LOAN BALANCE ================================
        oldbalance = loandetail.balance
        newbalance_afterpayment = oldbalance - amount

        if newbalance_afterpayment < 0:
            newbalance_afterpayment = 0

        loandetail.balance = newbalance_afterpayment
        loandetail.save()

        messages.success(
            request,
            "success",
            extra_tags=f"Loan payment recorded successfully. Principal of {principalamount}, Interest of {interestamount} and Fines of {fineamount}",
        )

        return HttpResponseRedirect(request.META.get("HTTP_REFERER"))

    else:
        #all runnning loans
        all_loans = Loans.objects.filter(
            branch=business_context['branch'],
            loan_status=3
        )
        bankaccounts = Account.objects.filter(
            Q(business=business_context['branch'].business),
            Q(category__name="Bank")
            | Q(category__name="Mobile Money")
            | Q(category__name="Cash"),
        )

        return render(request, "transactions/loans_make_transaction.html",
                      context={
                          'all_loans':all_loans,
                          'bankaccounts':bankaccounts
                      })


@csrf_exempt
def get_acc(request):
    # global accounts
    business_context = get_business_loans_context_data(request)

    accounts = Account.objects.filter(business=business_context['branch'].business)
    if request.user.is_authenticated:
        if request.method == "POST":
            # business_context = get_business_loans_context_data(request)
            # print('WE ARE HERE')
            acc = request.POST["acctype"].split("|")
            resp = "<option value='' disabled selected>Select Account</option>"
            for i in acc:
                if i != "All":
                    accounts = Account.objects.filter(
                        Q(
                            category=AccountCategory.objects.filter(
                                Q(name=i), Q(business=business_context['branch'].business)
                            ).first()
                        ),
                        ~Q(category__name="Members"),
                    )

                # print(accounts)

                for ac in accounts:
                    display_name = ''
                    try:
                        if ac.display_name.strip() != '':
                            display_name = ac.display_name
                        elif ac.name.strip() != '':
                            display_name = ac.name
                        elif ac.member_name is not None :
                            # print('We did it from hear')
                            display_name = ac.member_name.member_names
                    except:
                        pass
                    # print(display_name)

                    try:
                        resp += "<option value='%s'>%s</option>" % (
                        ac.id, display_name or 'no account')
                        # print('RESP',resp)
                    except Exception as e:
                        print('erorr', e)
                        print(ac.id)
                        pass
            return HttpResponse(resp)
        else:
            return HttpResponse(1)
    else:
        return HttpResponse(0)


def make_expense_list(request):
    if request.method == "POST":
        pk = request.POST["id"]
        name = request.POST["name"]
        amount = request.POST["amount"].replace(",", "")

        rendered = render(
            request,
            "transactions/expense_list.html",
            {"id": pk, "name": name, "amount": amount},
        )

        return HttpResponse(rendered)


@login_required
def make_expenses(request):
    business_context = get_business_loans_context_data(request)
    if business_context['branch'] is None:
        messages.error(
            request, "error",
            extra_tags="Action not allowed in the central view. Please logout and login into the respective branch"
        )
        return HttpResponseRedirect(reverse_lazy('index'))

    if request.method == "POST":
        receipt = request.POST["receipt"]
        supplier_id = request.POST["supplier"]
        particulars = request.POST["particulars"]
        date = request.POST["date"]
        pay_status = request.POST["pay_status"]

        if len(receipt) < 1 or receipt is None:
            receipt = "001"

        try:
            supplier = Account.objects.get(
                Q(id=supplier_id), Q(business=business_context['branch'].business)
            )
        except:
            return HttpResponse("1")

        expense_items = json.loads(particulars)
        total_amount = 0
        for e in expense_items:
            # record a transaction
            total_amount += float(e["amount"])
            # first get account
            exlepse_account = Account.objects.get(
                Q(id=e["id"]), Q(business=business_context['branch'].business)
            )
            transaction = Transactions.objects.create(
                financial_year=this_financial_year(request),
                receipt=receipt,
                transaction_type="Expense Invoice",
                account_dr=exlepse_account,
                account_cr=supplier,
                narration="Expense Invoice from %s" % supplier.name,
                reporting_amount=e["amount"],
                tx_date=date,
                added_by=request.user.staff,
                branch=business_context['branch'],
            )

        # if there was a payment, record the payment
        if pay_status == "1":
            payment_mode = request.POST["payment_mode"]
            payment_account = request.POST["payment_account"]

            tx_type = "Supplier Payment"

            supp = Account.objects.get(id=supplier.id)
            src_account = Account.objects.get(id=payment_account)
            newtx = Transactions.objects.create(
                branch=business_context['branch'],
                transaction_type=tx_type,
                account_dr=supp,
                account_cr=src_account,
                financial_year=this_financial_year(request),
                reporting_amount=total_amount,
                narration="Paid %s to supplier %s" % (total_amount, supp.name),
                tx_date=date,
                added_by=request.user.staff,
            )

        return HttpResponse("/transactions/expenses/new/")

    else:
        expensegl = Account.objects.filter(
            business=business_context['branch'].business, category__name="Expense Accounts"
        )
        suppliers = Account.objects.filter(
            business=business_context['branch'].business, category__name="Suppliers"
        )
        return render(
            request,
            "transactions/make_expense.html",
            {"accounts": expensegl, "suppliers": suppliers},
        )


@login_required
def update_expense(request, id):
    if request.method == "POST":
        receipt = request.POST["exp_ref"]
        amount = request.POST["exp_amount"].replace(",", "")
        narration = request.POST["narration"]
        date = request.POST["exp_date"]

        expense = get_object_or_404(Transactions, id=id)
        expense.receipt = receipt
        expense.reporting_amount = amount
        expense.narration = narration
        expense.tx_date = date
        expense.save()
        messages.success(
            request,
            "success",
            f"Expense for {expense.account_dr.name} updated successfully".capitalize(),
        )
    return HttpResponseRedirect(reverse_lazy("expenses_report"))


@login_required
def delete_expense(request, pk):
    expense = get_object_or_404(Transactions, id=pk)
    msg = f"Expense for {expense.account_dr.name} removed successfully".capitalize()
    expense.delete()
    messages.success(request, "success", msg)
    return HttpResponseRedirect(reverse_lazy("expenses_report"))


@login_required
def delete_transaction(request, pk):
    trans = get_object_or_404(Transactions, id=pk)
    msg = f"Transaction removed successfully".capitalize()
    trans.delete()
    message = f"Removed Transaction with details => Amount: <b><em>{trans.reporting_amount}</em></b>, Narration: <b><em>{trans.narration}</em></b>, Type: <b><em>{trans.transaction_type}</em></b>, Date: <b><em>{trans.tx_date}</em></b>, Account DR: <b><em>{trans.account_dr.name}</em></b> and Account CR: <b><em>{trans.account_cr.name}</em></b>"
    ActivityLog.objects.create(
        actor=request.user,
        title="Transaction deletion",
        action_type=DELETE,
        remarks=message,
        branch=branch_id(request.user),
    )
    messages.success(request, "success", msg)
    # return HttpResponseRedirect(reverse_lazy('igl'))
    return HttpResponseRedirect(request.META.get("HTTP_REFERER", reverse_lazy("gl")))


@login_required
def delete_transaction_daily_report(request, pk):
    trans = get_object_or_404(Transactions, id=pk)
    msg = f"Transaction removed successfully".capitalize()
    trans.delete()
    message = f"Removed Transaction with details => Amount: <b><em>{trans.reporting_amount}</em></b>, Narration: <b><em>{trans.narration}</em></b>, Type: <b><em>{trans.transaction_type}</em></b>, Date: <b><em>{trans.tx_date}</em></b>, Account DR: <b><em>{trans.account_dr.name}</em></b> and Account CR: <b><em>{trans.account_cr.name}</em></b>"
    ActivityLog.objects.create(
        actor=request.user,
        title="Transaction deletion",
        action_type=DELETE,
        remarks=message,
        branch=branch_id(request.user),
    )
    messages.success(request, "success", msg)
    return HttpResponseRedirect(reverse_lazy('daily_ledger_summary'))
    # return HttpResponseRedirect(request.META.get("HTTP_REFERER", reverse_lazy("gl")))


@login_required
def reverse_transaction(request, pk):
    trans = get_object_or_404(Transactions, id=pk)

    if trans.is_reversed:
        messages.error(request, "This Transaction is already reversed")
        return HttpResponseRedirect(reverse_lazy("igl"))

    msg = f"Transaction reversed successfully".capitalize()
    Transactions.objects.create(
        branch_id=branch_id(request.user),
        transaction_type="Transaction reversal",
        account_dr=trans.account_cr,
        account_cr=trans.account_dr,
        narration=f"Transaction reverse",
        reporting_amount=trans.reporting_amount,
        added_by=request.user.staff,
        financial_year=this_financial_year(request),
    )
    message = f"Reversed Transaction with details => Amount: <b><em>{trans.reporting_amount}</em></b>, Narration: <b><em>{trans.narration}</em></b>, Type: <b><em>{trans.transaction_type}</em></b>, Date: <b><em>{trans.tx_date}</em></b>, Account DR: <b><em>{trans.account_dr.name}</em></b> and Account CR: <b><em>{trans.account_cr.name}</em></b>"
    ActivityLog.objects.create(
        actor=request.user,
        title="Transaction reversal",
        action_type=REVERSE,
        remarks=message,
        branch=branch_id(request.user),
    )
    messages.success(request, "success", msg)

    trans.is_reversed = True
    trans.save()

    return HttpResponseRedirect(reverse_lazy("igl"))
