import random
import traceback
from datetime import datetime

from django.contrib import messages
from django.contrib.auth.decorators import login_required, user_passes_test
from django.db.models import Q, Sum
from django.http import HttpResponseRedirect, HttpResponse
from django.shortcuts import render

from accounts.models import Permissions
from accounts.perm_deco import user_in_business
from transactions.models import FixedAsset, Account, Transactions, FixedAssetMovement, FixedAssetLocation, \
    AccountCategory
from transactions.reports import this_financial_year, this_branch, this_business


@login_required
@user_in_business
def fixed_assets_register(request):
    fixed_assets = FixedAsset.objects.filter(branch=this_branch(request.user))
    return render(request, "transactions/fixed_assets.html", {'fixed_assets': fixed_assets})


@login_required
@user_in_business
@user_passes_test(lambda u: Permissions.objects.filter(item_name='can_add_fixed_assets').first() in u.staff.position.permissions.all())
def add_fixed_assets(request):
    global payment_account, payment_mode, fa
    if request.method == "POST":
        # categoryy = request.POST['category']
        name = request.POST['name']
        assetgl = request.POST['assetgl']
        supplier = request.POST['supplier']
        location = request.POST['location']

        if 'assetnum' in request.POST:
            assetnum = request.POST['assetnum']
        else:
            assetnum = None

        qty = request.POST['qty']
        amount = request.POST['amount'].replace(',', '')
        condition = request.POST['condition']
        particulars = request.POST['particulars']
        date = request.POST['date']
        pay_status = request.POST['pay_status']
        if pay_status == "1":
            payment_mode = request.POST['payment_mode']
            payment_account = request.POST['payment_account']
        total_amount = float(amount) * float(qty)

        datee = datetime.strptime(date, '%Y-%m-%d')

        # record GL
        try:
            supp = Account.objects.get(id=supplier)
            newtx = Transactions.objects.create(
                branch=request.user.staff.branch,
                transaction_type="Supplier Invoice - NC Asset",
                account_dr=Account.objects.get(id=assetgl),
                account_cr=Account.objects.get(id=supplier),
                reporting_amount=total_amount,
                financial_year=this_financial_year(request),
                narration="Purchased %s %s from %s" % (qty, name, supp.name),
                tx_date=date,
                added_by=request.user.staff
            )
        except Exception as ex:
            print(str(ex))
            messages.error(request, "Error Happened %s" % str(ex))
            return HttpResponseRedirect(request.META.get("HTTP_REFERER"))

        # Record the Fixed assets. loop through the quantity and assign asset Number
        for x in range(0, int(qty)):
            datex = now = datee.strftime("%m%y")
            randnum = random.randrange(1000, 9999)
            asset_no = "%s%s" % (datex, randnum)

            fa = FixedAsset.objects.create(
                name=name,
                branch=this_branch(request.user),
                account=Account.objects.get(id=assetgl),
                gl=newtx,
                acquisition_date=date,
                particulars=particulars,
                supplier=newtx.account_cr,
                asset_number=asset_no,
                purchase_price=int(float(str(request.POST['amount']).replace(',', ''))),
                working_condition=condition
            )
            newtx.fixed_asset = fa
            newtx.save()
            # add into movement table
            fam = FixedAssetMovement.objects.create(
                branch=this_branch(request.user),
                asset=fa,
                date=date,
                is_purchase=True,
                location_to=FixedAssetLocation.objects.get(id=location),
                condition=condition,
                description="Purchased Asset with particulars: %s" % particulars,
                added_by=request.user.staff
            )
        if pay_status == "1":
            tx_type = "Supplier Payment"

            supp = Account.objects.get(id=supplier)
            src_account = Account.objects.get(id=payment_account)
            newtx = Transactions.objects.create(
                branch=this_branch(request.user),
                transaction_type=tx_type,
                account_dr=supp,
                account_cr=src_account,
                financial_year=this_financial_year(request),
                reporting_amount=total_amount,
                narration="Paid %s to supplier %s" % (total_amount, supp.name),
                tx_date=date,
                added_by=request.user.staff
            )

            # first get the current set currency

        return HttpResponseRedirect(request.META.get("HTTP_REFERER"))

    else:
        locations = FixedAssetLocation.objects.filter(branch=this_branch(request.user))
        assetgl = Account.objects.filter(business=this_business(request.user), category__name="Fixed Assets")
        suppliers = Account.objects.filter(business=this_business(request.user), category__name="Suppliers")

        return render(request, "transactions/new_fixed_asset.html",
                      {"assetgls": assetgl, "suppliers": suppliers, "locations": locations})


@login_required
@user_in_business
@user_passes_test(lambda u: Permissions.objects.filter(item_name='can_add_fixed_assets').first() in u.staff.position.permissions.all())
def add_existing_fixed_assets(request):
    global payment_account, payment_mode, fa
    if request.method == "POST":
        # categoryy = request.POST['category']
        name = request.POST['name']
        assetgl = request.POST['assetgl']
        location = request.POST['location']

        # if 'assetnum' in request.POST:
        #     assetnum = request.POST['assetnum']
        # else:
        #     assetnum = None
        #
        # qty = request.POST['qty']
        acc_depreciation = request.POST['acc_depreciation'].replace(',', '')
        openning_bal = request.POST['openning_bal'].replace(',', '') #original price/purchase price
        print('openning balance', openning_bal)
        condition = request.POST['condition']
        particulars = request.POST['particulars']
        date = request.POST['date']
        datee = datetime.strptime(date, '%Y-%m-%d')

        # record GL
        try:
            opening_reserves = Account.objects.filter(name="Opening Reserves", business=request.user.staff.branch.business).first()

            # if opening_reserves.count()>0:
            #     opening_reserve = opening_reserves.first()
            # else:
            #     opening_reserve = Account

            newtx = Transactions.objects.create(
                branch=request.user.staff.branch,
                transaction_type="Opening balance - NC Asset",
                account_dr=Account.objects.get(id=assetgl),
                account_cr=opening_reserves,
                reporting_amount=float(openning_bal),
                financial_year=this_financial_year(request),
                narration="%s Opening balance" % (name),
                tx_date=date,
                added_by=request.user.staff
            )
            acculation_account = Account.objects.filter(related_to=assetgl, category__name="Accumulating Depreciation "
                                                                                           "Account",
                                                        business=request.user.staff.branch.business).first()

            depreciation_account = Account.objects.filter(related_to=assetgl, category__name="Depreciation Account",
                                                        business=request.user.staff.branch.business).first()

            acc_depreciation_transaction = Transactions.objects.create(
                branch=request.user.staff.branch,
                transaction_type="Asset depreciation",
                account_dr=depreciation_account,
                account_cr=Account.objects.get(id=assetgl),
                reporting_amount=float(acc_depreciation),
                financial_year=this_financial_year(request),
                narration=f"{name} depreciation",
                tx_date=date,
                added_by=request.user.staff
            )

            # acc_depreciation_transaction = Transactions.objects.create(
            #     branch=request.user.staff.branch,
            #     transaction_type="Asset Accumulated depreciation",
            #     account_dr=acculation_account,
            #     account_cr=depreciation_account,
            #     reporting_amount=float(acc_depreciation),
            #     financial_year=this_financial_year(request),
            #     narration=f"{name} accumulated depreciation",
            #     tx_date=date,
            #     added_by=request.user.staff
            # )
        except Exception as ex:
            print(str(ex))
            messages.error(request, "Error Happened %s" % str(ex))
            return HttpResponseRedirect(request.META.get("HTTP_REFERER"))

        # Record the Fixed assets. loop through the quantity and assign asset Number
        datex = now = datee.strftime("%m%y")
        randnum = random.randrange(1000, 9999)
        asset_no = "%s%s" % (datex, randnum)

        fa = FixedAsset.objects.create(
            name=name,
            branch=this_branch(request.user),
            account=Account.objects.get(id=assetgl),
            gl=newtx,
            acquisition_date=date,
            particulars=particulars,
            supplier=newtx.account_cr,
            asset_number=asset_no,
            purchase_price=float(openning_bal),
            working_condition=condition
        )
        newtx.fixed_asset = fa
        newtx.save()
        # add into movement table
        fam = FixedAssetMovement.objects.create(
            branch=this_branch(request.user),
            asset=fa,
            date=date,
            is_purchase=True,
            location_to=FixedAssetLocation.objects.get(id=location),
            condition=condition,
            description="Asset with particulars: %s" % particulars,
            added_by=request.user.staff
        )

        return HttpResponseRedirect(request.META.get("HTTP_REFERER"))

    else:
        locations = FixedAssetLocation.objects.filter(branch=this_branch(request.user))
        assetgl = Account.objects.filter(business=this_business(request.user), category__name="Fixed Assets")
        suppliers = Account.objects.filter(business=this_business(request.user), category__name="Suppliers")

        return render(request, "transactions/add_existing_asset.html",
                      {"assetgls": assetgl, "suppliers": suppliers, "locations": locations})



@login_required
@user_in_business
def asset_location(request):
    locations = FixedAssetLocation.objects.filter(branch=this_branch(request.user))
    return render(request, "transactions/fixed_asset_locations.html", {"locations": locations})


@login_required
@user_in_business
@user_passes_test(lambda u: Permissions.objects.filter(item_name='can_add_fixed_asset_location').first() in u.staff.position.permissions.all())
def add_asset_location(request):
    if request.method == "POST":
        name = request.POST['name']
        if 'address' in request.POST:
            address = request.POST['address']
        else:
            address = None

        if 'details' in request.POST:
            details = request.POST['details']
        else:
            details = None

        # check if name exists
        try:
            chk = FixedAssetLocation.objects.get(Q(branch=this_branch(request.user)), Q(name=name))
            return HttpResponse("0")
        except:
            pass

        # try your record
        try:
            rec = FixedAssetLocation.objects.create(
                branch=this_branch(request.user),
                name=name,
                address=address,
                details=details,
                added_by=request.user.staff
            )
            return HttpResponse("/transactions/fixed-assets/location/")
        except Exception as ex:
            print(str(ex))
            return HttpResponse("1")

    else:
        return HttpResponse("1")


@login_required
@user_in_business
@user_passes_test(lambda u: Permissions.objects.filter(item_name='can_add_fixed_asset_location').first() in u.staff.position.permissions.all())
def edit_asset_location(request):
    if request.method == "POST":
        id = request.POST['id']
        location = FixedAssetLocation.objects.get(id=id)

        name = request.POST['name']
        if 'address' in request.POST:
            address = request.POST['address']
        else:
            address = None

        if 'details' in request.POST:
            details = request.POST['details']
        else:
            details = None

        # check if name exists else where
        try:
            chk = FixedAssetLocation.objects.get(Q(branch=this_branch(request.user)), Q(name=name), ~Q(id=location.id))
            return HttpResponse("0")
        except:
            pass
        # try to update
        try:
            location.name = name
            location.address = address
            location.details = details
            location.save()
            return HttpResponse("/transactions/fixed-assets/location/")
        except Exception as ex:
            print(str(ex))
            return HttpResponse("1")

    else:
        return HttpResponse("1")


@login_required
@user_in_business
def fixed_assets_details(request, id):
    try:
        asset = FixedAsset.objects.get(Q(branch=this_branch(request.user)), Q(id=id))
        fa_details = FixedAssetMovement.objects.filter(asset=asset)
        fa_detail_last = FixedAssetMovement.objects.filter(asset=asset).last()
        if fa_detail_last.is_disposal:
            destinations = None
        else:
            destinations = FixedAssetLocation.objects.filter(Q(branch=this_branch(request.user)),
                                                             ~Q(id=fa_detail_last.location_to.id))
        customers = Account.objects.filter(
            business=this_business(request.user),
            category=AccountCategory.objects.filter(
                business=this_business(request.user),
                name="Customers"
            ).first()
        )
        return render(request, "transactions/fixed_asset_details.html",
                      {"details": fa_details, "asset": asset, "last": fa_detail_last, "destinations": destinations,
                       "customers": customers})
    except Exception as ex:
        print(str(ex))
        messages.error(request, "Invalid Request. Please try again")
        return HttpResponseRedirect(request.META.get("HTTP_REFERER"))


@login_required
@user_in_business
def fixed_asset_transfer(request, id):
    try:
        asset = FixedAsset.objects.get(Q(branch=this_branch(request.user)), Q(id=id))
    except Exception as ex:
        print(str(ex))
        return HttpResponse("4")
    if request.method == "POST":
        # check for missing fields
        try:
            date = request.POST['date']
            to = request.POST['to']
            fromm = request.POST['from']
            condition = request.POST['condition']
            description = request.POST['description']
        except Exception as ex:
            print(str(ex))
            return HttpResponse("1")
        # check for valid destinations
        try:
            source = FixedAssetLocation.objects.get(Q(id=fromm), Q(branch=this_branch(request.user)))
            destination = FixedAssetLocation.objects.get(Q(id=to), Q(branch=this_branch(request.user)))
        except Exception as ex:
            print(str(ex))
            return HttpResponse("2")

        # try to insert record
        try:
            FixedAssetMovement.objects.create(
                branch=this_branch(request.user),
                asset=asset,
                date=date,
                is_transfer=True,
                location_from=source,
                location_to=destination,
                condition=condition,
                description=description,
                added_by=request.user.staff
            )
            return HttpResponse(request.META.get("HTTP_REFERER"))
        except Exception as ex:
            print(str(ex))
            return HttpResponse("3")

    else:
        return HttpResponse("0")


@login_required
def fixed_asset_update(request, id):
    try:
        asset = FixedAsset.objects.get(Q(branch=this_branch(request.user)), Q(id=id))
        fa_detail_last = FixedAssetMovement.objects.filter(asset=asset).last()
    except Exception as ex:
        print(str(ex))
        return HttpResponse("0")

    if request.method == "POST":
        # check for missing fields
        try:
            date = request.POST['date']
            condition = request.POST['condition']
            description = request.POST['description']
        except Exception as ex:
            print(str(ex))
            return HttpResponse("2")

        # try to insert record
        try:
            FixedAssetMovement.objects.create(
                branch=this_branch(request.user),
                asset=asset,
                date=date,
                is_update=True,
                location_from=fa_detail_last.location_to,
                location_to=fa_detail_last.location_to,
                condition=condition,
                description=description,
                added_by=request.user.staff
            )
            return HttpResponse(request.META.get("HTTP_REFERER"))
        except Exception as ex:
            print(str(ex))
            return HttpResponse("3")

    else:
        return HttpResponse("1")


@login_required
def fixed_asset_depreciate(request, id):
    try:
        acc_depreciation = float(request.POST['acc_depreciation'].replace(',', ''))
        narration = request.POST['narration']
        asset = FixedAsset.objects.get(Q(branch=this_branch(request.user)), Q(id=id))
        print('asset gl', asset.account)
        fa_detail_last = FixedAssetMovement.objects.filter(asset=asset).last()
        date = request.POST['date']
        date = datetime.strptime(date, '%Y-%m-%d').date()
        # print(date)

        # get the purchase value
        purchase_price = asset.purchase_price

        # get rate
        rate = asset.account.eul

        # calculate depreciation
        # print('PURCHASE PRICE', purchase_price, rate)



        # get depreciation account
        depreciation_account = Account.objects.filter(
            business=this_business(request.user),
            related_to=asset.account.id,
            category=AccountCategory.objects.get(Q(business=this_business(request.user)),
                                                 Q(name="Depreciation Account"))
        ).first()

        # get accumulating depreciation account
        accum_depreciation_account = Account.objects.filter(
            business=this_business(request.user),
            related_to=asset.account.id,
            category=AccountCategory.objects.get(Q(business=this_business(request.user)),
                                                 Q(name="Accumulating Depreciation Account"))
        ).first()

        print('accum_depreciation_account', accum_depreciation_account.category.cat_type)

        # original
        # depreciation_amount = purchase_price / (rate * 12)

        # new
        depreciation_amount = acc_depreciation

        all_depreciations = Transactions.objects.filter(
            branch=this_branch(request.user),
            transaction_type="Asset Depreciation",
            fixed_asset=asset,
            account_dr=depreciation_account,
            account_cr=accum_depreciation_account,
        )
        # print(all_depreciations)

        all_depreciations=all_depreciations.aggregate(total=Sum('reporting_amount'))['total']
        if all_depreciations is None:
            all_depreciations = 0
        # print('all_depreciations', all_depreciations)
        # print('all_depreciations balance', purchase_price-all_depreciations)

        if depreciation_amount > (purchase_price-all_depreciations):
            # messages.error('Check depreciation amount',"Depreciation cant be more than the remaining asset valuation")
            messages.error(request, 'Check depreciation amount', extra_tags='Depreciation cant be more than the remaining asset valuation')
            return HttpResponse(request.META.get("HTTP_REFERER"))

        # print('DEPRECIATION PRICE', depreciation_amount)

        # record gl
        newtx = Transactions.objects.create(
            branch=this_branch(request.user),
            transaction_type="Asset Depreciation",
            account_dr=depreciation_account,
            account_cr=asset.account,
            # account_cr=accum_depreciation_account,
            reporting_amount=depreciation_amount,
            fixed_asset=asset,
            financial_year=this_financial_year(request),
            narration="%s depreciation" % asset.name,
            added_by=request.user.staff,
            tx_date=date
        )

        # record in asset movement table
        # try to insert record
        try:
            if narration.strip() != '':
                the_narration = f'{narration} ({asset.name} depreciation)'
            else:
                the_narration = f'{asset.name} depreciation'

            FixedAssetMovement.objects.create(
                branch=this_branch(request.user),
                asset=asset,
                date=date,
                is_depreciation=True,
                gl=newtx,
                location_from=fa_detail_last.location_to,
                location_to=fa_detail_last.location_to,
                condition=fa_detail_last.condition,
                description=the_narration,
                # description="%s monthly depreciation" % asset.name, 
                added_by=request.user.staff
            )
            # messages.success("Depreciation recorded successfully")
            return HttpResponse(request.META.get("HTTP_REFERER"))
        except Exception as ex:
            print(str(ex))
            # traceback.print_exc()
            return HttpResponse("2")

    except Exception as ex:
        print(str(ex))
        # traceback.print_exc()
        return HttpResponse("0")


@login_required
def fixed_asset_disposal(request, id):
    global tx_type, payment_mode, payment_account
    if request.method == "POST":
        try:
            asset = FixedAsset.objects.get(Q(branch=this_branch(request.user)), Q(id=id))
            fa_detail_last = FixedAssetMovement.objects.filter(asset=asset).last()

            date = request.POST['date']
            condition = request.POST['condition']
            customer = request.POST['customer']
            amount = request.POST['amount'].replace(',', '')
            pay_status = request.POST['pay_status']
            description = request.POST['description']

            if pay_status == "1":
                payment_mode = request.POST['payment_mode']
                payment_account = request.POST['payment_account']
            datee = datetime.strptime(date, '%Y-%m-%d')
            # let's start by getting these accounts
            asset_gl = asset.account
            asset_disposal_gl = Account.objects.filter(
                business=this_business(request.user),
                related_to=asset_gl.id,
                category=AccountCategory.objects.get(Q(business=this_business(request.user)),
                                                     Q(name="Asset Disposal Account"))
            ).first()

            try:
                # a) Write off the computer value/purchase price from the FAR
                # Dr.Asset Disposal GL Account:
                # Cr.Asset GLAccount:
                newtx = Transactions.objects.create(
                    branch=this_branch(request.user),
                    transaction_type="Write Off Asset",
                    account_dr=asset_disposal_gl,
                    account_cr=asset_gl,
                    financial_year=this_financial_year(request),
                    fixed_asset=asset,
                    reporting_amount=asset.purchase_price,
                    narration="Write off %s" % asset.name,
                    tx_date=date,
                    added_by=request.user.staff
                )

                # record asset movement
                try:
                    cust_acc = Account.objects.get(id=customer)
                    FixedAssetMovement.objects.create(
                        branch=this_branch(request.user),
                        asset=asset,
                        date=datetime.now().strftime("%Y-%m-%d"),
                        is_disposal=True,
                        gl=newtx,
                        location_from=fa_detail_last.location_to,
                        # location_to=fa_detail_last.location_to,
                        buyer=cust_acc,
                        sale_price=amount,
                        condition=condition,
                        description=description,
                        added_by=request.user.staff
                    )
                    # messages.success("Depreciation recorded successfully")

                except Exception as ex:
                    print(str(ex))
                    traceback.print_exc()
                    return HttpResponse("7")

                # b) Recogniseprofit/(loss)on disposal
                # Dr. Loss on Disposal: 2,237,500 (i.e. 3,800,000 – 1,562,500)
                # Dr. Accumulated Depreciation Account: UGX 1,562,500 (i.e. Sum of monthly “depreciations”)
                # Cr. Disposal GL Account: UGX 3,800,000 (i.e. 5,000,000 – 1,200,000)

                # get asset income account
                income_account = Account.objects.filter(
                    business=this_business(request.user),
                    related_to=asset_gl.id,
                    category=AccountCategory.objects.get(Q(business=this_business(request.user)),
                                                         Q(name="Asset Disposal Income"))
                ).first()

                # accumulating depreciation account
                accumulating_depreciation = Account.objects.filter(
                    business=this_business(request.user),
                    related_to=asset_gl.id,
                    category=AccountCategory.objects.get(Q(business=this_business(request.user)),
                                                         Q(name="Accumulating Depreciation Account"))
                ).first()

                # calculate loss/profit
                accum_amount = 0
                acum_gl = Transactions.objects.filter(branch=this_branch(request.user),
                                                      account_cr=accumulating_depreciation, fixed_asset=asset)
                for a in acum_gl:
                    accum_amount += a.reporting_amount

                cost = asset.purchase_price
                net_value_at_disposal = cost - accum_amount

                loss_profit = float(amount) - net_value_at_disposal

                # recognise loss or profit
                if loss_profit <= 0:
                    lp = -1 * loss_profit

                    newtx = Transactions.objects.create(
                        branch=this_branch(request.user),
                        transaction_type="Recognise loss on asset Disposal",
                        account_dr=income_account,
                        account_cr=asset_disposal_gl,
                        reporting_amount=lp,
                        financial_year=this_financial_year(request),
                        narration="Recognise loss on %s Disposal" % asset.name,
                        tx_date=date,
                        added_by=request.user.staff
                    )

                else:
                    newtx = Transactions.objects.create(
                        branch=this_branch(request.user),
                        transaction_type="Recognise profit on Asset Disposal",
                        account_dr=asset_disposal_gl,
                        account_cr=income_account,
                        reporting_amount=loss_profit,
                        fixed_asset=asset,
                        financial_year=this_financial_year(request),
                        narration="Recognise profit on %s Disposal" % asset.name,
                        tx_date=date,
                        added_by=request.user.staff
                    )

                # dr accumum  cr disposal_gl
                newtx = Transactions.objects.create(
                    branch=this_branch(request.user),
                    transaction_type="Recognise Asset Disposal",
                    account_dr=accumulating_depreciation,
                    account_cr=asset_disposal_gl,
                    reporting_amount=accum_amount,
                    fixed_asset=asset,
                    financial_year=this_financial_year(request),
                    narration="Recognise profit/loss on %s Disposal" % asset.name,
                    tx_date=date,
                    added_by=request.user.staff
                )

                # c) Recognise disposal proceeds
                # Dr. Cash/Bank/Customer Account: UGX 1,200,000 (depends on if the sale was on credit or in cash or payment through bank)
                # Cr. Computers Disposal GL Account: UGX 1,200,000

                # get the customer
                customer_acc = Account.objects.get(Q(business=this_business(request.user)), Q(id=customer))

                newtx = Transactions.objects.create(
                    branch=this_branch(request.user),
                    transaction_type="Customer Invoicing",
                    account_dr=customer_acc,
                    account_cr=asset_disposal_gl,
                    reporting_amount=amount,
                    fixed_asset=asset,
                    financial_year=this_financial_year(request),
                    narration="Customer Invoicing on %s Disposal" % asset.name,
                    added_by=request.user.staff
                )

                # if there is a payment done, then recognize the money paid
                if pay_status == "1":
                    # get the gl account
                    gl_acc = Account.objects.get(Q(business=this_business(request.user)), Q(id=payment_account))
                    newtx = Transactions.objects.create(
                        branch=this_branch(request.user),
                        transaction_type="Customer Payment",
                        account_dr=gl_acc,
                        account_cr=customer_acc,
                        fixed_asset=asset,
                        reporting_amount=amount,
                        financial_year=this_financial_year(request),
                        narration="Customer Payment for %s Disposal" % asset.name,
                        tx_date=date,
                        added_by=request.user.staff
                    )

                return HttpResponse(request.META.get("HTTP_REFERER"))

            except Exception as ex:
                print(str(ex))
                traceback.print_exc()
                return HttpResponse("1")
        except Exception as ex:
            print(str(ex))
            traceback.print_exc()
            return HttpResponse("2")

    else:
        return HttpResponse("0")


@login_required
def new_asset_location_popup(request):
    if request.method == "POST":
        name = request.POST['name']
        if 'address' in request.POST:
            address = request.POST['address']
        else:
            address = None

        if 'details' in request.POST:
            details = request.POST['details']
        else:
            details = None

        # check if name exists
        try:
            chk = FixedAssetLocation.objects.get(Q(branch=this_branch(request.user)), Q(name=name))
            return HttpResponse("0")
        except:
            pass

        # try your record
        try:
            rec = FixedAssetLocation.objects.create(
                branch=this_branch(request.user),
                name=name,
                address=address,
                details=details,
                added_by=request.user.staff
            )
            return HttpResponse("<option value='%s' selected>%s</option>" % (rec.id, rec.name))
        except Exception as ex:
            print(str(ex))
            return HttpResponse("1")

    else:
        return render(request, "transactions/pop_new_location.html")


@login_required
def general_report(request):
    asset = FixedAssetMovement.objects.filter(business=request.user.branch)
    title = "All Fixed Assets Movements"
    if request.method == "POST":
        fa = request.POST['asset']
        if fa == 'all':
            asset = asset
            title = "All Fixed Assets Movements"
        elif fa.split(':')[0] == 'cat':
            cid = fa.split(':')[1]
            ac = Account.objects.get(id=cid)
            title = "%s  Movements" % ac.name
            asset = FixedAssetMovement.objects.filter(business=request.user.branch, asset__account=ac)
        else:
            d = FixedAsset.objects.get(id=fa)
            title = "%s %s  Movements" % (d.asset_number, d.name)
            asset = FixedAssetMovement.objects.filter(business=request.user.branch, asset__id=fa)

        account_cat = Account.objects.filter(business=request.user.branch, category__name="Fixed Asset Account")
        options = ""
        for a in account_cat:
            options += "<option value='cat:%s'>%s All</option>" % (a.id, a.name)
            # print(a.name)
            fas = FixedAsset.objects.filter(business=request.user.branch, account=a)
            for b in fas:
                # print(b.name)
                options += "<option value='%s'>%s %s - %s</option>" % (b.id, b.asset_number, b.name, b.account.name)
        print(options)
        return render(request, "fixed_asset_report.html", {"assets": asset, "asset_options": options, 'title': title})


    else:

        account_cat = Account.objects.filter(business=request.user.branch, category__name="Fixed Asset Account")
        options = ""
        for a in account_cat:
            options += "<option value='cat:%s'>%s All</option>" % (a.id, a.name)
            # print(a.name)
            fas = FixedAsset.objects.filter(business=request.user.branch, account=a)
            for b in fas:
                # print(b.name)
                options += "<option value='%s'>%s %s - %s</option>" % (b.id, b.asset_number, b.name, b.account.name)
        print(options)
        return render(request, "fixed_asset_report.html", {"assets": asset, "asset_options": options, "title": title})
