import traceback
from datetime import datetime

# from io import StringIO

import xlwt
from PyPDF2.pdf import BytesIO
from django.contrib import messages
from django.contrib.auth.decorators import login_required
from django.db.models import Q, Sum
from django.http import HttpResponse, HttpResponseRedirect
from django.template.loader import get_template
from xhtml2pdf import pisa

from accounts.models import Branch
from loans.utils.loan_details import get_business_loans_context_data
from sacco.models import FinancialYear
from transactions.models import Transactions
from transactions.reports import this_branch, this_financial_year, make_Individual_gl, make_tb, make_bs, \
    make_member_statement, this_business


def render_to_pdf(template_src, context_dict):
    template = get_template(template_src)
    html = template.render(context_dict)
    result = BytesIO()
    # result = StringIO.StringIO()
    pdf = pisa.pisaDocument(BytesIO(html.encode("UTF-8")), result, encoding='UTF-8')
    # pdf = pisa.pisaDocument(StringIO.StringIO(html.encode("UTF-8")), result, encoding='UTF-8')
    if not pdf.err:
        return HttpResponse(result.getvalue(), content_type='application/pdf')
    return None


@login_required
def export_gl(request):
    if request.method == "POST":
        start_date = request.POST['start_date']
        end_date = request.POST['end_date']
        gl = Transactions.objects.filter(branch=this_branch(request.user), tx_date__range=(start_date, end_date))
        try:
            response = HttpResponse(content_type='application/ms-excel')
            response['Content-Disposition'] = 'attachment; filename="General Ledger.xls"'

            wb = xlwt.Workbook(encoding='utf-8')
            ws = wb.add_sheet('General Ledger')

            ws.col(2).width = int(20 * 260)
            ws.col(3).width = int(20 * 260)
            ws.col(4).width = int(20 * 360)
            ws.col(5).width = int(20 * 260)
            ws.col(6).width = int(20 * 260)
            ws.col(7).width = int(20 * 360)
            ws.col(8).width = int(20 * 260)

            style1 = xlwt.easyxf(
                'font: color-index black, bold on; pattern: pattern solid, fore_colour white; ')

            row_num = 1
            date_format = xlwt.XFStyle()
            date_format.num_format_str = 'yyyy-mm-dd'
            font_style = xlwt.XFStyle()
            font_style.font.bold = True

            font_stylet = xlwt.XFStyle()
            font_stylet.font.bold = True
            font_stylet.height = 320

            columns = [
                'SN',
                'Date',
                'Action',
                'Account',
                'Amount Dr',
                'Amount Cr',
                'Narrative'
            ]
            ws.write_merge(0, 0, 0, 7, "General Ledger for %s %s Branch from %s to %s" % (
                request.user.staff.branch.business.name, request.user.staff.branch.name, start_date, end_date),
                           font_stylet)
            for col_num in range(len(columns)):
                ws.write(row_num, col_num, columns[col_num], font_style)

            font_style = xlwt.XFStyle()
            date_format.num_format_str = 'yyyy-mm-dd'
            font_style.alignment.wrap = True
            font_style.alignment.vert = xlwt.Alignment.HORZ_RIGHT
            for c in gl:
                row_num += 1
                row = [
                    c.txno,
                    c.tx_date,
                    c.transaction_type,
                    c.account_dr.name,
                    float(c.reporting_amount),
                    '',
                    c.narration
                ]

                for col_num in range(len(row)):
                    ws.write(row_num, col_num, row[col_num], font_style)
                row_num += 1
                row = [
                    c.txno,
                    c.tx_date,
                    c.transaction_type,
                    c.account_cr.name,
                    '',
                    float(c.reporting_amount),
                    c.narration
                ]

                for col_num in range(len(row)):
                    ws.write(row_num, col_num, row[col_num], font_style)

            wb.save(response)

            return response

        except Exception as ex:
            print(str(ex))
            traceback.print_exc()

            return HttpResponse(str(ex))
    else:
        messages.error(request, "Invalid request")
        return HttpResponseRedirect(request.META.get("HTTP_REFERER"))


@login_required
def pdf_gl(request):
    if request.method == "POST":
        start_date = request.POST['start_date']
        end_date = request.POST['end_date']
        gl = Transactions.objects.filter(branch=this_branch(request.user), tx_date__range=(start_date, end_date))
        context = {"general_ledger": gl, 'user': request.user, "start_date": start_date, "end_date": end_date}

        try:
            filename = render_to_pdf('transactions/exports/general_ledger_export.html', context)
            resp = HttpResponse(filename.getvalue(), content_type="application/pdf")
            # ..and correct content-disposition
            resp['Content-Disposition'] = 'attachment; filename=%s Branch General Ledger Statement' % (
                request.user.staff.branch.name)

            return resp
        except Exception as ex:
            print("Erroe returning pdf................ %s" % str(ex))
            traceback.print_exc()
            messages.error(request, "Something went wrong. Please try again or contact support")
            return HttpResponse(str(ex))
    else:
        messages.error(request, "Invalid request")
        return HttpResponseRedirect(request.META.get("HTTP_REFERER"))


@login_required
def export_individual_gl(request):
    business_context = get_business_loans_context_data(request)
    if business_context['branch'] is None:  # here u are in the central view
        # show the business this person is attached to
        the_current_branch = this_branch(request.user)
    else:
        the_current_branch = business_context['branch']
    if request.method == "POST":
        if 'start_date' in request.POST:
            start_date = request.POST['start_date']
        else:
            dates = FinancialYear.objects.filter(status=True, business=this_business(request.user)).last()
            start_date = dates.start_date

        if 'end_date' in request.POST:
            end_date = request.POST['end_date']
        else:
            dates = FinancialYear.objects.filter(status=True, business=this_business(request.user)).last()
            end_date = datetime.today().date()

        context = make_Individual_gl(request)
        account = context['account']
        glx = context['individual_gl']
        # print(glx)

        total_cr = 0
        total_dr = 0

        for t in glx:
            # print(t)
            total_dr += t["amount_dr"]
            total_cr += t["amount_cr"]
        if account == "Members":
            acc_name = "Member Savings"
            total = total_cr - total_dr
        else:
            acc_name = account.name
            if account.category.dr_cr == "cr":
                total = total_cr - total_dr
            else:
                total = total_dr - total_cr

        try:
            response = HttpResponse(content_type='application/ms-excel')
            response[
                'Content-Disposition'] = 'attachment; filename="%s Individual General Ledger Statement from %s to %s.xls"' % (acc_name, start_date, end_date)

            wb = xlwt.Workbook(encoding='utf-8')
            ws = wb.add_sheet(acc_name)
            ws.col(2).width = int(20 * 260)
            ws.col(3).width = int(20 * 260)
            ws.col(4).width = int(20 * 360)
            ws.col(5).width = int(20 * 260)
            ws.col(6).width = int(20 * 260)
            ws.col(7).width = int(20 * 360)
            ws.col(8).width = int(20 * 260)
            ws.col(9).width = int(20 * 260)
            ws.col(10).width = int(20 * 260)
            ws.col(11).width = int(20 * 260)
            ws.col(12).width = int(20 * 260)
            ws.col(13).width = int(20 * 260)
            ws.col(14).width = int(20 * 260)
            style1 = xlwt.easyxf(
                'font: color-index black, bold on; pattern: pattern solid, fore_colour white; ')

            row_num = 1
            date_format = xlwt.XFStyle()
            date_format.num_format_str = 'yyyy-mm-dd'
            font_style = xlwt.XFStyle()
            font_style.font.bold = True

            font_stylet = xlwt.XFStyle()
            font_stylet.font.bold = True
            font_stylet.height = 320

            columns = [
                'TRXN',
                'TRXNDate',
                'Account Dr',
                'Account Cr',
                'Narrative',
                'Amount Dr',
                'Amount Cr',
                'Running Balance'
            ]
            ws.write_merge(0, 0, 0, 7, "%s Individual General Ledger Statement" % acc_name, font_stylet)
            for col_num in range(len(columns)):
                ws.write(row_num, col_num, columns[col_num], font_style)

            font_style = xlwt.XFStyle()
            font_style.alignment.wrap = True
            font_style.alignment.vert = xlwt.Alignment.HORZ_RIGHT
            for c in glx:
                row_num += 1
                if c['gl'] is None:
                    txno = ''
                    tx_date = ''
                    narration = ''
                else:
                    txno = c['gl'].txno
                    tx_date = c['gl'].tx_date
                    narration = c['gl'].narration

                if c['is_opening_balance']:
                    if account == "Members":
                        acc_cr = ''
                        acc_dr = 'Opening Balance'
                    else:
                        if account.category.dr_cr == "cr":
                            acc_cr = ''
                            acc_dr = 'Opening Balance'
                        else:
                            acc_cr = 'Opening Balance'
                            acc_dr = ''
                else:
                    if c['account_dr'] is None:
                        acc_dr = None
                    else:
                        if c['account_dr'].member is not None:
                            acc_dr = c['account_dr'].member.acc_number
                        else:
                            acc_dr = c['account_dr'].name
                    if c['account_cr'].member is not None:
                        acc_dr = c['account_cr'].member.acc_number
                    else:
                        acc_cr = c['account_cr'].name


                    # if narration == 'Initial deposit on registration':
                    #     print('txno', txno)
                    #     print('tx_date', tx_date)
                    #     print('acc_dr', acc_dr)
                    #     print('acc_cr', acc_cr)
                    #     print('account', c)

                row = [
                    txno,
                    tx_date,
                    acc_dr,
                    acc_cr,
                    narration,
                    float(c['amount_dr']),
                    float(c['amount_cr']),
                    float(c['balance'])
                ]

                # print('ROW', row)

                for col_num in range(len(row)):
                    ws.write(row_num, col_num, row[col_num], font_style)

            row_num += 2
            columns_totals = [
                '',
                '',
                '',
                '',
                'TOTAL',
                float(total_dr),
                float(total_cr),
                float(total)
            ]
            for col_num in range(len(columns_totals)):
                ws.write(row_num, col_num, columns_totals[col_num], font_stylet)

            wb.save(response)

            return response

        except Exception as ex:
            print(str(ex))
            traceback.print_exc()
            return HttpResponse(str(ex))

    else:
        return HttpResponse("this is not a post")


@login_required
def pdf_individual_gl(request):
    if request.method == "POST":
        if 'start_date' in request.POST:
            start_date = request.POST['start_date']
        else:
            dates = FinancialYear.objects.filter(status=True, business=this_business(request.user)).last()
            start_date = dates.start_date

        if 'end_date' in request.POST:
            end_date = request.POST['end_date']
        else:
            dates = FinancialYear.objects.filter(status=True, business=this_business(request.user)).last()
            end_date = datetime.today().date()
        context = make_Individual_gl(request)
        account = context['account']
        context['user'] = request.user
        glx = context['individual_gl']

        if account == "Members":
            acc_name = "Member Savings"
        else:
            acc_name = account.name

        try:
            filename = render_to_pdf('transactions/exports/individual_gl_export.html', context)
            resp = HttpResponse(filename.getvalue(), content_type="application/pdf")
            # ..and correct content-disposition
            resp['Content-Disposition'] = 'attachment; filename=%s %s Branch Individual GL for  %s from %s to %s' % (
                request.user.staff.branch.business.name, request.user.staff.branch.name, acc_name, start_date, end_date)

            return resp
        except Exception as ex:
            traceback.print_exc()
            print("Erroe returning pdf................ %s" % str(ex))
            messages.error(request, "Something went wrong. Please try again or contact support")
            return HttpResponse(str(ex))


    else:
        return None


#
@login_required
def export_tb(request):
    business_context = get_business_loans_context_data(request)
    if business_context['branch'] is None:  # here u are in the central view
        # show the business this person is attached to
        the_current_branch = this_branch(request.user)
    else:
        the_current_branch = business_context['branch']
    if 'start_date' in request.POST:
        start_date = request.POST['start_date']
    else:
        dates = FinancialYear.objects.filter(status=True, business=this_business(request.user)).last()
        start_date = dates.start_date

    if 'end_date' in request.POST:
        end_date = request.POST['end_date']
    else:
        dates = FinancialYear.objects.filter(status=True, business=this_business(request.user)).last()
        end_date = datetime.today().date()
    tb_context = make_tb(request)

    if 'report_for' in request.POST:
        report_for = request.POST['report_for']
        if report_for == "business":
            pass
        else:
            the_current_branch = Branch.objects.get(id=report_for)

    tb = tb_context['tb']
    start_date = tb_context['start_date']
    end_date = tb_context['end_date']

    cr_total = 0
    dr_total = 0
    for t in tb:
        cr_total += t['amount_cr']
        dr_total += t['amount_dr']
    try:
        response = HttpResponse(content_type='application/ms-excel')
        response['Content-Disposition'] = 'attachment; filename="%s Trial balance as at %s.xls"' % (
            the_current_branch.name, end_date)

        wb = xlwt.Workbook(encoding='utf-8')
        ws = wb.add_sheet('Trial Balance')
        ws.col(1).width = int(20 * 360)
        ws.col(2).width = int(20 * 360)
        ws.col(3).width = int(20 * 360)
        ws.col(4).width = int(20 * 360)

        style1 = xlwt.easyxf(
            'font: color-index black, bold on; pattern: pattern solid, fore_colour white; ')

        row_num = 1
        date_format = xlwt.XFStyle()
        date_format.num_format_str = 'yyyy-mm-dd'
        font_style = xlwt.XFStyle()
        font_style.font.bold = True

        font_stylet = xlwt.XFStyle()
        font_stylet.font.bold = True
        font_stylet.height = 320

        columns = [
            'GL Category',
            'TB Line',
            'Amount DR',
            'Amount CR',
        ]
        ws.write_merge(0, 0, 0, 4, "Trial Balance for %s as at %s" % (
            the_current_branch.name, end_date),
                       font_stylet)
        for col_num in range(len(columns)):
            ws.write(row_num, col_num, columns[col_num], font_style)

        font_style = xlwt.XFStyle()
        font_style.alignment.wrap = True
        font_style.alignment.vert = xlwt.Alignment.HORZ_RIGHT
        for c in tb:
            row_num += 1
            if c['is_retained_earning']:
                # if c['amount_dr'] != 0 and c['amount_cr'] != 0:
                row = [
                    '',
                    'Retained Earnings',
                    float(c['amount_dr']),
                    float(c['amount_cr'])
                ]
                for col_num in range(len(row)):
                    ws.write(row_num, col_num, row[col_num], font_style)
            else:
                # if float(c['amount_dr']) != 0 and float(c['amount_cr']) != 0:
                if c['is_members']:
                    row = [
                        'Members',
                        'Member Savings',
                        float(c['amount_dr']),
                        float(c['amount_cr'])
                    ]
                else:
                    row = [
                        c['account'].category.name,
                        c['account'].name,
                        float(c['amount_dr']),
                        float(c['amount_cr'])
                    ]

                for col_num in range(len(row)):
                    ws.write(row_num, col_num, row[col_num], font_style)
        row_num += 1
        totals = [
            '',
            'TOTAL',
            float(dr_total),
            float(cr_total)
        ]
        for col_numn in range(len(totals)):
            ws.write(row_num, col_numn, totals[col_numn], font_stylet)

        wb.save(response)

        return response

    except Exception as ex:
        print(str(ex))
        traceback.print_exc()
        return HttpResponse(str(ex))


@login_required
def pdf_tb(request):
    if 'start_date' in request.POST:
        start_date = request.POST['start_date']
    else:
        dates = FinancialYear.objects.filter(status=True, business=this_business(request.user)).last()
        start_date = dates.start_date

    if 'end_date' in request.POST:
        end_date = request.POST['end_date']
    else:
        dates = FinancialYear.objects.filter(status=True, business=this_business(request.user)).last()
        end_date = datetime.today().date()

    tb_context = make_tb(request)
    tb = tb_context['tb']

    start_date = tb_context['start_date']
    end_date = tb_context['end_date']
    tb_context['user'] = request.user

    try:

        filename = render_to_pdf('transactions/exports/trial_balance_export.html', tb_context)
        resp = HttpResponse(filename.getvalue(), content_type="application/pdf")
        # ..and correct content-disposition
        resp['Content-Disposition'] = 'attachment; filename= %s %s Trial Balance for the period %s to %s' % (
            request.user.staff.branch.business.name, request.user.staff.branch.name, start_date, end_date)

        return resp
    except Exception as ex:
        print("Erroe returning pdf................ %s" % str(ex))
        messages.error(request, "Something went wrong. Please try again or contact support")
        return HttpResponse(str(ex))


@login_required
def export_bs(request):
    business_context = get_business_loans_context_data(request)
    if business_context['branch'] is None:  # here u are in the central view
        # show the business this person is attached to
        the_current_branch = this_branch(request.user)
    else:
        the_current_branch = business_context['branch']
    if 'report_for' in request.POST:
        report_for = request.POST['report_for']
        if report_for == "business":
            pass
        else:
            the_current_branch = Branch.objects.get(id=report_for)
    if 'start_date' in request.POST:
        start_date = request.POST['start_date']
    else:
        dates = FinancialYear.objects.filter(status=True, business=this_business(request.user)).last()
        start_date = dates.start_date

    if 'end_date' in request.POST:
        end_date = request.POST['end_date']
    else:
        dates = FinancialYear.objects.filter(status=True, business=this_business(request.user)).last()
        end_date = datetime.today().date()

    # reporting_dates = ReportingDate.objects.filter(business=request.user.branch).first()
    # bs_assets = BalanceSheet.objects.filter(business=request.user.branch, is_asset=True)
    # bs_liabilities = BalanceSheet.objects.filter(business=request.user.branch, is_liability=True)
    context = make_bs(request, 'bs')
    bs_assets = context['assets']
    bs_liabilities = context['liabilities']

    assets_total = 0
    liability_total = 0
    # dr_total = 0
    for t in bs_assets:
        assets_total += t['amount']
        # dr_total += t.amount_dr
    for m in bs_liabilities:
        liability_total += m['amount']

    try:
        response = HttpResponse(content_type='application/ms-excel')
        response['Content-Disposition'] = 'attachment; filename="%s Balance Sheet as at %s.xls"' % (
        the_current_branch.name, end_date)

        wb = xlwt.Workbook(encoding='utf-8')
        ws = wb.add_sheet('Balance Sheet')
        ws.col(0).width = int(20 * 560)
        ws.col(1).width = int(20 * 560)
        ws.col(2).width = int(20 * 560)
        ws.col(3).width = int(20 * 560)
        ws.col(4).width = int(20 * 560)

        style1 = xlwt.easyxf(
            'font: color-index black, bold on; pattern: pattern solid, fore_colour white; ')

        row_num = 1
        date_format = xlwt.XFStyle()
        date_format.num_format_str = 'yyyy-mm-dd'
        font_style = xlwt.XFStyle()
        font_style.font.bold = True

        font_stylet = xlwt.XFStyle()
        font_stylet.font.bold = True
        font_stylet.height = 320
        font_stylet.alignment.vert = xlwt.Alignment.HORZ_RIGHT

        columns = [
            'Name of GL',
            'Amount'
        ]
        ws.write_merge(0, 0, 0, 2, "%s Statement of Financial Position as at %s" % (
            the_current_branch.name, end_date),
                       font_stylet)
        for col_num in range(len(columns)):
            ws.write(row_num, col_num, columns[col_num], font_style)
        row_num += 1
        columns_assets = [
            'ASSETS',
            ''
        ]
        for col_num in range(len(columns_assets)):
            ws.write(row_num, col_num, columns_assets[col_num], font_style)

        font_style = xlwt.XFStyle()
        font_style.alignment.wrap = True
        font_style.alignment.vert = xlwt.Alignment.HORZ_RIGHT
        for c in bs_assets:
            row_num += 1
            row = [
                c['account'].name,
                float(c['amount'])
            ]

            for col_num in range(len(row)):
                ws.write(row_num, col_num, row[col_num], font_style)
        row_num += 1
        totals = [
            'TOTAL ASSETS',
            float(assets_total),
        ]
        for col_numn in range(len(totals)):
            ws.write(row_num, col_numn, totals[col_numn], font_stylet)
        row_num += 1
        columns_liab = [
            'EQUITY AND LIABILITIES',
            ''
        ]
        for col_num in range(len(columns_liab)):
            ws.write(row_num, col_num, columns_liab[col_num], font_stylet)
        for c in bs_liabilities:
            row_num += 1
            if c['is_retained_earnings']:
                row = [
                    'Retained Earnings',
                    float(c['amount'])
                ]
            else:
                if c['is_members']:
                    row = [
                        'Member Savings',
                        float(c['amount'])
                    ]
                else:
                    row = [
                        c['account'].name,
                        float(c['amount'])
                    ]

            for col_num in range(len(row)):
                ws.write(row_num, col_num, row[col_num], font_style)
        row_num += 1
        totals = [
            'TOTAL EQUITY AND LIABILITIES',
            float(liability_total),
        ]
        for col_numn in range(len(totals)):
            ws.write(row_num, col_numn, totals[col_numn], font_stylet)

        wb.save(response)

        return response

    except Exception as ex:
        print(str(ex))
        return HttpResponse(str(ex))


@login_required
def pdf_bs(request):
    business_context = get_business_loans_context_data(request)
    if business_context['branch'] is None:  # here u are in the central view
        # show the business this person is attached to
        the_current_branch = this_branch(request.user)
    else:
        the_current_branch = business_context['branch']
    if 'report_for' in request.POST:
        report_for = request.POST['report_for']
        if report_for == "business":
            pass
        else:
            the_current_branch = Branch.objects.get(id=report_for)
    if 'start_date' in request.POST:
        start_date = request.POST['start_date']
    else:
        dates = FinancialYear.objects.filter(status=True, business=this_business(request.user)).last()
        start_date = dates.start_date

    if 'end_date' in request.POST:
        end_date = request.POST['end_date']
    else:
        dates = FinancialYear.objects.filter(status=True, business=this_business(request.user)).last()
        end_date = datetime.today().date()

    context = make_bs(request, 'bs')
    context['user'] = request.user
    try:
        filename = render_to_pdf('transactions/exports/balance_sheet_export.html', context)
        resp = HttpResponse(filename.getvalue(), content_type="application/pdf")
        # ..and correct content-disposition
        resp['Content-Disposition'] = 'attachment; filename=%s Balance Sheet as at %s' % (
            the_current_branch.name, end_date)

        return resp
    except Exception as ex:
        print("Erroe returning pdf................ %s" % str(ex))
        messages.error(request, "Something went wrong. Please try again or contact support")
        return HttpResponse(str(ex))


@login_required
def export_is(request):
    business_context = get_business_loans_context_data(request)
    if business_context['branch'] is None:  # here u are in the central view
        # show the business this person is attached to
        the_current_branch = this_branch(request.user)
    else:
        the_current_branch = business_context['branch']
    if 'report_for' in request.POST:
        report_for = request.POST['report_for']
        if report_for == "business":
            pass
        else:
            the_current_branch = Branch.objects.get(id=report_for)
    if 'start_date' in request.POST:
        start_date = request.POST['start_date']
    else:
        dates = FinancialYear.objects.filter(status=True, business=this_business(request.user)).last()
        start_date = dates.start_date

    if 'end_date' in request.POST:
        end_date = request.POST['end_date']
    else:
        dates = FinancialYear.objects.filter(status=True, business=this_business(request.user)).last()
        end_date = datetime.today().date()
    context = make_bs(request, 'is')
    context['user'] = request.user
    # start_date = this_financial_year(request).start_date
    # end_date = this_financial_year(request).end_date
    is_revenues = context['revenues']
    is_expenses = context['expenses']

    revenues_total = 0
    expenses_total = 0
    # dr_total = 0
    for t in is_revenues:
        revenues_total += t['amount']
        # dr_total += t.amount_dr
    for m in is_expenses:
        expenses_total += m['amount']

    profit_loss = revenues_total - expenses_total

    try:
        response = HttpResponse(content_type='application/ms-excel')
        response[
            'Content-Disposition'] = 'attachment; filename="%s Income statement for the period %s to %s.xls"' % (
            the_current_branch.name, start_date, end_date)

        wb = xlwt.Workbook(encoding='utf-8')
        ws = wb.add_sheet('Income Statement')
        ws.col(0).width = int(20 * 560)
        ws.col(1).width = int(20 * 560)
        ws.col(2).width = int(20 * 560)
        ws.col(3).width = int(20 * 560)
        ws.col(4).width = int(20 * 560)

        style1 = xlwt.easyxf(
            'font: color-index black, bold on; pattern: pattern solid, fore_colour white; ')

        row_num = 1
        date_format = xlwt.XFStyle()
        date_format.num_format_str = 'yyyy-mm-dd'
        font_style = xlwt.XFStyle()
        font_style.font.bold = True

        font_stylet = xlwt.XFStyle()
        font_stylet.font.bold = True
        font_stylet.height = 320
        font_stylet.alignment.vert = xlwt.Alignment.HORZ_RIGHT

        columns = [
            'Name of GL',
            'Amount'
        ]
        ws.write_merge(0, 0, 0, 2, "%s Income statement for the period %s to %s" % (
            the_current_branch.name, start_date, end_date),
                       font_stylet)
        for col_num in range(len(columns)):
            ws.write(row_num, col_num, columns[col_num], font_style)
        row_num += 2
        columns_revenues = [
            'REVENUES',
            ''
        ]
        for col_num in range(len(columns_revenues)):
            ws.write(row_num, col_num, columns_revenues[col_num], font_stylet)

        font_style = xlwt.XFStyle()
        font_style.alignment.wrap = True
        font_style.alignment.vert = xlwt.Alignment.HORZ_RIGHT
        for c in is_revenues:
            row_num += 1
            row = [
                c['account'].name,
                float(c['amount'])
            ]

            for col_num in range(len(row)):
                ws.write(row_num, col_num, row[col_num], font_style)
        row_num += 1
        totals = [
            'TOTAL REVENUES',
            float(revenues_total),
        ]

        for col_numn in range(len(totals)):
            ws.write(row_num, col_numn, totals[col_numn], font_stylet)

        row_num += 2
        columns_expenses = [
            'EXPENSES',
            ''
        ]
        for col_num in range(len(columns_expenses)):
            ws.write(row_num, col_num, columns_expenses[col_num], font_stylet)
        for c in is_expenses:
            if c['amount'] != 0:
                row_num += 1
                row = [
                    c['account'].name,
                    float(c['amount'])
                ]

                for col_num in range(len(row)):
                    ws.write(row_num, col_num, row[col_num], font_style)
        row_num += 1
        totals = [
            'TOTAL EXPENSES',
            float(expenses_total),
        ]
        for col_numn in range(len(totals)):
            ws.write(row_num, col_numn, totals[col_numn], font_stylet)

        row_num += 2
        totals = [
            'PROFIT/LOSS FOR THE PERIOD',
            float(profit_loss),
        ]
        for col_numn in range(len(totals)):
            ws.write(row_num, col_numn, totals[col_numn], font_stylet)

        wb.save(response)

        return response

    except Exception as ex:
        print(str(ex))
        return HttpResponse(str(ex))


@login_required
def pdf_is(request):
    business_context = get_business_loans_context_data(request)
    if business_context['branch'] is None:  # here u are in the central view
        # show the business this person is attached to
        the_current_branch = this_branch(request.user)
    else:
        the_current_branch = business_context['branch']
    if 'report_for' in request.POST:
        report_for = request.POST['report_for']
        if report_for == "business":
            pass
        else:
            the_current_branch = Branch.objects.get(id=report_for)
    if 'start_date' in request.POST:
        start_date = request.POST['start_date']
    else:
        dates = FinancialYear.objects.filter(status=True, business=this_business(request.user)).last()
        start_date = dates.start_date

    if 'end_date' in request.POST:
        end_date = request.POST['end_date']
    else:
        dates = FinancialYear.objects.filter(status=True, business=this_business(request.user)).last()
        end_date = datetime.today().date()
    context = make_bs(request, 'is')
    context['user'] = request.user
    # start_date = this_financial_year(request).start_date
    # end_date = this_financial_year(request).end_date

    try:
        filename = render_to_pdf('transactions/exports/income_statement_export.html', context)
        resp = HttpResponse(filename.getvalue(), content_type="application/pdf")
        # ..and correct content-disposition
        resp['Content-Disposition'] = 'attachment; filename=%s Income Statement for the period %s to %s' % (
            the_current_branch.name, start_date, end_date)

        return resp
    except Exception as ex:
        print("Erroe returning pdf................ %s" % str(ex))
        messages.error(request, "Something went wrong. Please try again or contact support")
        return HttpResponse(str(ex))


def pdf_member_statement(request):
    if this_financial_year(request):
        if request.method == "POST":
            context = make_member_statement(request)
            context['user'] = request.user
            start_date = context['start_date']
            end_date = context['end_date']
            account = context['account'].member.member_names

            try:
                filename = render_to_pdf('transactions/exports/member_statement_export.html', context)
                resp = HttpResponse(filename.getvalue(), content_type="application/pdf")
                # ..and correct content-disposition
                resp[
                    'Content-Disposition'] = 'attachment; filename=%s Account Statement for the period %s to %s.pdf' % (
                    account, start_date, end_date)

                return resp
            except Exception as ex:
                print("Erroe returning pdf................ %s" % str(ex))
                messages.error(request, "Something went wrong. Please try again or contact support")
                return HttpResponse(str(ex))

        else:
            messages.error(request, "Invalid request")
            return HttpResponseRedirect(request.META.get("HTTP_REFERER"))
    else:
        messages.error(request, "Financial Year not set")
        return HttpResponseRedirect(request.META.get("HTTP_REFERER"))
