from django.contrib import admin
# Register your models here.
from django.contrib.admin import display
# from .models import AccountCategory

from transactions.models import AccountCategory, Account, Transactions, FixedAsset, FixedAssetLocation, \
    FixedAssetMovement, SharesTransactions


class CustomModelAdmin(admin.ModelAdmin):

    def __init__(self, model, admin_site):
        self.list_display = [field.name for field in model._meta.fields if field.name != "id"]
        super(CustomModelAdmin, self).__init__(model, admin_site)


class TransAdmin(admin.ModelAdmin):
    def __init__(self, model, admin_site):
        self.list_display = [field.name for field in model._meta.fields if field.name != "id"]
        super(TransAdmin, self).__init__(model, admin_site)

    list_filter = ['date_added', 'tx_date']


@admin.register(Account)
class AccountAdmin(admin.ModelAdmin):
    list_display = [field.name for field in Account._meta.fields if field.name != "id"]
    list_display_links = [field.name for field in Account._meta.fields if field.name != "id"]

    list_filter = ['business']
    search_fields = ['member']


class MyAdmin(CustomModelAdmin):
    pass


admin.site.register(AccountCategory, MyAdmin)
admin.site.register(SharesTransactions, MyAdmin)
admin.site.register(Transactions, TransAdmin)
admin.site.register(FixedAsset, CustomModelAdmin)
admin.site.register(FixedAssetLocation, CustomModelAdmin)
admin.site.register(FixedAssetMovement, CustomModelAdmin)
