import os

from decouple import config

from .base import *

# SECURITY WARNING: keep the secret key used in production secret!
SECRET_KEY = config('SECRET_KEY')

# SECURITY WARNING: don't run with debug turned on in production!
DEBUG = False

ALLOWED_HOSTS = config('ALLOWED_HOSTS', default='', cast=lambda v: [s.strip() for s in v.split(',')])


DATABASES = {
    'default': {
        'ENGINE': 'django.db.backends.mysql',
        'NAME': config('DB_NAME'),
        'USER': config('DB_USER'),
        'PASSWORD': config('DB_PASSWORD'),
        'HOST': config('DB_HOST'),
        'PORT': '3306',
        'OPTIONS': {
        'sql_mode': 'traditional',

        }
    }
}



# Static files (CSS, JavaScript, Images)
# https://docs.djangoproject.com/en/4.0/howto/static-files/

STATIC_URL = 'static/'
STATIC_ROOT = config('STATIC_ROOT')
# STATICFILES_STORAGE = 'whitenoise.storage.CompressedManifestStaticFilesStorage'
MEDIA_ROOT = config('MEDIA_ROOT')
MEDIA_URL = config('MEDIA_URL')

# Default primary key field type
# https://docs.djangoproject.com/en/4.0/ref/settings/#default-auto-field

EMAIL_BACKEND = 'django_mailjet.backends.MailjetBackend'
MAILJET_API_KEY = 'e93adb797e20b9639b37abc0ee9c1bd6'
MAILJET_API_SECRET = 'add0476d360e829f54724158d785b785'
DEFAULT_FROM_EMAIL = 'Mfuko Plus <notifications@mfuko.net>'

# EMAIL_BACKEND = 'django.core.mail.backends.smtp.EmailBackend'
# EMAIL_USE_TLS = True
# EMAIL_HOST = 'in-v3.mailjet.com'
# EMAIL_PORT = 465
# EMAIL_HOST_USER = 'e93adb797e20b9639b37abc0ee9c1bd6'
# EMAIL_HOST_PASSWORD = 'add0476d360e829f54724158d785b785'
# DEFAULT_FROM_EMAIL = 'Mfuko Plus <notifications@mfuko.net>'

# BROKER_URL = 'redis://localhost:6379'
# CELERY_RESULT_BACKEND = 'redis://localhost:6379'
# # CELERY_ACCEPT_CONTENT = ['application/json']
# # CELERY_TASK_SERIALIZER = 'json'
# CELERY_RESULT_SERIALIZER = 'json'
# CELERY_TIMEZONE = 'Africa/Kampala'

RQ_QUEUES = {
    'default': {
        'HOST': 'localhost',
        'PORT': 6379,
        'DB': 0,
        # 'PASSWORD': 'some-password',
        'DEFAULT_TIMEOUT': 360,
    },
}

CORS_ALLOWED_ORIGINS = [
    "https://portal.mfuko.net"
]

CORS_URLS_REGEX = r"^/api/.*$"

SMS_SEND = True

LOGGING = {
    'version': 1,
    'disable_existing_loggers':True,
    'formatters': {
        'first_formatter' : {
            'format':"{asctime} - {levelname} - {module} - {message}",
            'style':"{",
            }
    },
    'handlers':{
        'file':{
            'class':'logging.FileHandler',
            'filename': 'info.log',
            'formatter':'first_formatter',
        },
        'console': {
            'class':'logging.StreamHandler',
            'formatter':'first_formatter',
        },
    },
    'loggers':{
        'main': {
            'handlers': ['file','console'],
            'propagate': True,
            'level':"INFO",
        }
    }
}

