"""
Django settings for mfuko project.

Generated by 'django-admin startproject' using Django 4.0.2.

For more information on this file, see
https://docs.djangoproject.com/en/4.0/topics/settings/

For the full list of settings and their values, see
https://docs.djangoproject.com/en/4.0/ref/settings/
"""
from decouple import config

from pathlib import Path

# Build paths inside the project like this: BASE_DIR / 'subdir'.
BASE_DIR = Path(__file__).resolve().parent.parent

# Application definition

INSTALLED_APPS = [
    'django.contrib.admin',
    'django.contrib.auth',
    'django.contrib.contenttypes',
    'django.contrib.sessions',
    'django.contrib.messages',
    'django.contrib.humanize',
    'whitenoise.runserver_nostatic',
    'django.contrib.staticfiles',
    'rest_framework.authtoken',
    'rest_framework',
    'corsheaders',
    'mathfilters',

    # installed apps
    'django_countries',
    'django_rq',
    'drf_yasg',

    # my apps
    'accounts',
    'loans',
    'sacco',
    'transactions',
    'mufukoadmin',
    'apis',
    'client_custom.namayingo'
]

AUTH_USER_MODEL = 'accounts.User'

MIDDLEWARE = [
    'django.middleware.security.SecurityMiddleware',
    'corsheaders.middleware.CorsMiddleware',
    'whitenoise.middleware.WhiteNoiseMiddleware',
    'django.contrib.sessions.middleware.SessionMiddleware',
    'django.middleware.common.CommonMiddleware',
    'django.middleware.csrf.CsrfViewMiddleware',
    'django.contrib.auth.middleware.AuthenticationMiddleware',
    'django.contrib.messages.middleware.MessageMiddleware',
    'django.middleware.clickjacking.XFrameOptionsMiddleware',
    # 'sacco.middleware.subscription.SubscriptionMiddleware',
    'sacco.after5_middleware.After5PermissionMiddleware',
]

ROOT_URLCONF = 'mfuko.urls'

TEMPLATES = [
    {
        'BACKEND': 'django.template.backends.django.DjangoTemplates',
        'DIRS': [BASE_DIR / 'templates']
        ,
        'APP_DIRS': True,
        'OPTIONS': {
            'context_processors': [
                'django.template.context_processors.debug',
                'django.template.context_processors.request',
                'django.contrib.auth.context_processors.auth',
                'django.contrib.messages.context_processors.messages',
                'django.template.context_processors.csrf',
                'sacco.context_processors.fy',
                'sacco.context_processors.allbranches',
                'sacco.context_processors.branch',
                'sacco.context_processors.system_perms',
                'sacco.context_processors.user_perms',
                'sacco.context_processors.am_namayingo',
                'sacco.context_processors.new_side_bar',
                'sacco.context_processors.view_groups',
                'sacco.context_processors.setup_business_filters',

            ],
        },
    },
]

WSGI_APPLICATION = 'mfuko.wsgi.application'

# Database
# https://docs.djangoproject.com/en/4.0/ref/settings/#databases


AUTHENTICATION_BACKENDS = [
    'django.contrib.auth.backends.ModelBackend',
    'accounts.backends.EmailOrUsernameModelBackend',
]

# Password validation
# https://docs.djangoproject.com/en/4.0/ref/settings/#auth-password-validators

AUTH_PASSWORD_VALIDATORS = [
    {
        'NAME': 'django.contrib.auth.password_validation.UserAttributeSimilarityValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.MinimumLengthValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.CommonPasswordValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.NumericPasswordValidator',
    },
]

# Internationalization
# https://docs.djangoproject.com/en/4.0/topics/i18n/

REST_FRAMEWORK = {
    'DEFAULT_AUTHENTICATION_CLASSES': (
        'rest_framework.authentication.TokenAuthentication',
    ),
    'DEFAULT_PERMISSION_CLASSES': (
        'rest_framework.permissions.IsAuthenticated',
    ),
    'DEFAULT_PAGINATION_CLASS':
        'rest_framework.pagination.PageNumberPagination',
    'PAGE_SIZE': 10,
    'DEFAULT_SCHEMA_CLASS':
        'rest_framework.schemas.coreapi.AutoSchema',
}

LANGUAGE_CODE = 'en-us'

TIME_ZONE = 'Africa/Kampala'

USE_I18N = True

USE_TZ = True

DEFAULT_AUTO_FIELD = 'django.db.models.BigAutoField'
APPEND_SLASH = True

COUNTRIES_FIRST = ['UG', 'SS']

COUNTRIES_ONLY = ['UG', 'KE', 'TZ', 'RW', 'BI', 'SS', 'SO', 'CD', 'NG', 'SD', 'ET']

DATA_UPLOAD_MAX_NUMBER_FIELDS = 10240

SESSION_EXPIRE_AT_BROWSER_CLOSE = False
SESSION_COOKIE_AGE = 1440 * 60

JPESAKEY = config('JPESAKEY')

# LOGGING = {
#     'version': 1,
#     'disable_existing_loggers': True,
#     'formatters': {
#         'first_formatter': {
#             'format': "{asctime} - {levelname} - {module} - {message}",
#             'style': "{",
#         }
#     },
#     'handlers': {
#         'file': {
#             'class': 'logging.FileHandler',
#             'filename': 'info.log',
#             'formatter': 'first_formatter',
#         },
#         'console': {
#             'class': 'logging.StreamHandler',
#             'formatter': 'first_formatter',
#         },
#         # 'mail_admins': {
#         #     'level': 'ERROR',
#         #     'class': 'django.utils.log.AdminEmailHandler',
#         #     'formatter': 'first_formatter',
#         # },
#     },
#     'loggers': {
#         'main': {
#             'handlers': ['file', 'console'],
#             'propagate': True,
#             'level': "INFO",
#         },
#         # 'django.request': {
#         #     'handlers': ['mail_admins'],
#         #     'level': 'ERROR',
#         #     'propagate': False,
#         # },
#     }
# }

NEW_SIDE_BAR = False

VIEW_GROUPS = True
