import ast
import traceback
from datetime import datetime, timedelta

from decimal import Decimal

from typing import Any

from dateutil.relativedelta import relativedelta
from django.db.models.functions import Coalesce, Trim
from django.views.generic import TemplateView, FormView, ListView
from django.utils.dateparse import parse_date
from num2words import num2words


from dateutil import parser
from dateutil.relativedelta import relativedelta
from django.contrib import messages
from django.contrib.auth import update_session_auth_hash
from django.contrib.auth.forms import PasswordChangeForm
from django.core.exceptions import ObjectDoesNotExist
from django.core.mail import BadHeaderError
from django.core.paginator import Paginator, PageNotAnInteger, EmptyPage
from django.core.serializers.json import DjangoJSONEncoder
from django.db import IntegrityError
from django.db.models import F, Count, Q, FloatField, Case, When, Value, CharField, Func, OuterRef, Subquery
from django.db.models.functions import Coalesce
from django.http import HttpResponseRedirect, HttpResponse, JsonResponse, Http404
from django.shortcuts import render, get_object_or_404, redirect
from django.urls import reverse_lazy
from django.utils import timezone
from django.utils.dateparse import parse_date
from django.utils.decorators import method_decorator
from django.views import View
from django.views.decorators.csrf import csrf_exempt
from django.views.generic import TemplateView, FormView, ListView
from num2words import num2words

from accounts.models import User, Permissions, Staff, Business, Salutation, Position, Role, Biodata
from accounts.permission_mixin import BusinessUserMixin, ViewPermissionsMixin
from loans.models import GeneralCharge, LoanTypes
from loans.models import Loans
from loans.utils.loan_details import get_business_loans_context_data
from sacco.constants import UPDATE, DELETE, FAILED, UPLOAD, ACCOUNT, CREATE, PORTAL
from sacco.decorators import can_do_this
from sacco.forms import (AddMemberForm, EditMemberForm, EditStaffForm, AddStaffForm, AddAccountForm, AddAccountTypeForm, \
                         FinanceYearForm, ChangeStaffPassword, EditStaffProfileForm, WithdrawForm, DepositForm,
                         EditGroupForm, EditGroupMemberForm, IndDepositForm, IndWithForm, SmsSettingForm,
                         EditChargeForm, AddGroupMemberForm, AddGroupAccountForm)
from sacco.models import *
from sacco.new_member_forms import AddGroupForm
from sacco.rq_task import upload_member, bulk_member_deposit, upload_new_members
from sacco.utils import *
from transactions.models import Transactions, Account, AccountCategory, SharesTransactions, StaffLedgerAssociated
from utils.file_uploads import make_thubnail
from utils.general import dial_country_code, proper_dial, random_with_N_digits


# extendable permission view
class PermView(BusinessUserMixin, ViewPermissionsMixin, View):
    perm_name = None
    perm_description = None
    deco_role = None

    def has_permissions(self):
        if self.perm_name:
            perms, created = Permissions.objects.get_or_create(item_name=self.perm_name)
            user_role = self.request.user.staff.position
            print('user_role', user_role)
            perms_in_role = list(user_role.permissions.all().values_list('id', flat=True))
            return perms.id in perms_in_role
        return True

class Index(BusinessUserMixin, View):
    template_name = 'sacco/index.html'

    def get(self, request, *args, **kwargs):
        business_context = session_business_data(request)
        data_context = determine_business_id_list(request.user.staff, business_context)

        the_current_branch_name = ''
        if business_context is None:
            the_current_branch_name = 'all branches'
        else:
            # get the current branch
            the_current_branch_name = Branch.objects.filter(business=business_context).first().name


        the_filter_branch = ''
        if business_context is None:
            business_filter = request.GET.get('business_filter', '')
            if business_filter:
                if business_filter != 'all_branches':
                    # get the branch
                    the_filter_branch = Branch.objects.filter(business_id=business_filter).first().name
                    # update the data context businesses
                    data_context['all_ids'] = [business_filter]
                else:
                    the_filter_branch = 'all branches'


        if data_context['title'] == 'all branches':
            title = 'Central Dashboard for all branches'
        else:
            title = f'Dashboard for {the_current_branch_name}'

        user = self.request.user
        business = biz_data(user) # business to which this user belongs
        branch = biz_staff_branch(user) # branch to which this user belongs

        clients = Member.objects.filter(branch__business_id__in=data_context['all_ids'], is_active=True).exclude(is_group=True)
        individuals = Member.objects.filter(branch__business_id__in=data_context['all_ids'], is_group=False, is_active=True)
        groups = Member.objects.filter(branch__business_id__in=data_context['all_ids'], is_group=True, is_active=True)
        male = Member.objects.filter(branch__business_id__in=data_context['all_ids'], biodata__gender='M')
        female = Member.objects.filter(branch__business_id__in=data_context['all_ids'], biodata__gender='F')
        unknown = Member.objects.filter(branch__business_id__in=data_context['all_ids'], biodata__gender__isnull=True)
        business_currency = CurrencySetting.objects.filter(business=businessdata(request)).first()
        business_shares = BusinessShares.objects.filter(business_id__in=data_context['all_ids'])
        business_setting = OtherSettings.objects.filter(business_id__in=data_context['all_ids'])
        individuals = Member.objects.filter(branch__business_id__in=data_context['all_ids'], is_group=False, is_active=True)
        groups = Member.objects.filter(branch__business_id__in=data_context['all_ids'], is_group=True, is_active=True)
        male = Member.objects.filter(branch__business_id__in=data_context['all_ids'], biodata__gender='M')
        female = Member.objects.filter(branch__business_id__in=data_context['all_ids'], biodata__gender='F')
        unknown = Member.objects.filter(branch__business_id__in=data_context['all_ids'], biodata__gender__isnull=True)
        business_currency = CurrencySetting.objects.filter(business=businessdata(request)).first()
        business_shares = BusinessShares.objects.filter(business_id__in=data_context['all_ids'])
        business_setting = OtherSettings.objects.filter(business_id__in=data_context['all_ids'])
        # cap = business_shares.market_cap #-- original
        cap = business_shares.aggregate(total=Sum('market_cap'))['total']
        if cap is None:
            cap = 0

        # price = business_setting.share_price #-- original
        # determine average of the price
        price = business_setting.aggregate(total=Sum('share_price'))['total']
        if price is None:
            price = 0
        price = round(price/len(data_context['all_ids']),2)

        # sold = business_shares.sold #-- original
        sold = business_shares.aggregate(total=Sum('sold'))['total']
        if sold is None:
            sold = 0

        # loan_receivables = Account.objects.filter(name='Loan Receivables', business=business).first() #-- original
        loan_receivables = list(Account.objects.filter(name='Loan Receivables', business_id__in=data_context['all_ids']).values_list('id', flat=True))
        # loan_interest_receivables = Account.objects.filter(name='Loan interest receivables', business=business).first() #-- original
        loan_interest_receivables = list(Account.objects.filter(name='Loan interest receivables', business_id__in=data_context['all_ids']).values_list('id', flat=True))

        loans = Transactions.objects.filter(branch__business_id__in=data_context['all_ids'])
        amount_out = loans.filter(account_dr_id__in=loan_receivables).aggregate(
            debits=Coalesce(Sum('reporting_amount'), 0.0, output_field=FloatField()))['debits']
        amount_in = loans.filter(account_cr_id__in=loan_receivables).aggregate(
            credits=Coalesce(Sum('reporting_amount'), 0.0, output_field=FloatField()))['credits']
        debits_int_ = loans.filter(account_dr_id__in=loan_interest_receivables).aggregate(
            total=Coalesce(Sum('reporting_amount'), 0.0, output_field=FloatField()))['total']
        credits_int = loans.filter(account_cr_id__in=loan_interest_receivables).aggregate(
            total=Coalesce(Sum('reporting_amount'), 0.0, output_field=FloatField()))['total']
        given_out = "{:0,.2f}".format(float(amount_out))
        received = "{:0,.2f}".format(float(amount_in))
        interest_received = "{:0,.2f}".format(float(credits_int))
        at_risk = "{:0,.2f}".format(float(amount_out - amount_in))

        if cap < 1 or price < 1:
            shares = 0
        else:
            shares = cap / price
        shares_sold = sold
        if cap < 1 or price < 1:
            share_balance = 0
        else:
            share_balance = cap / price - sold

        saving = MemberAccount.objects.filter(account__business_id__in=data_context['all_ids']).distinct().aggregate(
            total=Sum('balance')).values()
        try:
            if list(saving)[0] is None:
                savings = 0
            else:
                savings = list(saving)[0]
        except IndexError:
            savings = 0
        except Exception as e:
            savings = 0
            # print(str(e))
        saving_products = AccountTypes.objects.filter(business_id__in=data_context['all_ids'])
        loan_products = LoanTypes.objects.filter(business_id__in=data_context['all_ids'])
        active_loans = Loans.objects.filter(branch__business_id__in=data_context['all_ids'], loan_status=3)
        members = MemberAccount.objects.filter(account__business_id__in=data_context['all_ids'])
        member_withdraw = \
            list(Transactions.objects.filter(transaction_type='Withdraw',
                                             branch__business_id__in=data_context['all_ids']).aggregate(
                total=Sum('reporting_amount')).values())[0]
        if member_withdraw is None:
            total_withdraw = 0
        else:
            total_withdraw = member_withdraw

        total_member_accounts = AccountBroker.objects.filter(business_id__in=data_context['all_ids'], members__is_active=True, members__is_group=False, ).count()
        total_group_accounts = AccountBroker.objects.filter(business_id__in=data_context['all_ids'], members__is_active=True, members__is_group=True, ).count()

        return render(request, self.template_name, locals())

"""
PUSHED IN DEVEOPX with some ui changes and context changes
class Index(BusinessUserMixin, View):
    template_name = 'sacco/index.html'
    index_template_name = 'sacco/index.html'
    central_index_template_name = 'sacco/central_index.html'

    def get_index(self, request, *args, **kwargs):
        title = 'Dashboard'
        user = self.request.user
        business = biz_data(user)
        branch = biz_staff_branch(user)

        clients = Member.objects.filter(branch__business=businessdata(request))
        individuals = Member.objects.filter(branch__business=businessdata(request), is_group=False, is_active=True)
        groups = Member.objects.filter(branch__business=businessdata(request), is_group=True, is_active=True)
        male = Member.objects.filter(branch__business=businessdata(request), biodata__gender='M')
        female = Member.objects.filter(branch__business=businessdata(request), biodata__gender='F')
        unknown = Member.objects.filter(branch__business=businessdata(request), biodata__gender__isnull=True)
        business_currency = CurrencySetting.objects.filter(business=businessdata(request)).first()
        business_shares = BusinessShares.objects.filter(business=businessdata(request)).first()
        business_setting = OtherSettings.objects.filter(business=businessdata(request)).first()
        cap = business_shares.market_cap
        price = business_setting.share_price
        sold = business_shares.sold
        loan_receivables = Account.objects.filter(name='Loan Receivables', business=business).first()
        loan_interest_receivables = Account.objects.filter(name='Loan interest receivables', business=business).first()
        loans = Transactions.objects.filter(branch=branch)
        amount_out = loans.filter(account_dr=loan_receivables).aggregate(
            debits=Coalesce(Sum('reporting_amount'), 0.0, output_field=FloatField()))['debits']
        amount_in = loans.filter(account_cr=loan_receivables).aggregate(
            credits=Coalesce(Sum('reporting_amount'), 0.0, output_field=FloatField()))['credits']
        debits_int_ = loans.filter(account_dr=loan_interest_receivables).aggregate(
            total=Coalesce(Sum('reporting_amount'), 0.0, output_field=FloatField()))['total']
        credits_int = loans.filter(account_cr=loan_interest_receivables).aggregate(
            total=Coalesce(Sum('reporting_amount'), 0.0, output_field=FloatField()))['total']
        given_out = "{:0,.2f}".format(float(amount_out))
        received = "{:0,.2f}".format(float(amount_in))
        interest_received = "{:0,.2f}".format(float(credits_int))
        at_risk = "{:0,.2f}".format(float(amount_out - amount_in))

        if cap < 1 or price < 1:
            shares = 0
        else:
            shares = cap / price
        shares_sold = sold
        if cap < 1 or price < 1:
            share_balance = 0
        else:
            share_balance = cap / price - sold

        saving = MemberAccount.objects.filter(account__business=businessdata(request)).distinct().aggregate(
            total=Sum('balance')).values()
        try:
            if list(saving)[0] is None:
                savings = 0
            else:
                savings = list(saving)[0]
        except IndexError:
            savings = 0
        except Exception as e:
            savings = 0
            # print(str(e))
        saving_products = AccountTypes.objects.filter(business=businessdata(request))
        loan_products = LoanTypes.objects.filter(business=businessdata(request))
        active_loans = Loans.objects.filter(branch__business=businessdata(request), loan_status=3)
        members = MemberAccount.objects.filter(account__business=businessdata(request))
        member_withdraw = \
            list(Transactions.objects.filter(transaction_type='Withdraw',
                                             branch__business=businessdata(request)).aggregate(
                total=Sum('reporting_amount')).values())[0]
        if member_withdraw is None:
            total_withdraw = 0
        else:
            total_withdraw = member_withdraw

        return render(request, self.index_template_name, locals())

    def get_selected_business_index(self, request, *args, **kwargs):
        title = 'Dashboard'
        user = self.request.user
        business = biz_data(user)
        branch = biz_staff_branch(user)

        clients = Member.objects.filter(branch__business=session_business_id(request))
        individuals = Member.objects.filter(branch__business=session_business_id(request), is_group=False, is_active=True)
        groups = Member.objects.filter(branch__business=session_business_id(request), is_group=True, is_active=True)
        male = Member.objects.filter(branch__business=session_business_id(request), biodata__gender='M')
        female = Member.objects.filter(branch__business=session_business_id(request), biodata__gender='F')
        unknown = Member.objects.filter(branch__business=session_business_id(request), biodata__gender__isnull=True)
        business_currency = CurrencySetting.objects.filter(business=session_business_id(request)).first()
        business_shares = BusinessShares.objects.filter(business=session_business_id(request)).first()
        business_setting = OtherSettings.objects.filter(business=session_business_id(request)).first()
        cap = business_shares.market_cap
        price = business_setting.share_price
        sold = business_shares.sold
        loan_receivables = Account.objects.filter(name='Loan Receivables', business=session_business_data(request)).first()
        loan_interest_receivables = Account.objects.filter(name='Loan interest receivables', business=session_business_data(request)).first()
        loans = Transactions.objects.filter(branch=branch)
        amount_out = loans.filter(account_dr=loan_receivables).aggregate(
            debits=Coalesce(Sum('reporting_amount'), 0.0, output_field=FloatField()))['debits']
        amount_in = loans.filter(account_cr=loan_receivables).aggregate(
            credits=Coalesce(Sum('reporting_amount'), 0.0, output_field=FloatField()))['credits']
        debits_int_ = loans.filter(account_dr=loan_interest_receivables).aggregate(
            total=Coalesce(Sum('reporting_amount'), 0.0, output_field=FloatField()))['total']
        credits_int = loans.filter(account_cr=loan_interest_receivables).aggregate(
            total=Coalesce(Sum('reporting_amount'), 0.0, output_field=FloatField()))['total']
        given_out = "{:0,.2f}".format(float(amount_out))
        received = "{:0,.2f}".format(float(amount_in))
        interest_received = "{:0,.2f}".format(float(credits_int))
        at_risk = "{:0,.2f}".format(float(amount_out - amount_in))

        if cap < 1 or price < 1:
            shares = 0
        else:
            shares = cap / price
        shares_sold = sold
        if cap < 1 or price < 1:
            share_balance = 0
        else:
            share_balance = cap / price - sold

        saving = MemberAccount.objects.filter(account__business=session_business_id(request)).distinct().aggregate(
            total=Sum('balance')).values()
        try:
            if list(saving)[0] is None:
                savings = 0
            else:
                savings = list(saving)[0]
        except IndexError:
            savings = 0
        except Exception as e:
            savings = 0
            # print(str(e))
        saving_products = AccountTypes.objects.filter(business=session_business_id(request))
        loan_products = LoanTypes.objects.filter(business=session_business_id(request))
        active_loans = Loans.objects.filter(branch__business=session_business_id(request), loan_status=3)
        members = MemberAccount.objects.filter(account__business=session_business_id(request))
        member_withdraw = \
            list(Transactions.objects.filter(transaction_type='Withdraw',
                                             branch__business=session_business_id(request)).aggregate(
                total=Sum('reporting_amount')).values())[0]
        if member_withdraw is None:
            total_withdraw = 0
        else:
            total_withdraw = member_withdraw

        return render(request, self.index_template_name, locals())

    def get_central_index(self, request, *args, **kwargs):
        title = 'Central Dashboard'
        user = self.request.user

        # Get all businesses data instead of filtering by business
        clients = Member.objects.all()
        individuals = Member.objects.filter(is_group=False, is_active=True)
        groups = Member.objects.filter(is_group=True, is_active=True)
        male = Member.objects.filter(biodata__gender='M')
        female = Member.objects.filter(biodata__gender='F')
        unknown = Member.objects.filter(biodata__gender__isnull=True)

        # Aggregate savings across all businesses
        savings = MemberAccount.objects.all().aggregate(
            total=Coalesce(Sum('balance'), 0.0, output_field=FloatField()))['total']

        # Get all active loans across businesses
        active_loans = Loans.objects.filter(loan_status=3)

        # Aggregate withdrawals across all businesses
        total_withdraw = Transactions.objects.filter(
            transaction_type='Withdraw'
        ).aggregate(
            total=Coalesce(Sum('reporting_amount'), 0.0, output_field=FloatField())
        )['total']

        # Aggregate loan data across all businesses
        loan_receivables = Account.objects.filter(name='Loan Receivables')
        loan_interest_receivables = Account.objects.filter(name='Loan interest receivables')
        loans = Transactions.objects.all()

        # Calculate loan amounts
        amount_out = loans.filter(account_dr__in=loan_receivables).aggregate(
            debits=Coalesce(Sum('reporting_amount'), 0.0, output_field=FloatField()))['debits']
        amount_in = loans.filter(account_cr__in=loan_receivables).aggregate(
            credits=Coalesce(Sum('reporting_amount'), 0.0, output_field=FloatField()))['credits']
        debits_int_ = loans.filter(account_dr__in=loan_interest_receivables).aggregate(
            total=Coalesce(Sum('reporting_amount'), 0.0, output_field=FloatField()))['total']
        credits_int = loans.filter(account_cr__in=loan_interest_receivables).aggregate(
            total=Coalesce(Sum('reporting_amount'), 0.0, output_field=FloatField()))['total']

        # Format currency values
        given_out = "{:0,.2f}".format(float(amount_out))
        received = "{:0,.2f}".format(float(amount_in))
        interest_received = "{:0,.2f}".format(float(credits_int))
        at_risk = "{:0,.2f}".format(float(amount_out - amount_in))

        # Aggregate shares data across businesses
        total_shares = BusinessShares.objects.aggregate(
            total_cap=Coalesce(Sum('market_cap'), 0.0, output_field=FloatField()),
            total_sold=Coalesce(Sum('sold'), 0.0, output_field=FloatField())
        )
        shares_sold = total_shares['total_sold']
        share_balance = total_shares['total_cap'] - shares_sold if total_shares['total_cap'] > 0 else 0

        # Get all businesses for comparison
        businesses = Business.objects.all()

        # Get business-specific metrics for comparison
        business_metrics = []
        for business in businesses:
            metrics = {
                'name': business.name,
                'total_clients': Member.objects.filter(branch__business=business).count(),
                'total_loans': Loans.objects.filter(branch__business=business, loan_status=3).count(),
                'total_savings': MemberAccount.objects.filter(
                    account__business=business
                ).aggregate(
                    total=Coalesce(Sum('balance'), 0.0, output_field=FloatField())
                )['total'] or 0,
            }
            business_metrics.append(metrics)

        context = {
            'title': title,
            'clients': clients,
            'individuals': individuals,
            'groups': groups,
            'male': male,
            'female': female,
            'unknown': unknown,
            'savings': savings,
            'total_withdraw': total_withdraw,
            'active_loans': active_loans,
            'given_out': given_out,
            'received': received,
            'interest_received': interest_received,
            'at_risk': at_risk,
            'shares_sold': shares_sold,
            'share_balance': share_balance,
            'businesses': businesses,
            'business_metrics': business_metrics,
        }

        return render(request, self.central_index_template_name, context)

    def get(self, request, *args, **kwargs):
        try:
            business_context = session_business_data(request)

            if business_context is None:
                # central (all businesses context)
                return self.get_central_index(request, *args, **kwargs)

            # else (specified business context)
            return self.get_selected_business_index(request, *args, **kwargs)

            # else (specified business context)
            # return self.get_index(request, *args, **kwargs)

        except Exception as exception:
            raise exception
            
            
"""


class MyBusinessProfile(BusinessUserMixin, View):
    template_name = 'sacco/business_profile.html'

    def get(self, request, *args, **kwargs):
        business = request.user.staff.biodata.business
        title = f'{business.name} Profile'
        clients = Member.objects.filter(biodata__business=business, is_active=True, is_group=False)
        groups = Member.objects.filter(biodata__business=business, is_active=True, is_group=True)
        staffs = Staff.objects.filter(biodata__business=business, is_active=True)
        users = User.objects.filter(staff__biodata__business=business, is_active=True)
        sms = Sms.objects.filter(branch__business=business)
        branches = Branch.objects.filter(business=business, status=1)
        contacts = Staff.objects.filter(biodata__business=business, is_contact=True, is_active=True)

        return render(request, self.template_name, locals())


class Members(PermView):
    template_name = 'sacco/members.html'
    perm_name = 'view_member'

    def get(self, request, *args, **kwargs):
        business_context = session_business_data(request)
        data_context = determine_business_id_list(request.user.staff, business_context)

        the_current_branch_name = ''
        if business_context is None:
            the_current_branch_name = 'all branches'
        else:
            # get the current branch
            the_current_branch_name = Branch.objects.filter(business=business_context).first().name

        the_filter_branch = ''
        business_filter = ''
        if business_context is None:
            business_filter = request.GET.get('business_filter', '')
            if business_filter:
                if business_filter != 'all_branches':
                    # get the branch
                    the_filter_branch = Branch.objects.filter(business_id=business_filter).first().name
                    # update the data context businesses
                    data_context['all_ids'] = [business_filter]
                else:
                    the_filter_branch = 'all branches'

        if data_context['title'] == 'all branches':
            title = 'Members for all branches'
        else:
            title = f'Members for {the_current_branch_name}'

        # get the start date and end date
        start_date_str = request.GET.get('start_date', '')
        end_date_str = request.GET.get('end_date', '')
        member_name = request.GET.get('member_name', '')

        # recalculate_shares(branchdata(request))
        # recalculate_savings(businessdata(request))
        # trigger update of the member account balance

        # business = businessdata(request)
        # acc_types = AccountTypes.objects.filter(status=True, business=business)
        # accts = Account.objects.filter(business=business,
        #                                category__name__in=['Mobile Money', 'Cash', 'Bank', 'Account Receivables'])
        try:
            members_l = Member.objects.filter(biodata__business_id__in=data_context['all_ids'], is_active=True, is_group=False)
            registration_title = 'Showing members registered'
            start_date = parse_date(start_date_str) if start_date_str else None
            end_date = parse_date(end_date_str) if end_date_str else None
            print(start_date, end_date)
            print(type(start_date), type(end_date))
            if start_date:
                members_l = members_l.filter(date_joined__gte=start_date)
                registration_title = f'{registration_title} from {start_date_str}'
            if end_date:
                members_l = members_l.filter(date_joined__lte=end_date)
                registration_title = f'{registration_title} to {end_date_str}'

            if member_name:
                members_l = members_l.filter(biodata__name__icontains=member_name.strip())

            page = request.GET.get('page', 1)

            paginator = Paginator(members_l, 15)
            try:
                members_list = paginator.page(page)
            except PageNotAnInteger:
                members_list = paginator.page(1)
            except EmptyPage:
                members_list = paginator.page(paginator.num_pages)
        except AttributeError:
            return HttpResponseRedirect(reverse_lazy('index'))
        context = {
            'members_list': members_list,
            'members_l': members_l,
            'title': title,
            # 'acc_types': acc_types,
            # 'accts': accts,
            'registration_title': registration_title,
            'start_date_str': start_date_str,
            'end_date_str': end_date_str,
            'business_filter':business_filter,
            'member_name':member_name

        }
        return render(request, self.template_name, context)

    def post(self, request, *args, **kwargs):
        biz = Business.objects.filter(id=businessdata(request)).first()
        current_transaction = date.today()
        fy = FinancialYear.objects.filter(start_date__lte=current_transaction,
                                          end_date__gte=current_transaction, status=True).first()
        # print(fy)
        account_type = request.POST.get('account_type')
        open_bal = request.POST.get('open_bal_date')
        if fy is not None:
            if 'upload' in request.POST:
                file = request.FILES.get('file')
                if file:
                    try:
                        upload = upload_member(file, request.user, biz, account_type, fy, open_bal)
                        members_count = Member.objects.filter(member_upload=upload).count()
                        if members_count > 0:
                            messages.success(request, 'success', extra_tags='Successfully Uploaded excel')
                            log_title = 'Excel Upload'
                            message = f"{request.user.staff.biodata.name} Uploaded member's excel"

                            ActivityLog.objects.create(actor=request.user, title=log_title, action_type=UPLOAD,
                                                       remarks=message, branch=branch_id(request.user))
                        else:
                            messages.error(self.request, 'success', extra_tags='Upload failed')
                        return HttpResponseRedirect(reverse_lazy('members'))

                    except Exception as e:
                        logger.error(traceback.print_exc())
                        messages.error(request, 'error', extra_tags='Error uploading excel file')
                        log_title = 'Excel Upload failed'
                        message = f"{request.user.staff.biodata.name} failed to successfully Upload member's excel"

                        ActivityLog.objects.create(actor=request.user, title=log_title, action_type=UPLOAD,
                                                   remarks=message, status=FAILED, branch=branch_id(request.user))
                    return HttpResponseRedirect(reverse_lazy('members'))
            elif 'new_member' in request.POST:
                acct = request.POST['acct']
                newfile = request.FILES.get('new_member_file')
                if newfile:
                    try:
                        upload = upload_new_members(newfile, request.user, biz, account_type, acct)
                        members_count = Member.objects.filter(member_upload=upload).count()
                        if members_count > 0:
                            messages.success(request, 'success', extra_tags='Successfully Uploaded excel')
                            log_title = 'Excel Upload'
                            message = f"{request.user.staff.biodata.name} Uploaded member's excel"
                            ActivityLog.objects.create(actor=request.user, title=log_title, action_type=UPLOAD,
                                                       remarks=message,
                                                       branch=branch_id(request.user))
                        else:
                            messages.error(self.request, 'success', extra_tags='Upload failed')
                        return HttpResponseRedirect(reverse_lazy('members'))
                    except Exception as e:
                        # print(str(e))
                        logger.error(traceback.print_exc())
                        # traceback.print_exc()
                        messages.error(request, 'error', extra_tags='Error uploading excel file')
                        log_title = 'Excel Upload failed'
                        message = f"{request.user.staff.biodata.name} failed to successfully Upload member's excel"
                        ActivityLog.objects.create(actor=request.user, title=log_title, action_type=UPLOAD,
                                                   remarks=message, status=FAILED, branch=branch_id(request.user))
                        return HttpResponseRedirect(reverse_lazy('members'))
        else:
            messages.error(request, 'error', extra_tags='Financial year not set')
            log_title = 'Excel Upload failed'
            message = f"{request.user.staff.biodata.name} failed to successfully Upload member's excel"
            ActivityLog.objects.create(actor=request.user, title=log_title, action_type=UPLOAD,
                                       remarks=message, status=FAILED, branch=branch_id(request.user))
            return HttpResponseRedirect(reverse_lazy('members'))
        return render(request, self.template_name, locals())


class SearchMember(BusinessUserMixin, View):
    template_name = 'sacco/member_search.html'

    def get(self, request, *args, **kwargs):
        members = Member.objects.filter(biodata__business=businessdata(request), is_active=True, is_group=False)
        return render(request, self.template_name, locals())

    def post(self, request, *args, **kwargs):
        search_text = request.POST['search_text']
        if search_text is not None and search_text != u"":
            search_text = request.POST['search_text']
            request.session['search_member'] = search_text
            members = Member.objects.filter(biodata__business=businessdata(request),
                                            biodata__name__icontains=search_text, is_active=True, is_group=False)
        else:
            members = Member.objects.filter(biodata__business=businessdata(request), is_active=True, is_group=False)
        return HttpResponse(render_to_string(self.template_name, locals()))


# ==========ADD MEMBER ==================================
class AddMember(PermView):
    template_name = 'sacco/add_member.html'
    form_class = AddMemberForm
    perm_name = 'add_member'

    def get(self, request, *args, **kwargs):
        title = 'Add member'
        form = self.form_class
        salutations = Salutation.objects.all()
        current_transaction = date.today()

        acc_types = AccountTypes.objects.filter(status=True, business=businessdata(request))
        biz = Business.objects.filter(id=businessdata(request)).first()
        accounts_ = Account.objects.filter(business=businessdata(request),
                                           category__name__in=['Mobile Money', 'Cash', 'Bank'])
        onRegistration = OtherSettings.objects.get(business_id=businessdata(request)).set_ordinary

        return render(request, self.template_name, locals())

    # =========POSTING ADD MEMBER FORM DATA=========================
    def post(self, request, *args, **kwargs):
        try:
            user = request.user
            current_transaction = date.today()
            account_type = request.POST.get('account_type')
            member_type = request.POST.get('member_type')
            initial_shares = request.POST.get('initial_shares')
            share_select = request.POST.get('share_select')
            raw_initial = request.POST.get('initial')
            initial_before = float(raw_initial.replace(',', ''))
            initial = float(initial_before)
            # print('my initia', initial)
            fy = FinancialYear.objects.filter(start_date__lte=current_transaction,
                                              end_date__gte=current_transaction, status=True)
            the_account_type = AccountTypes.objects.filter(id=account_type).first()
            biz = biz_data(user)

            if fy.exists():
                financial_year = fy.first()
                form = self.form_class(request.POST, user=user, finance_year=financial_year, initial=initial)
                charge = int(check_charges(account_type, member_type, initial, user, initial_shares, share_select))
                # print('de charge', charge)
                min_balance = the_account_type.min_balance
                # print('de min', min_balance)

                if raw_initial and account_type:
                    # print('fine')
                    if int(initial) >= charge + min_balance:
                        if not biz.auto_acc_no:
                            account_number = request.POST.get('account_number', None)
                            if account_number:
                                if check_account(account_number, request.user):
                                    return JsonResponse({'msg': 'error', 'type': 'error',
                                                         'extra': 'Account number already taken'})
                            else:
                                return JsonResponse({'msg': 'error', 'type': 'error',
                                                     'extra': 'Account number not provided'})
                        if form.is_valid():
                            form.save()
                            log_title = 'New Member'
                            message = f"{request.user.staff.biodata.name} added a new member"
                            ActivityLog.objects.create(actor=request.user, title=log_title,
                                                       action_type=CREATE,
                                                       remarks=message,
                                                       branch=branch_id(request.user))
                            return JsonResponse({'msg': 'success', 'extra': 'Successfully Added member'})
                        else:
                            form_error = str(form.errors.as_json())
                            the_error = json.loads(form_error)
                            display = the_error['__all__'][0]['message']
                            log_title = 'New Member'
                            message = f"{request.user.staff.biodata.name} added a new member"
                            ActivityLog.objects.create(actor=request.user, title=log_title,
                                                       action_type=CREATE,
                                                       remarks=message, status=FAILED,
                                                       branch=branch_id(request.user))

                            return JsonResponse({'msg': 'balance', 'type': 'error', 'extra': display})
                    else:
                        return JsonResponse({
                            'msg': 'error', 'extra': 'Insufficient amount to cater for charges of {} '
                                                     'and minimum balance of {}'.format(charge, min_balance)})
                else:
                    return JsonResponse({'msg': 'error', 'extra': 'Initial deposit required'})
            else:
                # messages.error(request, 'error', extra_tags='Please Set current financial year')
                return JsonResponse({'msg': 'error', 'extra': 'Financial Year not set'})
        except Exception as e:
            logger.info(str(e))
            return JsonResponse({'msg': 'error', 'extra': 'failed to submit form'})

class UpdateAccountNumber(PermView):
    perm_name = 'update_account_number'

    def post(self, request, pk, *args, **kwargs):
        # check if the account exists
        the_acc = AccountBroker.objects.filter(id=pk)
        if not the_acc.exists():
            messages.error(request, 'error', extra_tags='Account nolonger exists')
            return redirect(request.META.get('HTTP_REFERER', '/'))
        # check if the acc number exists
        new_account_number = request.POST['new_account_number'].strip()
        check_broker = (
            AccountBroker.objects.annotate(stripped_acc_number=Trim(F("the_account__acc_number")))
            .filter(stripped_acc_number=new_account_number.strip())
            .exclude(id=pk)
        )
        if check_broker.exists():
            messages.error(request, 'error', extra_tags='Account number is already being used')
            return redirect(request.META.get('HTTP_REFERER', '/'))

        # update the account number
        the_actual_acc_id = the_acc.first().the_account.id
        MemberAccount.objects.filter(id=the_actual_acc_id).update(
            acc_number=new_account_number
        )
        messages.success(request, 'success', extra_tags='Account successfully updated')
        return redirect(request.META.get('HTTP_REFERER', '/'))


class MemberDetail(PermView):
    template_name = 'sacco/member_detail.html'
    perm_name = 'view_member'
    form_class = AddAccountForm

    def get_member(self, request):
        pkey = self.kwargs.get("pk")
        business_context = get_business_loans_context_data(request)
        member = get_object_or_404(Member, id=pkey, is_active=True, biodata__business_id__in=business_context['data_context'])
        return member

    def get(self, request, pk, *args, **kwargs):
        business_context = get_business_loans_context_data(request)
        form = self.form_class
        accts = []
        member = self.get_member(request)
        title = f'{member.biodata.name}'
        if 'data' in request.session:
            del request.session['data']
        member_accounts = AccountBroker.objects.filter(members=member).select_related('the_account')
        # print('MEM ACCOUNTS',member_accounts)
        acc_types = AccountTypes.objects.filter(status=True, business_id__in=business_context['data_context'])
        biz = Business.objects.filter(id=businessdata(request)).first()
        accounts_ = Account.objects.filter(business_id__in=business_context['data_context'],
                                           category__name__in=['Mobile Money', 'Cash', 'Bank'])
        for account in member_accounts:
            accts.append(account.the_account)
        recalculate_ind_savings(accts)
        member_loans = Loans.objects.filter(account__in=accts)

        combine = Transactions.objects.filter(Q(account_cr__member__in=accts) | Q(account_dr__member__in=accts)
                                              ).annotate(account=F('account_cr__member__acc_number')).values(
            'transaction_type', 'reporting_amount', 'narration', 'date_added', 'account', 'tx_date', 'id',
            'receipt').order_by('-tx_date', '-date_added')
        shares_trans = SharesTransactions.objects.filter(Q(seller=member) | Q(buyer=member)).order_by('-date')

        page = request.GET.get('page', 1)
        paginator = Paginator(combine, 10)
        try:
            combined = paginator.page(page)
        except PageNotAnInteger:
            combined = paginator.page(1)
        except EmptyPage:
            combined = paginator.page(paginator.num_pages)

        account_types = AccountTypes.objects.filter(business_id__in=business_context['data_context'])

        accounts_ = Account.objects.filter(business_id__in=business_context['data_context'], category__name__in=['Mobile Money', 'Cash',
                                                                                               'Bank'])

        initial_deposit = Transactions.objects.filter(transaction_type='Initial deposit',
                                                      account_cr__member__in=accts).order_by('-date_added')
        other_deposits = Transactions.objects.filter(Q(account_cr__member__in=accts) | Q(
            account_dr__member__in=accts)).filter(transaction_type='Deposit').order_by('-date_added')

        deposits = initial_deposit.union(other_deposits).order_by('-date_added')

        # determine unwithdrawable amt
        # Needs to be improved
        the_active_loans = Loans.objects.filter(account__in=accts, loan_status=3)
        saving_not_withdrawable = 0
        if the_active_loans.exists():
            saving_not_withdrawable = the_active_loans.aggregate(total=Sum("savings_rem_balance"))["total"]

        # print(member_accounts.first().the_account.id)
        http = 'http://' if not request.is_secure() else 'https://'

        baseUrl = request.headers['HOST']
        baseUrl = http + baseUrl

        # select branches
        if business_context['branch'] is not None:
            biz_ids_needed = list(
                Business.objects.filter(instance_type=business_context['branch'].business.instance_type).values_list('id',
                                                                                                                 flat=True))
            select_branches = Branch.objects.filter(business_id__in=biz_ids_needed).exclude(id=member.branch.id)
        else:
            select_branches = []

        return render(request, self.template_name, locals())

    def post(self, request, pk, *args, **kwargs):
        business_context = get_business_loans_context_data(request)
        member = self.get_member(request)
        current_transaction = datetime.datetime.today()
        # print(type(current_transaction.date()))
        return_url = request.META.get('HTTP_REFERER', '/')
        business = biz_data(self.request.user)

        if 'add_account' in request.POST:
            account_type = request.POST['account_type']
            raw_initial = request.POST.get('initial')
            initial_before = float(raw_initial.replace(',', ''))
            initial = float(initial_before)
            the_account_type = AccountTypes.objects.filter(id=account_type).first()
            financial_year = FinancialYear.objects.filter(business_id__in=business_context['data_context'], status=True).first()
            if financial_year is not None:
                form_data = request.POST.copy()
                form_data['is_new'] = 'YES'
                form_data['initial'] = initial
                # print('form data', form_data)
                if financial_year.is_within_financial_year(input_date=current_transaction):
                    form = self.form_class(form_data, user=request.user, finance_year=financial_year, branch=business_context['branch'])
                form = self.form_class(form_data, user=request.user, member=member.id, finance_year=financial_year,
                                       initial=initial, business_context=business_context['data_context'], branch=business_context['branch'])
                charge = check_charges_opening(account_type, initial)
                min_balance = the_account_type.min_balance
                if initial >= min_balance:
                    if initial >= charge + min_balance:
                        if form.is_valid():
                            messages.success(request, 'success', extra_tags='Successfully added account to member')
                            log_title = 'Account Created'
                            form.save()
                            message = f"{request.user.staff.biodata.name} created an account for {member.biodata.name}"
                            ActivityLog.objects.create(actor=request.user, title=log_title,
                                                       action_type=CREATE,
                                                       remarks=message,
                                                       branch=branch_id(request.user))
                            return HttpResponseRedirect(reverse_lazy('member_detail', args=[member.id]))
                        else:
                            form_error = form.errors.as_json()
                            # print('form_error', form_error)
                            messages.error(request, 'error', extra_tags='Account already exists')
                            log_title = 'Account Created'
                            message = f"{request.user.staff.biodata.name} failed to create an account for " \
                                      f"{member.biodata.name}"
                            ActivityLog.objects.create(actor=request.user, title=log_title,
                                                       action_type=CREATE,
                                                       remarks=message,
                                                       status=FAILED,
                                                       branch=branch_id(request.user))
                            return HttpResponseRedirect(reverse_lazy('member_detail', args=[member.id]))
                    else:
                        messages.error(request, 'error',
                                       extra_tags='Insufficient amount to cater for charges of {} '
                                                  'and minimum balance of {}'.format(charge, min_balance))
                        return HttpResponseRedirect(reverse_lazy('member_detail', args=[member.id]))
                else:
                    messages.error(request, 'error',
                                   extra_tags='Should be greater than the minimum deposit {}'.format(min_balance))
                    return HttpResponseRedirect(reverse_lazy('member_detail', args=[member.id]))
            else:
                messages.error(request, 'error', extra_tags='Financial year not set')
                return HttpResponseRedirect(reverse_lazy('member_detail', args=[member.id]))

        http = 'http://' if not request.is_secure() else 'https://'

        baseUrl = request.headers['HOST']
        baseUrl = http + baseUrl

        return render(request, self.template_name, locals())


class EditMember(PermView):
    template_name = 'sacco/member_edit.html'
    form_class = EditMemberForm
    perm_name = 'edit_member'
    perm_description = 'Edit Member'

    def get(self, request, pk, *args, **kwargs):
        business_context = get_business_loans_context_data(request)
        member = get_object_or_404(Member, id=pk, biodata__business_id__in=business_context['data_context'])
        title = f'{member.biodata.name}'
        acc_types = AccountTypes.objects.filter(status=True, business_id__in=business_context['data_context'])
        form = self.form_class(initial={'dob': member.biodata.dob})
        member_accounts = AccountBroker.objects.filter(members=member)
        salutations = Salutation.objects.all()
        contact_dial = dial_country_code(member.biodata.contact)
        other_contact_dial = dial_country_code(member.biodata.other_contact)
        mm_contact_dial = dial_country_code(member.biodata.mobile_money)

        return render(request, self.template_name, locals())

    def post(self, request, pk, *args, **kwargs):
        business_context = get_business_loans_context_data(request)
        member = get_object_or_404(Member, id=pk, is_active=True, biodata__business_id__in=business_context['data_context'])
        form = self.form_class(request.POST)
        if form.is_valid():
            try:
                name = form.cleaned_data.get('name')
                title = form.cleaned_data.get('title')
                gender = form.cleaned_data.get('gender')
                marital_status = form.cleaned_data.get('marital_status')
                dob = form.cleaned_data.get('dob')
                nin = form.cleaned_data.get('nin')
                contact = form.cleaned_data.get('contact')
                other_contact = form.cleaned_data.get('other_contact')
                email = form.cleaned_data.get('email')
                nok = form.cleaned_data.get('nok')
                nok_contacts = form.cleaned_data.get('nok_contacts')
                code = form.cleaned_data.get('code')
                code1 = form.cleaned_data.get('code1')
                code2 = form.cleaned_data.get('code2')
                mm = form.cleaned_data.get('mm')
                country = form.cleaned_data.get('country')
                location = form.cleaned_data.get('location')
                if title:
                    try:
                        salute = Salutation.objects.get(id=title)
                    except Salutation.DoesNotExist:
                        messages.error(request, 'error', extra_tags='Invalid Salutation')
                salute = None

                member.biodata.name = name
                member.biodata.gender = gender
                member.biodata.marital_status = marital_status
                member.biodata.dob = dob
                member.biodata.nin = nin
                member.biodata.contact = proper_dial(contact, code)
                member.biodata.other_contact = proper_dial(other_contact, code1)
                member.biodata.email = email
                member.biodata.nok = nok
                member.biodata.nok_contacts = nok_contacts
                member.biodata.mobile_money = proper_dial(mm, code2)
                member.biodata.title = salute
                member.biodata.country = country
                member.biodata.location = location
                member.save_related()
                messages.success(request, 'success', extra_tags='Member account updated successfully')
                log_title = 'Member Biodata Updated'
                message = f"{request.user.staff.biodata.name} updated {member.biodata.name}"
                ActivityLog.objects.create(actor=request.user, title=log_title,
                                           action_type=UPDATE,
                                           remarks=message,
                                           branch=branch_id(request.user))
                return HttpResponseRedirect(reverse_lazy('member_edit', args=[pk]))
            except Exception as e:
                messages.error(request, 'error', extra_tags=str(e))
                log_title = 'Member Biodata Updated'
                message = f"{request.user.staff.biodata.name} failed to update {member.biodata.name} biodata"
                ActivityLog.objects.create(actor=request.user, title=log_title,
                                           action_type=UPDATE,
                                           remarks=message,
                                           status=FAILED,
                                           branch=branch_id(request.user))
                return HttpResponseRedirect(reverse_lazy('member_edit', args=[pk]))
        return render(request, self.template_name, locals())


class UpdatePhoto(PermView):
    perm_name = 'edit_member'
    perm_description = 'Edit Member'

    def get(self, request, pk, *args, **kwargs):
        business_context = get_business_loans_context_data(request)
        member = get_object_or_404(Member, id=pk, is_active=True, branch__business_id__in=business_context['data_context'])
        if member.is_group:
            return HttpResponseRedirect(reverse_lazy('group_detail', args=[member.id]))
        return HttpResponseRedirect(reverse_lazy('member_detail', args=[member.id]))

    def post(self, request, pk, *args, **kwargs):
        business_context = get_business_loans_context_data(request)
        member = get_object_or_404(Member, id=pk, branch__business_id__in=business_context['data_context'], is_active=True)
        if 'profile_pic' in request.POST:
            dp = request.FILES['photo']
            red = make_thubnail(dp)
            if not member.is_group:
                member.biodata.photo = red
                member.save_related()
                message = f"{request.user.staff.biodata.name} updated {member.biodata.name}'s photo"
            else:
                member.photo = red
                member.save()
                message = f"{request.user.staff.biodata.name} updated {member.name}'s photo"
            messages.success(request, 'success', extra_tags='Successfully updated Photo')
            log_title = 'Member Photo Updated'
            ActivityLog.objects.create(actor=request.user, title=log_title,
                                       action_type=UPDATE,
                                       remarks=message,
                                       branch=branch_id(request.user))
            messages.success(request, 'success', extra_tags='Successfully updated Member Photo')

            if member.is_group:
                return HttpResponseRedirect(reverse_lazy('group_detail', args=[member.id]))
            return HttpResponseRedirect(reverse_lazy('member_detail', args=[member.id]))


class UpdateSignature(PermView):
    perm_name = 'edit_member'
    perm_description = 'Edit Member'

    def get(self, request, pk, *args, **kwargs):
        business_context = get_business_loans_context_data(request)
        member = get_object_or_404(Member, id=pk, is_active=True, biodata__business_id__in=business_context['data_context'])
        return HttpResponseRedirect(reverse_lazy('member_detail', args=[member.id]))

    def post(self, request, pk, *args, **kwargs):
        business_context = get_business_loans_context_data(request)
        member = get_object_or_404(Member, id=pk, biodata__business_id__in=business_context['data_context'])
        if 'update_sign' in request.POST:
            dp = request.FILES['signature']
            # print(dp)
            member.biodata.signature = dp
            member.save_related()
            messages.success(request, 'success', extra_tags='Successfully updated Member signature')
            log_title = 'Member Signature Updated'
            message = f"{request.user.staff.biodata.name} updated {member.biodata.name}'s photo"
            ActivityLog.objects.create(actor=request.user, title=log_title,
                                       action_type=UPDATE,
                                       remarks=message,
                                       branch=branch_id(request.user))

        return HttpResponseRedirect(reverse_lazy('member_detail', args=[member.id]))


class DeactivateMemberView(PermView):
    perm_name = 'delete_member'
    perm_description = 'Delete Member'

    def get(self, request, pk, *args, **kwargs):
        obj = get_object_or_404(Member, id=pk, branch__business=businessdata(request))
        obj.is_active = False
        obj.save()
        messages.success(request, 'success', extra_tags='Successfully deleted member')
        log_title = 'Member deleted'
        message = f"{request.user.staff.biodata.name} deleted {obj.biodata.name}"
        ActivityLog.objects.create(actor=request.user, title=log_title,
                                   action_type=DELETE,
                                   remarks=message,
                                   branch=branch_id(request.user))
        return HttpResponseRedirect(reverse_lazy('members'))


class EnrollMember(BusinessUserMixin, View):
    created_email = 'mufukoadmin/emails/action_email.html'
    perm_name = 'enroll_member'
    perm_description = 'Enroll Member'

    def get(self, request, pk, *args, **kwargs):
        obj = get_object_or_404(Member, id=pk, biodata__business=businessdata(request))

        if obj.biodata.email is None:
            messages.info(request, 'error', extra_tags='Enrolling member failed. Has no email address')
            log_title = 'Member Enrollment'
            message = f"{request.user.staff.biodata.name} attempted to enroll {obj.biodata.name} to access and use the member/clients portal but failed"
            ActivityLog.objects.create(actor=request.user, title=log_title, action_type=PORTAL, remarks=message,
                                       branch=branch_id(request.user))
            return HttpResponseRedirect(reverse_lazy('members'))

        user_mail = obj.biodata.email
        user_name = obj.biodata.email.split("@")[0]
        business_number = obj.branch.business.business_number

        if business_number is None:
            messages.info(request, 'error', extra_tags='Enrolling member failed. Business Code Error')
            log_title = 'Member Enrollment'
            message = f"{request.user.staff.biodata.name} attempted to enroll {obj.biodata.name} to access and use the " \
                      f"member/clients portal but failed"
            ActivityLog.objects.create(actor=request.user, title=log_title, action_type=PORTAL, remarks=message,
                                       branch=branch_id(request.user))
            return HttpResponseRedirect(reverse_lazy('members'))

        # ===== CHECK FOR EXISTENCE =========
        exists = User.objects.filter(email=user_mail)
        if exists.exists():
            # ====== CONNECT A USER CREATED TO THE MEMBER ======
            UserMember.objects.create(user_id=exists[0].id, member_id=obj.id)

            # ======= send email here ===========
            mail_content = "<p>Hello <b>" + obj.biodata.name + "</b>, <p>Your new account at </p> <p><b>" + obj.branch.business.name + "</b> has enrolled you successfully on Mfuko Plus Portal. <br> To get started with your portal account, follow the link: https://portal.mfuko.net, login with your username: <b>" + \
                           exists[
                               0].username + "</b> and your password. Use: <b>" + obj.branch.business.business_number + "</b> as the Business Code.</p><p>Access and monitor your transactions with " + obj.branch.business.name + " in the conform of home or office</p>"
            subject = "Mfuko Plus Portal"
            new_business_mail = {
                'site_name': 'Mfuko Plus',
                'salute': 'Regards',
                'subject': subject,
                'body': mail_content,
            }
            email_html = render_to_string(self.created_email, new_business_mail)

            # update portal status
            obj.portal = True
            obj.save()

            send_mail(subject, '', '', [obj.biodata.email, 'macdanson2@gmail.com'], html_message=email_html,
                      fail_silently=False)

            messages.success(request, 'success', extra_tags='Successfully enrolled member')
            log_title = 'Member Enrollment'
            message = f"{request.user.staff.biodata.name} enrolled {obj.biodata.name} to access and use the " \
                      f"member/clients portal"
            ActivityLog.objects.create(actor=request.user, title=log_title,
                                       action_type=PORTAL,
                                       remarks=message,
                                       branch=branch_id(request.user))
            return HttpResponseRedirect(reverse_lazy('members'))

        # ====== FOR A NEW ONE GENERATE CREDENTIALS ======
        temp_pass = str(random_with_N_digits(8))

        # ====== RECORD BUSINESS FIRST SYSTEM USER ============
        member_user = User.objects.create(email=user_mail, username=user_name)
        member_user.set_password(temp_pass)
        member_user.save()

        # ====== CONNECT A USER CREATED TO THE MEMBER ======
        UserMember.objects.create(user_id=member_user.id, member_id=obj.id)

        # update portal status
        obj.portal = True
        obj.save()

        # ======= send email here ===========
        mail_content = "<p>Hello <b>" + obj.biodata.name + "</b>, <p>Welcome to Mfuko Plus Portal!</p> <p><b>" + obj.branch.business.name + "</b> has enrolled you successfully on Mfuko Plus Portal. <br> To get started with your portal account, follow the link: https://portal.mfuko.net, login with your username: <b>" + member_user.username + "</b>, Business Code: <b>" + obj.branch.business.business_number + "</b> and a temporary password of <b>" + temp_pass + "</b>.</p><p>Access and monitor your transactions with " + obj.branch.business.name + " in the conform of home or office</p>"
        subject = "Welcome to Mfuko Plus Portal"
        new_business_mail = {
            'site_name': 'Mfuko Plus',
            'subject': subject,
            'salute': 'Regards',
            'body': mail_content,
        }
        email_html = render_to_string(self.created_email, new_business_mail)

        send_mail(subject, '', '',
                  [obj.biodata.email, 'macdanson2@gmail.com'],
                  html_message=email_html,
                  fail_silently=False)

        messages.success(request, 'success', extra_tags='Successfully enrolled member')
        log_title = 'Member Enrollment'
        message = f"{request.user.staff.biodata.name} enrolled {obj.biodata.name} to access and use the " \
                  f"member/clients portal"
        ActivityLog.objects.create(actor=request.user, title=log_title,
                                   action_type=PORTAL,
                                   remarks=message,
                                   branch=branch_id(request.user))
        return HttpResponseRedirect(reverse_lazy('members'))


class AccountTypesAll(PermView):
    template_name = 'sacco/account_types.html'
    form_class = AddAccountTypeForm
    perm_name = 'view_saving_product'
    perm_description = 'View Saving Product'

    def get(self, request, *args, **kwargs):
        business_context = get_business_loans_context_data(request)
        if business_context['branch'] is None:
            messages.error(
                request, "error",
                extra_tags="Action not allowed in the central view. Please logout and login into the respective branch"
            )
            return HttpResponseRedirect(request.META.get("HTTP_REFERER"))
        title = 'Savings Products'
        form = self.form_class
        acc_types = AccountTypes.objects.filter(business=business_context['branch'].business).order_by('-id')
        jsonQueryset = acc_types.values()
        accountTypesJson = json.dumps(list(jsonQueryset), cls=DjangoJSONEncoder)
        http = 'http://' if not request.is_secure() else 'https://'

        baseUrl = request.headers['HOST']
        baseUrl = http + baseUrl

        return render(request, self.template_name, locals())

    def post(self, request, *args, **kwargs):
        # print('nigga wassup')
        business_context = get_business_loans_context_data(request)
        form = AddAccountTypeForm(request.POST)
        if form.is_valid():
            # print('wait')
            name = form.cleaned_data.get("name")
            account_type = form.cleaned_data.get("account_type")
            minimum_balance = float(form.cleaned_data.get("minimum_balance").replace(',', ''))
            maturity = form.cleaned_data.get("maturity")
            dormancy_period = request.POST.get('dormancy_period', None)
            deposit_charge_vary = request.POST.get('deposit_charge_vary', None)
            withdraw_charge_vary = request.POST.get('withdraw_charge_vary', None)
            transfer_charge_vary = request.POST.get('transfer_charge_vary', None)
            charge_on_deposit_switch = form.cleaned_data.get('charge_on_deposit_switch', None)
            charge_on_withdraw_switch = form.cleaned_data.get('charge_on_withdraw_switch', None)
            charge_on_transfer_switch = form.cleaned_data.get('charge_on_transfer_switch', None)

            if account_type == 'f':
                the_is_fixed = True
            else:
                the_is_fixed = False

            if deposit_charge_vary == 'v':
                deposit_vary = True
            else:
                deposit_vary = False

            if withdraw_charge_vary == 'v':
                withdraw_vary = True
            else:
                withdraw_vary = False
            if transfer_charge_vary == 'v':
                transfer_vary = True
            else:
                transfer_vary = False

            if not AccountTypes.objects.filter(name__iexact=name, business=business_context['branch'].business).exists():
                create_acc_type = AccountTypes.objects.create(
                    name=name,
                    is_fixed=the_is_fixed,
                    min_balance=minimum_balance,
                    maturity=maturity,
                    dormancy_period=dormancy_period,
                    business=business_context['branch'].business,
                    deposit_charge_vary=deposit_vary,
                    withdraw_charge_vary=withdraw_vary,
                    transfer_charge_vary=transfer_vary,
                    deposit_charge=charge_on_deposit_switch,
                    withdraw_charge=charge_on_withdraw_switch,
                    transfer_charge=charge_on_transfer_switch
                )
                messages.success(request, 'success', extra_tags='Account type created successfully')
                log_title = 'Account type created'
                message = f"{request.user.staff.biodata.name} created new account type with the given name {name}"
                ActivityLog.objects.create(actor=request.user, title=log_title,
                                           action_type=CREATE,
                                           remarks=message,
                                           branch=business_context['branch'].id)
                return HttpResponseRedirect(reverse_lazy('add_account_type'))
            else:
                messages.error(request, 'error', extra_tags='Given account name already exists')
                return HttpResponseRedirect(reverse_lazy('add_account_type'))


@method_decorator(csrf_exempt, name='dispatch')
class UpdateAccountType(PermView):
    perm_name = 'view_saving_product'
    perm_description = 'View Saving Product'

    def post(self, request, pk, *args, **kwargs):
        business_context = get_business_loans_context_data(request)
        name = request.POST.get('name', None)
        account_type = request.POST.get('account_type', None)
        minimum_balance = request.POST.get('minimum_balance', None)
        maturity = request.POST.get('maturity', None)
        dormancy_period = request.POST.get('dormancy_period', None)
        deposit_charge_vary = request.POST.get('deposit_charge_vary', None)
        withdraw_charge_vary = request.POST.get('withdraw_charge_vary', None)
        transfer_charge_vary = request.POST.get('transfer_charge_vary', None)
        deposit_charge = request.POST.get('deposit_charge', None),
        withdraw_charge = request.POST.get('withdraw_charge', None),
        transfer_charge = request.POST.get('transfer_charge', None),

        if account_type == 'f':
            the_is_fixed = True
        else:
            the_is_fixed = False
        # do a check if name exists
        account_types_obj = AccountTypes.objects.filter(name__iexact=name, business=business_context['branch'].business).exclude(
            id=pk)

        if deposit_charge_vary == 'v':
            deposit_vary = True
        else:
            deposit_vary = False

        if withdraw_charge_vary == 'v':
            withdraw_vary = True
        else:
            withdraw_vary = False
        if transfer_charge_vary == 'v':
            transfer_vary = True
        else:
            transfer_vary = False

        if deposit_charge[0] == 'true':
            deposit_allow = True
        else:
            deposit_allow = False

        if withdraw_charge[0] == 'true':
            withdraw_allow = True
        else:
            withdraw_allow = False

        if transfer_charge[0] == 'true':
            transfer_allow = True
        else:
            transfer_allow = False

        if not account_types_obj:
            create_acc_type = AccountTypes.objects.filter(pk=pk).update(
                name=name,
                is_fixed=the_is_fixed,
                min_balance=minimum_balance,
                maturity=maturity,
                dormancy_period=dormancy_period,
                # business=businessdata(request),
                deposit_charge_vary=deposit_vary,
                withdraw_charge_vary=withdraw_vary,
                transfer_charge_vary=transfer_vary,
                deposit_charge=deposit_allow,
                withdraw_charge=withdraw_allow,
                transfer_charge=transfer_allow
            )

            # update the status for the transaction charges basing on variation updates
            # deposit
            if deposit_charge_vary == 'v':
                updateDepositCharges = TransactionCharge.objects.filter(account_type_id=pk, charge_type='d', start=None,
                                                                        end=None).update(
                    status=False
                )
                updateDepositCharges = TransactionCharge.objects.filter(account_type_id=pk, charge_type='d').exclude(
                    start=None, end=None).update(
                    status=True
                )
            else:
                updateDepositCharges = TransactionCharge.objects.filter(account_type_id=pk, charge_type='d').exclude(
                    start=None, end=None).update(
                    status=False
                )
                updateDepositCharges = TransactionCharge.objects.filter(account_type_id=pk, charge_type='d', start=None,
                                                                        end=None).update(
                    status=True
                )

            if withdraw_charge_vary == 'v':
                updateDepositCharges = TransactionCharge.objects.filter(account_type_id=pk, charge_type='w', start=None,
                                                                        end=None).update(
                    status=False
                )
                updateDepositCharges = TransactionCharge.objects.filter(account_type_id=pk, charge_type='w').exclude(
                    start=None, end=None).update(
                    status=True
                )
            else:
                updateDepositCharges = TransactionCharge.objects.filter(account_type_id=pk, charge_type='w').exclude(
                    start=None, end=None).update(
                    status=False
                )
                updateDepositCharges = TransactionCharge.objects.filter(account_type_id=pk, charge_type='w', start=None,
                                                                        end=None).update(
                    status=True
                )

            if transfer_charge_vary == 'v':
                updateDepositCharges = TransactionCharge.objects.filter(account_type_id=pk, charge_type='t', start=None,
                                                                        end=None).update(
                    status=False
                )
                updateDepositCharges = TransactionCharge.objects.filter(account_type_id=pk, charge_type='t').exclude(
                    start=None, end=None).update(
                    status=True
                )
            else:
                updateDepositCharges = TransactionCharge.objects.filter(account_type_id=pk, charge_type='t').exclude(
                    start=None, end=None).update(
                    status=False
                )
                updateDepositCharges = TransactionCharge.objects.filter(account_type_id=pk, charge_type='t', start=None,
                                                                        end=None).update(status=True)

            acc_types = AccountTypes.objects.filter(business=business_context['branch'].business).order_by('-id')
            jsonQueryset = acc_types.values()
            accountTypesJson = json.dumps(list(jsonQueryset), cls=DjangoJSONEncoder)

            updatedTemplate = render_to_string("sacco/search_account.html", locals())

            data = {
                'update': 'success',
                'accountTypesJson': accountTypesJson,
                'updatedTemplate': updatedTemplate
            }
            log_title = 'Account-type updated'
            message = f"{request.user.staff.biodata.name} updated account-type with the given name {name}"
            ActivityLog.objects.create(actor=request.user, title=log_title,
                                       action_type=CREATE,
                                       remarks=message,
                                       branch=business_context['branch'].id)
            return JsonResponse(data, safe=False)
        else:
            data = {
                'update': 'failed',
                'name': 'Already in use'
            }
            return JsonResponse(data)


class ChangeAccountTypeStatus(PermView):
    perm_name = 'view_saving_product'
    perm_description = 'View Saving Product'

    def get(self, request, pk, *args, **kwargs):
        with transaction.atomic():
            accTypeObj = AccountTypes.objects.filter(id=pk)
            this_type = accTypeObj.first()
            if accTypeObj.exists():
                currentStatus = accTypeObj[0].status
                if currentStatus:
                    newStatus = False
                else:
                    newStatus = True
                AccountTypes.objects.filter(id=pk).update(status=newStatus)
                messages.success(request, 'success', extra_tags='Account type status changed')
                log_title = 'Account-type status changed'
                message = f"{request.user.staff.biodata.name} updated the status of account-type with the given name {this_type.name}"
                ActivityLog.objects.create(actor=request.user, title=log_title,
                                           action_type=UPDATE,
                                           remarks=message,
                                           branch=branch_id(request.user))
                return HttpResponseRedirect(reverse_lazy('add_account_type'))
            else:
                messages.error(request, 'error', extra_tags='Account type nolonger exists')
                return HttpResponseRedirect(reverse_lazy('add_account_type'))


class SearchAccountType(BusinessUserMixin, View):
    template_name = 'sacco/search_account.html'

    def get(self, request, *args, **kwargs):
        acc_types = AccountTypes.objects.filter(business__id=businessdata(request)).order_by('-id')

        # print(members)
        return render(request, self.template_name, locals())

    def post(self, request, *args, **kwargs):
        search_text = request.POST['search_text']
        if search_text is not None or search_text != "":
            # search_text = request.POST['search_text']
            acc_types = AccountTypes.objects.filter(business__id=businessdata(request), name__icontains=search_text)
        else:
            acc_types = AccountTypes.objects.filter(business__id=businessdata(request))
        jsonQueryset = acc_types.values()
        accountTypesJson = json.dumps(list(jsonQueryset), cls=DjangoJSONEncoder)
        http = 'http://'
        if request.is_secure():
            http = 'https://'

        baseUrl = request.headers['HOST']
        baseUrl = http + baseUrl
        # print(baseUrl)
        return HttpResponse(render_to_string(self.template_name, locals()))


class FinancialYears(PermView):
    template_name = 'sacco/finance_years.html'
    form_class = FinanceYearForm
    perm_name = 'view_financial_years'
    perm_description = 'View Financial Years'

    def has_permissions(self):
        perms, created = Permissions.objects.get_or_create(item_name='view_financial_years',
                                                           description='View Financial Years')
        user_role = self.request.user.staff.position
        perms_in_role = list(user_role.permissions.all().values_list('id', flat=True))
        return perms.id in perms_in_role

    def get(self, request, *args, **kwargs):
        business_context = get_business_loans_context_data(request)
        if business_context['branch'] is None:
            messages.error(
                request, "error",
                extra_tags="Action not allowed in the central view. Please logout and login into the respective branch"
            )
            return HttpResponseRedirect(request.META.get("HTTP_REFERER"))

        title = 'Financial years'
        form = self.form_class
        financial_years = FinancialYear.objects.filter(business=business_context['branch'].business)
        jsonQueryset = financial_years.values()
        financialYearsJson = json.dumps(list(jsonQueryset), cls=DjangoJSONEncoder)
        testVariable = 'nigga work'
        http = 'http://'
        if request.is_secure():
            http = 'https://'

        baseUrl = request.headers['HOST']
        baseUrl = http + baseUrl

        return render(request, self.template_name, locals())

    def post(self, request, *args, **kwargs):
        business_context = get_business_loans_context_data(request)
        if 'add_fin' in request.POST:
            form = FinanceYearForm(request.POST)
            if form.is_valid():
                name = form.cleaned_data.get("name")
                start_date = form.cleaned_data.get("start_date")
                end_date = form.cleaned_data.get("end_date")

                # check if start date falls within a certain date range of acc type
                theDateUpdated = start_date
                checkStartDate = FinancialYear.objects.filter(start_date__lte=theDateUpdated,
                                                              end_date__gte=theDateUpdated,
                                                              business=business_context['branch'].business)
                checkEndDate = FinancialYear.objects.filter(start_date__lte=end_date, end_date__gte=end_date,
                                                            business=business_context['branch'].business)
                if checkStartDate or checkEndDate:
                    messages.error(request, 'error', extra_tags='Given range of dates already exist to another year')
                    return HttpResponseRedirect(reverse_lazy('financial_years'))

                # do a check if name exists
                if not FinancialYear.objects.filter(name__iexact=name, business=business_context['branch'].business).exists():
                    create_acc_type = FinancialYear.objects.create(
                        name=name,
                        start_date=start_date,
                        end_date=end_date,
                        business=business_context['branch'].business,
                        added_by_id=userdata(request)
                    )
                    messages.success(request, 'success', extra_tags='Financial year added successfully')
                    log_title = 'Financial Year added'
                    message = f"{request.user.staff.biodata.name} add Financial Year {create_acc_type.name}"
                    ActivityLog.objects.create(actor=request.user, title=log_title,
                                               action_type=CREATE,
                                               remarks=message,
                                               branch=business_context['branch'].id)
                    return HttpResponseRedirect(reverse_lazy('financial_years'))
                else:
                    messages.error(request, 'error', extra_tags='Given financial year name already exists')
                    return HttpResponseRedirect(reverse_lazy('financial_years'))


class ProfileView(BusinessUserMixin, View):
    template = 'sacco/profile.html'
    form_class = PasswordChangeForm
    form_class2 = EditStaffForm

    def get(self, request, *args, **kwargs):
        user = request.user
        form = self.form_class(user=user)
        form2 = self.form_class2(user=user, initial={'dob': user.staff.biodata.dob})
        title = user.staff.biodata.name
        contact_dial = dial_country_code(request.user.staff.biodata.contact)
        return render(request, self.template, locals())

    def post(self, request, *args, **kwargs):
        if 'change_password' in request.POST:
            form = self.form_class(user=request.user, data=request.POST or None)
            if form.is_valid():
                form.save()
                update_session_auth_hash(request, form.user)
                messages.success(request, 'success', extra_tags='Successfully updated password')
                return HttpResponseRedirect(reverse_lazy('logout'))
            else:
                # print(form.error_messages)
                messages.error(request, 'error', extra_tags='Error updating password')
                return HttpResponseRedirect(reverse_lazy('profile'))
        elif 'profile_update' in request.POST:
            form2 = self.form_class2(request.POST, user=request.user)
            if form2.is_valid():
                messages.success(request, 'success', extra_tags='Successfully updated profile')
                return HttpResponseRedirect(reverse_lazy('profile'))


class UpdateFinancialYear(PermView):
    perm_name = 'add_financial_year'
    perm_description = 'Add Financial Year'

    def post(self, request, pk, *args, **kwargs):
        # print(pk)
        name = request.POST.get('name', None)
        start_date = request.POST.get('start_date', None)
        end_date = request.POST.get('end_date', None)

        theDateUpdated = start_date
        checkStartDate = FinancialYear.objects.filter(start_date__lte=theDateUpdated, end_date__gte=theDateUpdated,
                                                      business__id=businessdata(request)).exclude(id=pk)
        checkEndDate = FinancialYear.objects.filter(start_date__lte=end_date, end_date__gte=end_date,
                                                    business__id=businessdata(request)).exclude(id=pk)
        if checkStartDate or checkEndDate:
            data = {
                'update': 'failed',
                'detail': 'date range in use'
            }
            return JsonResponse(data)

        if not FinancialYear.objects.filter(name__iexact=name, business__id=businessdata(request)).exclude(
                id=pk).exists():
            create_acc_type = FinancialYear.objects.filter(pk=pk).first()
            create_acc_type.name = name
            create_acc_type.start_date = start_date
            create_acc_type.end_date = end_date
            create_acc_type.save()
            # create_acc_type = FinancialYear.objects.filter(pk=pk).update(
            #     name=name,
            #     start_date=start_date,
            #     end_date=end_date
            # )

            financial_years = FinancialYear.objects.filter(business__id=businessdata(request))
            jsonQueryset = financial_years.values()
            # accountTypesJson = json.dumps(list(jsonQueryset), cls=DjangoJSONEncoder)
            financialYearsJson = list(jsonQueryset)

            data = {
                'update': 'success',
                'financialYearsJson': financialYearsJson
            }
            # print('updated')
            log_title = 'Financial Year updated'
            message = f"{request.user.staff.biodata.name} updated Financial Year {create_acc_type.name}"
            ActivityLog.objects.create(actor=request.user, title=log_title,
                                       action_type=UPDATE,
                                       remarks=message,
                                       branch=branch_id(request.user))
            return JsonResponse(data, safe=False)
        else:
            data = {
                'update': 'failed',
                'detail': 'name already in use'
            }
            return JsonResponse(data)


class DeleteFinancialYear(PermView):
    perm_name = 'add_financial_year'
    perm_description = 'Add Financial Year'

    def get(self, request, pk, *args, **kwargs):
        financialYearObj = FinancialYear.objects.filter(id=pk)
        if financialYearObj.exists():
            # check if there are some records using the year
            transactions_exist = Transactions.objects.filter(financial_year=financialYearObj[0]).exists()
            if transactions_exist:
                financialYearObj.update(status=False)
                messages.success(request, 'warning', extra_tags='Year cant be deleted but has been made inactive')
                log_title = 'Financial Year deactivated'
                message = f"{request.user.staff.biodata.name} has deactivated " \
                          f"Financial Year {financialYearObj.first().name}"
                ActivityLog.objects.create(actor=request.user, title=log_title,
                                           action_type=UPDATE,
                                           remarks=message,
                                           branch=branch_id(request.user))
                return HttpResponseRedirect(reverse_lazy('financial_years'))
            else:
                request.session['this_fy'] = financialYearObj.first().name
                financialYearObj.delete()
                messages.success(request, 'success', extra_tags='Financial year successfully deleted')
                fy = request.session.get('this_fy')
                log_title = 'Financial Year deactivated'
                message = f"{request.user.staff.biodata.name} deleted Financial Year {fy}"
                ActivityLog.objects.create(actor=request.user, title=log_title,
                                           action_type=UPDATE,
                                           remarks=message,
                                           branch=branch_id(request.user))
                del request.session['this_fy']
                return HttpResponseRedirect(reverse_lazy('financial_years'))
        else:
            messages.error(request, 'error', extra_tags='Financial year nolonger exists')
            return HttpResponseRedirect(reverse_lazy('financial_years'))


class ReactivateFinancialYear(PermView):
    perm_name = 'add_financial_year'
    perm_description = 'Add Financial Year'

    def get(self, request, pk, *args, **kwargs):
        financialYearObj = FinancialYear.objects.filter(id=pk)
        if financialYearObj.exists():
            # update status
            updateYear = financialYearObj.update(status=True)
            messages.error(request, 'success', extra_tags='Financial year reactivated successfully')
            log_title = 'Financial Year reactivated'
            message = f"{request.user.staff.biodata.name} reactivated Financial Year {financialYearObj.first().name}"
            ActivityLog.objects.create(actor=request.user, title=log_title,
                                       action_type=UPDATE,
                                       remarks=message,
                                       branch=branch_id(request.user))
            return HttpResponseRedirect(reverse_lazy('financial_years'))
        else:
            messages.error(request, 'error', extra_tags='Financial year nolonger exists')
            return HttpResponseRedirect(reverse_lazy('financial_years'))


class SearchFinancialYear(BusinessUserMixin, View):
    template_name = 'sacco/search_financial_year.html'

    def post(self, request, *args, **kwargs):
        search_text = request.POST['search_text']
        if search_text is not None or search_text != "":
            # search_text = request.POST['search_text']
            financial_years = FinancialYear.objects.filter(business__id=businessdata(request),
                                                           name__icontains=search_text)
        else:
            financial_years = FinancialYear.objects.filter(business__id=businessdata(request))

        jsonQueryset = financial_years.values()
        financialYearsJson = json.dumps(list(jsonQueryset), cls=DjangoJSONEncoder)
        # testVariable = 'nigga work'
        http = 'http://'
        if request.is_secure():
            http = 'https://'

        baseUrl = request.headers['HOST']
        baseUrl = http + baseUrl

        return HttpResponse(render_to_string(self.template_name, locals()))


class TransactionCharges(PermView):

    template_name = 'sacco/transaction_charges.html'
    perm_name = 'view_transaction_charges'

    def get(self, request, *args, **kwargs):
        business_context = get_business_loans_context_data(request)
        if business_context['branch'] is None:
            messages.error(
                request, "error",
                extra_tags="Action not allowed in the central view. Please logout and login into the respective branch"
            )
            return HttpResponseRedirect(request.META.get("HTTP_REFERER"))
        # title = 'Transaction charges'
        # form = self.form_class
        transactions_charges = TransactionCharge.objects.filter(
            account_type__business=business_context['branch'].business, status=True).order_by('id')
        account_types = AccountTypes.objects.filter(business=business_context['branch'].business).order_by('-id')
        if account_types:
            firstId = account_types[0].id
        else:
            firstId = 0

        # financial_years = FinancialYear.objects.filter(business=businessdata(request))
        jsonQuerysetTransaction = transactions_charges.values()
        jsonQuerysetAccTypes = account_types.values()
        transactionChargesJson = json.dumps(list(jsonQuerysetTransaction), cls=DjangoJSONEncoder)
        accTypesJson = json.dumps(list(jsonQuerysetAccTypes), cls=DjangoJSONEncoder)
        # testVariable = 'nigga work'

        http = 'http://'
        if request.is_secure():
            http = 'https://'

        baseUrl = request.headers['HOST']
        baseUrl = http + baseUrl

        return render(request, self.template_name, locals())

    def post(self, request, pk, *args, **kwargs):
        # print(pk)
        business_context = get_business_loans_context_data(request)
        start = request.POST.get('start', None)
        end = request.POST.get('end', None)
        charge_range = request.POST.get('charge_range', None)
        charge_type = request.POST.get('charge_type', None)
        is_charge_percentage = request.POST.get('is_charge_percentage', None)

        if is_charge_percentage == 'p':
            thePecentageVal = True
        else:
            thePecentageVal = False

        if start is None:
            theStartValue = None
        else:
            theStartValue = float(start)

        if end is None:
            theEndValue = None
        else:
            theEndValue = float(end)

        updateCharge = TransactionCharge.objects.filter(id=pk).update(
            start=theStartValue,
            end=theEndValue,
            charge=float(charge_range),
            charge_type=charge_type,
            is_charge_percentage=thePecentageVal
        )

        updatedTemplate = render_to_string("../templates/sacco/AddTransactionCharge.html")

        data = {
            'addition': 'successful',
            'updatedTemplate': updatedTemplate
        }
        log_title = 'Transaction charge updated'
        message = f"{request.user.staff.biodata.name} updated transaction charge"
        ActivityLog.objects.create(actor=request.user, title=log_title,
                                   action_type=UPDATE,
                                   remarks=message,
                                   branch=business_context['branch'].id)
        return JsonResponse(data, safe=False)


class AddTransactionCharges(PermView):
    perm_name = 'add_transaction_charges'

    @transaction.atomic()
    def post(self, request, pk, *args, **kwargs):
        business_context = get_business_loans_context_data(request)
        start = request.POST.get('start', None)
        end = request.POST.get('end', None)
        charge_range = request.POST.get('charge_range', None)
        charge_type = request.POST.get('charge_type', None)
        is_charge_percentage = request.POST.get('is_charge_percentage', None)
        # print(is_charge_percentage)
        try:
            accTypeObj = AccountTypes.objects.get(id=pk)
        except:
            data = {
                'addition': 'failed',
                'details': 'Saving product doesnt exist'
            }
            return JsonResponse(data, safe=False)

        if is_charge_percentage == 'p':
            thePercentageVal = True
        else:
            thePercentageVal = False

        if start is None:
            theStartValue = None
        else:
            theStartValue = float(start)

        if end is None:
            theEndValue = None
        else:
            theEndValue = float(end)

        if charge_type == 'd':
            theVariation = accTypeObj.deposit_charge_vary
        elif charge_type == 'w':
            theVariation = accTypeObj.withdraw_charge_vary
        else:
            theVariation = accTypeObj.transfer_charge_vary

        if theVariation:
            if theStartValue is None or theEndValue is None:
                data = {
                    'addition': 'failed',
                    'details': 'Please first refresh to get updated savings products settings'
                }
                return JsonResponse(data, safe=False)
        else:
            if theStartValue is not None or theEndValue is not None:
                data = {
                    'addition': 'failed',
                    'details': 'Please first refresh to get updated savings products settings'
                }
                return JsonResponse(data, safe=False)

        updateCharge = TransactionCharge.objects.filter(id=pk).create(
            start=theStartValue,
            end=theEndValue,
            charge=float(charge_range),
            charge_type=charge_type,
            is_charge_percentage=thePercentageVal,
            account_type_id=pk,
        )

        transactions_charges = TransactionCharge.objects.filter(status=True,
                                                                account_type__business=business_context['branch'].business).order_by('id')
        account_types = AccountTypes.objects.filter(business=business_context['branch'].business).order_by('-id')
        template = render_to_string("../templates/sacco/AddTransactionCharge.html",
                                    {"transactions_charges": transactions_charges, "account_types": account_types})

        # sdhfjad
        jsonQuerysetTransaction = transactions_charges.values()
        # jsonQuerysetAccTypes = account_types.values()
        transactionChargesJson = list(jsonQuerysetTransaction)
        # accTypesJson = json.dumps(list(jsonQuerysetAccTypes), cls=DjangoJSONEncoder)
        # print(transactionChargesJson)

        updatedTemplate = render_to_string("../templates/sacco/AddTransactionCharge.html")

        data = {
            'addition': 'successful',
            'updatedTemplate': template,
            'transactionChargesJson': transactionChargesJson
        }
        log_title = 'Transaction charge updated'
        message = f"{request.user.staff.biodata.name} updated transaction charge"
        ActivityLog.objects.create(actor=request.user, title=log_title,
                                   action_type=UPDATE,
                                   remarks=message,
                                   branch=business_context['branch'].id)
        return JsonResponse(data, safe=False)


class DeleteTransactionCharge(PermView):
    perm_name = 'delete_transaction_charges'

    def get(self, request, pk, *args, **kwargs):
        # get all transction objs of that particular acc type
        try:
            chargeObj = TransactionCharge.objects.get(id=pk)
        except:
            messages.error(request, 'error', extra_tags='Transaction charge nolonger exists')
            return HttpResponseRedirect(reverse_lazy('transaction_charges'))
        allChargesForAccType = TransactionCharge.objects.filter(account_type=chargeObj.account_type,
                                                                charge_type=chargeObj.charge_type,
                                                                status=True).order_by('id')
        # print(allChargesForAccType)

        count = 0
        for charge in allChargesForAccType:
            if chargeObj.id == charge.id:
                indexOfDeleteItem = count
            else:
                count = count + 1
        # print('the index is')
        # print(indexOfDeleteItem)

        if indexOfDeleteItem == 0:
            if len(allChargesForAccType) >= 2:
                # get element at position 1
                nextCharge = allChargesForAccType[1]
                updateTheCharge = TransactionCharge.objects.filter(id=nextCharge.id).update(
                    start=0
                )
                deleteCharge = TransactionCharge.objects.filter(id=pk).delete()
            else:
                # just delete the charge
                deleteCharge = TransactionCharge.objects.filter(id=pk).delete()
        else:
            last_element = allChargesForAccType.last()

            if int(last_element.id) == int(pk):
                deleteCharge = TransactionCharge.objects.filter(id=pk).delete()
            else:
                nextCharge = list(allChargesForAccType)[indexOfDeleteItem + 1]
                updateTheCharge = TransactionCharge.objects.filter(id=nextCharge.id).update(
                    start=chargeObj.start
                )
                deleteCharge = TransactionCharge.objects.filter(id=pk).delete()
        messages.error(request, 'success', extra_tags='Transaction charge deleted successfully')
        return HttpResponseRedirect(reverse_lazy('transaction_charges'))


class EditTransactionCharge(PermView):
    perm_name = 'edit_transaction_charges'

    def post(self, request, pk, *args, **kwargs):
        business_context = get_business_loans_context_data(request)
        try:
            chargeObj = TransactionCharge.objects.get(id=pk)
        except:
            data = {
                'addition': 'failed',
                'detail': 'Charge nolonger exists'
            }
            return JsonResponse(data, safe=False)

        start = request.POST.get('start', None)
        end = request.POST.get('end', None)
        charge_range = request.POST.get('charge_range', None)
        # charge_type = request.POST.get('charge_type', None)
        is_charge_percentage = request.POST.get('is_charge_percentage', None)

        # print(is_charge_percentage)

        if is_charge_percentage == 'p':
            thePercentageVal = True
        else:
            thePercentageVal = False

        if start is None:
            theStartValue = None
        else:
            theStartValue = float(start)

        if end is None:
            theEndValue = None
        else:
            theEndValue = float(end)

        if chargeObj.charge_type == 'd':
            theVariation = chargeObj.account_type.deposit_charge_vary
        elif chargeObj.charge_type == 'w':
            theVariation = chargeObj.account_type.withdraw_charge_vary
        else:
            theVariation = chargeObj.account_type.transfer_charge_vary

        if not theVariation:
            updateCharge = TransactionCharge.objects.filter(id=int(pk)).update(
                charge=float(charge_range),
                is_charge_percentage=thePercentageVal,
            )

            updatedTemplate = render_to_string("../templates/sacco/AddTransactionCharge.html")

            transactions_charges = TransactionCharge.objects.filter(
                account_type__business=business_context['branch'].business, status=True).order_by('id')
            account_types = AccountTypes.objects.filter(business=business_context['branch'].business).order_by('-id')
            template = render_to_string("../templates/sacco/AddTransactionCharge.html",
                                        {"transactions_charges": transactions_charges, "account_types": account_types})

            # sdhfjad
            jsonQuerysetTransaction = transactions_charges.values()
            # jsonQuerysetAccTypes = account_types.values()
            transactionChargesJson = list(jsonQuerysetTransaction)
            # accTypesJson = json.dumps(list(jsonQuerysetAccTypes), cls=DjangoJSONEncoder)
            # print(transactionChargesJson)

            data = {
                'update': 'successful',
                'updatedTemplate': template,
                'transactionChargesJson': transactionChargesJson
            }
            return JsonResponse(data, safe=False)

        else:

            # do some checking
            # -- check if there is no charge covering the range given
            allChargesForAccType = TransactionCharge.objects.filter(account_type=chargeObj.account_type,
                                                                    charge_type=chargeObj.charge_type,
                                                                    status=True).order_by('id')
            doTheUpdate = True
            for theCharge in allChargesForAccType:
                if theCharge.id != int(pk):
                    if theCharge.start <= float(start) and theCharge.end >= float(start):
                        doTheUpdate = False
                    elif theCharge.start <= float(end) and theCharge.end >= float(end):
                        doTheUpdate = False

            if doTheUpdate:
                count = 0
                for charge in allChargesForAccType:
                    if chargeObj.id == charge.id:
                        indexOfDeleteItem = count
                    else:
                        count = count + 1
                last_element = allChargesForAccType.last()
                if last_element.id == int(pk):
                    updateCharge = TransactionCharge.objects.filter(id=pk).update(
                        start=float(start),
                        end=float(end),
                        charge=float(charge_range),
                        is_charge_percentage=thePercentageVal,
                    )
                    # check if there are elements before
                    if len(list(allChargesForAccType)) > 1:
                        previousCharge = list(allChargesForAccType)[indexOfDeleteItem - 1]
                        updatePreviousCharge = TransactionCharge.objects.filter(id=previousCharge.id).update(
                            end=float(start) - 1,
                        )
                else:
                    # check if start and last value are smaller than the end of last charge
                    if theStartValue > last_element.end or theEndValue > last_element.end:
                        data = {
                            'update': 'failed',
                            'detail': 'Start and end should be small than the last maximum amount'
                        }
                        return JsonResponse(data, safe=False)

                    # reformat the start and end to match

                    # get the obj before and obj after
                    if indexOfDeleteItem == 0:
                        nextCharge = list(allChargesForAccType)[indexOfDeleteItem + 1]
                        updateCharge = TransactionCharge.objects.filter(id=pk).update(
                            start=float(start),
                            end=float(end),
                            charge=float(charge_range),
                            is_charge_percentage=thePercentageVal,
                        )
                        updateNextCharge = TransactionCharge.objects.filter(id=nextCharge.id).update(
                            start=float(end) + 1,
                        )
                    else:
                        previousCharge = list(allChargesForAccType)[indexOfDeleteItem - 1]
                        nextCharge = list(allChargesForAccType)[indexOfDeleteItem + 1]
                        updateCharge = TransactionCharge.objects.filter(id=pk).update(
                            start=float(start),
                            end=float(end),
                            charge=float(charge_range),
                            is_charge_percentage=thePercentageVal,
                        )
                        updateNextCharge = TransactionCharge.objects.filter(id=nextCharge.id).update(
                            start=float(end) + 1,
                        )
                        updatePreviousCharge = TransactionCharge.objects.filter(id=previousCharge.id).update(
                            end=float(start) - 1,
                        )

                transactions_charges = TransactionCharge.objects.filter(
                    account_type__business=business_context['branch'].business, status=True).order_by('id')
                account_types = AccountTypes.objects.filter(business=business_context['branch'].business).order_by('-id')
                template = render_to_string("../templates/sacco/AddTransactionCharge.html",
                                            {"transactions_charges": transactions_charges,
                                             "account_types": account_types})

                # sdhfjad
                jsonQuerysetTransaction = transactions_charges.values()
                # jsonQuerysetAccTypes = account_types.values()
                transactionChargesJson = list(jsonQuerysetTransaction)
                # accTypesJson = json.dumps(list(jsonQuerysetAccTypes), cls=DjangoJSONEncoder)
                # print(transactionChargesJson)

                updatedTemplate = render_to_string("../templates/sacco/AddTransactionCharge.html")

                data = {
                    'update': 'successful',
                    'updatedTemplate': template,
                    'transactionChargesJson': transactionChargesJson
                }
                return JsonResponse(data, safe=False)
            else:
                data = {
                    'update': 'failed',
                    'detail': 'range exists'
                }
                return JsonResponse(data, safe=False)


class AllGeneralCharges(PermView):
    template_name = 'sacco/general_charges.html'
    perm_name = 'view_general_charges'

    def get(self, request, *args, **kwargs):
        business_context = get_business_loans_context_data(request)
        if business_context['branch'] is None:
            messages.error(
                request, "error",
                extra_tags="Action not allowed in the central view. Please logout and login into the respective branch"
            )
            return HttpResponseRedirect(request.META.get("HTTP_REFERER"))
        title = 'Sacco general charges management'
        general_charges = GeneralCharge.objects.prefetch_related('applications').filter(
            business=business_context['branch'].business).order_by('-id')
        # charges = ApplicationAccountOrLoanType.objects.filter(pk=OuterRef('pk'))
        # results = general_charges.annotate(subquery_result=Subquery(charges.values('id')))
        # print(results.values())

        account_types = AccountTypes.objects.filter(business=business_context['branch'].business).order_by('-id')
        loan_types = LoanTypes.objects.filter(business=business_context['branch'].business).order_by('-id')
        application_types = ApplicationAccountOrLoanType.objects.filter(
            general_charge__business=business_context['branch'].business).order_by('-id')

        jsonQuerysetGeneralCharges = general_charges.values()
        generalChargesJson = json.dumps(list(jsonQuerysetGeneralCharges), cls=DjangoJSONEncoder)
        # print(generalChargesJson)
        y = []
        c = []
        # for m in general_charges:
        #     print(m.applications.values())

        jsonQuerysetApplicationTypes = application_types.values()
        applicationTypesJson = json.dumps(list(jsonQuerysetApplicationTypes), cls=DjangoJSONEncoder)

        http = 'http://'
        if request.is_secure():
            http = 'https://'

        baseUrl = request.headers['HOST']
        baseUrl = http + baseUrl

        return render(request, self.template_name, locals())

    def post(self, request, *args, **kwargs):
        business_context = get_business_loans_context_data(request)
        data = json.loads(request.POST.get('data', None))
        # logger.info(str(data))
        try:
            if GeneralCharge.objects.filter(charge__iexact=data['name'], business=business_context['branch'].business).exists():
                data = {
                    'addition': 'failed',
                    'detail': 'Name already exists'
                }
                return JsonResponse(data, safe=False)
            else:
                # create broker
                # execution_period_number: execution_period_number.value.trim(),
                # execution_period: execution_period_select.value

                if "execution_period_number" in data and "execution_period" in data:
                    theExecPeriodNum = int(data['execution_period_number'])
                    theExecPeriod = data['execution_period']
                else:
                    theExecPeriodNum = None
                    theExecPeriod = None

                if "is_fine" in data:
                    if data['is_fine'] == 'f':
                        theIsFine = True
                    else:
                        theIsFine = False
                else:
                    theIsFine = False

                addCharge = GeneralCharge.objects.create(
                    charge=data['name'],
                    is_revenue=data['is_revenue'],
                    application=data['application'],
                    amount=float(data['amount']),
                    is_percentage=data['is_percentage'],
                    status=True,
                    added_by_id=userdata(request),
                    business=business_context['branch'].business,
                    execution_period=theExecPeriod,
                    execution_period_number=theExecPeriodNum,
                    is_fine=theIsFine
                )
                log_title = 'General charge added'
                message = f"{request.user.staff.biodata.name} added a general charge {addCharge.charge}"
                ActivityLog.objects.create(actor=request.user, title=log_title,
                                           action_type=CREATE,
                                           remarks=message,
                                           branch=business_context['branch'].id)

                if data['application'] == 'l':
                    # get all the id of loan types and save to database
                    allLoanTypes = data['loan_type']
                    allLoanTypes = list(filter(None, allLoanTypes))
                    if len(allLoanTypes) > 0:
                        for id_loan in allLoanTypes:
                            loanTypeObj = LoanTypes.objects.get(id=int(id_loan))
                            createApplicationAccountOrLoanType = ApplicationAccountOrLoanType.objects.create(
                                general_charge=addCharge, loan_type=loanTypeObj)

                elif data['application'] == 'r':
                    allAccountTypes = data['account_type']
                    for id_loan in allAccountTypes:
                        try:
                            accountTypeObj = AccountTypes.objects.get(id=int(id_loan))
                            createApplicationAccountOrLoanType = ApplicationAccountOrLoanType.objects.create(
                                general_charge=addCharge, account_type=accountTypeObj)
                        except Exception as e:
                            logger.error(str(e))

                elif data['application'] == 'o':
                    if data['other_type'] == 'l':
                        allLoanTypes = data['loan_type']
                        # print(allLoanTypes)
                        for id_loan in allLoanTypes:
                            try:
                                loanTypeObj = LoanTypes.objects.get(id=int(id_loan))
                                createApplicationAccountOrLoanType = ApplicationAccountOrLoanType.objects.create(
                                    general_charge=addCharge, loan_type=loanTypeObj)
                            except Exception as e:
                                logger.error(str(e))
                    else:
                        allAccountTypes = data['account_type']
                        for id_loan in allAccountTypes:
                            try:
                                accountTypeObj = AccountTypes.objects.get(id=int(id_loan))
                                createApplicationAccountOrLoanType = ApplicationAccountOrLoanType.objects.create(
                                    general_charge=addCharge, account_type=accountTypeObj)
                            except Exception as e:
                                logger.error(str(e))

                general_charges = GeneralCharge.objects.filter(business=business_context['branch'].business).order_by('-id')

                jsonQuerysetGeneralCharges = general_charges.values()
                generalChargesJson = json.dumps(list(jsonQuerysetGeneralCharges), cls=DjangoJSONEncoder)

                application_types = ApplicationAccountOrLoanType.objects.filter(
                    general_charge__business=business_context['branch'].business).order_by('-id')

                jsonQuerysetApplicationTypes = application_types.values()
                applicationTypesJson = json.dumps(list(jsonQuerysetApplicationTypes), cls=DjangoJSONEncoder)

                context = {
                    'general_charges': general_charges
                }
                updatedTemplate = render_to_string("../templates/sacco/add_charge.html", locals())

                data = {
                    'addition': 'successful',
                    'updatedTemplate': updatedTemplate,
                    'generalChargesJson': generalChargesJson,
                    'applicationTypesJson': applicationTypesJson
                }
                logger.debug('jejeje')
                return JsonResponse(data, safe=False)
        except Exception as e:
            logger.error(str(e))
            return JsonResponse({'addition': 'failed'}, safe=False, status=400)


class EditGeneralCharge(PermView):
    def get(self, request, pk, *args, **kwargs):
        business_context = get_business_loans_context_data(request)
        charge = get_object_or_404(GeneralCharge, id=pk)
        title = charge.charge
        account_types = AccountTypes.objects.filter(business=business_context['branch'].business).order_by('-id')
        loan_types = LoanTypes.objects.filter(business=business_context['branch'].business).order_by('-id')
        application_types = ApplicationAccountOrLoanType.objects.filter(
            general_charge__business=business_context['branch'].business).order_by('-id')
        applications = list(charge.applications.all().values_list('loan_type_id', flat=True))
        http = 'http://' if not request.is_secure() else 'https://'
        baseUrl = request.headers['HOST']
        baseUrl = http + baseUrl
        # generalChargesJson = json.dumps(list(jsonQuerysetGegeneralCharges), cls=DjangoJSONEncoder)
        context = {
            'charge': charge,
            'title': title,
            'account_types': account_types,
            'applications': applications,
            'loan_types': loan_types,
            'application_types': application_types,
            'baseUrl': baseUrl,

        }
        return render(request, 'sacco/edit_charge.html', context)

    def post(self, request, pk, *args, **kwargs):
        business_context = get_business_loans_context_data(request)
        charge = get_object_or_404(GeneralCharge, id=pk)
        user = self.request.user
        form = EditChargeForm(user=user, charge=charge)
        if form.is_valid():
            form.save()
            messages.success(request, 'success', extra_tags='Successfully updated charge')
            return HttpResponseRedirect(reverse_lazy('edit_general_charge', args=[charge.id]))
        return HttpResponseRedirect(reverse_lazy('edit_general_charge', args=[charge.id]))


class EditGeneralCharges(PermView):
    perm_name = 'add_general_charges'

    def post(self, request, pk, *args, **kwargs):
        business_context = get_business_loans_context_data(request)
        data = json.loads(request.POST.get('data', None))
        # logger.info(data)
        chargeObj = GeneralCharge.objects.filter(id=int(pk))
        # print(chargeObj)
        if not chargeObj:
            data = {
                'addition': 'failed',
                'detail': 'Charge nolonger exists'
            }
            return JsonResponse(data, safe=False)
        else:
            # update broker
            if "execution_period_number" in data and "execution_period" in data:
                theExecPeriodNum = int(data['execution_period_number'])
                theExecPeriod = data['execution_period']
            else:
                theExecPeriodNum = None
                theExecPeriod = None

            if "is_fine" in data:
                if data['is_fine'] == 'f':
                    theIsFine = True
                else:
                    theIsFine = False
            else:
                theIsFine = False

            updateCharge = chargeObj.update(
                charge=data['name'],
                is_revenue=data['is_revenue'],
                application=data['application'],
                amount=float(data['amount']),
                is_percentage=data['is_percentage'],
                execution_period=theExecPeriod,
                execution_period_number=theExecPeriodNum,
                is_fine=theIsFine
            )

            # updating the acc/loan types
            # first delete
            deleteExistingCharges = ApplicationAccountOrLoanType.objects.filter(general_charge=int(pk)).delete()

            if data['application'] == 'l':
                # get all the id of loan types and save to database
                allLoanTypes = data['loan_type']
                for id_loan in allLoanTypes:
                    try:
                        loanTypeObj = LoanTypes.objects.get(id=int(id_loan))
                        createApplicationAccountOrLoanType = ApplicationAccountOrLoanType.objects.create(
                            general_charge=chargeObj[0], loan_type=loanTypeObj)
                    except:
                        print('not added')

            elif data['application'] == 'r':
                allAccountTypes = data['account_type']
                for id_loan in allAccountTypes:
                    try:
                        accountTypeObj = AccountTypes.objects.get(id=int(id_loan))
                        createApplicationAccountOrLoanType = ApplicationAccountOrLoanType.objects.create(
                            general_charge=chargeObj[0], account_type=accountTypeObj)
                    except:
                        print('not added')

            elif data['application'] == 'o':
                if data['other_type'] == 'l':
                    allLoanTypes = data['loan_type']
                    # print(allLoanTypes)
                    for id_loan in allLoanTypes:
                        try:
                            loanTypeObj = LoanTypes.objects.get(id=int(id_loan))
                            createApplicationAccountOrLoanType = ApplicationAccountOrLoanType.objects.create(
                                general_charge=chargeObj[0], loan_type=loanTypeObj)
                        except:
                            print('not added')
                else:
                    allAccountTypes = data['account_type']
                    for id_loan in allAccountTypes:
                        try:
                            accountTypeObj = AccountTypes.objects.get(id=int(id_loan))
                            createApplicationAccountOrLoanType = ApplicationAccountOrLoanType.objects.create(
                                general_charge=chargeObj[0], account_type=accountTypeObj)
                        except:
                            print('not added')

            general_charges = GeneralCharge.objects.filter(business=business_context['branch'].business).order_by('-id')

            jsonQuerysetGeneralCharges = general_charges.values()
            generalChargesJson = json.dumps(list(jsonQuerysetGeneralCharges), cls=DjangoJSONEncoder)

            application_types = ApplicationAccountOrLoanType.objects.filter(
                general_charge__business=business_context['branch'].business).order_by('-id')

            jsonQuerysetApplicationTypes = application_types.values()
            applicationTypesJson = json.dumps(list(jsonQuerysetApplicationTypes), cls=DjangoJSONEncoder)

            updatedTemplate = render_to_string("../templates/sacco/add_charge.html", locals())

            data = {
                'update': 'successful',
                'updatedTemplate': updatedTemplate,
                'generalChargesJson': generalChargesJson,
                'applicationTypesJson': applicationTypesJson
            }
            log_title = 'General charge update'
            message = f"{request.user.staff.biodata.name} added a general charge {chargeObj.first().charge}"
            ActivityLog.objects.create(actor=request.user, title=log_title,
                                       action_type=UPDATE,
                                       remarks=message,
                                       branch=business_context['branch'].id)
            return JsonResponse(data, safe=False)


class ActivateOrDeativateCharge(PermView):
    perm_name = 'deactivate_general_charges'

    def get(self, request, pk, *args, **kwargs):
        business_context = get_business_loans_context_data(request)
        chargeObj = GeneralCharge.objects.filter(id=int(pk))
        if chargeObj:
            # activate/deactivate
            if chargeObj[0].status:
                newStatus = False
                status = 'Deactivated'
            else:
                newStatus = True
                status = 'Activated'
            updateCharge = chargeObj.update(
                status=newStatus
            )
            messages.error(request, 'success', extra_tags='Status updated successfully')
            log_title = 'General charge update'
            message = f"{request.user.staff.biodata.name} {status} general charge {chargeObj.first().charge}"
            ActivityLog.objects.create(actor=request.user, title=log_title,
                                       action_type=UPDATE,
                                       remarks=message,
                                       branch=business_context['branch'].id)
            return HttpResponseRedirect(reverse_lazy('general_charges'))

        else:
            messages.error(request, 'error', extra_tags='Charge nolonger exists')
            return HttpResponseRedirect(reverse_lazy('general_charges'))


class SearchGeneralCharge(BusinessUserMixin, View):
    template_name = 'sacco/add_charge.html'

    def post(self, request, *args, **kwargs):
        business_context = get_business_loans_context_data(request)
        search_text = request.POST['search_text']
        if search_text is not None or search_text != "":
            # search_text = request.POST['search_text']
            general_charges = GeneralCharge.objects.filter(business=business_context['branch'].business,
                                                           charge__icontains=search_text).order_by('-id')
            # print(general_charges)
        else:
            general_charges = GeneralCharge.objects.filter(business=business_context['branch'].business).order_by('-id')
        return HttpResponse(render_to_string(self.template_name, locals()))


class StaffListView(PermView):
    perm_name = 'view_staff'
    template_name = 'sacco/staff.html'

    def get(self, request, *args, **kwargs):
        user = request.user
        title = 'Staff Members'

        business_context = session_business_data(request)
        data_context = determine_business_id_list(request.user.staff, business_context)
        object_list = Staff.objects.filter(branch__business_id__in=data_context['all_ids'], is_active=True).order_by('-id')

        # filter by business
        if business_context is None:
            business_filter = request.GET.get('business_filter', '')
            if business_filter:
                if business_filter == 'all_branches':
                    object_list = object_list.filter(branch__business_id__in=data_context['all_ids'])
                else:
                    object_list = object_list.filter(branch__business_id=business_filter)

        return render(request, self.template_name, locals())


class DeleteStaffView(PermView):
    perm_name = 'view_staff'
    template_name = 'sacco/staff.html'

    def get(self, request, pk, *args, **kwargs):
        # get the staff
        the_staff = Staff.objects.filter(id=pk, is_active=True)
        if not the_staff.exists():
            messages.error(request, 'error', extra_tags='Staff is nolonger available')
            return HttpResponseRedirect(reverse_lazy('staff'))
        # get the user and deactivate the make them inactive
        the_user = User.objects.filter(staff=the_staff.first()).update(
            is_active=False
        )
        the_staff.update(
            is_active=False
        )
        messages.success(request, 'success', extra_tags='Staff successfully removed')
        return HttpResponseRedirect(reverse_lazy('staff'))


class StaffAddView(PermView):
    perm_name = 'add_staff'
    template_name = 'sacco/add_staff.html'
    form_class = AddStaffForm

    def get(self, request, *args, **kwargs):
        business_context = session_business_data(request)  # gets the business object
        if business_context is None:
            messages.error(request, 'error', extra_tags='Cannot add staff in the central point')
            return HttpResponseRedirect(reverse_lazy('staff'))

        user = request.user
        roles = Role.objects.filter(business=business_context)
        # businesses = Business.objects.filter().exclude(name__icontains="nugsoft")
        title = 'Add Staff Members'
        form = self.form_class()

        business_context = session_business_data(request)  # gets the business object
        if business_context is None:
            messages.error(request, 'error', extra_tags='Cannot add staff in the central point')
            return HttpResponseRedirect(reverse_lazy('staff'))

        # get the branch for the current business
        current_branch = Branch.objects.filter(business_id=business_context.id).first()

        staff_default_business = request.user.staff.branch.business

        # get the connected businesses for this business
        if staff_default_business.instance_type == 'not connected':
            # businesses = Business.objects.filter(id=staff_default_business.id).exclude(id=staff_default_business.id)
            businesses = Branch.objects.filter(id=request.user.staff.branch.id).exclude(id=request.user.staff.branch.id)
        else:
            # businesses = Business.objects.filter(instance_type=staff_default_business.instance_type).exclude(id=staff_default_business.id)
            businesses = Branch.objects.filter(business__instance_type=staff_default_business.instance_type).exclude(
                id=current_branch.id)

        # get the can access central point
        can_access_central_point = request.user.staff.can_access_central
        return render(request, self.template_name, locals())

    def post(self, request, *args, **kwargs):
        user = request.user
        business_context = session_business_data(request) # gets the business object
        if business_context is None:
            messages.error(request, 'error', extra_tags='Cannot add staff in the central point')
            return HttpResponseRedirect(reverse_lazy('staff'))

        form = self.form_class(data=request.POST, user=user, instance_type=request.user.staff.branch.business.instance_type, business_id=business_context.id)
        if form.is_valid():
            messages.success(request, 'success', extra_tags='Successfully added Staff')
            return HttpResponseRedirect(reverse_lazy('staff'))
        else:
            messages.error(request, 'error', extra_tags=str(form.non_field_errors()))
            return HttpResponseRedirect(reverse_lazy('add_staff'))


class StaffDetailView(PermView):
    perm_name = 'view_staff'
    template_name = 'sacco/staff_detail.html'
    form_class = ChangeStaffPassword
    action_email_html = 'mufukoadmin/emails/action_email.html'

    # email_template_name = 'sacco/emails/emails.html'

    def get(self, request, pk, *args, **kwargs):
        business_context = get_business_loans_context_data(request)

        if business_context['branch'] is None:
            messages.error(
                request, "error",
                extra_tags="Action not allowed in the central view. Please logout and login into the respective branch"
            )
            return HttpResponseRedirect(request.META.get("HTTP_REFERER"))

        obj = get_object_or_404(Staff, id=pk, branch=business_context['branch'], is_active=True)
        positions = Position.objects.filter(business=business_context['branch'].business)
        set_pass_form = self.form_class
        staff = False
        if User.objects.filter(staff=obj).exists():
            staff = True

        set_pass_form = self.form_class
        title = f'Staff | {obj.biodata.name.upper()}'

        staff_businesses = obj.businesses.all()

        staff_businesses_accessible = list(staff_businesses.exclude(id=obj.branch.business.id).values_list('id', flat=True))
        # get the accessible branches
        staff_access_branches = Branch.objects.filter(business_id__in=staff_businesses_accessible)

        # select branches
        biz_ids_needed=list(Business.objects.filter(instance_type=business_context['branch'].business.instance_type).values_list('id', flat=True))
        select_branches = Branch.objects.filter(business_id__in=biz_ids_needed).exclude(id=obj.branch.id)

        can_migrate_staff=request.user.staff.can_migrate_staff

        return render(request, self.template_name, locals())

    def post(self, request, pk, *args, **kwargs):
        business_context = get_business_loans_context_data(request)
        obj = get_object_or_404(Staff, id=pk, branch=business_context['branch'], is_active=True)
        domain = request.headers['Host']
        if 'set_pass' in request.POST:
            set_pass_form = self.form_class(data=request.POST, user=request.user, staff=obj)
            if set_pass_form.is_valid():
                set_pass_form.save()
                messages.success(request, 'success', extra_tags='Successfully changed password')
                log_title = 'Staff password update'
                message = f"{request.user.staff.biodata.name} updated {obj.biodata.name}'s password"
                ActivityLog.objects.create(actor=request.user, title=log_title,
                                           action_type=UPDATE,
                                           remarks=message,
                                           branch=business_context['branch'].id)
                return HttpResponseRedirect(reverse_lazy('staff_detail', args=[obj.id]))
            else:
                messages.error(request, 'error', extra_tags=str(set_pass_form.error_messages['password_mismatch']))
                return HttpResponseRedirect(reverse_lazy('staff_detail', args=[obj.id]))
        elif 'change_role' in request.POST:
            # print('id:' + request.POST.get('role'))
            role = Position.objects.filter(id=request.POST.get('role')).first()
            # print(role)
            if obj.position is None:
                # generate password
                gen_password, created = GeneratedPassword.objects.get_or_create(staff=obj)
                gen_password.password = str(random_with_N_digits(8))
                gen_password.is_used = False
                gen_password.can_login = True
                gen_password.save()
                if not hasattr(obj, 'user'):
                    username = obj.biodata.email.split('@')[0]
                    try:
                        User.objects.create(staff=obj, email=obj.biodata.email, username=username)
                    except IntegrityError:
                        messages.error(request, 'error', extra_tags='Every staff must have a unique email')
                        return HttpResponseRedirect(reverse_lazy('staff_detail', args=[obj.id]))

                obj.user.set_password(gen_password.password)
                subject = "Generated One Time Password"
                c = {
                    'salute': 'Regrets',
                    'site_name': 'Mfuko Plus',
                    'body': '<p>Hello ' + f'{obj.biodata.name}'.title() + ',</p>  You have been enrolled as ' + role.title + ' at ' + str(
                        obj.biodata.business.name).title() + '. To access your new account follow the link: ' + domain + ' and your email ' + obj.biodata.email + ' as username with a temporary password: ' + gen_password.password,
                }
                email_html = render_to_string(self.action_email_html, c)
                if obj.biodata.email:
                    try:
                        send_mail(subject, '', '', [obj.biodata.email, 'macdanson2@gmail.com'], html_message=email_html,
                                  fail_silently=False)
                        # print(send_mail)
                    except BadHeaderError:
                        return HttpResponse('Invalid header found.')

            obj.position_id = role
            obj.save_related()
            # print('Yes I reached here but not new')
            messages.success(request, 'success', extra_tags='Successfully updated Role')
            log_title = 'Staff role update'
            message = f"{request.user.staff.biodata.name} updated {obj.biodata.name}'s role"
            ActivityLog.objects.create(actor=request.user, title=log_title,
                                       action_type=UPDATE,
                                       remarks=message,
                                       branch=branch_id(request.user))
            return HttpResponseRedirect(reverse_lazy('staff_detail', args=[obj.id]))

        return render(request, self.template_name, locals())


class StaffEditView(PermView):
    perm_name = 'edit_staff'
    template_name = 'sacco/edit_staff.html'
    form_class = EditStaffProfileForm

    def get(self, request, pk, *args, **kwargs):
        business_context = get_business_loans_context_data(request)  # gets the business object
        if business_context['branch'] is None:
            messages.error(request, 'error', extra_tags='Cannot add staff in the central point')
            return HttpResponseRedirect(reverse_lazy('staff'))

        obj = get_object_or_404(Staff, id=pk, branch=business_context['branch'], is_active=True)
        title = obj.biodata.name
        form = self.form_class(initial={'dob': obj.biodata.dob})
        salutations = Salutation.objects.all()
        positions = Position.objects.filter(business=business_context['branch'].business)
        roles = Role.objects.filter(business=business_context['branch'].business)

        staff_default_business = business_context['branch'].business

        # -- original ---
        # businesses = Business.objects.filter().exclude(name__icontains="nugsoft")
        # ---------------
        # get the connected businesses for this business
        if staff_default_business.instance_type == 'not connected':
            # businesses = Business.objects.filter(id=staff_default_business.id).exclude(id=staff_default_business.id)
            businesses = Branch.objects.filter(id=request.user.staff.branch.id).exclude(id=request.user.staff.branch.id)
        else:
            # businesses = Business.objects.filter(instance_type=staff_default_business.instance_type).exclude(id=staff_default_business.id)
            businesses = Branch.objects.filter(business__instance_type=staff_default_business.instance_type).exclude(
                id=business_context['branch'].id)

        # attached businesses
        staff_businesses = obj.businesses.all().exclude(id=staff_default_business.id)

        # ensure that the current staff doesnot edit themselves
        if request.user.staff.id == int(pk):
            can_edit_staff_central = False
        else:
            can_edit_staff_central = True

        # get the can access central point
        can_access_central_point = request.user.staff.can_access_central
        return render(request, self.template_name, locals())

    def post(self, request, pk, *args, **kwargs):
        business_context = get_business_loans_context_data(request)  # gets the business object
        if business_context['branch'] is None:
            messages.error(request, 'error', extra_tags='Cannot add staff in the central point')
            return HttpResponseRedirect(reverse_lazy('staff'))

        obj = get_object_or_404(Staff, id=pk, branch=business_context['branch'], is_active=True)
        form = self.form_class(request.POST, instance_type=request.user.staff.branch.business.instance_type)
        salutations = Salutation.objects.all()
        positions = Position.objects.filter(business=business_context['branch'].business)
        roles = Role.objects.filter(business=business_context['branch'].business)
        # businesses = Business.objects.filter().exclude(name__icontains="nugsoft")
        staff_businesses = obj.businesses.all()

        try:
            if form.is_valid():
                name = form.cleaned_data.get('name')
                title = form.cleaned_data.get('title')
                marital_status = form.cleaned_data.get('marital_status')
                dob = form.cleaned_data.get('dob')
                nin = form.cleaned_data.get('nin')
                contact = form.cleaned_data.get('contact')
                other_contact = form.cleaned_data.get('other_contact')
                email = form.cleaned_data.get('email')
                nok = form.cleaned_data.get('nok')
                nok_contacts = form.cleaned_data.get('nok_contacts')
                code = form.cleaned_data.get('code')
                code1 = form.cleaned_data.get('code1')
                code2 = form.cleaned_data.get('code2')
                mm = form.cleaned_data.get('mm')
                country = form.cleaned_data.get('country')
                location = form.cleaned_data.get('location')
                gender = form.cleaned_data.get('gender')
                employee_no = form.cleaned_data.get('employee_no')
                can_access_central = form.cleaned_data.get('can_access_central')
                businesses = form.cleaned_data.get('businesses')

                if contact:
                    primary_c = proper_dial(contact, code)
                else:
                    primary_c = contact

                if other_contact:
                    other_c = proper_dial(other_contact, code1)
                else:
                    other_c = other_contact

                if mm:
                    mm_c = proper_dial(mm, code2)
                else:
                    mm_c = other_contact
                if title:
                    try:
                        salute = Salutation.objects.get(id=title)
                    except Salutation.DoesNotExist:
                        messages.error(request, 'error', extra_tags='Invalid Salutation')
                        return HttpResponseRedirect(reverse_lazy('staff_detail', args=[obj.id]))
                else:
                    salute = None

                check_emp_no = Biodata.objects.filter(employee_no=employee_no.strip(),
                                                      business=business_context['branch'].business).exclude(id=obj.biodata.id).exists()
                if check_emp_no:
                    messages.error(request, 'error',
                                   extra_tags='Provided employee number already belongs to another person')
                    return HttpResponseRedirect(reverse_lazy('edit_staff', args=[obj.id]))

                obj.biodata.name = name
                obj.biodata.gender = gender
                obj.biodata.marital_status = marital_status
                obj.biodata.dob = dob
                obj.biodata.nin = nin
                obj.biodata.contact = primary_c
                obj.biodata.other_contact = other_c
                obj.biodata.email = email
                obj.biodata.nok = nok
                obj.biodata.nok_contacts = nok_contacts
                obj.biodata.mobile_money = mm_c
                obj.biodata.title = salute
                obj.biodata.country = country
                obj.biodata.location = location
                obj.biodata.employee_no = employee_no


                # Add business relationships
                if request.user.staff.can_access_central:
                    obj.can_access_central = can_access_central
                    obj.businesses.clear()
                    # first add the original business
                    obj.businesses.add(obj.branch.business)

                    for business in businesses:
                        obj.businesses.add(business)

                obj.save_related()

                messages.success(request, 'success', extra_tags='Successfully updated Staff')
                log_title = 'Staff update'
                message = f"{request.user.staff.biodata.name} updated {obj.biodata.name} profile"
                ActivityLog.objects.create(actor=request.user, title=log_title,
                                           action_type=UPDATE,
                                           remarks=message,
                                           branch=business_context['branch'].id)
                return HttpResponseRedirect(reverse_lazy('staff_detail', args=[obj.id]))

            title = obj.biodata.name
            # print(form.errors)
            messages.error(request, 'error', extra_tags='Invalid Input: An error occurred while updating staff!')

            # return HttpResponseRedirect(reverse_lazy('edit_staff', args=[pk]))
            return render(request, self.template_name, locals())

        except Exception as exception:
            # print('-- exception --', exception)
            raise exception


class DeactivateStaffView(PermView):
    perm_name = 'delete_staff'

    def get(self, request, pk, *args, **kwargs):
        obj = get_object_or_404(Staff, id=pk, branch=request.user.staff.branch, is_active=True)
        obj.is_active = False
        obj.save()
        messages.success(request, 'success', extra_tags='Successfully deleted staff member')
        log_title = 'Staff delete'
        message = f"{request.user.staff.biodata.name} deleted {obj.biodata.name} profile"
        ActivityLog.objects.create(actor=request.user, title=log_title,
                                   action_type=DELETE,
                                   remarks=message,
                                   branch=branch_id(request.user))
        return HttpResponseRedirect(reverse_lazy('staff'))


class SystemRolesView(PermView):
    perm_name = 'view_roles'
    template_name = 'sacco/staff_roles.html'

    def get(self, request, *args, **kwargs):
        business_context = get_business_loans_context_data(request)
        if business_context['branch'] is None:
            messages.error(
                request, "error",
                extra_tags="Action not allowed in the central view. Please logout and login into the respective branch"
            )
            return HttpResponseRedirect(request.META.get("HTTP_REFERER"))

        title = 'User Roles'
        logged_user = request.user.staff.position_id
        # print(logged_user)
        object_list = Position.objects.filter(business=business_context['branch'].business).exclude(id=logged_user)
        perm_list = Permissions.objects.all()

        return render(request, self.template_name, locals())

    def post(self, request, *args, **kwargs):
        business_context = get_business_loans_context_data(request)
        if 'add_role' in request.POST:
            title = request.POST['title']
            if title:
                role = Position.objects.create(title=title, created_by=biz_staff(request.user),
                                               business=business_context['branch'].business)
                messages.success(request, 'success', extra_tags='Successfully added a user role')
                log_title = 'Role added'
                message = f"{request.user.staff.biodata.name} added new role {role.title}"
                ActivityLog.objects.create(actor=request.user, title=log_title,
                                           action_type=CREATE,
                                           remarks=message,
                                           branch=business_context['branch'].id)
                return HttpResponseRedirect(reverse_lazy('user_roles'))
        return render(request, self.template_name, locals())


class SaccoRolesView(PermView):
    perm_name = 'view_position'
    template_name = 'sacco/sacco_roles.html'
    deco_role = 'add_position'

    def get(self, request, *args, **kwargs):
        business_context = get_business_loans_context_data(request)
        if business_context['branch'] is None:
            messages.error(
                request, "error",
                extra_tags="Action not allowed in the central view. Please logout and login into the respective branch"
            )
            return HttpResponseRedirect(request.META.get("HTTP_REFERER"))

        title = 'Staff Positions'
        object_list = Role.objects.filter(business=business_context['branch'].business).values('id').annotate(
            staff=Count('roles')).values('title', 'created_by__biodata__name', 'staff', 'created_date', 'id')

        return render(request, self.template_name, locals())

    @can_do_this
    def post(self, request, *args, **kwargs):
        business_context = get_business_loans_context_data(request)
        if 'add_role' in request.POST:
            title = request.POST['title']
            if title:
                position = Role.objects.create(title=title, created_by=biz_staff(request.user),
                                               business=business_context['branch'].business)
                messages.success(request, 'success', extra_tags='Successfully added a role')
                log_title = 'Role added'
                message = f"{request.user.staff.biodata.name} added new position {position.title}"
                ActivityLog.objects.create(actor=request.user, title=log_title,
                                           action_type=CREATE,
                                           remarks=message,
                                           branch=business_context['branch'].id)
                return HttpResponseRedirect(reverse_lazy('staff_positions'))
        return render(request, self.template_name, locals())


class ManageStaffRoleView(PermView):
    perm_name = 'view_position'

    def get(self, request, pk, *args, **kwargs):
        business_context = get_business_loans_context_data(request)
        if business_context['branch'] is None:
            messages.error(
                request, "error",
                extra_tags="Action not allowed in the central view. Please logout and login into the respective branch"
            )
            return HttpResponseRedirect(request.META.get("HTTP_REFERER"))

        obj = get_object_or_404(Role, id=pk, business=business_context['branch'].business)
        request.session['position'] = obj.title
        obj.delete()
        position = request.session.get('position')
        messages.success(request, 'success', extra_tags='Successfully deleted Staff Position')
        message = f"{request.user.staff.biodata.name} deleted {position}"
        ActivityLog.objects.create(actor=request.user, action_type=DELETE, branch=business_context['branch'].id,
                                   remarks=message)
        del request.session['position']
        return HttpResponseRedirect(reverse_lazy('staff_roles'))

    def post(self, request, pk, *args, **kwargs):
        business_context = get_business_loans_context_data(request)
        obj = get_object_or_404(Role, id=pk, business=business_context['branch'].business)
        title = request.POST['title']
        request.session['this_title'] = obj.title
        if title:
            obj.title = title
            obj.save()
            old_title = request.session.get('this_title')
            message = f"{request.user.staff.biodata.name} updated staff position from {old_title} to {title}"
            ActivityLog.objects.create(actor=request.user,
                                       action_type=UPDATE,
                                       title='Position update',
                                       branch=business_context['branch'].id,
                                       remarks=message)
            del request.session['this_title']
            return HttpResponseRedirect(reverse_lazy('staff_positions'))


class ShareSettings(PermView):
    perm_name = 'view_share_settings'
    template_name = 'sacco/share_settings.html'

    def get(self, request, *args, **kwargs):
        business_context = get_business_loans_context_data(request)
        if business_context['branch'] is None:
            messages.error(
                request, "error",
                extra_tags="Action not allowed in the central view. Please logout and login into the respective branch"
            )
            return HttpResponseRedirect(request.META.get("HTTP_REFERER"))
        title = 'Sacco share settings'
        # acc_types = AccountTypes.objects.filter(business__id=businessdata(request))
        # jsonQueryset = acc_types.values()
        # accountTypesJson = json.dumps(list(jsonQueryset), cls=DjangoJSONEncoder)
        http = 'http://' if not request.is_secure() else 'https://'

        baseUrl = request.headers['HOST']
        baseUrl = http + baseUrl

        try:
            share_settings = OtherSettings.objects.get(business=business_context['branch'].business)
            # all_members = AccountBroker.objects.filter(members__biodata__business_id=businessdata(request))
            # print(all_members)
        except (OtherSettings.DoesNotExist, AttributeError,):
            # print('no settings')
            share_settings = 'no_settings'
            share_settingsJson = 'no_data'
        except Exception as e:
            print(str(e))

        return render(request, self.template_name, locals())


@method_decorator(csrf_exempt, name='dispatch')
class UpdateOtherSettings(PermView):
    perm_name = 'view_advanced_settings'

    def post(self, request, pk, *args, **kwargs):
        business_context = get_business_loans_context_data(request)
        dividend_setting = request.POST.get('dividend_setting', None)

        settingObj = OtherSettings.objects.filter(id=int(pk))
        if not settingObj:
            data = {
                'addition': 'failed',
                'detail': 'Settings dont exists'
            }
            return JsonResponse(data, safe=False)
        else:
            if dividend_setting == 's':
                theSetting = True
            else:
                theSetting = False
            settingObj.update(dividends_sharing=theSetting)
            data = {
                'update': 'successful',
            }
            message = f"{request.user.staff.biodata.name} updated business settings"
            ActivityLog.objects.create(actor=request.user,
                                       action_type=UPDATE,
                                       title='Business settings updated',
                                       branch=business_context['branch'].id,
                                       remarks=message)
            return JsonResponse(data, safe=False)


@method_decorator(csrf_exempt, name='dispatch')
class EditShares(PermView):
    perm_name = 'manage_shares'

    def post(self, request, pk, *args, **kwargs):
        business_context = get_business_loans_context_data(request)
        share_limit = request.POST.get('share_limit', None)
        share_price = request.POST.get('share_price', None)

        settingObj = OtherSettings.objects.filter(id=int(pk))
        if not settingObj:
            data = {
                'addition': 'failed',
                'detail': 'Settings dont exists'
            }
            return JsonResponse(data, safe=False)
        else:
            settingObj.update(share_price=float(share_price), share_limit=float(share_limit))
            data = {
                'update': 'successful',
            }
            message = f"{request.user.staff.biodata.name} updated share settings"
            ActivityLog.objects.create(actor=request.user,
                                       action_type=UPDATE,
                                       title='Share settings update',
                                       branch=business_context['branch'].id,
                                       remarks=message)
            return JsonResponse(data, safe=False)


@method_decorator(csrf_exempt, name='dispatch')
class UpdateOnRegistration(PermView):
    perm_name = 'update_advanced_settings'

    def post(self, request, pk, *args, **kwargs):
        business_context = get_business_loans_context_data(request)
        on_registration_status = request.POST.get('on_registration_status', None)

        settingObj = OtherSettings.objects.filter(id=int(pk))
        if not settingObj:
            data = {
                'addition': 'failed',
                'detail': 'Settings dont exists'
            }
            return JsonResponse(data, safe=False)
        else:
            if on_registration_status == 'a':
                theSetting = False
            else:
                theSetting = True

            updateSettings = settingObj.update(
                set_ordinary=theSetting
            )
            data = {
                'update': 'successful',
            }
            return JsonResponse(data, safe=False)


class SaccoSmsSettingsAll(PermView):
    perm_name = 'update_advanced_settings'
    template_name = 'sacco/sacco_sms_settings.html'

    def get(self, request, *args, **kwargs):
        title = 'Sacco sms settings'
        sacco_sms_settings = SaccoSmsSettings.objects.filter(business__id=businessdata(request)).order_by('-id')
        # jsonQueryset = acc_types.values()
        # accountTypesJson = json.dumps(list(jsonQueryset), cls=DjangoJSONEncoder)
        http = 'http://' if not request.is_secure() else 'https://'

        baseUrl = request.headers['HOST']
        baseUrl = http + baseUrl
        context = {'title': title, 'sms_settings': sacco_sms_settings, 'baseUrl': baseUrl}
        return render(request, self.template_name, context)


@method_decorator(csrf_exempt, name='dispatch')
class UpdateSaccoSmsSetting(PermView):
    perm_name = 'update_advanced_settings'

    def post(self, request, pk, *args, **kwargs):
        the_value = request.POST.get('the_value', None)

        saccoSmsSettingObj = SaccoSmsSettings.objects.filter(id=int(pk))
        section = saccoSmsSettingObj.first().when_to_send
        if not saccoSmsSettingObj:
            data = {
                'update': 'failed',
                'section': section,
            }
            return JsonResponse(data, safe=False)
        else:
            if the_value == 'true':
                add_value = True
            else:
                add_value = False
            saccoSmsSettingObj.update(
                status=add_value
            )
            data = {
                'update': 'successful',
                'value': the_value,
                'section': section,
            }
            message = f"{request.user.staff.biodata.name} updated sms settings"
            ActivityLog.objects.create(actor=request.user,
                                       action_type=UPDATE,
                                       title='SMS settings update',
                                       branch=request.user.staff.branch_id,
                                       remarks=message)
            return JsonResponse(data, safe=False)


class SMSAdvancedSettingsView(PermView, TemplateView):
    template_name = 'sacco/advanced_sms_setting.html'
    perm_name = 'update_advanced_settings'

    def get_context_data(self, **kwargs):
        context = super().get_context_data(**kwargs)
        charge_option = NotiSettings.objects.filter(business=biz_data(self.request.user)).first()
        sms_cost = SMSCost.objects.filter(business=biz_data(self.request.user)).first()
        context['title'] = 'Advanced SMS Setting'
        context['form'] = SmsSettingForm
        context['option'] = charge_option.faces_charge
        context['amount'] = sms_cost.cost if sms_cost else 0
        return context


class SMSChargeView(FormView):
    template_name = 'sacco/advanced_sms_setting.html'
    form_class = SmsSettingForm
    success_url = reverse_lazy('advanced_sms_setting')

    def get_form_kwargs(self):
        kwargs = super(SMSChargeView, self).get_form_kwargs()
        kwargs['user'] = self.request.user
        return kwargs

    def post(self, request, *args, **kwargs):
        form = self.get_form()
        if form.is_valid():
            form.save()
            messages.success(request, 'success', extra_tags='Successfully updated message setting')
            return self.form_valid(form)
        else:
            return HttpResponseRedirect(reverse_lazy('advanced_sms_setting'))

    def form_valid(self, form):
        print(form.cleaned_data['option'])
        return super().form_valid(form)


class ManageUserRoleView(PermView):
    perm_name = 'delete_role'

    def get(self, request, pk, *args, **kwargs):
        business_context = get_business_loans_context_data(request)
        obj = get_object_or_404(Position, id=pk, business=business_context['branch'].business)
        request.session['this_role'] = obj.title
        obj.delete()
        messages.success(request, 'success', extra_tags='Successfully deleted Role')
        message = f"{request.user.staff.biodata.name} deleted role {request.session.get('this_role')}"
        ActivityLog.objects.create(actor=request.user,
                                   action_type=DELETE,
                                   title='Role deleted',
                                   branch=business_context['branch'].id,
                                   remarks=message)
        return HttpResponseRedirect(reverse_lazy('user_roles'))

    def post(self, request, pk, *args, **kwargs):
        business_context = get_business_loans_context_data(request)
        obj = get_object_or_404(Position, id=pk, business=business_context['branch'].business)
        title = request.POST['title']
        if title:
            obj.title = title
            obj.save()
            message = f"{request.user.staff.biodata.name} updated role {obj.title}"
            ActivityLog.objects.create(actor=request.user,
                                       action_type=UPDATE,
                                       title='Role Updated',
                                       branch=request.user.staff.branch_id,
                                       remarks=message)
            return HttpResponseRedirect(reverse_lazy('user_roles'))


class AddPermRoleView(PermView):
    perm_name = 'edit_role'

    def get(self, request, pk, *args, **kwargs):

        business_context = get_business_loans_context_data(request)

        position = Position.objects.get(id=pk, business=business_context['branch'].business)
        perms = list(position.permissions.values_list('id', flat=True))
        action = None

        val = request.GET.get('perms')
        if val:
            user_permission = Permissions.objects.get(id=val)
            if int(val) in perms:
                action = 'Revoked'
                position.permissions.remove(int(val))
            else:
                position.permissions.add(int(val))
                action = 'Assigned'
            message = f"{request.user.staff.biodata.name} {action} {user_permission.description} to {position.title} role"
            ActivityLog.objects.create(actor=request.user,
                                       action_type=UPDATE,
                                       title=f'Permission {action} to role',
                                       branch=business_context['branch'].id,
                                       remarks=message)
            return JsonResponse({'action': action, 'perm': user_permission.description})
        return JsonResponse({'data': 'nara'})


class MembersWithdraw(PermView):
    perm_name = 'view_withdraws'
    deco_role = 'can_withdraw'
    template_name = 'sacco/member_with.html'
    form_class = WithdrawForm

    def get_member(self, request):
        pkey = self.kwargs.get("pk")
        business_context = get_business_loans_context_data(request)
        # branch = branch_id(self.request.user)
        member = get_object_or_404(Member, id=pkey, is_active=True, branch=business_context['branch'])
        return member

    def get(self, request, pk, *args, **kwargs):
        business_context = get_business_loans_context_data(request)
        if len(business_context['data_context']) != 1:
            messages.error(
                request, "error", extra_tags="Action not allowed in the central view. Please logout and login into the respective branch"
            )
            return HttpResponseRedirect(request.META.get("HTTP_REFERER"))

        member = self.get_member(request)
        if member.is_group is False:
            title = f'{member.biodata.name} Withdraws'
        else:
            title = f'{member.name} Withdraws'
        member_accounts = AccountBroker.objects.filter(members=member)

        # determine if the staff is attached to any accounts
        check_associated_acc = StaffLedgerAssociated.objects.filter(staff=request.user.staff)
        if check_associated_acc.exists():
            acc_ids = list(check_associated_acc.values_list('account_asscociated__id', flat=True))
            accounts_ = Account.objects.filter(id__in=acc_ids)
        else:
            accounts_ = Account.objects.filter(business_id=business_context['data_context'][0],
                                               category__name__in=['Mobile Money', 'Cash', 'Bank'])

        branch = biz_staff_branch(request.user)
        accts = []
        trans_types = ['Withdraw']
        for account in member_accounts:
            accts.append(account.the_account)

        withdraws = Transactions.objects.filter(transaction_type='Withdraw', account_dr__member__in=accts)

        # deposits = initial_deposit.union(other_deposits)
        if 'filter_trans' in request.GET:
            from_date = request.GET['from_date']
            to_date = request.GET['to_date']
            formatted_from = parser.parse(from_date)
            formatted_to = parser.parse(to_date)
            if to_date > from_date:
                if from_date and to_date:
                    withdraws = Transactions.objects.filter(transaction_type='Withdraw',
                                                            account_dr__member__in=accts,
                                                            tx_date__gte=from_date,
                                                            tx_date__lte=to_date
                                                            ).order_by('-date_added')

        the_active_loans = Loans.objects.filter(account__in=accts, loan_status=3).exclude(savings_rem_balance=None)
        saving_not_withdrawable = 0
        if the_active_loans.exists():
            saving_not_withdrawable = the_active_loans.aggregate(total=Sum("savings_rem_balance"))["total"]
            if saving_not_withdrawable is None:
                saving_not_withdrawable = 0

        return render(request, self.template_name, locals())

    @can_do_this
    def post(self, request, *args, **kwargs):
        # print('its the beginning')
        try:
            business_context = get_business_loans_context_data(request)
            member = self.get_member(request)
            business = biz_data(self.request.user)
            current_transaction = date.today()
            return_url = request.META.get('HTTP_REFERER', '/')
            fy = FinancialYear.objects.filter(start_date__lte=current_transaction,
                                              end_date__gte=current_transaction, business_id=business_context['data_context'][0], status=True)

            if fy.exists():
                financial_year = fy.first()
                form = self.form_class(request.POST, user=request.user, finance_year=financial_year, member=member, business_context=business_context)
                raw_withdraw = request.POST['amount']
                account = request.POST['account_id']
                initial_before = float(raw_withdraw.replace(',', ''))
                initial = float(initial_before)
                this_account = MemberAccount.objects.get(id=account)
                member_acct = AccountBroker.objects.filter(the_account=this_account).first()
                charges = check_withdraw_charges(account, initial)

                if initial >= charges:
                    if form.is_valid():
                        try:
                            form.save()
                        except Exception as e:
                            # print('We here', e)
                            my_list = list(e)
                            return JsonResponse({'msg': 'error', 'extra': my_list[0]}, safe=True)
                        c = {
                            'amount': initial,
                            'charges': charges,
                            'owner': member_acct.members.biodata.name,
                            'acc': this_account.acc_number,
                            'rec': 'Withdraw',
                            'url': return_url
                        }
                        request.session['data'] = c
                        messages.success(request, 'success', extra_tags='Withdraw successful')
                        message = f"{request.user.staff.biodata.name} withdraw {raw_withdraw} to {this_account.acc_number}"
                        ActivityLog.objects.create(actor=request.user,
                                                   action_type=ACCOUNT,
                                                   title='Account Withdraw',
                                                   branch=branch_id(request.user),
                                                   remarks=message)
                        return JsonResponse(
                            {'msg': 'success', 'extra': 'Withdraw successful'}, safe=True)
                    else:
                        # print('nope')
                        # print(form.errors)
                        form_error = form.errors.as_json()
                        err_dict = ast.literal_eval(form_error)
                        error = err_dict['__all__'][0]['message']
                        x = ast.literal_eval(error)
                        return JsonResponse({'msg': 'error', 'extra': x[0]}, safe=True)
                else:
                    return JsonResponse({'msg': 'error', 'extra': 'Total charges are {}'.format(charges)}, safe=True)
            else:
                return JsonResponse({'msg': 'error', 'extra': 'Financial Year not set'})
        except Exception as e:
            logger.error(traceback.print_exc())
            return JsonResponse({'msg': 'error', 'extra': "Error occurred while submitting data"})


class MemberDeposit(PermView):
    perm_name = 'view_deposits'
    deco_role = 'can_deposit'
    template_name = 'sacco/member_deps.html'
    form_class = DepositForm

    def get_member(self, request):
        business_context = get_business_loans_context_data(request)
        pkey = self.kwargs.get("pk")
        # branch = branch_id(self.request.user)
        member = get_object_or_404(Member, id=pkey, is_active=True, branch=business_context['branch'])
        return member

    def get(self, request, pk, *args, **kwargs):
        business_context = get_business_loans_context_data(request)
        if business_context['branch'] is None:
            messages.error(
                request, "error",
                extra_tags="Action not allowed in the central view. Please logout and login into the respective branch"
            )
            return HttpResponseRedirect(request.META.get("HTTP_REFERER"))
        member = self.get_member(request)
        if member.is_group is False:
            title = f'{member.biodata.name} Deposits'
        else:
            title = f'{member.name} Deposits'
        member_accounts = AccountBroker.objects.filter(members=member)

        # determine if the staff is attached to any accounts
        check_associated_acc = StaffLedgerAssociated.objects.filter(staff=request.user.staff)
        if check_associated_acc.exists():
            acc_ids = list(check_associated_acc.values_list('account_asscociated__id', flat=True))
            accounts_ = Account.objects.filter(id__in=acc_ids)
        else:
            accounts_ = Account.objects.filter(business=business_context['branch'].business,
                                               category__name__in=['Mobile Money', 'Cash', 'Bank'])
        branch = biz_staff_branch(request.user)
        accts = []
        trans_types = ['Initial deposit', 'Deposit']
        for account in member_accounts:
            accts.append(account.the_account)
        # initial_deposit = Transactions.objects.filter(transaction_type='Initial deposit',
        #                                               account_cr__member__in=accts)
        deposits = Transactions.objects.filter(account_cr__member__in=accts, transaction_type__in=trans_types)

        # deposits = Transactions.objects.filter(Q(account_cr__member__in=accts) | Q(
        #     account_dr__member__in=accts)).filter(transaction_type__in=trans_types)

        # deposits = initial_deposit.union(other_deposits)
        if 'filter_trans' in request.GET:
            from_date = request.GET['from_date']
            to_date = request.GET['to_date']
            formatted_from = parser.parse(from_date)
            formatted_to = parser.parse(to_date)
            if to_date > from_date:
                if from_date and to_date:
                    initial_deposit = Transactions.objects.filter(
                        transaction_type__in=['Initial deposit', 'Deposit'],
                        account_cr__member__in=accts,
                        tx_date__gte=from_date,
                        tx_date__lte=to_date
                    ).order_by('-date_added')

                    deposits = initial_deposit

        return render(request, self.template_name, locals())

    @can_do_this
    def post(self, request, *args, **kwargs):
        # print('its the beginning')
        try:
            business_context = get_business_loans_context_data(request)
            member = self.get_member(request)
            business = biz_data(self.request.user)
            current_transaction = date.today()
            return_url = request.META.get('HTTP_REFERER', '/')
            fy = FinancialYear.objects.filter(start_date__lte=current_transaction,
                                              end_date__gte=current_transaction, business=business_context['branch'].business, status=True)

            if fy.exists():
                financial_year = fy.first()
                form = self.form_class(request.POST, user=request.user, finance_year=financial_year, member=member, branch=business_context['branch'])
                raw_deposit = request.POST['amount']
                account = request.POST['account_id']
                initial_before = float(raw_deposit.replace(',', ''))
                initial = float(initial_before)
                # inwords = num2words(initial)
                this_account = MemberAccount.objects.get(id=account)
                member_acct = AccountBroker.objects.filter(the_account=this_account).first()
                charges = check_depo_charges(account, initial)

                if initial >= charges:
                    if form.is_valid():
                        form.save()
                        c = {
                            'amount': initial,
                            'charges': charges,
                            'owner': member_acct.members.biodata.name,
                            'acc': this_account.acc_number,
                            'rec': 'Deposit',
                            'url': return_url
                        }
                        request.session['data'] = c
                        messages.success(request, 'success', extra_tags='Deposit successful')
                        message = f"{request.user.staff.biodata.name} deposited {raw_deposit} to {this_account.acc_number}"
                        ActivityLog.objects.create(actor=request.user,
                                                   action_type=ACCOUNT,
                                                   title='Account Deposit',
                                                   branch=branch_id(request.user),
                                                   remarks=message)
                        return JsonResponse(
                            {'msg': 'success', 'extra': 'Deposit successful'}, safe=True)
                    else:
                        # print('nope')
                        form_error = form.errors.as_json()
                        err_dict = ast.literal_eval(form_error)
                        error = err_dict['__all__'][0]['message']
                        x = ast.literal_eval(error)
                        return JsonResponse({'msg': 'error', 'extra': x[0]}, safe=True)
                else:
                    return JsonResponse({'msg': 'error', 'extra': 'Total charges are {}'.format(charges)}, safe=True)
            else:
                return JsonResponse({'msg': 'error', 'extra': 'Financial Year not set'})
        except Exception as e:
            logger.error(traceback.print_exc())
            return JsonResponse({'msg': 'error', 'extra': "Error occurred while submiting data"})


class CurrencySettings(BusinessUserMixin, View):
    template_name = 'sacco/currency_settings.html'

    def get(self, request, *args, **kwargs):
        title = 'Sacco currency settings'
        obj = get_object_or_404(CurrencySetting, business__id=businessdata(request))

        # Opening JSON file
        with open('allCurrencies.json', 'r') as openfile:
            # Reading from json file
            allTheCurrencies = json.load(openfile)
            # print(allTheCurrencies)

        http = 'http://'
        if request.is_secure():
            http = 'https://'

        baseUrl = request.headers['HOST']
        baseUrl = http + baseUrl

        return render(request, self.template_name, locals())


@method_decorator(csrf_exempt, name='dispatch')
class UpdateCurrency(PermView):
    perm_name = 'update_currency_settings'

    def post(self, request, pk, *args, **kwargs):
        the_currency = request.POST.get('the_currency', None)

        currencySettingObj = CurrencySetting.objects.filter(id=int(pk))
        if not currencySettingObj:
            data = {
                'addition': 'failed',
                'detail': 'Settings dont exists'
            }
            return JsonResponse(data, safe=False)
        else:

            updateSettings = currencySettingObj.update(
                currency=the_currency
            )
            data = {
                'update': 'successful',
            }
            message = f"{request.user.staff.biodata.name} updated currency settings"
            ActivityLog.objects.create(actor=request.user,
                                       action_type=UPDATE,
                                       title='Currency settings',
                                       branch=branch_id(request.user),
                                       remarks=message)
            return JsonResponse(data, safe=False)


@method_decorator(csrf_exempt, name='dispatch')
class UpdateCurrencyIndication(PermView):
    perm_name = 'update_currency_settings'

    def post(self, request, pk, *args, **kwargs):
        the_value = request.POST.get('the_value', None)

        currencySettingObj = CurrencySetting.objects.filter(id=int(pk))
        if not currencySettingObj:
            data = {
                'addition': 'failed',
                'detail': 'Settings dont exists'
            }
            return JsonResponse(data, safe=False)
        else:
            if the_value == 's':
                theSetting = True
            else:
                theSetting = False

            updateSettings = currencySettingObj.update(
                show_currency=theSetting
            )
            data = {
                'update': 'successful',
            }
            message = f"{request.user.staff.biodata.name} updated currency settings"
            ActivityLog.objects.create(actor=request.user,
                                       action_type=UPDATE,
                                       title='Currency settings',
                                       branch=branch_id(request.user),
                                       remarks=message)
            return JsonResponse(data, safe=False)


class TransactionChargesSettings(PermView):
    perm_name = 'view_transaction_charges'
    template_name = 'sacco/transaction_charges_settings.html'

    def get(self, request, *args, **kwargs):
        title = 'Sacco transaction charges settings'
        accountTypesObj = AccountTypes.objects.filter(business__id=businessdata(request)).order_by('-id')
        # jsonQueryset = acc_types.values()
        # accountTypesJson = json.dumps(list(jsonQueryset), cls=DjangoJSONEncoder)
        http = 'http://'
        if request.is_secure():
            http = 'https://'

        baseUrl = request.headers['HOST']
        baseUrl = http + baseUrl

        return render(request, self.template_name, locals())


@method_decorator(csrf_exempt, name='dispatch')
class UpdateTransactionChargeSettings(PermView):
    perm_name = 'update_advanced_settings'

    def post(self, request, pk, *args, **kwargs):
        the_value = request.POST.get('the_value', None)
        the_type = request.POST.get('the_type', None)

        accTypeObj = AccountTypes.objects.filter(id=pk)
        if not accTypeObj:
            data = {
                'update': 'failed',
                'detail': 'Settings dont exist'
            }
            return JsonResponse(data, safe=False)
        else:
            if the_value == 'true':
                add_value = True
            else:
                add_value = False

            if the_type == 'd':
                updateSettings = accTypeObj.update(
                    deposit_charge=add_value
                )
            elif the_type == 'w':
                updateSettings = accTypeObj.update(
                    withdraw_charge=add_value
                )
            else:
                updateSettings = accTypeObj.update(
                    transfer_charge=add_value
                )

            data = {
                'update': 'successful',
            }
            message = f"{request.user.staff.biodata.name} updated transaction charge settings"
            ActivityLog.objects.create(actor=request.user,
                                       action_type=UPDATE,
                                       title='Transaction charge settings',
                                       branch=branch_id(request.user),
                                       remarks=message)
            return JsonResponse(data, safe=False)


@method_decorator(csrf_exempt, name='dispatch')
class SearchTransactionChargeSetting(BusinessUserMixin, View):
    template_name = 'sacco/search_transaction_charge_settings.html'

    def post(self, request, *args, **kwargs):
        search_text = request.POST['search_text']
        if search_text is not None or search_text != "":
            accountTypesObj = AccountTypes.objects.filter(business__id=businessdata(request),
                                                          name__icontains=search_text).order_by('-id')
        else:
            accountTypesObj = AccountTypes.objects.filter(business__id=businessdata(request)).order_by('-id')

        return HttpResponse(render_to_string(self.template_name, locals()))


class ShareTransactions(PermView):
    template_name = 'sacco/shareholder_transactions.html'

    def get(self, request, *args, **kwargs):
        business_context = get_business_loans_context_data(request)
        if business_context['branch'] is None:
            messages.error(
                request, "error",
                extra_tags="Action not allowed in the central view. Please logout and login into the respective branch"
            )
            return HttpResponseRedirect(request.META.get("HTTP_REFERER"))
        if business_context['the_current_branch_name'] == 'all branches':
            title = "Share transactions for all branches"
        else:
            the_current_branch_name = business_context['the_current_branch_name']
            title = f"Share transactions for {the_current_branch_name}"
        # title = 'Share transactions'
        business_shares = BusinessShares.objects.filter(business=business_context['branch'].business).first()
        share_holders = Member.objects.filter(
            # member_type='o',
            biodata__business=business_context['branch'].business
        )
        business_setting = OtherSettings.objects.filter(business=business_context['branch'].business).first()
        if business_shares.market_cap > 0 and business_setting.share_price > 0:
            share_balance = business_shares.market_cap / business_setting.share_price - business_shares.sold
        else:
            share_balance = 0

        all_members = Member.objects.filter(biodata__business=business_context['branch'].business).order_by('-id')
        jsonQuerysetSaccoMembers = all_members.values()
        allMembersJson = json.dumps(list(jsonQuerysetSaccoMembers), cls=DjangoJSONEncoder)

        group = get_object_or_404(BusinessShares, business=business_context['branch'].business)

        the_market_cap = group.market_cap

        shareCharges = GeneralCharge.objects.filter(business=business_context['branch'].business, application='s')
        total = 0
        for charge in shareCharges:
            total = total + charge.amount

        http = 'http://'
        if request.is_secure():
            http = 'https://'

        baseUrl = request.headers['HOST']
        baseUrl = http + baseUrl

        return render(request, self.template_name, locals())


@method_decorator(csrf_exempt, name='dispatch')
class UpdateMembershipStatus(PermView):
    perm_name = 'update_share_settings'

    @transaction.atomic()
    def post(self, request, pk, *args, **kwargs):
        business_context = get_business_loans_context_data(request)
        status = request.POST.get('status', None)
        acc_id = request.POST.get('acc_id', None)
        date_created = datetime.datetime.now().date()

        memberObj = Member.objects.filter(id=pk)
        if not memberObj:
            data = {
                'update': 'failed',
                'details': 'member nolonger exists'
            }
            return JsonResponse(data, safe=False)

        if memberObj[0].member_type == status:
            data = {
                'update': 'failed',
                'details': 'Membership status didnt change'
            }
            return JsonResponse(data, safe=False)

        # from ordinary to shareholder
        # check if the credit account has enough balance

        # check if there are existing charges for sacco for on shares
        shareCharges = GeneralCharge.objects.filter(business=business_context['branch'].business, application='s')
        total = 0
        for charge in shareCharges:
            total = total + charge.amount

        smsSettingsObj = SaccoSmsSettings.objects.get(when_to_send='On membership change',
                                                      business=business_context['branch'].business)

        if status == 's':
            # update credited and debited accounts
            if acc_id != 'null':
                accountObj = MemberAccount.objects.get(id=int(acc_id))

                if accountObj.balance < total:
                    data = {
                        'update': 'failed',
                        'details': 'Insufficient account balance',
                    }
                    return JsonResponse(data, safe=False)

            equity_cat, created = AccountCategory.objects.get_or_create(business=business_context['branch'].business, name="Shares",
                                                                        dr_cr='cr', cat_type='liability')
            equity, created = Account.objects.get_or_create(name='Share Capital', business=business_context['branch'].business,
                                                            category=equity_cat)

            if acc_id == 'null':
                theAcc = None
                equity = None
            else:
                # get current financial year
                current_transaction = datetime.datetime.today()
                fy = FinancialYear.objects.filter(start_date__lte=current_transaction,
                                                  end_date__gte=current_transaction,
                                                  business=business_context['branch'].business)
                if fy.exists():
                    financial_year = fy.first()
                else:
                    data = {
                        'update': 'failed',
                        'details': 'Financial year not set'
                    }
                    return JsonResponse(data, safe=False)

                member_acc = Account.objects.get(member_id=int(acc_id))

                Transactions.objects.create(
                    branch=business_context['branch'],
                    transaction_type="Share Charge",
                    financial_year=financial_year,
                    account_dr=equity,
                    account_cr=member_acc,
                    narration="Charge on Membership status change",
                    reporting_amount=total,
                    added_by=biz_staff(request.user),
                    tx_date=date_created
                )
        else:
            # check if member has any shares
            if memberObj[0].shares > 0:
                data = {
                    'update': 'failed',
                    'details': 'Please first sell the shares'
                }
                return JsonResponse(data, safe=False)

        updateMember = memberObj.update(member_type=status)
        if status == 's':
            currentStatus = 'ordinary'
            newStatus = 'shareholder'
        else:
            currentStatus = 'shareholder'
            newStatus = 'ordinary'

        if currentStatus == 'shareholder':
            theTotalMessage = ''
        else:
            theTotalMessage = ' with total charges of ' + str(total)
        theMessage = 'This is to notify you that your membership status has been changed from ' + currentStatus + ' to ' + newStatus + theTotalMessage

        if smsSettingsObj.status:
            checkAndSendMessage(request.user, theMessage, memberObj[0].biodata.contact,
                                memberObj[0].biodata.name, member=memberObj)
        else:
            template_file_link = 'mufukoadmin/emails/action_email.html'
            html_body = '<p>Hello ' + memberObj[0].biodata.name.__str__() + ',</p> ' + theMessage

            sendEmail(template_file_link, html_body, 'Cheers', 'Membership status changed', memberObj[0].biodata.email)

        all_members = Member.objects.filter(biodata__business=business_context['branch'].business).order_by('-id')
        jsonQuerysetSaccoMembers = all_members.values()
        allMembersJson = json.dumps(list(jsonQuerysetSaccoMembers), cls=DjangoJSONEncoder)

        data = {
            'update': 'successful',
            'allMembersJson': allMembersJson,
        }
        return JsonResponse(data, safe=False)


class AllMemberAccounts(BusinessUserMixin, ViewPermissionsMixin, View):
    def has_permissions(self):
        perms, created = Permissions.objects.get_or_create(item_name='can_view_member_accounts',
                                                           description='Can View Member Accounts')
        user_role = self.request.user.staff.position
        perms_in_role = list(user_role.permissions.all().values_list('id', flat=True))
        return perms.id in perms_in_role

    def get(self, request, pk, *args, **kwargs):
        memberObj = Member.objects.get(id=pk)
        allAcc = memberObj.accounts.all()
        jsonQueryallAcc = allAcc.values()
        allAccJson = json.dumps(list(jsonQueryallAcc), cls=DjangoJSONEncoder)
        data = {
            'fetch': 'successful',
            'allAccJson': allAccJson,
            'status': memberObj.member_type
        }
        return JsonResponse(data, safe=False)


class SmsBroadcastCenter(BusinessUserMixin, View):
    template_name = 'sacco/sms_broadcast_center.html'

    def get(self, request, *args, **kwargs):
        title = 'Sms broadcast center'
        # account =
        all_members = Member.objects.filter(biodata__business__id=businessdata(request)).order_by('biodata__name')

        date_today = datetime.datetime.today()
        current_month_first_day = date_today.replace(day=1, hour=0, minute=0, second=0, microsecond=0)

        dt = date_today
        next_month_first_day = (dt.replace(day=1) + timedelta(days=32)).replace(day=1)
        next_month_first_day = next_month_first_day.replace(day=1, hour=0, minute=0, second=0, microsecond=0)

        # print(today.month)
        thisMonthCount = SmsTransaction.objects.filter(
            created_date__range=[current_month_first_day, next_month_first_day],
            branch=biz_staff_branch(request.user)

        ).count()

        totalBroadcastedCount = SmsTransaction.objects.filter(branch=biz_staff_branch(request.user)).count()
        saccoBranchSmsQuantity = Sms.objects.get(branch=biz_staff_branch(request.user)).quantity
        recepientsCount = SmsTransaction.objects.filter(branch=biz_staff_branch(request.user)).values(
            'receiver').distinct().count()

        savingProductObj = AccountTypes.objects.filter(business_id=businessdata(request))
        loanTypesObj = LoanTypes.objects.filter(business_id=businessdata(request))

        http = 'http://' if not request.is_secure() else 'https://'

        baseUrl = request.headers['HOST']
        baseUrl = http + baseUrl

        return render(request, self.template_name, locals())


@method_decorator(csrf_exempt, name='dispatch')
class SaccoBroadcastMesssages(BusinessUserMixin, View):

    def manage_charge(self, chager, account, user, sms_cost, no_of_messages):
        if chager.faces_charge == 'Client':
            rec_no = datetime.datetime.now().strftime("%y%m%d%H%M%S")
            today = datetime.date.today()
            fy = FinancialYear.objects.filter(start_date__lte=today, end_date__gte=today).first()
            category = AccountCategory.objects.filter(name='Income').first()
            if account:
                # members_account = MemberAccount.objects.filter(memeber_account__).first().the_account
                sms_revenue = Account.objects.filter(name='SMS Revenue', category=category)
                if not sms_revenue.exists():
                    new_acc = Account.objects.create(name='SMS Revenue', display_name='SMS Revenue', category=category,
                                                     business=biz_data(user))
                else:
                    new_acc = sms_revenue.first()

                Transactions.objects.create(
                    branch=biz_staff_branch(user),
                    transaction_type='SMS Charge',
                    account_dr=account,
                    account_cr=new_acc,
                    narration="Payment for SMSs received",
                    reporting_amount=sms_cost.cost if sms_cost else 0 * no_of_messages,
                    added_by=biz_staff(user),
                    financial_year=fy,
                    tx_date=today,
                    receipt=rec_no,
                    reference=rec_no
                )
            else:
                print('no account')

    def post(self, request, *args, **kwargs):
        data = json.loads(request.POST.get('data', None))
        chager = NotiSettings.objects.filter(business=biz_data(self.request.user)).first()

        saccoBranchSmsObj = Sms.objects.filter(branch=biz_staff_branch(request.user))
        if not saccoBranchSmsObj:
            data = {
                'send': 'failed',
                'details': 'sacco settings dont exist'
            }
            return JsonResponse(data, safe=False)

        messageSent = 0
        messagesFailed = 0
        currentSaccoMessages = saccoBranchSmsObj[0].quantity

        # calculate number of messages person
        no_of_messages = len(data['message']) / 160

        if isInt(no_of_messages):
            theMessCount = no_of_messages
        else:
            theMessCount = int(no_of_messages) + 1

        if currentSaccoMessages < theMessCount:
            data = {
                'send': 'failed',
                'details': 'Insufficient messages'
            }
            return JsonResponse(data, safe=False)

        if data['the_type'] == 'member':
            for theMember in data['members']:
                memberObj = Member.objects.filter(id=int(theMember))
                if memberObj:
                    if currentSaccoMessages >= theMessCount:
                        theresponse = sendMessage(memberObj[0].biodata.contact, data['message'])
                        if theresponse == 'failed':
                            messagesFailed = messagesFailed + theMessCount
                            addSmsTransaction = SmsTransaction.objects.create(
                                branch=biz_staff_branch(request.user),
                                quantity=theMessCount,
                                trans_type=SmsTransaction.USAGE,
                                body=data['message'],
                                receiver=memberObj[0].biodata.name,
                                is_broadcast=True,
                                delivery_id=theresponse,
                                status=SmsTransaction.FAILED,
                                added_by=biz_staff(request.user),
                                message_id=theresponse
                            )
                        else:
                            addSmsTransaction = SmsTransaction.objects.create(
                                branch=biz_staff_branch(request.user),
                                quantity=theMessCount,
                                trans_type=SmsTransaction.USAGE,
                                body=data['message'],
                                receiver=memberObj[0].biodata.name,
                                is_broadcast=True,
                                delivery_id=theresponse,
                                status=SmsTransaction.PENDING,
                                added_by=biz_staff(request.user),
                                message_id=theresponse
                            )
                            messageSent = messageSent + theMessCount
                            currentSaccoMessages = currentSaccoMessages - theMessCount

                            # self.manage_charge(chager, account, user, sms_cost, no_of_messages)
                    else:
                        messagesFailed = messagesFailed + theMessCount
                        addSmsTransaction = SmsTransaction.objects.create(
                            branch=biz_staff_branch(request.user),
                            quantity=theMessCount,
                            trans_type=SmsTransaction.USAGE,
                            body=data['message'],
                            receiver=memberObj[0].biodata.name,
                            is_broadcast=True,
                            delivery_id=theresponse,
                            status=SmsTransaction.FAILED,
                            added_by=biz_staff(request.user),
                            message_id=theresponse
                        )

        else:
            if data['group'] == 'members':
                theMessagesLoopList = Member.objects.filter(branch=biz_staff_branch(request.user))
            elif data['group'] == 'shareholder':
                theMessagesLoopList = Member.objects.filter(branch=biz_staff_branch(request.user),
                                                            member_type='s')
            elif data['group'] == 'ordinary':
                theMessagesLoopList = Member.objects.filter(branch=biz_staff_branch(request.user),
                                                            member_type='o')
            elif data['group'] == 'staff':
                theMessagesLoopList = Staff.objects.filter(branch=biz_staff_branch(request.user))

            elif data['group'] == 'loans':
                # theCount= Staff.objects.filter(branch=biz_staff_branch(request.user), is_active=True).count()
                theMessagesLoopList = Loans.objects.filter(branch=biz_staff_branch(request.user), loan_status=3)

            elif 'saving_product' in data['group']:

                theId = data['group'].replace('saving_product', '')
                theMessagesLoopList = Member.objects.filter(branch=biz_staff_branch(request.user),
                                                            accounts__account_type_id=int(theId), is_active=True)
            elif 'loan_type' in data['group']:
                theId = data['group'].replace('loan_type', '')
                theMessagesLoopList = Loans.objects.filter(branch=biz_staff_branch(request.user),
                                                           loan_type_id=int(theId),
                                                           loan_status=3)
            elif 'status' in data['group']:
                if data['group'] == 'status_applied':
                    theMessagesLoopList = Loans.objects.filter(branch=biz_staff_branch(request.user), loan_status=0)
                elif data['group'] == 'status_appraised':
                    theMessagesLoopList = Loans.objects.filter(branch=biz_staff_branch(request.user), loan_status=1)
                elif data['group'] == 'status_approved':
                    theMessagesLoopList = Loans.objects.filter(branch=biz_staff_branch(request.user), loan_status=2)
                elif data['group'] == 'status_disbursed':
                    theMessagesLoopList = Loans.objects.filter(branch=biz_staff_branch(request.user), loan_status=3)
                elif data['group'] == 'status_closed':
                    theMessagesLoopList = Loans.objects.filter(branch=biz_staff_branch(request.user), loan_status=4)
                elif data['group'] == 'status_rejected':
                    theMessagesLoopList = Loans.objects.filter(branch=biz_staff_branch(request.user), loan_status=5)
                elif data['group'] == 'status_waived_off':
                    theMessagesLoopList = Loans.objects.filter(branch=biz_staff_branch(request.user), loan_status=6)
                elif data['group'] == 'status_written_off':
                    theMessagesLoopList = Loans.objects.filter(branch=biz_staff_branch(request.user), loan_status=7)
                elif data['group'] == 'status_topped_up':
                    theMessagesLoopList = Loans.objects.filter(branch=biz_staff_branch(request.user), loan_status=8)

            for theAccount in theMessagesLoopList:
                if currentSaccoMessages >= theMessCount:
                    if data['group'] == 'loans' or 'status' in data['group'] or 'loan_type' in data['group']:
                        memberObj = Member.objects.get(accounts=theAccount.account)
                        contact = memberObj.biodata.contact
                        thereceiver = memberObj.biodata.name
                    else:
                        contact = theAccount.biodata.contact
                        thereceiver = theAccount.biodata.name
                    theresponse = sendMessage(contact, data['message'])
                    if theresponse == 'failed':
                        messagesFailed = messagesFailed + theMessCount
                        addSmsTransaction = SmsTransaction.objects.create(
                            branch=biz_staff_branch(request.user),
                            quantity=theMessCount,
                            trans_type=SmsTransaction.USAGE,
                            body=data['message'],
                            receiver=thereceiver,
                            is_broadcast=True,
                            delivery_id=theresponse,
                            status=SmsTransaction.FAILED,
                            added_by=biz_staff(request.user),
                            message_id=theresponse

                        )
                    else:
                        addSmsTransaction = SmsTransaction.objects.create(
                            branch=biz_staff_branch(request.user),
                            quantity=theMessCount,
                            trans_type=SmsTransaction.USAGE,
                            body=data['message'],
                            receiver=thereceiver,
                            is_broadcast=True,
                            delivery_id=theresponse,
                            status=SmsTransaction.PENDING,
                            added_by=biz_staff(request.user),
                            message_id=theresponse

                        )
                        messageSent = messageSent + theMessCount
                        currentSaccoMessages = currentSaccoMessages - theMessCount
                else:
                    messagesFailed = messagesFailed + theMessCount
                    addSmsTransaction = SmsTransaction.objects.create(
                        branch=biz_staff_branch(request.user),
                        quantity=theMessCount,
                        trans_type=SmsTransaction.USAGE,
                        body=data['message'],
                        receiver=thereceiver,
                        is_broadcast=True,
                        delivery_id=theresponse,
                        status=SmsTransaction.FAILED,
                        added_by=biz_staff(request.user),
                        message_id=theresponse

                    )

        # update sacco messages
        updateSaccoBranchQuantity = saccoBranchSmsObj.update(
            quantity=currentSaccoMessages
        )

        totalBroadcastedCount = SmsTransaction.objects.filter(branch=biz_staff_branch(request.user)).count()
        saccoBranchSmsQuantity = Sms.objects.get(branch=biz_staff_branch(request.user)).quantity
        recepientsCount = SmsTransaction.objects.filter(branch=biz_staff_branch(request.user)
                                                        ).values('receiver').distinct().count()

        date_today = datetime.datetime.today()
        current_month_first_day = date_today.replace(day=1, hour=0, minute=0, second=0, microsecond=0)

        dt = date_today
        next_month_first_day = (dt.replace(day=1) + timedelta(days=32)).replace(day=1)
        next_month_first_day = next_month_first_day.replace(day=1, hour=0, minute=0, second=0, microsecond=0)

        # print(today.month)
        thisMonthCount = SmsTransaction.objects.filter(
            created_date__range=[current_month_first_day, next_month_first_day],
            branch=biz_staff_branch(request.user)

        ).count()

        data = {
            'send': 'successful',
            'messageSent': messageSent,
            'messagesFailed': messagesFailed,
            'totalBroadcastedCount': totalBroadcastedCount,
            'saccoBranchSmsQuantity': saccoBranchSmsQuantity,
            'recepientsCount': recepientsCount,
            'thisMonthCount': thisMonthCount
        }
        return JsonResponse(data, safe=False)


class UpdateMessagesOnPageLoading(BusinessUserMixin, View):
    def get(self, request, *args, **kwargs):
        branchSmsTransactions = SmsTransaction.objects.filter(branch=biz_staff_branch(request.user),
                                                              status=SmsTransaction.PENDING)

        for theTransaction in branchSmsTransactions:

            theResponse = checkMessageStatus(theTransaction.message_id)
            print('WE ARE UPDATING', theResponse)
            if theResponse == 'accepted':
                SmsTransaction.objects.filter(id=theTransaction.id).update(
                    status=SmsTransaction.SENT)
            elif theResponse == 'failed':
                SmsTransaction.objects.filter(id=theTransaction.id).update(status=SmsTransaction.FAILED)
                branchSmsObj = Sms.objects.filter(branch=biz_staff_branch(request.user))
                newQuantity = branchSmsObj[0].quantity + 1
                branchSmsObj.update(quantity=newQuantity)

        totalBroadcastedCount = SmsTransaction.objects.filter(branch=biz_staff_branch(request.user)).count()
        saccoBranchSmsQuantity = Sms.objects.get(branch=biz_staff_branch(request.user)).quantity
        recepientsCount = SmsTransaction.objects.filter(branch=biz_staff_branch(request.user)).values(
            'receiver').distinct().count()

        date_today = datetime.datetime.today()
        current_month_first_day = date_today.replace(day=1, hour=0, minute=0, second=0, microsecond=0)

        dt = date_today
        next_month_first_day = (dt.replace(day=1) + timedelta(days=32)).replace(day=1)
        next_month_first_day = next_month_first_day.replace(day=1, hour=0, minute=0, second=0, microsecond=0)

        thisMonthCount = SmsTransaction.objects.filter(
            created_date__range=[current_month_first_day, next_month_first_day],
            branch=biz_staff_branch(request.user)

        ).count()

        data = {
            'update': 'successful',
            'totalBroadcastedCount': totalBroadcastedCount,
            'saccoBranchSmsQuantity': saccoBranchSmsQuantity,
            'recepientsCount': recepientsCount,
            'thisMonthCount': thisMonthCount
        }
        return JsonResponse(data, safe=False)


class BulkDeposit(PermView):
    perm_name = 'can_deposit'
    template_name = 'sacco/bulk_deposit.html'

    def get(self, request, *args, **kwargs):
        title = 'Make Bulk deposits'
        biz_accounts = AccountBroker.objects.filter(business=businessdata(request))
        accounts_ = Account.objects.filter(business=businessdata(request),
                                           category__name__in=['Mobile Money', 'Cash', 'Bank'])
        return render(request, self.template_name, locals())

    def post(self, request, *args, **kwargs):
        amount = request.POST['deposit']
        accounts = request.POST.getlist('accounts')
        account_credited = request.POST['the_account']
        current_transaction = datetime.datetime.today()
        int_accounts = [int(ac) for ac in accounts]
        business = biz_data(self.request.user)
        financial_year = FinancialYear.objects.filter(business=business, status=True).first()
        if financial_year is not None:
            if financial_year.is_within_financial_year(input_date=current_transaction):
                if amount and accounts:
                    bulk_member_deposit(request.user, int_accounts, amount, account_credited, financial_year)
                    messages.success(request, 'success', extra_tags='Successfully deposited')
                    message = f"{request.user.staff.biodata.name} made a bulk deposited"
                    ActivityLog.objects.create(actor=request.user,
                                               action_type=ACCOUNT,
                                               title='Bulk deposit',
                                               branch=branch_id(request.user),
                                               remarks=message)
                    return HttpResponseRedirect(reverse_lazy('bulk_deposit'))
        # else:
        #     messages.error(request, 'error', extra_tags='Are all fields filled')
        return HttpResponseRedirect(reverse_lazy('bulk_deposit'))


class AdvancedSettings(BusinessUserMixin, View):
    template_name = 'sacco/advanced_settings.html'

    def get(self, request, *args, **kwargs):
        title = 'Advanced settings'

        notificationSettingObj = get_object_or_404(NotiSettings, business_id=businessdata(request))

        http = 'http://' if not request.is_secure() else 'https://'

        baseUrl = request.headers['HOST']
        baseUrl = http + baseUrl

        return render(request, self.template_name, locals())


@method_decorator(csrf_exempt, name='dispatch')
class UpdateNotificationSettings(BusinessUserMixin, View):

    def post(self, request, *args, **kwargs):
        the_value = request.POST.get('the_value', None)

        notificationSettingObj = NotiSettings.objects.filter(business_id=businessdata(request))
        if not notificationSettingObj:
            data = {
                'addition': 'failed',
                'detail': 'Settings dont exists'
            }
            return JsonResponse(data, safe=False)
        else:

            updateSettings = notificationSettingObj.update(
                notification_type=int(the_value)
            )
            data = {
                'update': 'successful',
            }
            message = f"{request.user.staff.biodata.name} has updated notification settings"
            ActivityLog.objects.create(actor=request.user,
                                       action_type=UPDATE,
                                       title='Notifications updates',
                                       branch=branch_id(request.user),
                                       remarks=message)
            return JsonResponse(data, safe=False)


class SmsCenter(BusinessUserMixin, View):
    template_name = 'sacco/sms_center.html'

    def get(self, request, *args, **kwargs):
        title = 'Sms center'

        # notificationSettingObj = get_object_or_404(NotiSettings, business_id=businessdata(request))
        date_today = datetime.datetime.today()
        current_month_first_day = date_today.replace(day=1, hour=0, minute=0, second=0, microsecond=0)

        dt = date_today
        next_month_first_day = (dt.replace(day=1) + timedelta(days=32)).replace(day=1)
        next_month_first_day = next_month_first_day.replace(day=1, hour=0, minute=0, second=0, microsecond=0)

        # print(today.month)
        thisMonthCount = SmsTransaction.objects.filter(
            created_date__range=[current_month_first_day, next_month_first_day],
            branch=biz_staff_branch(request.user)

        ).count()

        totalBroadcastedCount = SmsTransaction.objects.filter(branch=biz_staff_branch(request.user)).count()
        saccoBranchSmsQuantity = Sms.objects.get(branch=biz_staff_branch(request.user)).quantity
        recepientsCount = SmsTransaction.objects.filter(branch=biz_staff_branch(request.user)).values(
            'receiver').distinct().count()

        smsTransactions = SmsTransaction.objects.filter(branch=biz_staff_branch(request.user),
                                                        trans_type=SmsTransaction.USAGE).order_by('-id')

        http = 'http://' if not request.is_secure() else 'https://'

        baseUrl = request.headers['HOST']
        baseUrl = http + baseUrl

        return render(request, self.template_name, locals())


@method_decorator(csrf_exempt, name='dispatch')
class SmsGroupCount(BusinessUserMixin, View):
    def post(self, request, *args, **kwargs):
        theGroupId = request.POST.get('the_group_id', None)

        if theGroupId == 'members':
            theCount = Member.objects.filter(branch=biz_staff_branch(request.user), is_active=True).count()
        elif theGroupId == 'shareholder':
            theCount = Member.objects.filter(branch=biz_staff_branch(request.user), member_type='s',
                                             is_active=True).count()
        elif theGroupId == 'ordinary':
            theCount = Member.objects.filter(branch=biz_staff_branch(request.user), member_type='o',
                                             is_active=True).count()
        elif theGroupId == 'staff':
            theCount = Staff.objects.filter(branch=biz_staff_branch(request.user), is_active=True).count()
        elif theGroupId == 'loans':
            # theCount= Staff.objects.filter(branch=biz_staff_branch(request.user), is_active=True).count()
            theCount = Loans.objects.filter(branch=biz_staff_branch(request.user), loan_status=3).count()
        elif 'saving_product' in theGroupId:

            theId = theGroupId.replace('saving_product', '')
            theCount = Member.objects.filter(branch=biz_staff_branch(request.user),
                                             accounts__account_type_id=int(theId), is_active=True).count()
        elif 'loan_type' in theGroupId:
            theId = theGroupId.replace('loan_type', '')
            theCount = Loans.objects.filter(branch=biz_staff_branch(request.user), loan_type_id=int(theId),
                                            loan_status=3).count()
        elif 'status' in theGroupId:
            if theGroupId == 'status_applied':
                theCount = Loans.objects.filter(branch=biz_staff_branch(request.user), loan_status=0).count()
            elif theGroupId == 'status_appraised':
                theCount = Loans.objects.filter(branch=biz_staff_branch(request.user), loan_status=1).count()
            elif theGroupId == 'status_approved':
                theCount = Loans.objects.filter(branch=biz_staff_branch(request.user), loan_status=2).count()
            elif theGroupId == 'status_disbursed':
                theCount = Loans.objects.filter(branch=biz_staff_branch(request.user), loan_status=3).count()
            elif theGroupId == 'status_closed':
                theCount = Loans.objects.filter(branch=biz_staff_branch(request.user), loan_status=4).count()
            elif theGroupId == 'status_rejected':
                theCount = Loans.objects.filter(branch=biz_staff_branch(request.user), loan_status=5).count()
            elif theGroupId == 'status_waived_off':
                theCount = Loans.objects.filter(branch=biz_staff_branch(request.user), loan_status=6).count()
            elif theGroupId == 'status_written_off':
                theCount = Loans.objects.filter(branch=biz_staff_branch(request.user), loan_status=7).count()
            elif theGroupId == 'status_topped_up':
                theCount = Loans.objects.filter(branch=biz_staff_branch(request.user), loan_status=8).count()

        saccoBranchSmsQuantity = Sms.objects.get(branch=biz_staff_branch(request.user)).quantity

        data = {
            'fetch': 'successful',
            'the_count': theCount,
            'current_messages': saccoBranchSmsQuantity
        }
        return JsonResponse(data, safe=False)


@method_decorator(csrf_exempt, name='dispatch')
class UpdateMarketCap(BusinessUserMixin, View):

    def post(self, request, *args, **kwargs):
        business_context = get_business_loans_context_data(request)
        market_cap = request.POST.get('market_cap', None)

        businessSharesObj = BusinessShares.objects.filter(business=business_context['branch'].business)
        if not businessSharesObj:
            data = {
                'update': 'failed',
                'details': 'settings dont exist'
            }
            return JsonResponse(data, safe=False)
        else:
            updateBusinessShares = businessSharesObj.update(
                market_cap=int(float(market_cap))
            )
            data = {
                'update': 'successful',
            }
            message = f"{request.user.staff.biodata.name} has updated the marketcap"
            ActivityLog.objects.create(actor=request.user,
                                       action_type=UPDATE,
                                       title='Markepcap updates',
                                       branch=business_context['branch'].id,
                                       remarks=message)
            return JsonResponse(data, safe=False)


class MemberAccountsView(PermView):
    perm_name = 'can_view_member_accounts'
    template_name = 'sacco/member_accounts.html'

    def get(self, request, *args, **kwargs):
        business_context = session_business_data(request)
        data_context = determine_business_id_list(request.user.staff, business_context)
        business_context_revised = get_business_loans_context_data(request)

        the_current_branch_name = ''
        if business_context is None:
            the_current_branch_name = 'all branches'
        else:
            # get the current branch
            the_current_branch_name = Branch.objects.filter(business=business_context).first().name

        the_filter_branch = ''
        business_filter = ''
        if business_context is None:
            business_filter = request.GET.get('business_filter', '')
            if business_filter:
                if business_filter != 'all_branches':
                    # get the branch
                    the_filter_branch = Branch.objects.filter(business_id=business_filter).first().name
                    # update the data context businesses
                    data_context['all_ids'] = [business_filter]
                else:
                    the_filter_branch = 'all branches'

        if data_context['title'] == 'all branches':
            title = 'Member accounts for all branches'
        else:
            title = f'Member accounts for {the_current_branch_name}'

        client = 'Members'

        # title = f'{client} Accounts\''
        user = request.user
        branch = biz_staff_branch(user)

        #update of the balance
        # recalculate_shares(business_context_['branch'].id)
        # recalculate_shares(branchdata(request))
        # recalculate_savings(businessdata(request))
        # trigger the update of account balance
        if business_context_revised['branch'] is None:
            for biz_id in data_context['all_ids']:
                the_biz_branch=Branch.objects.filter(business_id=biz_id).first()
                SavingsSharesRecalculate.objects.create(
                    branch=the_biz_branch,
                    update_type = 'shares'
                )
                SavingsSharesRecalculate.objects.create(
                    branch=the_biz_branch,
                    update_type='savings'
                )
        else:
            SavingsSharesRecalculate.objects.create(
                branch=business_context_revised['branch'],
                update_type='shares'
            )
            SavingsSharesRecalculate.objects.create(
                branch=business_context_revised['branch'],
                update_type='savings'
            )


        members = []
        if 'data' in request.session:
            del request.session['data']
        biz_accounts = AccountBroker.objects.filter(members__branch__business_id__in=data_context['all_ids'],
                                                    members__is_active=True, the_account__is_active=True
                                                    )

        # Apply filters
        member_name = request.GET.get('member_name', '')
        account_number = request.GET.get('account_number', '')
        if member_name:
            biz_accounts = biz_accounts.filter(members__biodata__name__icontains=member_name.strip())
        if account_number:
            biz_accounts = biz_accounts.filter(the_account__acc_number__icontains=account_number.strip())

        biz_accounts = biz_accounts.annotate(acc_number=F('the_account__acc_number')).annotate(
            name=F('members__biodata__name')).annotate(account_type=F('the_account__account_type__name')
                                                       ).annotate(balance=F('the_account__balance')
                                                                  ).annotate(portal=F('members__portal')).values(
            'acc_number', 'name', 'members_id', 'account_type', 'balance',
            'portal', 'the_account_id', 'members__branch__name')

        # Pagination
        page = request.GET.get('page', 1)
        paginator = Paginator(biz_accounts, 10)

        try:
            biz_accounts = paginator.page(page)
        except PageNotAnInteger:
            biz_accounts = paginator.page(1)
        except EmptyPage:
            biz_accounts = paginator.page(paginator.num_pages)

        context = {
            'biz_accounts': biz_accounts,
            # 'accounts_': accounts_,
            # 'all_charges': all_charges,
            'title': title,
            'members': members,
            'member_name':member_name,
            'account_number':account_number,
            'business_filter':business_filter
        }
        return render(request, self.template_name, context)



"""
Member acc from developx with some context changes

class MemberAccountsView(PermView):
    perm_name = 'can_view_member_accounts'
    template_name = 'sacco/member_accounts.html'

    def get(self, request, *args, **kwargs):
        business_context = session_business_data(request)
        data_context = determine_business_id_list(request.user.staff, business_context)

        the_current_branch_name = ''
        if business_context is None:
            the_current_branch_name = 'all branches'
        else:
            # get the current branch
            the_current_branch_name = Branch.objects.filter(business=business_context).first().name

        the_filter_branch = ''
        if business_context is None:
            business_filter = request.GET.get('business_filter', '')
            if business_filter:
                if business_filter != 'all_branches':
                    # get the branch
                    the_filter_branch = Branch.objects.filter(business_id=business_filter).first().name
                    # update the data context businesses
                    data_context['all_ids'] = [business_filter]
                else:
                    the_filter_branch = 'all branches'

        if data_context['title'] == 'all branches':
            title = 'Member accounts for all branches'
        else:
            title = f'Member accounts for {the_current_branch_name}'

        client = 'Members'
        # title = f'{client} Accounts\''
        user = request.user
        branch = biz_staff_branch(user)

        # update of account balances and shares
        recalculate_shares(branchdata(request))
        recalculate_savings(businessdata(request))

        members = []
        if 'data' in request.session:
            del request.session['data']
        biz_accounts = AccountBroker.objects.filter(members__branch__business_id__in=data_context['all_ids'],
                                                    members__is_active=True
                                                    ).annotate(acc_number=F('the_account__acc_number')).annotate(
            name=F('members__biodata__name')).annotate(account_type=F('the_account__account_type__name')
                                                       ).annotate(balance=F('the_account__balance')
                                                                  ).annotate(portal=F('members__portal')).values(
            'acc_number', 'name', 'members_id', 'account_type', 'balance',
            'portal', 'the_account_id', 'members__branch')
        print(biz_accounts[0])
        # accounts_ = Account.objects.filter(business=business, category__name__in=['Mobile Money', 'Cash', 'Bank'])
        # all_charges = GeneralCharge.objects.filter(business=business)
        context = {
            'biz_accounts': biz_accounts,
            # 'accounts_': accounts_,
            # 'all_charges': all_charges,
            'title': title,
            'members': members
        }
        return render(request, self.template_name, context)

    def get_central_context(self, request, *args, **kwargs):
        business = Business.objects.filter(id=businessdata(request)).first()
        if business.type == 1:
            client = 'Members'
        else:
            client = 'Clients'
        title = f'{client} Accounts\''
        user = request.user
        branch = biz_staff_branch(user)
        recalculate_shares(branchdata(request))
        recalculate_savings(businessdata(request))
        members = []
        if 'data' in request.session:
            del request.session['data']
        biz_accounts = AccountBroker.objects.filter(members__branch=branch,
                                                    members__is_active=True
                                                    ).annotate(acc_number=F('the_account__acc_number')).annotate(
            name=F('members__biodata__name')).annotate(account_type=F('the_account__account_type__name')
                                                       ).annotate(balance=F('the_account__balance')
                                                                  ).annotate(portal=F('members__portal')).values(
            'acc_number', 'name', 'members_id', 'account_type', 'balance',
            'portal', 'the_account_id')
        accounts_ = Account.objects.filter(business=business, category__name__in=['Mobile Money', 'Cash', 'Bank'])
        all_charges = GeneralCharge.objects.filter(business=business)
        context = {
            'biz_accounts': biz_accounts,
            'accounts_': accounts_,
            'all_charges': all_charges,
            'title': title,
            'members': members
        }
        return render(request, self.template_name, context)

    def get_selected_business_context(self, request, *args, **kwargs):
        business = Business.objects.filter(id=businessdata(request)).first()
        if business.type == 1:
            client = 'Members'
        else:
            client = 'Clients'
        title = f'{client} Accounts\''
        user = request.user
        branch = biz_staff_branch(user)
        recalculate_shares(branchdata(request))
        recalculate_savings(businessdata(request))
        members = []
        if 'data' in request.session:
            del request.session['data']
        biz_accounts = AccountBroker.objects.filter(members__branch=branch,
                                                    members__is_active=True
                                                    ).annotate(acc_number=F('the_account__acc_number')).annotate(
            name=F('members__biodata__name')).annotate(account_type=F('the_account__account_type__name')
                                                       ).annotate(balance=F('the_account__balance')
                                                                  ).annotate(portal=F('members__portal')).values(
            'acc_number', 'name', 'members_id', 'account_type', 'balance',
            'portal', 'the_account_id')
        accounts_ = Account.objects.filter(business=business, category__name__in=['Mobile Money', 'Cash', 'Bank'])
        all_charges = GeneralCharge.objects.filter(business=business)
        context = {
            'biz_accounts': biz_accounts,
            'accounts_': accounts_,
            'all_charges': all_charges,
            'title': title,
            'members': members
        }
        return render(request, self.template_name, context)

    def get(self, request, *args, **kwargs):
        try:
            business_context = session_business_data(request)

            if business_context is None:
                # central (all businesses context)
                return self.get_central_context(request, *args, **kwargs)

            # else (specified business context)
            return self.get_selected_business_context(request, *args, **kwargs)

            # else (specified business context)
            # return self.get_index(request, *args, **kwargs)

        except Exception as exception:
            raise exception
"""


class ExportMemberAccountsView(PermView):
    def get(self, request, *args, **kwargs):
        business = Business.objects.filter(id=businessdata(request)).first()
        if business.type == 1:
            client = 'Members'
        else:
            client = 'Clients'
        title = f'{client} Accounts\''
        user = request.user
        branch = biz_staff_branch(user)
        biz_accounts = AccountBroker.objects.filter(members__branch=branch,
                                                    members__is_active=True
                                                    ).annotate(acc_number=F('the_account__acc_number')).annotate(
            name=F('members__biodata__name')).annotate(account_type=F('the_account__account_type__name')
                                                       ).annotate(balance=F('the_account__balance')
                                                                  ).annotate(portal=F('members__portal')).values(
            'acc_number', 'name', 'members_id', 'account_type', 'balance',
            'portal', 'the_account_id')
        # print('biz_accounts', biz_accounts)
        df = pd.DataFrame(biz_accounts)
        response = HttpResponse(content_type='application/ms-excel')
        response['Content-Disposition'] = 'attachment; filename="sample_excel.xlsx"'

        # Create an Excel writer using Pandas
        writer = pd.ExcelWriter(response, engine='xlsxwriter')
        df.to_excel(writer, sheet_name='Sheet1', index=False)
        writer.save()

        return response


class InactiveAccountsView(PermView):
    perm_name = 'can_view_member_accounts'
    template_name = 'sacco/inactive_accounts.html'

    def get(self, request, *args, **kwargs):
        title = 'Inactive Accounts'
        inactive_accounts = AccountBroker.objects.filter(members__branch=request.user.staff.branch,
                                                         members__is_active=False)
        return render(request, self.template_name, locals())

class DormantAccountsView(PermView):
    perm_name = 'can_view_member_accounts'
    template_name = 'sacco/dormant_accounts.html'

    def get(self, request, *args, **kwargs):
        business_context = session_business_data(request)
        data_context = determine_business_id_list(request.user.staff, business_context)
        business_context_revised = get_business_loans_context_data(request)
        accounts = Account.objects.filter(business_id__in=data_context['all_ids'],
                                          category__name__in=['Mobile Money', 'Cash', 'Bank'])
        title = 'Dormant Accounts'
        dormant_accounts = AccountBroker.objects.filter(business_id__in=data_context['all_ids'],
                                                         members__is_active=True,
                                                        the_account__is_active=False,)
        return render(request, self.template_name, locals())

class RecoverMember(PermView):
    # perm_name = 'recover_member'
    # perm_description = 'Recover Member'

    def post(self, request, *args, **kwargs):
        business_context = session_business_data(request)
        data_context = determine_business_id_list(request.user.staff, business_context)
        business_context_revised = get_business_loans_context_data(request)

        user = request.user
        branch = business_context_revised['branch']
        pk = request.POST.get('account_id', None)
        recovery_amount = request.POST.get('recovery_amount', None)
        payment_mode = request.POST.get('payment_mode', None)
        payment_mode_account = Account.objects.filter(id=payment_mode, business_id__in=data_context['all_ids']).first()
        account_broker = AccountBroker.objects.filter(id=pk, business_id__in=data_context['all_ids']).first()
        member_account = Account.objects.get(member=account_broker.the_account,
                                                business_id__in=data_context['all_ids'])

        financial_year = FinancialYear.objects.filter(business=businessdata(request)).first()
        date_created = datetime.datetime.now().date()
        rec_no = datetime.datetime.now().strftime("%y%m%d%H%M%S")
        # branch = biz_staff_branch(request.user)
        if recovery_amount:
            recovery_amount = float(recovery_amount)
        else:
            recovery_amount = 0
        account_recovery_cat = AccountCategory.objects.get(business=biz_data(request.user),
                                                           name="Income")
        acc_involved, _ = Account.objects.get_or_create(name='Account Recovery Charges', business=biz_data(request.user),
                                                        category=account_recovery_cat)

        if recovery_amount == 0:
            member_account.member.is_active = True
            member_account.member.save()
            messages.success(request, 'success', extra_tags='Successfully Recovered Account')
            log_title = 'Account Recovered'
            message = f"{request.user.staff.biodata.name} recovered {member_account.member.acc_number}"
            ActivityLog.objects.create(actor=request.user, title=log_title,
                                       action_type=UPDATE,
                                       remarks=message,
                                       branch=branch_id(request.user))
            return HttpResponseRedirect(reverse_lazy('member_accounts'))
        else:
            decimals = 2
            if recovery_amount:
                if round(float(recovery_amount), decimals) > 0:
                    trans1 = Transactions.objects.create(
                        branch=branch,
                        transaction_type='Account Recovery',
                        account_dr=payment_mode_account,
                        account_cr=member_account,
                        narration=f'Deposit of {recovery_amount} to {member_account.member.acc_number} for account recovery',
                        reporting_amount=recovery_amount,
                        added_by=biz_staff(request.user),
                        financial_year=financial_year,
                        tx_date=date_created,
                        receipt=rec_no,
                    )


                    trans2 = Transactions.objects.create(
                        branch=branch,
                        transaction_type='Account Recovery',
                        account_dr=member_account,
                        account_cr=acc_involved,
                        narration=f'Charge of {recovery_amount} deducted from {member_account.member.acc_number} for Member recovery.',
                        reporting_amount=recovery_amount,
                        added_by=biz_staff(request.user),
                        financial_year=financial_year,
                        tx_date=date_created,
                        receipt=rec_no,
                    )

                member_account.member.is_active = True
                member_account.member.save()
                messages.success(request, 'success', extra_tags='Successfully Recovered Account')
                log_title = 'Account Recovered'
                message = f"{request.user.staff.biodata.name} recovered {member_account.member.acc_number}"
                ActivityLog.objects.create(actor=request.user, title=log_title,
                                           action_type=UPDATE,
                                           remarks=message,
                                           branch=branch_id(request.user))
                return HttpResponseRedirect(reverse_lazy('member_accounts'))
        messages.error(request, 'error', extra_tags='Recovery of Account was Unsuccessful')
        return HttpResponseRedirect(reverse_lazy('dormant_accounts'))


class IndDepositView(PermView):
    perm_name = 'view_deposits'
    deco_role = 'can_deposit'
    form_class = IndDepositForm

    def get(self, request, *args, **kwargs):

        return redirect(request.META.get('HTTP_REFERER', '/'))

    @can_do_this
    def post(self, request, *args, **kwargs):
        return_url = request.META.get('HTTP_REFERER', '/')
        current_transaction = date.today()

        business = biz_data(self.request.user)
        financial_year = FinancialYear.objects.filter(business=business, status=True).first()
        if financial_year is not None:
            if financial_year.is_within_financial_year(input_date=current_transaction):

                form = self.form_class(request.POST, user=request.user, finance_year=financial_year)
                deposit = request.POST['amount']
                account = request.POST['unique']
                from_initial = deposit.replace(',', '')
                initial = int(float(from_initial))
                this_account = MemberAccount.objects.get(id=account)
                detail = AccountBroker.objects.get(the_account=this_account)
                charges = check_ind_depo_charges(account, initial)
                inwords = num2words(initial, 'en_GB')
                if int(initial) >= charges:
                    if form.is_valid():
                        c = {
                            'amount': initial,
                            'charges': charges,
                            'owner': detail.members.biodata.name,
                            'acc': this_account.acc_number,
                            'rec': 'Deposit',
                            'url': return_url
                        }
                        request.session['data'] = c
                        return JsonResponse({'msg': 'success', 'extra': 'Deposited successfully'}, safe=True)
                else:
                    return JsonResponse({'msg': 'error', 'extra': 'Total charges are {}'.format(charges)}, safe=True)
        return redirect(request.META.get('HTTP_REFERER', '/'))


class IndWithdrawView(PermView):
    deco_role = 'can_withdraw'
    perm_name = 'view_withdraws'
    form_class = IndWithForm

    def get(self, request, *args, **kwargs):

        return redirect(request.META.get('HTTP_REFERER', '/'))

    @can_do_this
    def post(self, request, *args, **kwargs):
        return_url = request.META.get('HTTP_REFERER', '/')
        current_transaction = date.today()
        business = biz_data(self.request.user)
        financial_year = FinancialYear.objects.filter(business=business, status=True).first()
        if financial_year is not None:
            if financial_year.is_within_financial_year(input_date=current_transaction):
                form = self.form_class(request.POST, user=request.user, finance_year=financial_year)
                deposit = request.POST['amount']
                account = request.POST['with_unique']
                from_initial = deposit.replace(',', '')
                initial = int(float(from_initial))
                inwords = num2words(initial)
                this_account = MemberAccount.objects.get(id=account)
                detail = AccountBroker.objects.get(the_account=this_account)
                member_acct = AccountBroker.objects.filter(the_account=this_account).first()
                account_type = member_acct.the_account.account_type
                charges_and_balance = check_ind_withdraw_charges(account, initial)

                the_account_type = AccountTypes.objects.filter(id=account_type.id).first()
                min_balance = the_account_type.min_balance
                total_trans = this_account.balance - min_balance
                allowed_with = initial + charges_and_balance
                if this_account.account_type.is_fixed:
                    maturity_date = member_acct.created_date + relativedelta(months=+the_account_type.maturity)
                    if member_acct.created_date >= maturity_date:
                        if int(allowed_with) <= total_trans:
                            if form.is_valid():
                                c = {
                                    'amount': initial,
                                    'charges': charges_and_balance,
                                    'owner': detail.members.biodata.name,
                                    'acc': this_account.acc_number,
                                    'rec': 'Withdraw',
                                    'url': return_url
                                }
                                request.session['data'] = c
                                return JsonResponse(
                                    {'msg': 'success', 'extra': 'Withdraw successful'}, safe=True)
                            else:
                                return JsonResponse(
                                    {'msg': 'error', 'extra': 'Form invalid'}, safe=True)
                        else:
                            return JsonResponse(
                                {'msg': 'error', 'extra': 'Insufficient balance to cater for charges of {} and '
                                                          'maintain a minimum balance of {}'.format(charges_and_balance,
                                                                                                    min_balance)},
                                safe=True)
                    else:
                        return JsonResponse({'msg': 'error', 'extra': 'Finance year not set'}, safe=True)
                else:
                    if int(allowed_with) <= total_trans:
                        if form.is_valid():
                            c = {
                                'amount': initial,
                                'charges': charges_and_balance,
                                'owner': detail.members.biodata.name,
                                'acc': this_account.acc_number,
                                'rec': 'Withdraw',
                                'url': return_url
                            }
                            request.session['data'] = c
                            return JsonResponse(
                                {'msg': 'success', 'extra': 'Withdraw successful', 'charge': charges_and_balance,
                                 'deposit': initial, 'acc_no': this_account.acc_number,
                                 'owner': detail.members.biodata.name, 'words': inwords.title()}, safe=True)
                        else:
                            return JsonResponse(
                                {'msg': 'error', 'extra': 'Form invalid'}, safe=True)
                    else:
                        return JsonResponse(
                            {'msg': 'error', 'extra': 'Insufficient balance to cater for charges of {} and '
                                                      'maintain a minimum balance of {}'.format(charges_and_balance,
                                                                                                min_balance)},
                            safe=True)

        return redirect(request.META.get('HTTP_REFERER', '/'))


class TransfersView(PermView):
    perm_name = 'make_a_transfer'
    template_name = 'sacco/transfers.html'
    receipt_template = 'sacco/receipts/withdraw_receipt.html'

    def get(self, request, *args, **kwargs):
        business_context = get_business_loans_context_data(request)
        title = 'Savings Transfer'
        if business_context['branch'] is None:
            messages.error(
                request, "error",
                extra_tags="Action not allowed in the central view. Please logout and login into the respective branch"
            )
            return HttpResponseRedirect(request.META.get("HTTP_REFERER"))
        if 'data' in request.session:
            del request.session['data']
        user = request.user
        branch = biz_staff_branch(user)
        # biz_accounts = AccountBroker.objects.filter(members__branch=branch, members__is_active=True)
        biz_accounts = AccountBroker.objects.filter(members__branch__business_id__in=business_context['data_context'],
                                                    members__is_active=True
                                                    ).annotate(acc_number=F('the_account__acc_number')).annotate(
            name=F('members__biodata__name')).annotate(account_type=F('the_account__account_type__name')
                                                       ).annotate(balance=F('the_account__balance')
                                                                  ).annotate(portal=F('members__portal')).values(
            'acc_number', 'name', 'members_id', 'account_type', 'balance',
            'portal', 'the_account_id')

        context = {
            'title': title,
            'biz_accounts': biz_accounts
        }

        return render(request, self.template_name, locals())

    def post(self, request):
        business_context = get_business_loans_context_data(request)
        return_url = request.META.get('HTTP_REFERER', '/')
        account_from = request.POST['account_from']
        account_to = request.POST['account_to']
        transfer_date = request.POST['date']
        amount_raw = str(request.POST['amount']).strip()
        initial = amount_raw.replace(',', '')
        amount = float(initial)
        user = request.user
        current_transaction = date.today()
        business = business_context['branch'].business
        financial_year = FinancialYear.objects.filter(business=business, start_date__lte=current_transaction,
                                                      end_date__gte=current_transaction, status=True).first()

        try:
            if financial_year is not None:
                # print('Financial year', financial_year)
                # print('current_transaction', current_transaction)
                if financial_year.is_within_financial_year(input_date=current_transaction):
                    if account_from != account_to:
                        account1 = MemberAccount.objects.get(id=account_from)
                        extra_info = AccountBroker.objects.get(the_account=account1)

                        account2 = MemberAccount.objects.get(id=account_to)
                        extra_info_receiver = AccountBroker.objects.get(the_account=account2)
                        charges = fund_transfer(account1, account2, amount, user, financial_year, transfer_date, business_context['branch'])
                        messages.success(request, 'success', extra_tags='Successfully transferred')
                        # session data
                        c = {
                            'amount': amount,
                            'charges': charges,
                            'owner': extra_info.members.biodata.name,
                            'acc': account1.acc_number,
                            'rec': 'Transfer',
                            'url': return_url,
                            'received_by_acc': account2.acc_number,
                            'received_by': extra_info_receiver.members.biodata.name
                        }
                        request.session['data'] = c
                        message = f"{request.user.staff.biodata.name} has transferred {amount_raw}" \
                                  f" from {account_from} to {account_to}"
                        ActivityLog.objects.create(actor=request.user,
                                                   action_type=UPDATE,
                                                   title='Savings transfer',
                                                   branch=business_context['branch'].id,
                                                   remarks=message)
                        return JsonResponse({'msg': 'success', 'extra': 'Successfully made a transfer'}, safe=True)
                    else:
                        return JsonResponse({'msg': 'error', 'extra': 'Cant make a transfer to a similar account'},
                                            safe=True)
                else:
                    return JsonResponse({'msg': 'error',
                                         'extra': 'You can not transfer money for the given date. Please check the financial year or change the date'},
                                        safe=True)
            else:
                return JsonResponse({'msg': 'error', 'extra': 'Finance year not set'}, safe=True)
        except Exception as e:
            error = str(e)
            logger.info(traceback.print_exc())
            return JsonResponse({'msg': 'error', 'extra': error}, safe=True)


class TransHistory(TemplateView):
    template_name = 'sacco/trans_history.html'

    def get_context_data(self, **kwargs):
        context = super().get_context_data(**kwargs)
        trans = PaymentTransaction.objects.all()
        context['transactions'] = trans
        context['title'] = 'Transaction History'

        return context


class MemberUploadView(ListView):
    template_name = 'sacco/member_upload.html'
    context_object_name = 'member_uploads'
    paginate_by = 10
    ordering = '-created_at'

    def get_queryset(self):
        business_context = get_business_loans_context_data(self.request)
        user = self.request.user
        business = business_context['branch'].business
        queryset = MemberUpload.objects.filter(business=business)
        return queryset

    def get_context_data(self, **kwargs):
        context = super().get_context_data(**kwargs)
        context['title'] = 'Member Uploads'
        return context


class DeleteMemberUploadView(View):

    @transaction.atomic
    def get(self, request, my_uuid):
        member_acc = None
        upload = MemberUpload.objects.get(uuid=my_uuid)  # final
        biodata = Biodata.objects.filter(member_upload=upload.uuid)  # first delete
        broker = AccountBroker.objects.filter(members__member_upload=upload)  # fifth delete
        account = MemberAccount.objects.filter(member_account__in=broker)  # forth delete
        if account.exists():
            member_acc = Account.objects.filter(
                member_id__in=list(account.values_list('id', flat=True)))  # third delete
        transactions = Transactions.objects.filter(
            Q(account_dr__in=member_acc) | Q(account_cr__in=member_acc))  # second delete
        members = Member.objects.filter(member_upload=upload)
        biodata.delete()
        transactions.delete()
        if member_acc:
            member_acc.delete()
        if account:
            account.delete()
        if broker is not None:
            shares_record = SharesTransactions.objects.filter(
                buyer_id__in=list(members.values_list('id', flat=True)))  # sixth
            shares_record.delete()
            broker.delete()
        members.delete()
        upload.delete()
        messages.success(self.request, 'success', extra_tags='Successfully deleted upload')
        return HttpResponseRedirect(reverse_lazy('member_upload'))


class CreateGroupView(View):
    def get(self, request):
        acc_types = AccountTypes.objects.filter(status=True, business=businessdata(request))
        biz = Business.objects.filter(id=businessdata(request)).first()
        branch = branch_id(self.request.user)
        accounts_ = Account.objects.filter(business=businessdata(request),
                                           category__name__in=['Mobile Money', 'Cash', 'Bank'])
        onRegistration = OtherSettings.objects.get(business_id=businessdata(request)).set_ordinary
        title = 'Create Group'
        context = {
            'acc_types': acc_types,
            'biz': biz,
            'branch': branch,
            'title': title,
            'accounts_': accounts_,
            'onRegistration': onRegistration,
        }
        return render(self.request, 'sacco/add_group.html', context)

    def post(self, request):
        form = AddGroupForm(self.request.POST, user=self.request.user)
        if form.is_valid():
            form.save()
            messages.success(self.request, 'success', extra_tags='Successfully added group')
        else:
            # print(form.errors)
            messages.error(self.request, 'success', extra_tags='Error submitting form')
        return HttpResponseRedirect(reverse_lazy('create_group'))


class GroupDetail(BusinessUserMixin, View):
    template_name = 'sacco/group_detail.html'
    form_class = EditGroupForm

    def get_member(self, request):
        pk = self.kwargs.get("pk")
        # branch = branch_id(self.request.user)
        # biz = businessdata(self.request)
        # group = get_object_or_404(Member, id=pk, is_active=True, is_group=True, branch__business_id=biz)
        business_context = session_business_data(request)
        data_context = determine_business_id_list(request.user.staff, business_context)

        the_current_branch_name = ''
        if business_context is None:
            the_current_branch_name = 'all branches'
        else:
            # get the current branch
            the_current_branch_name = Branch.objects.filter(business=business_context).first().name

        the_filter_branch = ''
        business_filter = ''
        if business_context is None:
            business_filter = request.GET.get('business_filter', '')
            if business_filter:
                if business_filter != 'all_branches':
                    # get the branch
                    the_filter_branch = Branch.objects.filter(business_id=business_filter).first().name
                    # update the data context businesses
                    data_context['all_ids'] = [business_filter]
                else:
                    the_filter_branch = 'all branches'

        if data_context['title'] == 'all branches':
            title = 'Groups for all branches'
        else:
            title = f'Groups for {the_current_branch_name}'

        try:
            group = Member.objects.filter(is_active=True, is_group=True, branch__business_id__in=data_context['all_ids']
                                          ).annotate(accs=Count('accounts', distinct=True)
                                                     ).prefetch_related('owners', 'members').get(id=pk)
            return group
        except Member.DoesNotExist:
            return render(self.request, 'errors/404.html', status=404)

    def get(self, request, pk, *args, **kwargs):

        group = self.get_member(request)
        biz = biz_data(self.request.user)
        title = f'{group.name}'
        form = self.form_class({'date_joined': group.date_joined})
        accts = []
        saving_products = AccountTypes.objects.filter(business=biz)
        grp_accounts = group.owners.all()
        grp_members = group.members.all()
        signo = grp_members.filter(is_signatory=True)
        for account in grp_accounts:
            accts.append(account.the_account)
        grp_loans = Loans.objects.filter(account__in=accts)
        combined = Transactions.objects.filter(Q(account_dr__member__in=accts) | Q(account_cr__member__in=accts)
                                               ).annotate(debit_account=F('account_dr__member__acc_number')
                                                          ).annotate(
            credit_account=F('account_cr__member__acc_number')).values(
            'debit_account', 'credit_account', 'transaction_type', 'reporting_amount', 'narration',
            'date_added').order_by('-date_added')

        account_types = AccountTypes.objects.filter(business=businessdata(request))
        accounts_ = Account.objects.filter(business=businessdata(request),
                                           category__name__in=['Mobile Money', 'Cash', 'Bank'])

        can_delete_group = False
        if request.user.staff.position.permissions.filter(item_name='delete_group').exists():
            can_delete_group = True

        can_handle_group_transactional_data = False
        if request.user.staff.position.permissions.filter(item_name='handle_group_transactional_data').exists():
            can_handle_group_transactional_data = True

        return render(request, self.template_name, locals())

    def post(self, request, pk, *args, **kwargs):
        group = self.get_member(request)
        form = self.form_class(request.POST)
        if form.is_valid():
            try:
                name = form.cleaned_data.get('name')
                dob = form.cleaned_data.get('dob')
                contact = form.cleaned_data.get('contact')
                other_contact = form.cleaned_data.get('other_contact')
                email = form.cleaned_data.get('email')
                code = form.cleaned_data.get('code')
                code1 = form.cleaned_data.get('code1')
                location = form.cleaned_data.get('location')

                group.name = name
                group.date_joined = dob
                group.contact = proper_dial(contact, code)
                group.other_contact = proper_dial(other_contact, code1)
                group.email = email
                group.location = location
                group.save()
                messages.success(request, 'success', extra_tags='Successfully updated')
                message = f"{request.user.staff.biodata.name} updated group {name}"
                ActivityLog.objects.create(actor=request.user,
                                           action_type=UPDATE,
                                           title='Group update',
                                           branch=branch_id(request.user),
                                           remarks=message)
                return HttpResponseRedirect(reverse_lazy('group_detail', args=[pk]))
            except Exception as e:
                messages.error(request, 'error', extra_tags=str(e))
                return HttpResponseRedirect(reverse_lazy('group_detail', args=[pk]))
        else:
            error = form.errors
            messages.error(self.request, 'error', extra_tags=error)
            return HttpResponseRedirect(reverse_lazy('group_detail', args=[pk]))


class SaccoGroups(PermView):
    perm_name = 'view_member'
    deco_role = 'add_member'
    template_name = 'sacco/groups.html'
    form_class = AddGroupForm

    def get(self, request, *args, **kwargs):
        business_context = session_business_data(request)
        data_context = determine_business_id_list(request.user.staff, business_context)

        the_current_branch_name = ''
        if business_context is None:
            the_current_branch_name = 'all branches'
        else:
            # get the current branch
            the_current_branch_name = Branch.objects.filter(business=business_context).first().name

        the_filter_branch = ''
        business_filter = ''
        if business_context is None:
            business_filter = request.GET.get('business_filter', '')
            if business_filter:
                if business_filter != 'all_branches':
                    # get the branch
                    the_filter_branch = Branch.objects.filter(business_id=business_filter).first().name
                    # update the data context businesses
                    data_context['all_ids'] = [business_filter]
                else:
                    the_filter_branch = 'all branches'

        if data_context['title'] == 'all branches':
            title = 'Groups for all branches'
        else:
            title = f'Groups for {the_current_branch_name}'

        can_add_group = False
        if request.user.staff.position.permissions.filter(item_name='add_group').exists():
            can_add_group = True

        can_delete_group = False
        if request.user.staff.position.permissions.filter(item_name='delete_group').exists():
            can_delete_group = True

        # biz = Business.objects.filter(id=businessdata(request)).first()
        # branch = branch_id(self.request.user)
        group_list = Member.objects.filter(is_active=True, is_group=True, branch__business_id__in=data_context['all_ids'])
        # filters
        group_name = request.GET.get('group_name', '')
        if group_name:
            group_list = group_list.filter(name__icontains=group_name)

        group_list = group_list.values('id').annotate(
            mems=Count('members', distinct=True), accs=Count('accounts', distinct=True)
        ).values('mems', 'id', 'name', 'accs', 'branch__name',
                 group_officer_name=F('group_officer__biodata__name'),
                 group_officer_id = F('group_officer__id')
                 )

        # print(group_list)

        all_staff = Staff.objects.filter(branch__business_id__in=data_context['all_ids'])

        # Pagination
        page = request.GET.get('page', 1)
        paginator = Paginator(group_list, 10)

        try:
            group_list = paginator.page(page)
        except PageNotAnInteger:
            group_list = paginator.page(1)
        except EmptyPage:
            group_list = paginator.page(paginator.num_pages)
        return render(request, self.template_name, locals())


class UpdateGroupLoanOfficer(PermView):
    perm_name = 'view_member'
    deco_role = 'add_member'
    def post(self, request, *args, **kwargs):
        # business_context = session_business_data(request)
        new_officer = self.request.POST.get('the_officer')
        group_id = self.request.POST.get('update_officer_group_id')

        # print(f'new_officer:{new_officer}, group_id:{group_id}')

        check_group = Member.objects.filter(id=group_id)
        if not check_group.exists():
            messages.error(request, 'error', extra_tags='Group nolonger exists')
            return redirect(request.META.get("HTTP_REFERER", "/"))

        check_group.update(
            group_officer_id=new_officer
        )

        # get all loans and update the officer field
        all_members = GroupMember.objects.filter(group_id=group_id)
        # print(all_members.values_list('member__biodata__name'))
        member_ids = list(all_members.values_list('member__id', flat=True))
        Loans.objects.filter(applicant_id__in=member_ids, loan_status__in=[0,1,2,3,8]).update(
            officer_id=new_officer
        )
        messages.success(request, 'success', extra_tags='Officer updated successfully. All group loans have been also attached to the officer')
        return redirect(request.META.get("HTTP_REFERER", "/"))


class AddGroupAccount(PermView):
    perm_name = 'can_manage_member_accounts'
    form_class = AddGroupAccountForm

    def get(self, request, pk, *args, **kwargs):
        business_context = session_business_data(request)
        data_context = determine_business_id_list(request.user.staff, business_context)
        grp = get_object_or_404(Member, id=pk, is_active=True, branch__business=data_context['all_ids'], is_group=True)
        return HttpResponseRedirect(reverse_lazy('group_detail', args=[grp.id]))

    def post(self, request, pk, *args, **kwargs):
        business_context = session_business_data(request)
        data_context = determine_business_id_list(request.user.staff, business_context)
        grp = get_object_or_404(Member, id=pk, is_active=True, branch__in=data_context['all_ids'], is_group=True)
        new_account_form = self.form_class(request.POST, user=request.user, member=grp.id, business=data_context['all_ids'])

        if 'add_account' in request.POST:
            if new_account_form.is_valid():
                new_account_form.save()
                messages.success(request, 'success', extra_tags='Successfully added account to Group')
                return HttpResponseRedirect(reverse_lazy('group_detail', args=[grp.id]))
            else:
                form_error = new_account_form.errors.as_json()
                # err_dict = ast.literal_eval(form_error)
                # x = ast.literal_eval(str(error))
                messages.error(request, 'error', extra_tags=new_account_form.errors)
                return HttpResponseRedirect(reverse_lazy('group_detail', args=[grp.id]))
        else:
            messages.error(request, 'error', extra_tags='Not here')
            return HttpResponseRedirect(reverse_lazy('group_detail', args=[grp.id]))


class AddExistingMemberToGroup(BusinessUserMixin, View):
    def get_member(self, request):
        pkey = self.kwargs.get("pk")
        group = get_object_or_404(Member, id=pkey)
        if group.is_group:
            return group
        raise Http404("The requested resource is not available.")

    # @can_do_this
    def post(self, request, *args, **kwargs):
        business_context = get_business_loans_context_data(request)
        staff = biz_staff(self.request.user)
        group = self.get_member(request)
        member = self.request.POST.get('member')
        if not group.members.filter(member_id=member).exists():
            GroupMember.objects.create(group=group, member_id=member, added_by=staff)
            messages.success(request, 'success', 'Successfully added to group')
        else:
            messages.error(self.request, 'success', extra_tags='Member already exist in group')

        checking_namayingo = CustomBusiness.objects.filter(business=business_context['branch'].business,
                                                           business_module='NAMAMYINGO').first()
        # print('checking_namayingo', checking_namayingo)
        if checking_namayingo is None:
            return HttpResponseRedirect(reverse_lazy('group_members', args=[group.id]))
        else:
            return HttpResponseRedirect(reverse_lazy('namayingo_group_members', args=[group.id]))


class AddGroupMember(BusinessUserMixin, View):
    def get(self, request, pk):
        grp = get_object_or_404(Member, id=pk, is_active=True, branch__business=businessdata(request), is_group=True)
        return HttpResponseRedirect(reverse_lazy('group_members', args=[grp.id]))

    def post(self, request, pk):
        grp = get_object_or_404(Member, id=pk, is_active=True, branch__business=businessdata(request), is_group=True)
        form = AddGroupMemberForm(request.POST, user=self.request.user, group=grp)
        if form.is_valid():
            form.save()
            messages.success(self.request, 'success', extra_tags='Successfully added member to group')
        else:
            error = form.errors
            messages.error(self.request, 'error', extra_tags=error)
        checking_namayingo = CustomBusiness.objects.filter(business=businessdata(request),
                                                           business_module='NAMAMYINGO').first()
        print('checking_namayingo', checking_namayingo)
        if checking_namayingo is None:
            return HttpResponseRedirect(reverse_lazy('group_members', args=[grp.id]))
        else:
            return HttpResponseRedirect(reverse_lazy('namayingo_group_members', args=[grp.id]))


class DeleteGroupMember(PermView):
    perm_name = 'delete_member'

    def get(self, request, pk, pk1, *args, **kwargs):
        member = get_object_or_404(GroupMember, member__branch_id=branch_id(self.request.user), id=pk)
        # print(member)
        # request.session['grp_member'] = member
        if member.is_signatory:
            messages.error(request, 'error', extra_tags='Can not delete a signatory')
            return HttpResponseRedirect(reverse_lazy('group_members', args=[pk1]))
        member.delete()
        messages.success(request, 'success', extra_tags='Successfully deleted Member')
        message = f"{request.user.staff.biodata.name} deleted Member"
        ActivityLog.objects.create(actor=request.user,
                                   action_type=DELETE,
                                   title='Group delete',
                                   branch=branch_id(request.user),
                                   remarks=message)
        return HttpResponseRedirect(reverse_lazy('group_members', args=[pk1]))


class GroupMembers(PermView):
    perm_name = 'view_member'
    template_name = 'sacco/group_members.html'
    form_class = EditGroupMemberForm

    def get(self, request, pk, *args, **kwargs):
        try:
            group = Member.objects.filter(is_group=True).prefetch_related('members').get(id=pk)
        except Member.DoesNotExist:
            return render(request, 'errors/404.html', status=404)
        except Member.MultipleObjectsReturned:
            group = Member.objects.filter(is_group=True, is_active=True, id=pk).prefetch_related('members').first()
        except Exception:
            return render(request, 'errors/500.html', status=500)
        form = AddGroupMemberForm
        sacco_members = Member.objects.filter(is_active=True, branch_id=branch_id(self.request.user)).annotate(
            ur_name=F('biodata__name'))
        members = group.members.all().order_by('-is_signatory')
        title = f'{group.name} Members'
        context = {
            'group': group,
            'members': members,
            'member_count': members.count(),
            'title': title,
            'sacco_members': sacco_members.values('id', 'ur_name'),
            'form': form
        }
        return render(request, self.template_name, context)


class ViewGroupMember(PermView):
    perm_name = 'view_member'
    template_name = 'sacco/group_mem_detail.html'
    form_class = EditGroupMemberForm

    def get(self, request, pk, *args, **kwargs):
        business_context = session_business_data(request)
        data_context = determine_business_id_list(request.user.staff, business_context)
        # group = get_object_or_404(Member, id=pk, biodata__business=businessdata(request), is_group=True)
        member = get_object_or_404(GroupMember, member__branch__business_id__in=data_context['all_ids'], id=pk)
        form = self.form_class
        title = member.member.biodata.name
        contact_dial = dial_country_code(member.member.biodata.contact)
        other_contact_dial = dial_country_code(member.member.other_contact)
        account = AccountBroker.objects.filter(members=member.member)
        return render(request, self.template_name, locals())

    def post(self, request, pk, *args, **kwargs):
        business_context = session_business_data(request)
        data_context = determine_business_id_list(request.user.staff, business_context)

        member = get_object_or_404(GroupMember, member__branch__business_id__in=data_context['all_ids'], id=pk)
        form = self.form_class(request.POST, user=request.user, group=member.id, member=member.id)
        if 'save_updates' in request.POST:
            if form.is_valid():
                messages.success(request, 'success', extra_tags='Successfully updated Member')
                message = f"{request.user.staff.biodata.name} has updated member in group {member.group.name}"
                ActivityLog.objects.create(actor=request.user,
                                           action_type=UPDATE,
                                           title='Group member update',
                                           branch=branch_id(request.user),
                                           remarks=message)
                return HttpResponseRedirect(reverse_lazy('grp_mem_det', args=[member.id]))
            else:
                message = form.errors
                messages.error(request, 'error', extra_tags=message)
        elif 'profile_pic' in request.POST:
            dp = request.FILES['photo']
            thumbnail = make_thubnail(dp)
            the_member = member.member
            the_member.biodata.photo = thumbnail
            the_member.save_related()
            messages.success(request, 'success', extra_tags='Successfully updated photo')
            message = f"{request.user.staff.biodata.name} has updated photo {member.member.biodata.name}"
            ActivityLog.objects.create(actor=request.user,
                                       action_type=UPDATE,
                                       title='Group member update',
                                       branch=branch_id(request.user),
                                       remarks=message)
            return HttpResponseRedirect(reverse_lazy('grp_mem_det', args=[member.id]))
        return HttpResponseRedirect(reverse_lazy('grp_mem_det', args=[member.id]))


def make_signatory(request, pk):
    member = get_object_or_404(GroupMember, member__branch_id=branch_id(request.user), id=pk)
    if request.method == 'POST':
        role = request.POST.get('role', None)
        if role != 'Ordinary':
            member.is_signatory = True
        else:
            member.is_signatory = False
        member.role = role
        member.save()
        messages.success(request, 'success', extra_tags='Successfully updated status')
    return HttpResponseRedirect(reverse_lazy('grp_mem_det', args=[member.id]))


class MemberBulkDeposit(PermView):
    perm_name = 'can_deposit'
    template_name = 'sacco/member_bulk_deposit.html'

    def get(self, request, pk, *args, **kwargs):
        title = 'Make Bulk deposits'
        try:
            group = Member.objects.filter(is_group=True).prefetch_related('members').get(id=pk)
        except Member.DoesNotExist:
            return render(request, 'errors/404.html', status=404)
        except Member.MultipleObjectsReturned:
            group = Member.objects.filter(is_group=True, is_active=True, id=pk).prefetch_related('members').first()
        except Exception as e:
            logger.error(str(e))
            return render(request, 'errors/500.html', status=500)
        # group.members.all()
        members = group.members.all()
        # print(members.values_list('member_id', flat=True))
        biz_accounts = AccountBroker.objects.filter(business=businessdata(request),
                                                    members_id__in=members.values_list('member_id', flat=True))
        accounts_ = Account.objects.filter(business=businessdata(request),
                                           category__name__in=['Mobile Money', 'Cash', 'Bank'])
        context = {
            'title': title,
            'accounts_': accounts_,
            'group': group,
            'biz_accounts': biz_accounts
        }
        return render(request, self.template_name, context)

    def post(self, request, pk, *args, **kwargs):
        try:
            group = Member.objects.filter(is_group=True).prefetch_related('members').get(id=pk)
        except Member.DoesNotExist:
            return render(request, 'errors/404.html', status=404)
        except Member.MultipleObjectsReturned:
            group = Member.objects.filter(is_group=True, is_active=True, id=pk).prefetch_related('members').first()
        except Exception:
            return render(request, 'errors/500.html', status=500)
        amount = request.POST['deposit']
        accounts = request.POST.getlist('accounts')
        account_credited = request.POST['the_account']
        current_transaction = datetime.datetime.today()
        business = biz_data(self.request.user)
        financial_year = FinancialYear.objects.filter(business=business, status=True).first()
        if financial_year is not None:
            if financial_year.is_within_financial_year(input_date=current_transaction):
                if amount and accounts:
                    account_dict = [{'account_number': account_number, 'amount': amount, 'date': current_transaction}
                                    for account_number in accounts]  # mapping amount to accounts
                    bulk_member_deposit(request.user, account_dict, account_credited,
                                        business)  # bulk deposit function called here
                    messages.success(request, 'success', extra_tags='Successfully deposited')
                    message = f"{request.user.staff.biodata.name} made a bulk deposited"
                    ActivityLog.objects.create(actor=request.user,
                                               action_type=ACCOUNT,
                                               title='Bulk deposit',
                                               branch=branch_id(request.user),
                                               remarks=message)
                    return HttpResponseRedirect(reverse_lazy('make_bulk_deposit', args=[group.id]))
                else:
                    messages.error(request, 'error', extra_tags='Check amount or cash')
            else:
                messages.error(request, 'error', extra_tags='Validate financial year range')

        else:
            messages.error(request, 'error', extra_tags='Financial year is None')
        return HttpResponseRedirect(reverse_lazy('make_bulk_deposit', args=[group.id]))


class StaffAssociatedView(PermView):
    perm_name = 'can_assign_accounts_to_staff'
    template_name = 'sacco/accounts_associated.html'

    def get(self, request, *args, **kwargs):
        business_context = get_business_loans_context_data(request)
        branch_id = biz_staff_branch(request.user).id

        if business_context['branch'] is None:
            messages.error(
                request, "error",
                extra_tags="Action not allowed in the central view. Please logout and login into the respective branch"
            )
            return HttpResponseRedirect(reverse_lazy('index'))

        # get all staff except the one logged in
        # all_staff = StaffLedgerAssociated.objects.filter(branch_id=branch_id(request.user)).exclude(staff=self.request.user.staff)
        all_staff = StaffLedgerAssociated.objects.filter(branch=business_context['branch']).exclude(staff=request.user.staff)
        actual_staff = Staff.objects.filter(branch=business_context['branch']).exclude(id=request.user.staff.id)
        available_accounts = Account.objects.filter(
            Q(business=business_context['branch'].business),
            (
                    Q(category__name="Bank")
                    | Q(category__name="Mobile Money")
                    | Q(category__name="Cash")
            ),
        )
        return render(request, self.template_name, locals())

    def post(self, request, *args, **kwargs):
        business_context = get_business_loans_context_data(request)
        staff_associated = request.POST['staff_associated']
        account_associated = request.POST['account_associated']

        # check if no one already has this account attached
        staff_ledgers_for_account = StaffLedgerAssociated.objects.filter(account_asscociated_id=account_associated, branch=business_context['branch'])
        if staff_ledgers_for_account.exists():
            messages.error(request, 'error', extra_tags='Account already belongs to another person')
            return HttpResponseRedirect(reverse_lazy('staff_associated'))
        StaffLedgerAssociated.objects.create(
            branch=business_context['branch'],
            account_asscociated_id=account_associated,
            staff_id=staff_associated,
            added_by_id=userdata(request)
        )
        messages.success(request, 'success', extra_tags='Account assigned successfully')
        return HttpResponseRedirect(reverse_lazy('staff_associated'))


class DeleteStaffAssociatedView(PermView):
    perm_name = 'can_assign_accounts_to_staff'

    def get(self, request, pk, *args, **kwargs):
        StaffLedgerAssociated.objects.filter(id=pk).delete()
        return HttpResponseRedirect(reverse_lazy('staff_associated'))


class DailyMemberReportView(PermView):
    perm_name = "view_member"
    template_name = "sacco/daily_member_report.html"

    def get(self, request, *args, **kwargs):
        try:
            business_context = get_business_loans_context_data(request)
            business_filter = business_context['business_filter']

            if business_context['the_current_branch_name'] == 'all branches':
                title = "Daily Member Report for all branches"
            else:
                the_current_branch_name = business_context['the_current_branch_name']
                title = f"Daily Member Report for {the_current_branch_name}"
            # Get today's date
            today = timezone.now().date()

            date_type = request.GET.get("date_type", None)

            single_date = request.GET.get("single_date", None)

            start_date = request.GET.get("start_date", None)

            end_date = request.GET.get("end_date", None)

            # base transactions query
            query = Q(Q(transaction_type='Savings') | Q(transaction_type='savings'))

            if single_date:
                query &= Q(tx_date=single_date)
            else:
                # default to today
                query &= Q(tx_date=today)

            if start_date:
                query &= Q(tx_date__gte=start_date)
            if end_date:
                query &= Q(tx_date__lte=end_date)

            # Get total savings for
            today_savings = Transactions.objects.filter(branch__business_id__in=business_context['data_context']).filter(query).annotate(
                account_number=Case(
                    When(account_cr__category__name="Members", then=F("account_cr__member__acc_number"))
                ),
                amount=F('reporting_amount')
            )

            total_savings = today_savings.aggregate(
                total_savings=Sum('reporting_amount')
            )['total_savings'] or 0

            # base share transactions query
            share_transactions_query = Q()

            if single_date:
                share_transactions_query &= Q(date=single_date)
            else:
                # default to today
                share_transactions_query &= Q(date=today)

            if start_date:
                share_transactions_query &= Q(date__gte=start_date)
            if end_date:
                share_transactions_query &= Q(date__lte=end_date)

            # Get total shares bought today
            today_shares = SharesTransactions.objects.filter(branch__business_id__in=business_context['data_context']).filter(share_transactions_query).annotate(
                name=F('buyer__biodata__name'),
            )

            total_shares = today_shares.aggregate(
                total_shares=Sum('shares')
            )['total_shares'] or 0

            # Get new members who joined
            # base member query
            member_query = Q()

            if single_date:
                member_query &= Q(date_joined=single_date)
            else:
                # default to today
                member_query &= Q(date_joined=today)

            if start_date:
                member_query &= Q(date_joined__gte=start_date)
            if end_date:
                member_query &= Q(date_joined__lte=end_date)

            new_members = Member.objects.filter(branch__business_id__in=business_context['data_context']).filter(member_query).select_related('biodata')

            context = {
                "title": title,
                'today': today,
                'today_savings': today_savings,
                'today_shares': today_shares,
                'total_savings': total_savings,
                'total_shares': total_shares,
                'new_members': new_members,
                'new_members_count': new_members.count(),
                'date_type': date_type,
                'single_date': today if single_date is None else single_date,
                'start_date': start_date,
                'end_date': end_date,
                'business_filter': business_filter
            }

            return render(request, self.template_name, context)

        except Exception as exception:
            raise exception


class GroupConcat(Func):
    function = 'GROUP_CONCAT'
    template = '%(function)s(DISTINCT %(expressions)s)'
    output_field = CharField()


class MemberSummaryView(PermView):
    perm_name = 'can_view_member_accounts'
    template_name = 'sacco/member_summary.html'
    items_per_page = 10

    def get(self, request, *args, **kwargs):
        try:
            # Get business details
            business = biz_data(request.user)
            business_id = business.id

            business_context = get_business_loans_context_data(request)
            business_filter = business_context['business_filter']

            if business_context['the_current_branch_name'] == 'all branches':
                title = "Member Summary for all branches"
            else:
                the_current_branch_name = business_context['the_current_branch_name']
                title = f"Member Summary for {the_current_branch_name}"

            # Determine client type
            # client = "Members" if business.type == 1 else "Clients"
            # title = f"{client} Summary"

            the_branch = biz_staff_branch(request.user)


            # Get members data
            # members = Member.objects.filter(
            #     biodata__business_id=business_id
            # ).select_related('biodata')

            # Get business share price
            settings = OtherSettings.objects.filter(business_id__in=business_context['data_context'])
            share_price = settings.aggregate(total=Sum('share_price'))['total'] or Decimal('0')
            share_price = share_price/len(business_context['data_context'])
            # share_price = settings.share_price or Decimal('0') -- original

            account_numbers_subquery = AccountBroker.objects.filter(
                members=OuterRef('pk')
            ).annotate(
                account_numbers=GroupConcat('the_account__acc_number')
            ).values('account_numbers')[:1]

            members_data = (
                Member.objects.filter(branch__business_id__in=business_context['data_context'], is_active=True)
                .values(
                    'id', 'biodata__name', 'name', 'shares'  # Fields to group by
                )
                .annotate(
                    total_savings_from_acc=Coalesce(
                        Sum('owners__the_account__balance', distinct=True, output_field=FloatField()),
                        Value(0.0),
                    ),
                    total_loan_balance=Coalesce(
                        Sum('applicant__balance', filter=Q(applicant__loan_status=3), output_field=FloatField()),
                        Value(0.0),
                    ),
                    total_principal_balance=Coalesce(
                        Sum('applicant__principal_balance', filter=Q(applicant__loan_status=3),
                            output_field=FloatField()),
                        Value(0.0),
                    ),
                    total_interest_balance=Coalesce(
                        Sum('applicant__interest_balance', filter=Q(applicant__loan_status=3),
                            output_field=FloatField()),
                        Value(0.0),
                    ),
                    total_shares=Coalesce(F('shares'), Value(0.0), output_field=FloatField()),
                    total_share_value=Coalesce(
                        F('shares') * Value(share_price), Value(0.0), output_field=FloatField()
                    ),
                    mem_name=Case(
                        When(is_group=True, then=F('name')),  # Use 'name' if is_group=True
                        default=F('biodata__name'),  # Otherwise, use 'biodata__name'
                        output_field=CharField(),
                    ),
                    account_numbers=Subquery(account_numbers_subquery),
                )
            )

            # Calculate totals before pagination
            totals = {
                'savings_balance': members_data.aggregate(total=Sum('total_savings_from_acc'))['total'],
                'principal_balance': members_data.aggregate(total=Sum('total_principal_balance'))['total'],
                'interest_balance': members_data.aggregate(total=Sum('total_interest_balance'))['total'],
                'loan_balance': members_data.aggregate(total=Sum('total_loan_balance'))['total'],
                'total_shares': members_data.aggregate(total=Sum('total_shares'))['total'],
                'shares_amount': members_data.aggregate(total=Sum('total_share_value'))['total']
            }

            # Pagination
            page = request.GET.get('page', 1)
            paginator = Paginator(members_data, self.items_per_page)

            try:
                paginated_members = paginator.page(page)
            except PageNotAnInteger:
                paginated_members = paginator.page(1)
            except EmptyPage:
                paginated_members = paginator.page(paginator.num_pages)

            context = {
                'title': title,
                'members': paginated_members,
                'totals': totals,
                'business': business,
                'business_filter':business_filter
            }

            return render(request, self.template_name, context)

        except Exception as exception:
            raise exception



class PublicHolidaysView(PermView):
    template_name = 'sacco/public_holidays.html'
    perm_name = 'handle_public_holidays'
    items_per_page = 50

    def get(self, request, *args, **kwargs):
        try:

            public_holidays = PublicHoliday.objects.filter(branch =biz_staff_branch(request.user))

            # Pagination
            page = request.GET.get('page', 1)
            paginator = Paginator(public_holidays, self.items_per_page)

            try:
                paginated_public_holidays = paginator.page(page)
            except PageNotAnInteger:
                paginated_public_holidays = paginator.page(1)
            except EmptyPage:
                paginated_public_holidays = paginator.page(paginator.num_pages)

            context = {
                'title': 'Public Holidays',
                'public_holidays': paginated_public_holidays,
            }

            return render(request, self.template_name, context)

        except Exception as exception:
            raise exception

    def post(self, request, *args, **kwargs):
        try:
            name = request.POST.get("name", None)

            day = request.POST.get("day", None)

            month = request.POST.get("month", None)

            if not name:
                messages.error(request, "error", extra_tags="Name: Public Holiday Name is missing!")

                return redirect(request.META.get("HTTP_REFERER", "/"))

            if not day:
                messages.error(request, "error", extra_tags="Day: Public Holiday Day is missing!")

                return redirect(request.META.get("HTTP_REFERER", "/"))

            if not month:
                messages.error(request, "error", extra_tags="Month: Public Holiday Month is missing!")

                return redirect(request.META.get("HTTP_REFERER", "/"))

            # first check if that name already exists
            check_holiday_name = PublicHoliday.objects.filter(
                name=name,
                branch=biz_staff_branch(request.user)
            )
            if check_holiday_name.exists():
                messages.error(request, "error", extra_tags="Provided holiday name already exists")
                return redirect(request.META.get("HTTP_REFERER", "/"))
            check_holiday_dates = PublicHoliday.objects.filter(
                day=day,
                month=month,
                branch=biz_staff_branch(request.user)
            )
            if check_holiday_dates.exists():
                messages.error(request, "error", extra_tags="Holiday with the provided dates already exists")
                return redirect(request.META.get("HTTP_REFERER", "/"))


            PublicHoliday.objects.create(
                name=name,
                day=day,
                month=month,
                branch=biz_staff_branch(request.user)
            )

            messages.success(request, 'success', extra_tags="Public Holiday Added Successfully.")

            return redirect(request.META.get("HTTP_REFERER", "/"))
        except Exception as exception:
            raise exception


class PublicHolidayView(BusinessUserMixin, View):
    template_name = 'sacco/public_holidays.html'
    items_per_page = 50

    def get(self, request, pk=None, *args, **kwargs):
        try:

            public_holiday = PublicHoliday.objects.get(pk=pk)

            context = {
                'title': public_holiday.name,
                'public_holiday': public_holiday,
            }

            return render(request, self.template_name, context)

        except Exception as exception:
            raise exception

    def post(self, request, pk=None, *args, **kwargs):
        try:

           PublicHoliday.objects.get(pk=pk).delete()

           messages.success(request, 'success', extra_tags="Public Holiday Deleted Successfully.")

           return redirect(reverse_lazy("public_holidays"))

        except ObjectDoesNotExist:
            messages.error(request, 'error', extra_tags="Public Holiday Not Found.")

            return redirect(reverse_lazy("public_holidays"))

        except Exception as exception:
            raise exception

class MigrateStaffView(View):
    def post(self, request, pk, *args, **kwargs):
        # check if staff exists
        the_staff = Staff.objects.filter(id=pk)
        if not the_staff.exists():
            messages.error(request, 'error', extra_tags="Staff nolonger exists")
            return redirect(reverse_lazy("staff"))


        # the staff objects
        the_staff = the_staff.first()
        # get the new branch
        new_branch = Branch.objects.get(id=request.POST.get('migrate_branch'))

        # create the attached account
        all_associated_acc = StaffLedgerAssociated.objects.filter(staff=the_staff, branch=the_staff.branch)
        # remove the current
        StaffLedgerAssociated.objects.filter(staff=the_staff, branch=new_branch).delete()
        for acc in all_associated_acc:
            # create the acc in new business
            check_acc = Account.objects.filter(name=acc.account_asscociated.name.strip(), business=new_branch.business)
            if check_acc.exists():
                StaffLedgerAssociated.objects.create(
                    branch=new_branch,
                    account_asscociated=check_acc.first(),
                    staff=the_staff,
                    added_by=request.user.staff
                )
            else:
                new_acc_tranc = Account.objects.create(
                    # code=''
                    name = acc.account_asscociated.name,
                    display_name = acc.account_asscociated.display_name,
                    category = AccountCategory.objects.get(name=acc.account_asscociated.category.name, business=new_branch.business),
                    business = new_branch.business,
                    added_by = request.user.staff
                )

                StaffLedgerAssociated.objects.create(
                    branch=new_branch,
                    account_asscociated = new_acc_tranc,
                    staff = the_staff,
                    added_by = request.user.staff
                )

        # update the staff biodata

        Biodata.objects.filter(id=the_staff.biodata.id).update(
            business=new_branch.business
        )
        # staff branch
        Staff.objects.filter(id=the_staff.id).update(
            branch=new_branch
        )
        # clear of attached businesses
        the_staff.businesses.clear()
        # add the default business
        the_staff.businesses.add(new_branch.business)

        messages.success(request, 'success', extra_tags="Staff migrated successfully")
        return redirect(reverse_lazy("staff"))


class MigrateMemberView(View):
    def post(self, request, pk, *args, **kwargs):
        # check if staff exists
        the_member = Member.objects.filter(id=pk)
        if not the_member.exists():
            messages.error(request, 'error', extra_tags="Member nolonger exists")
            return redirect(reverse_lazy("member_accounts"))
        the_member = the_member.first()

        new_branch = Branch.objects.get(id=request.POST.get('migrate_branch'))

        # mem_ids = [the_member.id]
        new_business_id = new_branch.business.id
        new_branch_id = new_branch.id
        old_branch_id = the_member.branch.id
        old_business_id = the_member.branch.business.id

        # all_members = Member.objects.filter(id__in=mem_ids)
        # get the groups the belong to - remove the record
        GroupMember.objects.filter(member_id=the_member.id, group__branch_id=old_branch_id).delete()

        the_broker = AccountBroker.objects.filter(members=the_member).first()
        migrate_single_member(the_broker, new_branch_id, new_business_id, old_business_id)

        messages.success(request, 'success', extra_tags="Member migrated successfully")
        return redirect(reverse_lazy("member_accounts"))
