import datetime
import math
import random
import time

import requests
import json
import pandas as pd
from django.utils.html import strip_tags
from pandas import Timestamp

from accounts.models import Branch, Business, Biodata
from commons.logger import logger
from loans.utils.error_handlers import ChargeCheckError
# from sacco.views import ShareTransactions

try:
    import httplib
except:
    import http.client as httplib

from django.conf import settings
from django.core.exceptions import ValidationError
from django.core.mail import send_mail, EmailMultiAlternatives, get_connection
from django.db import transaction
from django.db.models import Sum, Q

from loans.models import ApplicationAccountOrLoanType, Loans
from sacco.models import TransactionCharge, OtherSettings, MemberAccount, AccountBroker, Sms, SmsTransaction, \
    SaccoSmsSettings, NotiSettings, SMSCost, FinancialYear, Member, BusinessShares, AccountTypes
from transactions.models import Account, Transactions, AccountCategory, SharesTransactions
from django.utils.translation import gettext as _





def userdata(r):
    user_id = r.user.staff.id
    return user_id


def have_internet():
    conn = httplib.HTTPConnection("www.google.com", timeout=5)
    try:
        conn.request("HEAD", "/")
        conn.close()
        return True
    except:
        conn.close()
        return False


def businessdata(r):
    business_id = r.user.staff.biodata.business.id
    return business_id


def branchdata(r):
    brancn_id = r.user.staff.branch.id
    return brancn_id


def biz_id(user):
    business_id = user.staff.biodata.business.id
    return business_id


def branch_id(user):
    brancn_id = user.staff.branch.id
    return brancn_id


def biz_staff(user):
    staff = user.staff
    return staff


def biz_data(user):
    business = user.staff.biodata.business
    return business


def biz_staff_branch(user):
    branch = user.staff.branch

    return branch


def check_exist_status(k, m):
    if k in m:
        return True
    return False


def sendMessage(phone_number, message):
    data = {
        'api_id': 'API34770800361',
        'api_password': 'nugsoft@2020',
        'sms_type': 'T',
        'encoding': 'T',
        'sender_id': 'BULKSMS',
        'phonenumber': phone_number,
        'textmessage': message
    }

    url = 'http://apidocs.speedamobile.com/api/SendSMS'

    headers = {
        'content-type': 'application/json'
    }
    decodedValue = {
        'message_id': '83905948',
        'remarks': 'Message Submitted Sucessfully'
    }
    try:
        if settings.SMS_SEND:
            response = requests.request("POST", url, data=json.dumps(data), headers=headers)
            decodedValue = json.loads(response.content)
        if decodedValue['remarks'] == 'Message Submitted Sucessfully':
            return decodedValue['message_id']
    except Exception as e:
        print('nara it failed ', str(e))
    return 'failed'


def isInt(n):
    return n % 1 == 0


def checkMessageStatus(message_id):
    # print(message_id)
    url = 'http://apidocs.speedamobile.com/api/GetDeliveryStatus?message_id=' + str(message_id)

    try:
        response = requests.request("GET", url)
        # print(response)
    except:
        return 'request failed'
    decodedValue = json.loads(response.content)
    print(decodedValue)
    if decodedValue['DLRStatus'] == 'Accepted':
        return 'accepted'
    elif decodedValue['DLRStatus'] == 'Expired' or decodedValue['DLRStatus'] == 'Undeliverable' or decodedValue[
        'DLRStatus'] == 'Rejected' or decodedValue['DLRStatus'] == 'Unknown' or decodedValue['DLRStatus'] == 'Failed':
        return 'failed'
    else:
        return 'pending'


def checkAndSendMessage(user, message, phone_number, receiver_name, *args, **kwargs):
    print('my number: ', phone_number)
    member = None
    account = None
    rec_no = kwargs.get('rec_no', None)
    this_account = kwargs.get('this_account', None)
    if rec_no is None:
        rec_no = datetime.datetime.now().strftime("%y%m%d%H%M%S")
    if 'account' in kwargs:
        account = kwargs['account']

    sacco_branch_sms = Sms.objects.filter(branch=biz_staff_branch(user)).first()
    sms_balance = sacco_branch_sms.quantity
    sms_cost = SMSCost.objects.filter(business=biz_data(user)).first()
    chager = NotiSettings.objects.filter(business=biz_data(user)).first()


    # calculate number of messages person
    no_of_messages = len(message) / 160
    sms_body_count = math.ceil(no_of_messages)

    if int(sms_balance) < int(sms_body_count):
        # print('I have some SMSs credit of ', sms_balance)
        return 'insufficient messages'

    if chager.faces_charge == 'Client':
        if not this_account is None:
            balance = this_account.balance
            if sms_cost is not None:
                if sms_cost.cost > 0:
                    msg_cost = sms_cost.cost * sms_body_count
                    message = message + str(balance - msg_cost)


    # print('I have some SMSs credit of ', sms_balance)
    the_response = sendMessage(phone_number, message)
    # print('sms', the_response)
    # print('Immediate response', the_response)

    if the_response == 'failed':
        # print('here 1')
        return 'failed'
    else:
        # print('that')
        SmsTransaction.objects.create(
            branch=biz_staff_branch(user),
            quantity=sms_body_count,
            trans_type=SmsTransaction.USAGE,
            body=message,
            receiver=receiver_name,
            is_broadcast=True,
            delivery_id=the_response,
            status=SmsTransaction.PENDING,
            added_by=biz_staff(user),
            message_id=the_response
        )
        # update messages of sacco
        sacco_branch_sms.quantity = sms_balance - sms_body_count
        sacco_branch_sms.save()
        # record transaction here
        if chager.faces_charge == 'Client':
            print('Client is facing these charges')
            today = datetime.date.today()
            fy = FinancialYear.objects.filter(start_date__lte=today, end_date__gte=today,
                                              business=biz_data(user)).first()
            category = AccountCategory.objects.filter(name='Income', business=biz_data(user)).first()
            sms_revenue = Account.objects.filter(name='SMS Revenue', category=category, business=biz_data(user)).first()
            if sms_revenue is None:
                sms_revenue = Account.objects.create(name='SMS Revenue', display_name='SMS Revenue', category=category,
                                                     business=biz_data(user))
            if account:
                # print('it has')
                # members_account = MemberAccount.objects.filter(memeber_account__).first().the_account

                # print('fgfgsdghdsghsdghsdgh')
                if sms_cost is not None:
                    if sms_cost.cost > 0:
                        msg_cost = sms_cost.cost * sms_body_count
                        # if not dep_with is None:
                        #     new_cost =
                        Transactions.objects.create(
                            branch=biz_staff_branch(user),
                            transaction_type='SMS Charge',
                            account_dr=account,
                            account_cr=sms_revenue,
                            narration="Payment for SMSs received",
                            reporting_amount=msg_cost,
                            added_by=biz_staff(user),
                            financial_year=fy,
                            tx_date=today,
                            receipt=rec_no,
                            reference=rec_no
                        )
            else:
                print('no account')
        else:
            print('nope')

        return 'sent'


def sendEmail(template_file_link, html_body, salute, subject, email):
    c = {
        'salute': salute,
        'site_name': 'Mfuko Plus',
        'body': html_body,
    }
    try:
        email_html = render_to_string(template_file_link, c)
        send_mail(subject, '', '', [email, 'macdanson2@gmail.com'], html_message=email_html, fail_silently=False)
    except Exception as e:
        print(f'THE ERROR', e)


def sendTransEmail(template_file_link, html_body, business, subject, email):
    c = {
        'salute': 'Yours sincerely',
        'business': business,
        'subject': subject,
        'body': html_body,
    }
    email_html = render_to_string(template_file_link, c)
    # print('Connection Status', have_internet())
    if have_internet():
        send_mail(subject, '', '', [email, 'macdanson2@gmail.com'], html_message=email_html, fail_silently=False)


def check_charges(account_type, member_type, initial, user, initial_shares, share_select, branch):
    try:
        setting_status = OtherSettings.objects.filter(business=branch.business).first()
        share_price = 0
        depo_dict = []
        gen_dict = []

        gen_cgs = ApplicationAccountOrLoanType.objects.filter(account_type_id=account_type,
                                                              general_charge__application='r', general_charge__business=branch.business)

        gen_charges = 0
        if gen_cgs.exists():
            gen_dataframe = pd.DataFrame(gen_cgs.values())

            for gen in gen_cgs:
                amount = gen.general_charge.amount
                if gen.general_charge.is_percentage:
                    amount = initial * (gen.general_charge / 100)
                gen_dict.append(
                    {
                        'id': gen.id,
                        'amount': amount
                    }
                )
            gen_charges_df = pd.DataFrame(gen_dict)
            gen_frame = pd.merge(gen_dataframe, gen_charges_df, on='id')

            # summing general charges dataframe
            gen_charges = gen_frame['amount'].sum()

        # print('my general charges{}'.format(gen_charges))

        dep_cgs = TransactionCharge.objects.filter(account_type_id=account_type,
                                                   charge_type='d',
                                                   status=True)
        # print('starter')
        # print('dep_cgs', dep_cgs)
        depo_charges = 0
        if dep_cgs.count() > 0:
            depo_dataframe = pd.DataFrame(dep_cgs.values())
            # print(dep_cgs)
            # deposit charges
            for d in dep_cgs:
                amount = d.charge
                if d.account_type.deposit_charge_vary:
                    if d.start <= initial <= d.end:
                        amount = d.charge
                    if d.is_charge_percentage:
                        amount = initial * (d.charge / 100)
                depo_dict.append({'id': d.id, 'amount': amount, 'account_type_name': d.account_type.name})

                depo_data_charges = pd.DataFrame(depo_dict)
                # print('fjf', depo_data_charges)
                if not depo_dataframe.empty and not depo_data_charges.empty:
                    deposit_frame = pd.merge(depo_dataframe, depo_data_charges, on='id')

                    depo_charges = deposit_frame['amount'].sum()

        total_charges = 0

        # new member type
        if member_type == '2':
            if not setting_status.set_ordinary:
                # print('my share price {}'.format(share_price))
                if share_select == '1':
                    share_price = int(initial_shares) * int(setting_status.share_price)
                    # print('share', share_price)
                total_charges = depo_charges + gen_charges + share_price
            else:
                total_charges = depo_charges + gen_charges
        return total_charges
    except Exception as e:
        logger.error(str(e))
        raise ChargeCheckError(f'error occurred while checking charge: {e}')


def check_depo_charges(account, initial):
    this_account = MemberAccount.objects.get(id=account)
    member_acct = AccountBroker.objects.filter(the_account=this_account).first()
    depo_dict = []
    dep_cgs = TransactionCharge.objects.filter(account_type_id=member_acct.the_account.account_type,
                                               charge_type='d', status=True)

    depo_charges = 0
    if dep_cgs.exists():
        depo_dataframe = pd.DataFrame(dep_cgs.values())
        # deposit charges
        for d in dep_cgs:
            if d.account_type.deposit_charge_vary:
                if d.start <= int(initial) <= d.end:
                    amount = d.charge
                    if d.is_charge_percentage:
                        amount = int(initial) * (d.charge / 100)
                    depo_dict.append({'id': d.id, 'amount': amount, 'account_type_name': d.account_type.name})
                    print(depo_dict)
                else:
                    amount = 0
            else:
                amount = d.charge
                if d.is_charge_percentage:
                    amount = initial * (d.charge / 100)
                depo_dict.append({'id': d.id, 'amount': amount, 'account_type_name': d.account_type.name})
            depo_data_charges = pd.DataFrame(depo_dict)
            if not depo_dataframe.empty and not depo_data_charges.empty:
                deposit_frame = pd.merge(depo_dataframe, depo_data_charges, on='id')
                depo_charges = deposit_frame['amount'].sum()
            else:
                depo_charges = 0

    else:
        depo_charges = 0

    return depo_charges


def check_withdraw_charges(account, initial):
    this_account = MemberAccount.objects.get(id=account)
    # print(this_account.acc_number)

    member_acct = AccountBroker.objects.filter(the_account=this_account).first()

    depo_dict = []
    dep_cgs = TransactionCharge.objects.filter(account_type_id=member_acct.the_account.account_type,
                                               charge_type='w', status=True)

    depo_charges = 0
    if dep_cgs.exists():
        depo_dataframe = pd.DataFrame(dep_cgs.values())
        # print(dep_cgs)
        # deposit charges
        for d in dep_cgs:
            if d.account_type.withdraw_charge_vary:
                if d.start <= int(initial) <= d.end:
                    amount = d.charge
                    if d.is_charge_percentage:
                        amount = int(initial) * (d.charge / 100)
                    depo_dict.append({'id': d.id, 'amount': amount, 'account_type_name': d.account_type.name})
                    # print(depo_dict)
                else:
                    amount = 0
            else:
                amount = d.charge
                if d.is_charge_percentage:
                    amount = initial * (d.charge / 100)
                depo_dict.append({'id': d.id, 'amount': amount, 'account_type_name': d.account_type.name})
            depo_data_charges = pd.DataFrame(depo_dict)
            if not depo_dataframe.empty and not depo_data_charges.empty:
                deposit_frame = pd.merge(depo_dataframe, depo_data_charges, on='id')
                depo_charges = deposit_frame['amount'].sum()
            else:
                depo_charges = 0

        # print('my withdraw charges{} '.format(depo_charges))

    else:
        depo_charges = 0

    return depo_charges


def check_charges_opening(account_type, initial):
    depo_dict = []
    gen_dict = []

    gen_cgs = ApplicationAccountOrLoanType.objects.filter(account_type_id=account_type,
                                                          general_charge__application='r')

    gen_dataframe = pd.DataFrame(gen_cgs.values())

    if not gen_dataframe.empty:

        for gen in gen_cgs:
            amount = gen.general_charge.amount
            if gen.general_charge.is_percentage:
                amount = initial * (gen.general_charge / 100)
            gen_dict.append({'id': gen.id, 'amount': amount})
        gen_charges_df = pd.DataFrame(gen_dict)
        gen_frame = pd.merge(gen_dataframe, gen_charges_df, on='id')

        # summing general charges dataframe
        gen_charges = gen_frame['amount'].sum()

        # print('my general charges{}'.format(gen_charges))
    else:
        gen_charges = 0

    dep_cgs = TransactionCharge.objects.filter(account_type_id=account_type,
                                               charge_type='d',
                                               status=True)
    # print(dep_cgs)

    depo_charges = 0
    if dep_cgs.exists():
        depo_dataframe = pd.DataFrame(dep_cgs.values())
        # print(dep_cgs)
        # deposit charges
        for d in dep_cgs:
            if d.account_type.deposit_charge_vary:
                if d.start <= initial <= d.end:
                    amount = d.charge
                    if d.is_charge_percentage:
                        amount = initial * (d.charge / 100)
                    depo_dict.append({'id': d.id, 'amount': amount, 'account_type_name': d.account_type.name})
                    print(depo_dict)
                else:
                    amount = 0
            else:
                amount = d.charge
                if d.is_charge_percentage:
                    amount = initial * (d.charge / 100)
                depo_dict.append({'id': d.id, 'amount': amount, 'account_type_name': d.account_type.name})
            depo_data_charges = pd.DataFrame(depo_dict)
            if not depo_dataframe.empty and not depo_data_charges.empty:
                deposit_frame = pd.merge(depo_dataframe, depo_data_charges, on='id')
                depo_charges = deposit_frame['amount'].sum()
            else:
                depo_charges = 0

        # print('my deposit charges{}'.format(depo_charges))

    else:
        depo_charges = 0

    total_charges = depo_charges + gen_charges

    return total_charges


def check_ind_depo_charges(account, initial):
    this_account = MemberAccount.objects.filter(id=account).first()
    member_acct = AccountBroker.objects.filter(the_account=this_account).first()
    depo_dict = []
    dep_cgs = TransactionCharge.objects.filter(account_type_id=member_acct.the_account.account_type,
                                               charge_type='d', status=True)

    depo_charges = 0
    if dep_cgs.exists():
        depo_dataframe = pd.DataFrame(dep_cgs.values())
        # print(dep_cgs)
        # deposit charges
        for d in dep_cgs:
            if d.account_type.deposit_charge_vary:
                if d.start <= int(initial) <= d.end:
                    amount = d.charge
                    if d.is_charge_percentage:
                        amount = int(initial) * (d.charge / 100)
                    depo_dict.append({'id': d.id, 'amount': amount, 'account_type_name': d.account_type.name})
                    # print(depo_dict)
                else:
                    amount = 0
            else:
                amount = d.charge
                if d.is_charge_percentage:
                    amount = initial * (d.charge / 100)
                depo_dict.append({'id': d.id, 'amount': amount, 'account_type_name': d.account_type.name})
            depo_data_charges = pd.DataFrame(depo_dict)
            if not depo_dataframe.empty and not depo_data_charges.empty:
                deposit_frame = pd.merge(depo_dataframe, depo_data_charges, on='id')
                if d.account_type.deposit_charge:
                    depo_charges = deposit_frame['amount'].sum()
                else:
                    depo_charges = 0
            else:
                depo_charges = 0
        # print('my deposit charges{}'.format(depo_charges))
        # print('from checker')
    else:
        depo_charges = 0

    return depo_charges


def check_ind_withdraw_charges(account, initial):
    this_account = MemberAccount.objects.filter(id=account).first()
    # print(this_account)

    member_acct = AccountBroker.objects.filter(the_account=this_account).first()
    # print('m {}'.format(member_acct))

    depo_dict = []
    dep_cgs = TransactionCharge.objects.filter(account_type_id=member_acct.the_account.account_type,
                                               charge_type='w', status=True)

    depo_charges = 0
    if dep_cgs.exists():
        depo_dataframe = pd.DataFrame(dep_cgs.values())
        print(dep_cgs)
        # deposit charges
        for d in dep_cgs:
            if d.account_type.withdraw_charge_vary:
                if d.start <= int(initial) <= d.end:
                    amount = d.charge
                    if d.is_charge_percentage:
                        amount = int(initial) * (d.charge / 100)
                    depo_dict.append({'id': d.id, 'amount': amount, 'account_type_name': d.account_type.name})
                    print(depo_dict)
                else:
                    amount = 0
            else:
                amount = d.charge
                if d.is_charge_percentage:
                    amount = initial * (d.charge / 100)
                depo_dict.append({'id': d.id, 'amount': amount, 'account_type_name': d.account_type.name})
            depo_data_charges = pd.DataFrame(depo_dict)
            if not depo_dataframe.empty and not depo_data_charges.empty:
                deposit_frame = pd.merge(depo_dataframe, depo_data_charges, on='id')
                if d.account_type.withdraw_charge:
                    depo_charges = deposit_frame['amount'].sum()
                else:
                    depo_charges = 0
            else:
                depo_charges = 0

        print('my withdraw charges{}'.format(depo_charges))

    else:
        depo_charges = 0

    return depo_charges


def final_charges(charge):
    return charge


@transaction.atomic
def fund_transfer(account1, account2, initial, user, financial_year, transfer_date, branch):
    # print('amount here', initial)
    error_messages = {
        'fund_failed': _('Insufficient balance to complete transfer'),
    }
    rec_no = datetime.datetime.now().strftime("%y%m%d%H%M%S")
    income_acc = Account.objects.filter(category__name="Transfer Income", business=branch.business).first()
    min_balance = account1.account_type.min_balance
    # print('mi', min_balance)
    tran_dict = []
    tran_cgs = TransactionCharge.objects.filter(account_type=account1.account_type,
                                                charge_type='t', status=True)
    member_acct = AccountBroker.objects.filter(the_account=account1).first()
    member_acct_receiver = AccountBroker.objects.filter(the_account=account2).first()
    member_from_acc = Account.objects.filter(business=branch.business, member=account1).first()
    member_to_acc = Account.objects.filter(business=branch.business, member=account2).first()
    # print('------------')
    # print(tran_cgs)
    # print('---end---')
    trans_charges = 0
    if tran_cgs.exists():
        # print('okay')
        trans_dataframe = pd.DataFrame(tran_cgs.values())
        # print(tran_cgs)
        # transfer charges
        for t in tran_cgs:
            if t.account_type.transfer_charge_vary:
                if t.start <= int(initial) <= t.end:
                    amount = t.charge
                    if t.is_charge_percentage:
                        amount = int(initial) * (t.charge / 100)
                    tran_dict.append({'id': t.id, 'amount': amount, 'account_type_name': t.account_type.name})
                    # print(tran_dict)
            else:
                amount = t.charge
                if t.is_charge_percentage:
                    amount = initial * (t.charge / 100)
                # print(t.id)
                tran_dict.append({'id': t.id, 'amount': amount, 'account_type_name': t.account_type.name})
                # print('---')
            trans_data_charges = pd.DataFrame(tran_dict)
            if not trans_dataframe.empty and not trans_data_charges.empty:
                transfer_frame = pd.merge(trans_dataframe, trans_data_charges, on='id')
                # print('charge {}'.format(trans_charges))
                if t.account_type.transfer_charge:
                    if t.account_type.transfer_charge_vary:
                        dfs = transfer_frame[(transfer_frame['start'] <= initial) & (initial <= transfer_frame['end'])]
                    else:
                        dfs = transfer_frame
                else:
                    dfs = pd.DataFrame(columns=['id', 'start', 'end', 'charge', 'account_type_id',
                                                'charge_type', 'status', 'is_charge_percentage', 'created_date',
                                                'deletion_date', 'amount', 'account_type_name'])
                trans_charges = dfs['amount'].sum()
                # print(dfs)
                total_trans = account1.balance - min_balance

                allowed_transfer = initial + trans_charges
                if int(allowed_transfer) <= total_trans:
                    if not dfs.empty:
                        for index, row in dfs.iterrows():
                            Transactions.objects.create(
                                branch=branch,
                                transaction_type='Charge on transfer',
                                account_dr=member_from_acc,
                                account_cr=income_acc,
                                narration='Transfer Charge on {}'.format(row["account_type_name"]),
                                reporting_amount=row["amount"],
                                added_by=biz_staff(user),
                                financial_year=financial_year,
                                tx_date=transfer_date,
                                receipt=rec_no
                            )
                        break
                    else:
                        trans_charges = 0
                else:
                    raise ValidationError(
                        error_messages['fund_failed'],
                        code='fund_failed',
                    )
    # print('nope')
    Transactions.objects.create(
        branch=branch,
        transaction_type='Transfer',
        account_dr=member_from_acc,
        account_cr=member_to_acc,
        narration="Transfer from {} to {}".format(account1.acc_number, account2.acc_number),
        reporting_amount=initial,
        added_by=biz_staff(user),
        financial_year=financial_year,
        tx_date=transfer_date,
        receipt=rec_no
    )
    final_charges(trans_charges)
    member_debits = list(Transactions.objects.filter(account_dr=member_from_acc).aggregate(
        total=Sum('reporting_amount')).values())[0]

    receiving_member_debits = list(Transactions.objects.filter(account_dr=member_to_acc).aggregate(
        total=Sum('reporting_amount')).values())[0]

    if receiving_member_debits is None:
        receiving_member_debits = 0

    if member_debits is None:
        member_debits = 0

    member_credits = list(Transactions.objects.filter(account_cr=member_from_acc).aggregate(
        total=Sum('reporting_amount')).values())[0]

    receiving_member_credits = list(Transactions.objects.filter(account_cr=member_to_acc).aggregate(
        total=Sum('reporting_amount')).values())[0]

    if receiving_member_credits is None:
        receiving_member_credits = 0

    # print('here')

    account1.balance = member_credits - member_debits
    # print(member_debits)
    # print('after', receiving_member_debits, 'CREDITS', receiving_member_credits)
    account1.save()

    account2.balance = receiving_member_credits - receiving_member_debits
    account2.save()
    # print('almost', receiving_member_debits)

    #sender
    member_acc = Account.objects.filter(member_id=member_acct.the_account_id).first()
    #receiver
    member_acc_receiver = Account.objects.filter(member_id=member_acct_receiver.the_account_id).first()

    smsSettingsObj = SaccoSmsSettings.objects.get(when_to_send='On transfer transaction',
                                                  business=branch.business)
    # Sender msg
    message = f'From {member_acc_receiver.business.short_name}, You have made a transfer of {initial} ugx from your account {account1.acc_number} to account {account2.acc_number} ({member_acc_receiver.bio_name}) and incurred total charges of {trans_charges}UGX\n Your new balance is {account1.balance}'
    if smsSettingsObj.status:
        if member_acct.members.biodata.contact:
            print('ok')
            checkAndSendMessage(user, message, member_acct.members.biodata.contact, member_acct.members.biodata.name,
                                account=member_acc)
    else:
        print('send using email')

    #receiver msg
    message = f'From {member_acc_receiver.business.short_name}, You have received {initial} ugx from account {account1.acc_number} ({member_acc.bio_name}) on your account {member_acc_receiver.member.acc_number}. Your new balance is {account2.balance}'
    if smsSettingsObj.status:
        if member_acct_receiver.members.biodata.contact:
            print('ok')
            checkAndSendMessage(user, message, member_acct_receiver.members.biodata.contact, member_acct_receiver.members.biodata.name,
                                account=member_acc_receiver)
    else:
        print('send using email')
    return trans_charges


def convert(a):
    it = iter(a)
    res_dct = dict(zip(it, it))
    return res_dct


def check_account(acc_number, user):
    try:
        if AccountBroker.objects.filter(the_account__acc_number=acc_number, business=biz_data(user)).exists():
            return True
        return False
    except Exception as e:
        print('error', str(e))
        logger.error(str(e))


def gen_account(user):
    minimum = 10000000
    maximum = 99999999
    while True:
        number = random.randint(minimum, maximum)
        if not AccountBroker.objects.filter(the_account__acc_number=number, business=biz_data(user)).exists():
            # print(count)
            return number


def ref_no(branch):
    branch_info = str(branch).zfill(3)
    # print(branch_info)
    timestamp = int(time.time() * 1000)  # Convert current timestamp to milliseconds
    random_suffix = random.randint(100, 999)  # Generate a random 3-digit number
    int_uuid = int(f"{timestamp}{random_suffix}")
    # print(int_uuid)
    return str(int_uuid)


def generate_serial_number(branch):
    timestamp = datetime.datetime.now().timestamp()
    de_time = str(timestamp).split('.')[0].zfill(12)
    branch_info = str(branch).zfill(4)
    serial_number = de_time + branch_info

    if Transactions.objects.filter(receipt=serial_number, branch_id=branch).exists():
        # If a transaction with the generated serial number already exists, generate a new one recursively
        return generate_serial_number(branch)
    return serial_number


# def recalculate_shares(branch):
#     # print('Recalculate shares:', branch)
#     all_members = Member.objects.filter(branch_id=branch)
#     # print('TOTAL MEMBERS',all_members.count(), '-------------')
#     new_total_shares = 0
#     for member in all_members:
#         # print('current shares', member.shares)
#         member_id = member.id
#         try:
#             sold_shares = SharesTransactions.objects.filter(seller=member_id).aggregate(total_sold=Sum('shares'))
#             shares_sold = sold_shares['total_sold'] or 0
#             bought_shares = SharesTransactions.objects.filter(buyer=member_id).aggregate(total_bought=Sum('shares'))
#             shares_bought = bought_shares['total_bought'] or 0
#
#             share_balance = float(shares_bought) - float(shares_sold)
#             member.shares = share_balance
#             member.save()
#             new_total_shares = new_total_shares + share_balance
#             # print('new shares', member.shares)
#
#         except Exception as exe:
#             print(str(exe))
#     print('TOTAL NEW SHARES', new_total_shares)
#     the_branch = Branch.objects.get(id=branch)
#     BusinessShares.objects.filter(business=the_branch.business).update(sold=new_total_shares)


def recalculate_shares(branch):

    shares = []
    # print('Recalculate shares:', branch)
    all_members = Member.objects.filter(branch_id=branch).prefetch_related('shares_buyer', 'shares_seller')
    # print('TOTAL MEMBERS',all_members.count(), '-------------')
    new_total_shares = 0
    for member in all_members:
        # print('current shares', member.shares)
        # member_id = member.id

        sold_shares = member.shares_seller.aggregate(total_sold=Sum('shares'))
        shares_sold = sold_shares['total_sold'] or 0
        bought_shares = member.shares_buyer.aggregate(total_bought=Sum('shares'))
        shares_bought = bought_shares['total_bought'] or 0

        share_balance = float(shares_bought) - float(shares_sold)
        member.shares = share_balance
        shares.append(member)
        new_total_shares = new_total_shares + share_balance
    Member.objects.bulk_update(shares, ['shares'], batch_size=1000)
    the_branch = Branch.objects.get(id=branch)
    BusinessShares.objects.filter(business=the_branch.business).update(sold=new_total_shares)


# def recalculate_savings(business):
#     print('Recalculate savings:', business)
#     all_member_ledgers = Account.objects.filter(business_id=business, member_id__gt=0)
#     for member_ledger in all_member_ledgers:
#         try:
#             member_account = MemberAccount.objects.get(id=member_ledger.member_id)
#             new_balance = Transactions.objects.filter(
#                 Q(account_dr=member_ledger.id) | Q(account_cr=member_ledger.id)).aggregate(
#                 bal=Sum(
#                     Case(
#                         When(account_cr=member_ledger.id, then=F('reporting_amount')),
#                         default=0, output_field=FloatField()))
#                     - Sum(
#                     Case(
#                         When(account_dr=member_ledger.id, then=F('reporting_amount')),
#                         default=0, output_field=FloatField()))
#             )
#             member_account.balance = new_balance.get('bal', 0)
#             member_account.save()
#         except Exception as exe:
#             print(str(exe))


def recalculate_savings(business):
    # Fetch all MemberAccount objects with their related Account objects
    member_accounts = MemberAccount.objects.filter(
        account__business=business, id__gt=0
    ).prefetch_related('account__account_cr', 'account__account_dr', 'account')

    members_to_update = []
    for member_account in member_accounts:
        # Calculate the total credits and total debits using aggregation
        total_credits = member_account.account.aggregate(
            total_credits=Sum('account_cr__reporting_amount')
        )['total_credits'] or 0
        total_debits = member_account.account.aggregate(
            total_debits=Sum('account_dr__reporting_amount')
        )['total_debits'] or 0

        # Calculate the new balance
        new_balance = total_credits - total_debits
        balance = member_account.balance
        if balance != new_balance:
            member_account.balance = new_balance
            members_to_update.append(member_account)

    # Bulk update the members' balances
    MemberAccount.objects.bulk_update(members_to_update, ['balance'], batch_size=1000)


def recalculate_ind_savings(accounts):
    # Fetch all MemberAccount objects with their related Account objects
    member_accounts = accounts

    members_to_update = []
    for member_account in member_accounts:
        # Calculate the total credits and total debits using aggregation
        total_credits = member_account.account.aggregate(
            total_credits=Sum('account_cr__reporting_amount')
        )['total_credits'] or 0
        total_debits = member_account.account.aggregate(
            total_debits=Sum('account_dr__reporting_amount')
        )['total_debits'] or 0

        # Calculate the new balance
        new_balance = total_credits - total_debits
        member_account.balance = new_balance
        members_to_update.append(member_account)

    # Bulk update the members' balances
    MemberAccount.objects.bulk_update(members_to_update, ['balance'], batch_size=1000)


def get_loan_repayment_upload_submitted_values(request):
    return {
        'upload_file': request.FILES['proof'],
        'udate': datetime.datetime.strptime(request.POST['udate'], '%Y-%m-%d').date(),
        'narration': request.POST['narration'],
        'debit_acc': request.POST['debited'],
    }


def check_loan_repayment_fields_xlsx(data):
    fields = ['loan number', 'date', 'amount paid', 'reference', 'fines']
    fields_missing = []
    for field in fields:
        if not field in data:
            fields_missing.append(field)
    return fields_missing


def check_old_repayment_template(data):
    # print(data)
    fields = ['account number', 'deposit date', 'amount', 'reference']
    fields_missing = []
    for field in fields:
        if not field in data:
            fields_missing.append(field)
    return fields_missing


def get_dividend_upload_submitted_values(request):
    return {
        'upload_file': request.FILES['proof'],
        'udate': datetime.datetime.strptime(request.POST['udate'], '%Y-%m-%d').date(),
        'debited': request.POST['debited'],
        'narration': request.POST['narration'],
    }


def check_dividend_upload_fields_xlsx(data):
    fields = ['account', 'date', 'amount', 'saving', 'reference']
    fields_missing = []
    for field in fields:
        if not field in data:
            fields_missing.append(field)
    return fields_missing


def get_withdraw_upload_submitted_values(request):
    return {
        'upload_file': request.FILES['proof'],
        'udate': datetime.datetime.strptime(request.POST['udate'], '%Y-%m-%d').date(),
        'narration': request.POST['narration'],
        'credit_acc': request.POST['debited'],
        'apply_charges_from': request.POST['apply_charges_from'],
    }


def check_withdraw_upload_fields_xlsx(data, apply_charges_from):
    fields = ['account number', 'withdraw date', 'amount', 'reference', 'charge']
    fields_missing = []
    for field in fields:
        if field == 'charge':
            if apply_charges_from == 'excel':
                if not field in data:
                    fields_missing.append(field)
        else:
            if not field in data:
                fields_missing.append(field)
    return fields_missing


def get_member_balance(acc_number, business):
    # print('acc_number', acc_number)
    acc_broker = AccountBroker.objects.filter(the_account__acc_number=acc_number, business=business)

    if acc_broker.exists():
        memberAcc = acc_broker.first().the_account
        # print('acc_number', acc_number)
        # memberAcc = memberAcc.first()
        member_broker = acc_broker.first()
        member_acc = Account.objects.filter(member_id=member_broker.the_account_id).first()
        total_debits = Transactions.objects.filter(
            account_dr=member_acc
        ).aggregate(Sum('reporting_amount'))['reporting_amount__sum']
        total_credits = Transactions.objects.filter(
            account_cr=member_acc
        ).aggregate(Sum('reporting_amount'))['reporting_amount__sum']
        if total_debits is None:
            total_debits = 0
        if total_credits is None:
            total_credits = 0
        return total_credits - total_debits
    else:
        return 'failed'


def handle_single_withdraw(acc_number, business_data, branch_data, user_data, credit_acc, withdraw_data,
                           values_submitted):
    transactions_added = []
    timestamp = Timestamp(withdraw_data['withdraw date'])
    formatted_string = timestamp.strftime('%Y-%m-%d')
    withdraw_date = datetime.datetime.strptime(formatted_string, '%Y-%m-%d').date()
    # withdraw_date = withdraw_data['withdraw date']
    initial_before = float(withdraw_data['amount'].replace(',', ''))
    initial = float(initial_before)
    rec_no = datetime.datetime.now().strftime("%y%m%d%H%M%S")
    # ref_no = cleaned_data.get('with_ref') or rec_no
    # this_biz = Business.objects.filter(id=biz_id(user)).first()
    # notify_type = NotiSettings.objects.filter(business=business_data).first()
    # template_file_link = 'sacco/emails/transactional.html'
    # currency = CurrencySetting.objects.filter(business=business_data).first()

    # if not date_created:
    #     date_created = datetime.datetime.now().date()
    income_acc = Account.objects.filter(category__name="Withdraw Income", business=business_data).first()
    acc_broker = AccountBroker.objects.filter(the_account__acc_number=acc_number, business=business_data)
    this_account = acc_broker.first().the_account

    # chart of accounts
    memberAcc = acc_broker.first().the_account
    member_broker = acc_broker.first()
    member_acc = Account.objects.filter(member_id=member_broker.the_account_id).first()

    acc_involved = Account.objects.get(id=int(credit_acc), business=business_data)
    depo_dict = []

    if values_submitted['apply_charges_from'] == 'excel':
        if str(withdraw_data['charge']).strip() != 'nan' and str(withdraw_data['charge']).strip() != '0':
            print('WE HAVE CHARGED', withdraw_data['charge'])
            charge_trans = Transactions.objects.create(
                branch=branch_data,
                transaction_type='Charge on withdraw',
                account_dr=member_acc,
                account_cr=income_acc,
                narration=f'Charge on withdraw of {initial}',
                reporting_amount=float(withdraw_data['charge'].replace(',', '')),
                added_by_id=user_data,
                tx_date=withdraw_date,
                receipt=rec_no,
                reference=values_submitted['narration']
            )
            transactions_added.append(charge_trans.id)
    else:
        depo_cgs = TransactionCharge.objects.filter(account_type_id=member_broker.the_account.account_type,
                                                    charge_type='w', status=True)
        with_charges = 0
        if depo_cgs.exists():
            depo_dataframe = pd.DataFrame(depo_cgs.values())
            # print(depo_cgs)
            # deposit charges
            for w in depo_cgs:
                if w.account_type.withdraw_charge_vary:
                    if w.start <= initial <= w.end:
                        amount = w.charge
                        if w.is_charge_percentage:
                            amount = initial * (w.charge / 100)
                        depo_dict.append({'id': w.id, 'amount': amount, 'account_type_name': w.account_type.name})
                        # print(depo_dict)
                    else:
                        amount = 0
                else:
                    amount = w.charge
                    # print(w)
                    if w.is_charge_percentage:
                        amount = initial * (w.charge / 100)
                    # print(w.id)
                    depo_dict.append({'id': w.id, 'amount': amount, 'account_type_name': w.account_type.name})
                    # print('---')
                depo_data_charges = pd.DataFrame(depo_dict)
                # print(f'x is {depo_data_charges}')
                if not depo_dataframe.empty and not depo_data_charges.empty:
                    deposit_frame = pd.merge(depo_dataframe, depo_data_charges, on='id')
                    if w.account_type.withdraw_charge:
                        if w.account_type.withdraw_charge_vary:
                            # print('am varying')
                            dfs = deposit_frame[(deposit_frame['start'] <= initial) & (initial <= deposit_frame['end'])]
                        else:
                            # print('amount')
                            dfs = deposit_frame
                    else:
                        dfs = pd.DataFrame(columns=['id', 'start', 'end', 'charge', 'account_type_id',
                                                    'charge_type', 'status', 'is_charge_percentage', 'created_date',
                                                    'deletion_date', 'amount', 'account_type_name'])
                    # print(f'my x is {dfs}')
                    with_charges = dfs['amount'].sum()
                    if not dfs.empty:
                        for index, row in dfs.iterrows():
                            charge_trans = Transactions.objects.create(
                                branch=branch_data,
                                transaction_type='Charge on withdraw',
                                account_dr=member_acc,
                                account_cr=income_acc,
                                narration=f'Charge on withdraw of {initial}',
                                reporting_amount=row["amount"],
                                added_by_id=user_data,
                                # financial_year=financial_year,
                                tx_date=withdraw_date,
                                receipt=rec_no,
                                reference=values_submitted['narration']
                            )
                            transactions_added.append(charge_trans.id)
                        break
                else:
                    with_charges = 0

    trans = Transactions.objects.create(
        branch=branch_data,
        transaction_type='Withdraw',
        account_dr=member_acc,
        account_cr=acc_involved,
        narration=f'Withdraw of {initial} from {this_account.acc_number}' if not values_submitted['narration'] else
        values_submitted['narration'],
        reporting_amount=initial,
        added_by_id=user_data,
        # financial_year=financial_year,
        tx_date=withdraw_date,
        receipt=rec_no,
        reference=values_submitted['narration']
    )
    transactions_added.append(trans.id)

    member_debits = \
        list(Transactions.objects.filter(account_dr=member_acc).aggregate(total=Sum('reporting_amount')).values())[
            0]
    if member_debits is None:
        member_debits = 0
    # print(f'my member debits {member_debits}')
    member_credit = \
        list(Transactions.objects.filter(account_cr=member_acc).aggregate(total=Sum('reporting_amount')).values())[
            0]

    if member_credit is None or member_credit < 1:
        member_credits = 0
    else:
        member_credits = member_credit

    this_account.balance = member_credits - member_debits
    this_account.save()

    the_member_ = MemberAccount.objects.get(id=this_account.id)
    # print(the_member_.balance)
    return transactions_added


def is_excel_doc(file):
    excelSigs = [
        ('xlsx', b'\x50\x4B\x05\x06', 2, -22, 4),
        ('xls', b'\x09\x08\x10\x00\x00\x06\x05\x00', 0, 512, 8),  # Saved from Excel
        ('xls', b'\x09\x08\x10\x00\x00\x06\x05\x00', 0, 1536, 8),  # Saved from LibreOffice Calc
        ('xls', b'\x09\x08\x10\x00\x00\x06\x05\x00', 0, 2048, 8)  # Saved from Excel then saved from Calc
    ]

    for sigType, sig, whence, offset, size in excelSigs:
        file.seek(offset, whence)
        byts = file.read(size)

        if byts == sig:
            return True
    return False


# utils.py

from django.core.mail import send_mass_mail
from django.template.loader import render_to_string


def send_bulk_emails(recipients: list, subject, template_name, *args, **kwargs):
    connection = get_connection()  # uses SMTP server specified in settings.py
    connection.open()  # If you don't open the connection manually, Django will automatically open, then tear down the connection in msg.send()
    template_path = f'sacco/emails/{template_name}.html'  # Path to your HTML email template
    from_email = settings.DEFAULT_FROM_EMAIL
    email_messages = []

    for recipient in recipients:
        to_email = recipient['email']
        html_body = f"<p>Dear {recipient['name']},</p> <p>This is to inform you that your account  with A/C No: {recipient['account_number']} has been charged with {recipient['charge']} UGX. <br>We hope that you have a good experience with our services and <b>tfa</b> will do it’s best to please you. We will be looked forward to serving you in adherence to our quality standards.</p><p>Thanking you and with profound regards.</p>"
        context = {
            'salute': 'Yours sincerely',
            'business': recipient['business'],
            'subject': subject,
            'body': html_body,
        }
        html_content = render_to_string(template_path, context)
        text_content = strip_tags(html_content)  # Strip the html tag. So people can see the pure text at least.

        # Create the email message
        message = EmailMultiAlternatives(subject, text_content, from_email, [to_email], connection=connection)
        message.attach_alternative(html_content, "text/html")
        message.send()
        email_messages.append(message)
    connection.close()  # Cleanup


def format_date_pd(date):
    # Customize the date format here
    return pd.to_datetime(date).strftime('%Y-%m-%d')


def session_business_id(request):
    """
    Returns either a specific business ID or None based on session data.
    None indicates that all businesses should be queried ("central" view).

    Args:
        request: The HTTP request object containing session data

    Returns:
        int or None: Business ID if specific business selected, None if "central" selected
    """
    selected_business = request.session.get('selected_business_id')

    if selected_business == 'central':
        return None
    return selected_business


def session_business_data(request):
    """
    Returns either a specific business object or None based on session data.
    None indicates that all businesses should be queried ("central" view).

    Args:
        request: The HTTP request object containing session data

    Returns:
        Business Object or None: Business Object<pk> if specific business selected, None if "central" selected
    """
    selected_business = request.session.get('selected_business_id')

    if selected_business == 'central' :
        return None
    return Business.objects.get(pk=selected_business)


def filter_by_session_business(queryset, request):
    """
    Filters a queryset based on the selected business in the session.
    If "central" is selected, returns data for all businesses.

    Args:
        queryset: The initial queryset to filter
        request: The HTTP request object containing session data

    Returns:
        QuerySet: Filtered queryset based on business selection
    """
    business_id = session_business_id(request)

    if business_id is None:  # "central" selected
        return queryset
    return queryset.filter(business_id=business_id)


def determine_business_id_list(staff, business_context):
    if business_context is None:
        # get all the connected business ids
        instance_type = staff.branch.business.instance_type
        all_business_ids = list(Business.objects.filter(instance_type=instance_type).values_list('id', flat=True))
        return {
            'all_ids': all_business_ids,
            'title': 'all branches'
        }
    else:
        return {
            'all_ids': [business_context.id],
            'title': business_context.name
        }

def migrate_single_member(acc_broker, new_branch_id, new_business_id, old_business_id):
    # member
    Member.objects.filter(id=acc_broker.members.id).update(branch_id=new_branch_id)
    # account
    # -- get the equivalent acc type
    # Transactions account
    trans_acc = Account.objects.get(member=acc_broker.the_account)
    Account.objects.filter(member=acc_broker.the_account).update(
        business_id=new_business_id,
    )
    the_acc_type = AccountTypes.objects.filter(business_id=new_business_id, name=acc_broker.the_account.account_type.name).first()
    MemberAccount.objects.filter(id=acc_broker.the_account.id).update(
        account_type=the_acc_type
    )
    # biodata
    Biodata.objects.filter(id=acc_broker.members.biodata.id).update(
        business_id=new_business_id
    )
    # loans
    Loans.objects.filter(applicant=acc_broker.members).update(
        branch_id=new_branch_id
    )
    # shares
    SharesTransactions.objects.filter(Q(seller=acc_broker.members)|Q(buyer=acc_broker.members)).update(
        branch_id=new_branch_id
    )

    # transactions
    the_mem_transactions = (Transactions.objects.filter(Q(account_dr=trans_acc)|Q(account_cr=trans_acc)))
    # .exclude(account_dr_id=121).exclude(account_cr_id=121))
    for tran in the_mem_transactions:
        if tran.account_cr.member is None:
            try:
                acc_cr = Account.objects.get(business_id=new_business_id, name=tran.account_cr.name)
            except Exception as e:
                the_old_cr_acc = tran.account_cr
                acc_cr = Account.objects.create(
                    name=the_old_cr_acc.name,
                    business_id=new_business_id,
                    display_name=the_old_cr_acc.name,
                    category=AccountCategory.objects.get(name=the_old_cr_acc.category.name, business_id=new_business_id)
                )
        else:
            acc_cr = tran.account_cr

        if tran.account_dr.member is None:
            try:
                acc_dr = Account.objects.get(business_id=new_business_id, name=tran.account_dr.name)
            except Exception as e:
                the_old_dr_acc = tran.account_dr
                acc_dr = Account.objects.create(
                    name=the_old_dr_acc.name,
                    business_id=new_business_id,
                    display_name=the_old_dr_acc.name,
                    category=AccountCategory.objects.get(name=the_old_dr_acc.category.name, business_id=new_business_id)
                )
        else:
            acc_dr = tran.account_dr

        Transactions.objects.filter(id=tran.id).update(
            branch_id=new_branch_id,
            account_dr=acc_dr,
            account_cr=acc_cr
        )


    AccountBroker.objects.filter(id=acc_broker.id).update(
        business_id=new_business_id
    )

