from django.urls import path, re_path

# from .exception_handler import AnyHold
from loans import exports
from loans.exports import Runningpdf
from .json_requests import export_members, export_groups, check_charge_sum, export_savings, export_group_members, \
    export_member_summary, export_daily_member_report
from .message_centre import SmsPackages, ChoicePlan, PaymentCallBack
from .new_view import AddMemberView
from .payroll import StaffPayroll, PayrollDelete, StaffAdvance, StaffSalary, StaffAllowance, MonthPayments
from .receipts import WithdrawReceipt, ReceiptDetail
from .reports import RunningLoansReport, SavingsReport, ExpensesReport, AuditTrialsView, DailyLedgerSummaryView
from .shares import ManageShares, SellShares, TransferShares, ShareHolders, RemoveSharesTransaction, RemoveSharesTransactionMember
from .upload_savings import UploadSavings, UploadWithdraws, UploadTransactions, UploadShares, UploadRepyments, \
    UploadDevidends, UploadJvs, CorrectLoans, InterestUpload, UpdateRepayments, UploadAdjustments, CorrectTopups, \
    UploadSharesSales, UploadRepaymentsVersion2, UploadWithdrawsV2, WithdrawUploadsView, ReverseWithdrawUploadView, ReverseSavingsUploadView, SavingsUploadsView

from .views import *
from sacco import tests

urlpatterns = [
    path('', Index.as_view(), name='index'),
    path('my/business', MyBusinessProfile.as_view(), name='business_profile'),
    path('members/', Members.as_view(), name='members'),
    path('add-member', AddMember.as_view(), name='add_member'),
    path('account-types', AccountTypesAll.as_view(), name='add_account_type'),
    path('update-account-type/<slug:pk>', UpdateAccountType.as_view(), name='update_account_type'),
    path('change-account-type-status/<slug:pk>', ChangeAccountTypeStatus.as_view(), name='change_account_type_status'),
    path('search-account-type', SearchAccountType.as_view(), name='search_account_type'),
    path('search-financial-year', SearchFinancialYear.as_view(), name='search_financial_year'),

    path('financial-years', FinancialYears.as_view(), name='financial_years'),
    path('update-financial-year/<slug:pk>', UpdateFinancialYear.as_view(), name='update_financial_year'),
    path('delete-financial-year/<slug:pk>', DeleteFinancialYear.as_view(), name='delete-financial-year'),
    path('delete-transaction-charge/<slug:pk>', DeleteTransactionCharge.as_view(), name='delete_transaction_charge'),
    path('reactivate-financial-year/<slug:pk>', ReactivateFinancialYear.as_view(), name='reactivate_financial_year'),

    path('transaction-charges', TransactionCharges.as_view(), name='transaction_charges'),
    path('add-transaction-charges/<slug:pk>', AddTransactionCharges.as_view(), name='add_transaction_charges'),
    path('edit-transaction-charge/<slug:pk>', EditTransactionCharge.as_view(), name='edit_transaction_charge'),
    path('general-charges', AllGeneralCharges.as_view(), name='general_charges'),
    path('edit-general-charges/<slug:pk>', EditGeneralCharges.as_view(), name='edit_general_charges'),
    path('edit-general-charge/<int:pk>/', EditGeneralCharge.as_view(), name='edit_general_charge'),
    path('activate-or-deativate-charge/<slug:pk>', ActivateOrDeativateCharge.as_view(),
         name='activate_or_deativate_charge'),
    path('search-general-charge', SearchGeneralCharge.as_view(), name='search_general_charge'),
    path('share-settings', ShareSettings.as_view(), name='share_settings'),
    path('update-other-settings/<slug:pk>', UpdateOtherSettings.as_view(), name='update_other_settings'),
    path('edit-shares/<slug:pk>', EditShares.as_view(), name='edit_shares'),
    path('update-on-registration/<slug:pk>', UpdateOnRegistration.as_view(), name='update_on_registration'),
    path('sacco-sms-settings', SaccoSmsSettingsAll.as_view(), name='sacco_sms_settings'),
    path('sacco-sms-charge', SMSChargeView.as_view(), name='sacco_sms_charge'),
    path('update-sacco-sms-setting/<slug:pk>', UpdateSaccoSmsSetting.as_view(), name='update_sacco_sms_setting'),
    path('advanced-sms-setting', SMSAdvancedSettingsView.as_view(), name='advanced_sms_setting'),
    path('currency-settings', CurrencySettings.as_view(), name='currency_settings'),
    path('update-currency/<slug:pk>', UpdateCurrency.as_view(), name='update_currency'),
    path('update-currency-indication/<slug:pk>', UpdateCurrencyIndication.as_view(), name='update_currency_indication'),
    path('transaction-charges-settings', TransactionChargesSettings.as_view(), name='transaction_charges_settings'),
    path('update-transaction-charge-settings/<slug:pk>', UpdateTransactionChargeSettings.as_view(),
         name='update_transaction_charge_settings'),
    path('search-transaction-charge-setting', SearchTransactionChargeSetting.as_view(),
         name='search_transaction_charge_setting'),
    path('share-transactions', ShareTransactions.as_view(), name='share_transactions'),
    path('update-membership-status/<slug:pk>', UpdateMembershipStatus.as_view(), name='update_membership_status'),
    path('all-member-accounts/<slug:pk>', AllMemberAccounts.as_view(), name='all_member_accounts'),
    path('sms-broadcast-center', SmsBroadcastCenter.as_view(), name='sms_broadcast_center'),
    path('sacco-broadcast-messsages', SaccoBroadcastMesssages.as_view(), name='sacco_broadcast_messsages'),
    path('update-messages-on-page-loading', UpdateMessagesOnPageLoading.as_view(),
         name='update_messages_on_page_loading'),
    path('advanced-settings', AdvancedSettings.as_view(), name='advanced_settings'),
    path('update-notification-settings', UpdateNotificationSettings.as_view(), name='update_notification_settings'),
    path('sms-center', SmsCenter.as_view(), name='sms_center'),
    path('sms-package-plans', SmsPackages.as_view(), name='sms_package_plans'),
    path('payment-complete/', PaymentCallBack.as_view(), name='payment-complete'),
    path('plan/<int:pk>/', ChoicePlan.as_view(), name='choice_plan'),
    path('sms-group-count', SmsGroupCount.as_view(), name='sSms_group_count'),
    path('update-market-cap', UpdateMarketCap.as_view(), name='update_market_cap'),

    path('search-member/', SearchMember.as_view(), name='search_member'),
    path('check-charge-range/', check_charge_sum, name='check_charge_range'),
    path('member/<int:pk>/', MemberDetail.as_view(), name='member_detail'),
    path('member/recover_member/', RecoverMember.as_view(), name='recover_member'),
    path('update-acc-number/<int:pk>/', UpdateAccountNumber.as_view(), name='update_account_number'),
    path('member/edit/<int:pk>/', EditMember.as_view(), name='member_edit'),
    path('member/edit-photo/<int:pk>/', UpdatePhoto.as_view(), name='member_photo'),
    path('member/edit-sign/<int:pk>/', UpdateSignature.as_view(), name='member_sign'),
    path('member/delete/<int:pk>/', DeactivateMemberView.as_view(), name='member_delete'),
    path('member/enroll/<int:pk>/', EnrollMember.as_view(), name='member_enroll'),
    path('member/withdraw/<int:pk>/', MembersWithdraw.as_view(), name='member_withdraw'),
    path('member/deposit/<int:pk>/', MemberDeposit.as_view(), name='member_deposit'),
    path('export-members/', export_members, name='export_members'),
    path('member/bulk-deposit/', BulkDeposit.as_view(), name='bulk_deposit'),
    path('member/accounts/', MemberAccountsView.as_view(), name='member_accounts'),
    path('member/export-accounts/', ExportMemberAccountsView.as_view(), name='export_member_accounts'),
    path('member/inactive/', InactiveAccountsView.as_view(), name='inactive_accounts'),
    path('member/dormant/', DormantAccountsView.as_view(), name='dormant_accounts'),
    path('member/transfers/', TransfersView.as_view(), name='member_transfers'),
    path('upload-savings/', UploadSavings.as_view(), name='upload_savings'),
    path('upload-withdraws/', UploadWithdraws.as_view(), name='upload_withdraws'),
    path('upload-shares/', UploadShares.as_view(), name='upload_shares'),
    path('upload-shares-sales/', UploadSharesSales.as_view(), name='upload_shares_sales'),
    path('upload-transactions/', UploadTransactions.as_view(), name='upload_transactions'),
    path('upload-repayments/', UploadRepyments.as_view(), name='upload_repayments'),
    path('upload-repayments-v2/', UploadRepaymentsVersion2.as_view(), name='upload_repayments_v2'),
    path('upload-devidends/', UploadDevidends.as_view(), name='upload_devidends'),
    path('upload-jvs/', UploadJvs.as_view(), name='upload_jvs'),
    path('correct-loans/', CorrectLoans.as_view(), name='correct_loans'),
    path('correct-topups/', CorrectTopups.as_view(), name='correct_topups'),
    path('upload-interests/', InterestUpload.as_view(), name='upload_interests'),
    path('upload-adjustments/', UploadAdjustments.as_view(), name='upload_adjustments'),
    path('update-repayments/', UpdateRepayments.as_view(), name='update_repayments'),

    path('member/ind-depo/accounts/', IndDepositView.as_view(), name='member_ind_accounts'),
    path('member/ind-with/accounts/', IndWithdrawView.as_view(), name='member_ind_w_accounts'),
    path('member/withdraw-uploads/', WithdrawUploadsView.as_view(), name='withdraw_uploads'),
    path('member/savings-uploads/', SavingsUploadsView.as_view(), name='savings_uploads'),
    path('member/reverse-withdraw-upload/<int:pk>/', ReverseWithdrawUploadView.as_view(),name='reverse_withdraw_upload'),
    path('member/reverse-savings-upload/<int:pk>/', ReverseSavingsUploadView.as_view(),name='reverse_savings_upload'),


    path('member/ind-with/withdraw-upload/', UploadWithdrawsV2.as_view(), name='member_ind_w_accounts_v2'),

    # staff management
    path('profile/', ProfileView.as_view(), name='profile'),
    path('staffs/', StaffListView.as_view(), name='staff'),
    path('staff-add/', StaffAddView.as_view(), name='add_staff'),
    path('staff/<int:pk>/', StaffDetailView.as_view(), name='staff_detail'),
    path('staff/edit/<int:pk>/', StaffEditView.as_view(), name='edit_staff'),
    path('staff/delete/<int:pk>/', DeactivateStaffView.as_view(), name='delete_staff'),
    path('user-roles/', SystemRolesView.as_view(), name='user_roles'),
    path('audit-trials/', AuditTrialsView.as_view(), name='audit_trials'),
    path('user-role/delete/<int:pk>/', ManageUserRoleView.as_view(), name='delete_user_role'),
    path('user-role/edit/<int:pk>/', ManageUserRoleView.as_view(), name='edit_user_role'),
    path('user-role/<int:pk>/', AddPermRoleView.as_view(), name='manage_role'),

    path('staff/positions', SaccoRolesView.as_view(), name='staff_positions'),
    path('staff-role/delete/<int:pk>/', ManageStaffRoleView.as_view(), name='delete_staff_role'),
    path('staff-role/edit/<int:pk>/', ManageStaffRoleView.as_view(), name='edit_staff_role'),

    path('staff_payroll/', StaffPayroll.as_view(), name='staff_payroll'),
    path('staff_salaries/', StaffSalary.as_view(), name='staff_salaries'),
    path('staff_advance/', StaffAdvance.as_view(), name='staff_advances'),
    path('staff_allowance/', StaffAllowance.as_view(), name='staff_allowances'),
    path('payroll/delete/<int:pk>/', PayrollDelete.as_view(), name='delete_payroll'),
    # path('payroll/detail/<int:id>/', PayrollDetail.as_view(), name='get_payroll'),
    path('payroll/month/<str:date>/<int:pk>/', MonthPayments.as_view(), name='month_payroll'),

    #     Shares module urls
    path('shares', ManageShares.as_view(), name='shares'),
    path('shares/sell', SellShares.as_view(), name='sell_shares'),
    path('shares/transfer', TransferShares.as_view(), name='transfer_shares'),
    path('shares/sharesholders', ShareHolders.as_view(), name='shares_holders'),
    path('shares/remove-share-transaction/<int:pk>/', RemoveSharesTransaction.as_view(), name='remove_share_transaction'),
    path('shares/remove-share-transaction-mem/<int:pk>/<int:mem_id>/', RemoveSharesTransactionMember.as_view(), name='remove_share_transaction_mem'),

    # ========= Receipts ============
    path('receipts/withdraw', WithdrawReceipt.as_view(), name='withdraw_receipt'),
    path('receipt-detail/<int:pk>/<int:member_id>/', ReceiptDetail.as_view(), name='receipt_detail'),
    # path('whom', AnyHold.as_view(), name='to_whom')

    # =============== Other Reports and exports in PDF and Excel formats ============
    # ====== Reporting URLs
    path('reports/savings', SavingsReport.as_view(), name='savings_report'),
    path('reports/loans/running', RunningLoansReport.as_view(), name='running_loans_report'),
    path('reports/expenses', ExpensesReport.as_view(), name='expenses_report'),
    path('reports/daily-ledger-summary', DailyLedgerSummaryView.as_view(), name='daily_ledger_summary'),
    

    # ====== Exporting URLs
    path('export-savings/', export_savings, name='export_savings'),
    path('export-group-members/<int:pk>', export_group_members, name='export_group_members'),
    path('running-excel/', exports.RunningLoansExcel, name='running_excel'),
    path('expense-excel/', exports.ExpensesExcel, name='expense_excel'),
    path('shareholders-excel/', exports.ShareHoldersExcel, name='shareholders_excel'),
    path('failed-repayment/<int:pk>/', exports.FailedRepaymentExcel, name='failed_repayments'),
    path('failed-withdraws/<int:pk>/', exports.FailedWithdrawExcel, name='failed_withdraws'),
    path('failed-loans-upload/<int:pk>/', exports.FailedLoansUploadedExcel, name='failed_loans_upload'),
    

    path('failed-savings/<int:pk>/', exports.FailedSavingExcel, name='failed_savings'),

    path('running-pdf/', Runningpdf.as_view(), name='running_pdf'),
    path('transaction-history/', TransHistory.as_view(), name='trans_history'),
    path('member-uploads/', MemberUploadView.as_view(), name='member_upload'),
    path('member-uploads/delete/<uuid:my_uuid>/', DeleteMemberUploadView.as_view(), name='member_upload_delete'),

    path('test/', tests.TestLoans, name='TestLoans'),
    path('new-add-member/', AddMemberView.as_view(), name='add_member_new'),

    path('groups/', SaccoGroups.as_view(), name='sacco_groups'),
    path('create-group/', CreateGroupView.as_view(), name='create_group'),
    path('update-group-loan-officer/', UpdateGroupLoanOfficer.as_view(), name='update_group_loan_officer'),

    path('export-groups/', export_groups, name='export_groups'),
    path('group/<int:pk>/', GroupDetail.as_view(), name='group_detail'),
#     re_path(r'^group/(?P<pk>\d+)(?:/(?P<extra>\w*))?/$', GroupDetail.as_view(), name='group_detail'),
    path('group/<int:pk>/members/', GroupMembers.as_view(), name='group_members'),
    # path('group/<int:pk>/add-member/', AddGroupMembers.as_view(), name='add_member'),
    path('group/<int:pk1>/delete-member/<int:pk>/', DeleteGroupMember.as_view(), name='delete_group_member'),
    path('add-account-group/<int:pk>/', AddGroupAccount.as_view(), name='add_grp_acct'),
    path('group-member/<int:pk>/', ViewGroupMember.as_view(), name='grp_mem_det'),
    path('group/<int:pk>/add-member/', AddGroupMember.as_view(), name='add_group_member'),
    path('group/<int:pk>/add-existing-member/', AddExistingMemberToGroup.as_view(), name='add_existing_grp_member'),
    path('group-member-signatory/<int:pk>/', make_signatory, name='make_signatory'),
    path('group-bulk-deposit/<int:pk>/', MemberBulkDeposit.as_view(), name='make_bulk_deposit'),
    path('staff-associated/', StaffAssociatedView.as_view(), name='staff_associated'),
    path('delete-staff-associated/<int:pk>/', DeleteStaffAssociatedView.as_view(), name='delete_staff_associated'),

    path('deactivate-staff/<int:pk>/', DeleteStaffView.as_view(), name='deactivate-staff'),

    path('member-summary/', MemberSummaryView.as_view(), name='member_summary'),
    path('export-member-summary/', export_member_summary, name='export_member_summary'),
    path('daily-member-report/', DailyMemberReportView.as_view(), name='daily_member_report'),
    path('export-daily-member-report/', export_daily_member_report, name='export_daily_member_report'),
    path('public-holidays/', PublicHolidaysView.as_view(), name='public_holidays'),
    path('public-holiday/<int:pk>/', PublicHolidayView.as_view(), name='public_holiday'),
    path('migrate-staff/<int:pk>/', MigrateStaffView.as_view(), name='migrate_staff'),
    path('migrate-member/<int:pk>/', MigrateMemberView.as_view(), name='migrate_member'),

]
