import re
import sys
import traceback
from datetime import *
from math import floor
from dateutil.relativedelta import relativedelta
from django.contrib.auth.decorators import login_required
from django.http import HttpResponseRedirect
from django.urls import reverse_lazy
from django.utils.decorators import method_decorator
from django.shortcuts import render
from django.views import View
from pandas import Timestamp
from requests import request

from accounts.models import Business
from loans.utils.loan_uploads_utils import get_top_up_upload_submitted_values, trim_lower_case_dictionary_keys, \
    get_loan_principal_balance, determine_amount_paid_principal_and_interest, \
    get_receivable_acc_and_loan_interest_receivables_acc, get_or_create_excess_payment_acc, trim_lower_case_list_keys, \
    get_date_key
from sacco.constants import UPLOAD, CREATE, DELETE
from sacco.models import LoanSettings, ActivityLog, AccountBroker, TransactionCharge, WithdrawUpload, SavingUpload
from django.db.models import Q, F, FloatField, Case, When
from loans.models import *
from sacco.views import PermView

from transactions.models import AccountCategory, SharesTransactions, Transactions, Account

from sacco.utils import *
from django.contrib import messages
from loans.utils.loan_details import update_loan_summary_details, get_business_loans_context_data

# Create your views here.
from transactions.reports import today


@login_required
def updateloans(request, loanid):
    nowdate = today.strftime("%Y-%m-%d")
    this_business = Business.objects.filter(id=businessdata(request)).first()
    pk = loanid

    detail = Loans.objects.raw(
        "SELECT l.*, b.the_account_id as accountid, b.members_id as memberid, a.acc_number, m.biodata_id, m.id, c.name AS member_name, year(l.approved_on) as yapp, month(l.approved_on) as appmonth, day(l.approved_on) as appday FROM account_broker b, member_accounts a, sacco_member m, biodata c, loans l where b.the_account_id = a.id and b.business_id = %s and b.members_id = m.id and m.biodata_id = c.id and l.account_id = a.id and l.branch_id = %s and l.id=%s" % (
            businessdata(request), branchdata(request), pk))[0]

    laonacct = Account.objects.filter(name='Loan Receivables', business=businessdata(request))[0]

    formula = detail.loan_type.formula
    approved_amount = detail.amount_approved
    try:
        memberledger = Account.objects.filter(member_id=detail.accountid)[0]
    except Exception as mb:

        #     =======================CREATE MEMBER LEDGER==================================
        lcategory = AccountCategory.objects.filter(name='Members', business_id=businessdata(request))[0]
        creatledger = Account.objects.create(member_id=detail.accountid, category_id=lcategory.id,
                                             business_id=businessdata(request), added_by_id=userdata(request))

        memberledger = creatledger

    if detail.is_topup is True and int(detail.loan_status) < 3:
        title = 'Loan topup application details'

    elif int(detail.loan_status) < 3:
        title = 'Loan application details'

    try:
        paid = Transactions.objects.raw(
            "SELECT SUM(reporting_amount) as tpaid,id from transactions where (transaction_type='Loan repayment' OR transaction_type='Loan interest') AND loan_id= %s " % (
                loanid))[0]
        paidamount = paid.tpaid

    except:
        paidamount = 0

    #    ========================CLEARED INTERESTS============================================

    interestspaid = Transactions.objects.filter(loan_id=loanid, transaction_type='Loan interest',
                                                branch__business_id=businessdata(request))
    intpaid = interestspaid.count()

    # except Exception as ex:
    #     intpaid = 0

    # ===========================================================================================

    try:
        editsetings = LoanSettings.objects.filter(business=businessdata(request))[0]
        decimals = editsetings.decimals
        nonemember = editsetings.allow_others
        minguarantors = editsetings.minimum_guarantors
    except Exception as gex:
        decimals = 0
        formula = 1
        minguarantors = 1
        nonemember = False

    securities = Loansecurities.objects.filter(loan=loanid)

    # ======================SEND TO THE VIEW CALCULATED CHARGES======================================

    totalcharges = 0

    if int(detail.loan_status) > 1:
        actualchargesx = detail.charges
        try:
            actualcharges = json.loads(actualchargesx)
            for chg in actualcharges:
                chargeamount = chg['amount']
                totalcharges = totalcharges + chargeamount

        except:
            totalcharges = 0

    # ============ GET CHARGES IF THE CHARGES ARE STILL IN APPLICATION STAGE ====================
    else:
        charges = ApplicationAccountOrLoanType.objects.filter(loan_type=detail.loan_type, general_charge__status=1,
                                                              general_charge__application="l")
        actualcharges = []
        for charge in charges:
            ispercentage = charge.general_charge.is_percentage
            if ispercentage == 1:
                if detail.loan_status < 2:
                    chargeamount = (charge.general_charge.amount * detail.amount_requested) / 100
                else:
                    chargeamount = (charge.general_charge.amount * detail.amount_approved) / 100

            else:
                chargeamount = charge.general_charge.amount

            actualcharges.append({"name": charge.general_charge.charge, "amount": chargeamount})

            totalcharges = totalcharges + chargeamount

    if detail.is_topup == True:
        oldloan = LoanTopups.objects.filter(topup_loan_id=loanid)[0]
        oldbalance = oldloan.closed_loan.balance
        totalcharges = totalcharges + oldbalance

    if detail.charges_paid == False:
        disbusable = approved_amount
    else:
        disbusable = approved_amount - totalcharges
    disbusable = round(disbusable, decimals)

    guarantors = Loanguarantors.objects.filter(loan=loanid)
    docs = LoanUpload.objects.filter(loan=loanid)
    loantypes = LoanTypes.objects.filter(business=businessdata(request), is_active=True)

    if editsetings.allow_uploads is True and docs.count() > 0:
        must_upload = 1
    elif editsetings.allow_uploads is True and docs.count() < 1:
        must_upload = 0
    else:
        must_upload = 1

    # ==================GET INTEREST IN RELATION TO SETTINGS=====================
    if detail.interval is not None:
        typeinterval = detail.interval

    else:
        typeinterval = detail.loan_type.interval
        detail.interval = typeinterval
        detail.save()

    interest = (detail.rate / 100) / 12

    if detail.loan_status > 2:
        repayments = Transactions.objects.raw(

            "SELECT sum(reporting_amount) as paidamount, id, receipt FROM transactions where loan_id= %s and (transaction_type='Loan repayment' or transaction_type='Loan interest' ) GROUP BY receipt" % (
                loanid))
    if detail.loan_status > 2:

        maccount = detail.accountid

        # ===================CHECK IF THE LOAN HAS A TOPUP APPLICATION ALREADY=========================
        try:
            checktopup = Loans.objects.filter(account_id=maccount, loan_status__lt=3)[0]
            sometopup = 1
        except:
            sometopup = 0

        try:
            paidamount = round(paidamount, decimals)

        except:
            paidamount = 0

        duration = detail.approved_duration
        appdate = detail.schedule_start
        principal = detail.amount_approved

        if not detail.charges_paid:

            principal = float(principal) + float(totalcharges)
            approved_amount = float(approved_amount) + float(totalcharges)
        else:

            principal = principal
            approved_amount = float(approved_amount)

        if formula == 5:
            interest = (detail.rate / 100)

        if formula == 1:
            if typeinterval == 3:
                interest = (detail.rate / 100) / 12

            if typeinterval == 0:
                interest = (detail.rate / 100) / 365

            if typeinterval == 1:
                interest = (detail.rate / 100) / 52

            if typeinterval == 2:
                interest = (detail.rate / 100) / 26

            if typeinterval == 4:
                interest = (detail.rate / 100)

        if formula == 2:
            if typeinterval == 3:
                interest = (detail.rate / 100)

            if typeinterval == 0:
                interest = (detail.rate / 100) / 30

            if typeinterval == 1:
                interest = (detail.rate / 100) / 4

            if typeinterval == 2:
                interest = (detail.rate / 100) / 2

            if typeinterval == 4:
                interest = (detail.rate / 100) * 12

        if formula == 3:
            if typeinterval == 3:
                interest = (detail.rate / 100) * 4

            if typeinterval == 0:
                interest = (detail.rate / 100) * 7

            if typeinterval == 1:
                interest = (detail.rate / 100)

            if typeinterval == 2:
                interest = (detail.rate / 100) * 2

            if typeinterval == 4:
                interest = (detail.rate / 100) * 52

        if formula == 4:
            if typeinterval == 3:
                interest = (detail.rate / 100) * 30

            if typeinterval == 0:
                interest = (detail.rate / 100)

            if typeinterval == 1:
                interest = (detail.rate / 100) * 7

            if typeinterval == 2:
                interest = (detail.rate / 100) * 14

            if typeinterval == 4:
                interest = (detail.rate / 100) * 256

        # ===================GET LOAN REPAYMENTS========================================

        # =====================IF INTERVAL IS MONTHLY =========================
        if typeinterval == 3:
            to_add = relativedelta(months=1)
            try:
                all_duration = relativedelta(months=duration)
            except Exception as exp:
                print(str(exp))

        # =====================IF INTERVAL IS DAILY =========================

        if typeinterval == 0:
            to_add = relativedelta(days=1)
            all_duration = relativedelta(days=duration)

        # =====================IF INTERVAL IS WEEKLY =========================

        if typeinterval == 1:
            to_add = relativedelta(weeks=1)
            all_duration = relativedelta(weeks=duration)

        # =====================IF INTERVAL IS BI-WEEKLY =========================

        if typeinterval == 2:
            to_add = relativedelta(weeks=2)
            all_duration = relativedelta(weeks=duration * 2)

        # =====================IF INTERVAL IS YEARLY =========================

        if typeinterval == 4:
            to_add = relativedelta(years=1)
            all_duration = relativedelta(years=duration)

        # ================================DETERMINING THE FINES AND ON WHICH SCHEDULES==========================
        nowdate = datetime.datetime.today().date()

        # get loan fines

        loanfines = ApplicationAccountOrLoanType.objects.filter(loan_type_id=detail.loan_type.id,
                                                                general_charge__application='o',
                                                                general_charge__is_fine=True)

        # loanfines=[]

        sfine = 0
        fine = 0
        # =======================IF RATE TYPE IS FLAT============================
        cumrative_payments = 0
        if detail.rate_type == 1:
            days = []
            schedules = approved_amount / duration
            interestperschedue = approved_amount * interest
            payable = interestperschedue + schedules
            payable = payable
            startyear = detail.yapp
            startmonth = detail.appmonth + 1
            startday = detail.appday

            # ========================================GET PAID SCHEDULES=========================

            paidschedules = paidamount / payable
            paidschedules = floor(paidschedules)

            # ====================================Balance for the next schedule=======================
            nextbal = paidamount - (payable * paidschedules)
            nextintallment = payable - nextbal

            nextschedule = paidschedules + 1

            edate = appdate + to_add
            # print(appdate)
            date1 = edate
            totalpayable = payable * duration

            totalinterest = totalpayable - principal

            totalpayable = round(totalpayable, decimals)

            rbalance = totalpayable

            date2 = date1 + all_duration
            m = 1

            try:

                principalbalance = principal

                sch_date = date1
                while date1 < date2:
                    pbalance = 0

                    if intpaid == m or intpaid > m:
                        actualinterest = 0
                    else:
                        actualinterest = interestperschedue

                    rbalance = rbalance - payable
                    rbalance = rbalance
                    if m == nextschedule:
                        isnext = 1
                        spaid = nextbal
                        sbalance = nextintallment

                    elif m < nextschedule:
                        isnext = 0
                        spaid = payable
                        sbalance = 0

                    else:
                        isnext = 2
                        spaid = 0
                        sbalance = payable

                    sfine = sfine

                    principalbalance = principalbalance - schedules

                    days.append(
                        [date1.strftime("%Y-%m-%d"), isnext, round(spaid, decimals), round(sbalance, decimals),
                         round(rbalance, decimals), round(actualinterest, decimals), sfine,
                         round(principalbalance, decimals), round(payable, decimals)])
                    date1 = date1 + to_add

                    m = m + 1
            except Exception as erp:
                print("ERROR %", str(erp))

            generalbalance = totalpayable - paidamount
            try:
                if generalbalance == 0 or generalbalance < 1:
                    detail.loan_status = 4

            except:
                pass
            generalbalance = round(generalbalance, decimals)
            detail.balance = generalbalance
            detail.save()

        # =============================================IF THE RATE TYPE IS REDUCING=====================================
        if detail.rate_type == 2:
            in_date = ''
            loan_dict = {}
            data = []
            days = []

            edate = appdate + to_add
            date1 = edate
            principals = 0
            date2 = date1 + all_duration
            runningbal = detail.amount_approved
            if interest > 0:
                numilator = principal * interest * (
                        (pow((1 + interest), duration)) / (pow((1 + interest), duration) - 1))
            else:
                numilator = principal / duration
            payable = numilator

            totalpayable = payable * duration

            totalpayable = totalpayable

            rprincipal = 0
            rbalance = principal
            # ========================================GET PAID SCHEDULES=========================

            paidschedules = paidamount / payable
            paidschedules = floor(paidschedules)

            # print('PAID SCHEDULES ARE ', paidschedules, 'Paid Is ', paidamount, 'Payabale is ', payable)

            nextschedule = paidschedules + 1
            # ====================================Balance for the next schedule=======================
            nextbal = paidamount - (payable * paidschedules)
            nextintallment = payable - nextbal

            m = 1
            isnext = 0
            sfine = 0
            sch_date = date1

            pbalance = principal
            sch_date = date1
            generalbalance = totalpayable - paidamount
            try:
                if generalbalance == 0 or generalbalance < 1:
                    detail.loan_status = 4

            except:
                pass
            generalbalance = round(generalbalance, decimals)
            detail.balance = generalbalance
            detail.save()

            fyear = FinancialYear.objects.filter(end_date__year=2021, business_id=businessdata(request))[0]
            endyear = fyear.end_date

            expectedinterest = 0
            while date1 < date2:

                sfine = 0
                sfines = 0
                if m == nextschedule:
                    isnext = 1
                    spaid = round(nextbal, decimals)
                    sbalance = round(nextintallment, decimals)

                elif m < nextschedule:
                    isnext = 0
                    spaid = round(payable, decimals)
                    sbalance = 0

                else:
                    isnext = 2
                    spaid = 0
                    sbalance = round(payable, decimals)

                days.append(date1.strftime("%Y-%m-%d"))

                # print(nowdate)
                # print(date1)
                if date1 < nowdate and isnext > 0:
                    for loanfine in loanfines:
                        fineamount = loanfine.general_charge.amount
                        if loanfine.general_charge.is_percentage == True:
                            sfines = (fineamount / 100) * payable
                        else:
                            sfines = fineamount

                        sfine = float(sfine) + float(sfines)
                else:
                    sfine = 0

                sfine = round(sfine, decimals)

                interestperschedue = rbalance * interest
                interestperschedue = interestperschedue

                if date1.year == 2021:
                    print("YEAR IS 2021")
                    expectedinterest = expectedinterest + interestperschedue
                if interest > 0:
                    rbalance = principal * ((pow((1 + interest), duration) - pow((1 + interest), m)) / (
                            pow((1 + interest), duration) - 1))
                else:
                    rbalance = rbalance - payable
                if intpaid == m or intpaid > m:
                    actualinterest = 0

                else:

                    actualinterest = interestperschedue

                rprincipal = payable - interestperschedue
                rprincipal = rprincipal

                rbalance = rbalance

                pbalance = pbalance - rprincipal
                if spaid > 0:
                    cumrative_payments = cumrative_payments + spaid

                else:
                    cumrative_payments = 0

                loan_dict[in_date] = date1.strftime("%Y-%m-%d")
                loan_dict[rprincipal] = rprincipal
                loan_dict[rbalance] = rbalance
                loan_dict[isnext] = isnext
                loan_dict[interestperschedue] = interestperschedue
                loan_dict[spaid] = spaid
                loan_dict[sbalance] = sbalance
                loan_dict[actualinterest] = actualinterest
                data.append(
                    [round(rprincipal, decimals), loan_dict[in_date], round(rbalance, decimals),
                     round(interestperschedue, decimals), round(isnext, decimals),
                     round(spaid, decimals), round(sbalance, decimals),
                     round(actualinterest, decimals), sfine, round(payable, decimals),
                     round(pbalance, decimals), round(cumrative_payments, decimals)

                     ])
                date1 = sch_date + m * to_add
                m = m + 1
                sfine = 0

                # date1 = date1 + to_add

                # //principal = rprincipal

            nowdate = datetime.datetime.today()

            if nowdate.date() > date2:
                isoverdue = True

            else:
                isoverdue = False

            if detail.sub_intervals == True:
                totalinterest = round(totalinterest, decimals)
                totalpayable = approved_amount + totalinterest
            else:
                totalinterest = totalpayable - detail.amount_approved

            generalbalance = (totalpayable) - paidamount

            print(totalpayable)
            print(paidamount)
            try:
                if generalbalance == 0 or generalbalance < 1:
                    detail.loan_status = 4
            except:
                pass
            generalbalance = round(generalbalance, decimals)
            detail.balance = generalbalance
            detail.save()

            #
            totalpayable = round(totalpayable, decimals)

            #      ==============================SAVING THE LOAN INTEREST RECEIVABLE TRANSACTION============================
            #         CHECK DUPLICATE=
            check = Transactions.objects.filter(loan_id=loanid, transaction_type='Expected loan interest').exists()
            if check:
                upd = Transactions.objects.filter(loan_id=loanid, transaction_type='Expected loan interest')[0]
                upd.reporting_amount = expectedinterest
                upd.save()
            else:
                intrestaccount = Account.objects.filter(name='Loan interests',
                                                        business=businessdata(request)).first()

                receivable = \
                    Account.objects.filter(name='Loan interest receivables', business=businessdata(request))[
                        0]

                loanr = Account.objects.filter(name='Loan receivables', business=businessdata(request))[
                    0]

                narration = 'Loan interest expected from ', detail.member_name

                trans = Transactions.objects.create(reporting_amount=expectedinterest,
                                                    narration=narration,
                                                    account_dr_id=receivable.id,
                                                    account_cr_id=intrestaccount.id,
                                                    loan_id=loanid,
                                                    tx_date=detail.approved_on,
                                                    transaction_type='Expected loan interest',
                                                    added_by_id=userdata(request),
                                                    branch_id=branchdata(request))

        try:

            intrestaccount = Account.objects.filter(name='Loan interests',
                                                    business=businessdata(request)).first()

            receivable = Account.objects.filter(name='Loan interest receivables', business=businessdata(request))[
                0]

            loanr = Account.objects.filter(name='Loan receivables', business=businessdata(request))[
                0]

            narration = 'Loan interest expected from ', detail.member_name

            principalpaid = Transactions.objects.filter(loan_id=loanid, account_cr_id=1085).aggregate(
                totalpaid=Sum('reporting_amount'))
            totalpaid = principalpaid['totalpaid']

            principaldr = Transactions.objects.filter(loan_id=loanid,
                                                      account_dr_id=1085).aggregate(
                totalout=Sum('reporting_amount'))
            totalout = principaldr['totalout']
            if float(totalpaid) > float(totalout):
                interestback = float(totalpaid) - float(totalout)

                #             GET LAST PAYMENT DATE ===================

                lastp = Transactions.objects.filter(loan_id=loanid,
                                                    transaction_type='Loan repayment').last()
                lastdate = lastp.tx_date

                #             REVERSE THE INTEREST ==================================
                #
                narr = 'Loan interest reversed from over paid loan principal for account ', detail.member_name
                interest_trans = Transactions.objects.create(reporting_amount=interestback,
                                                             narration=narr,
                                                             account_dr_id=loanr.id,
                                                             account_cr_id=intrestaccount.id,
                                                             loan_id=loanid,
                                                             tx_date=lastdate,
                                                             transaction_type='Interest on loan',
                                                             added_by_id=userdata(request),
                                                             branch_id=branchdata(request))
        except Exception as iex:

            print(str(iex))

            # =========================RECORD INTEREST======================================


# =================================UPLAOD LOANS==========================================
@method_decorator(login_required, name='dispatch')
class UploadSavings(View):
    template_name = 'sacco/upload_savings.html'

    def get(self, request, *args, **kwargs):
        title = 'SAVINGS UPLOADS'
        bankaccounts = Account.objects.filter(Q(business=businessdata(request)),
                                              (Q(category__name='Bank') | Q(category__name='Mobile Money') | Q(
                                                  category__name='Cash') | Q(
                                                  category__name='Shares') |
                                               Q(category__name='Account Receivables') |
                                               Q(category__name='Reserves')))
        context = {
            'title': title,
            'bankaccounts': bankaccounts
        }

        return render(request, self.template_name, context)

    # ====WHEN THE POST IS MADE==========================

    def post(self, request, *args, **kwargs):
        formtype = request.POST['form_type']
        if formtype == 'delete':
            pk = request.POST['uploadid']

        if formtype == 'upload':
            upload_file = request.FILES['proof']
            udatea = request.POST['udate']
            udate = datetime.datetime.strptime(udatea, '%Y-%m-%d')
            debited = request.POST['debited']
            narration = request.POST['narration']

            data = upload_file.read().decode('utf-8')

            n = 0

            # you can use the re library --> import re
            rows = re.split('\n', data)  # splits along new line

            nloans = 0
            # === RECORD THE UPLOAD=========================
            savings_made = []
            savings_failed = []
            transactions_added = []

            for index, row in enumerate(rows):
                n = n + 1

                cells = row.split(',')

                if n > 1:

                    try:
                        nloans = nloans + 1
                        memberacct = cells[0].strip()
                        print('Member account', memberacct)

                        approvedon = cells[1]
                        approvedon = pd.to_datetime(approvedon, infer_datetime_format=True)
                        approvedon = approvedon.strftime('%Y-%m-%d')

                        amount = cells[2]
                        refeence = cells[3]
                        amount = float(amount.replace(',', ''))
                        # getmemberid = MemberAccount.objects.filter(acc_number=memberacct,
                        #                                            account_type__business_id=businessdata(request))
                        the_acc_broker = AccountBroker.objects.filter(business_id=businessdata(request), the_account__acc_number=memberacct)
                        if not the_acc_broker.exists():

                            savings_failed.append({
                                'reason': 'Account does not exist',
                                'account number': memberacct
                            })
                        else:
                            getmemberid = the_acc_broker.first().the_account
                            checkmember = Account.objects.filter(member=getmemberid,
                                                                business_id=businessdata(request)).exists()
                            # print('checkmember', checkmember)

                            if checkmember:
                                getmemberleger = Account.objects.filter(member=getmemberid, business=businessdata(request))[0]
                            else:

                                membercat = AccountCategory.objects.filter(name='Members', business_id=businessdata(request))[0]
                                getmemberleger = Account.objects.create(name='',
                                                    member_id=getmemberid.id,
                                                    business_id=businessdata(request),
                                                    category_id=membercat.id,
                                                    added_by_id=userdata(request)
                                                )

                            #      SAVE THE TRANSCTION=============================================
                            # check if transaction already exixts
                            exists = Transactions.objects.filter(receipt=refeence, branch_id=branchdata(request)).exists()

                            savetransaction = Transactions.objects.create(reporting_amount=amount,
                                                                        narration=narration,
                                                                        receipt=refeence,
                                                                        account_cr_id=getmemberleger.id,
                                                                        account_dr_id=debited,
                                                                        tx_date=approvedon,
                                                                        transaction_type='Deposit',
                                                                        branch_id=branchdata(request))
                            print('savetransaction', savetransaction.id)
                            # print('savetransaction',savetransaction)
                            savings_made.append(memberacct)
                            transactions_added.append(savetransaction.id)
                            # print("approved on %s" % datetime.strptime(str(approvedon), '%Y-%m-%d'))

                    except Exception as lex:
                        if str(lex) != 'list index out of range':
                            savings_failed.append({
                                'reason': 'Account does not exist',
                                'account number': memberacct,
                                'actual_err': f'{str(lex)}'
                            })
            
            SavingUpload.objects.create(
                narration=narration,
                total_records_added=len(savings_made),
                total_records_failed=len(savings_failed),
                transactions_created=json.dumps({
                    'transactions_created': transactions_added,
                }),
                branch_id=branchdata(request),
                file=upload_file,
                failed_savings=json.dumps({
                    'failed_saving': savings_failed
                })
            )
            if len(savings_failed) > 0:
                messages.success(request, 'info', extra_tags=f'Some savings have been uploaded successfully, {str(len(savings_made))} were successful and {str(len(savings_failed))} failed. Please check savings uploads for details')
            else:
                messages.success(request, 'success', extra_tags='Savings uploaded successfully')

        # =================================EDITING LOAN TYPE===================================

        return HttpResponseRedirect(request.META.get("HTTP_REFERER"))


def updateloansTransactions(self, request, loanid):
    nowdate = today.strftime("%Y-%m-%d")

    pk = loanid

    detail = Loans.objects.filter(id=pk)[0]
    approved = detail.amount_approved
    try:
        tcharges = Transactions.objects.filter(loan_id=loanid, transaction_type='Loan Charges')[0]

        totalcharges = tcharges.reporting_amount

    except Exception as ex:
        print('ERR', str(ex))

        totalcharges = 0

    disbursed = approved - totalcharges
    givenout = Transactions.objects.filter(loan_id=loanid, transaction_type='give loan')[0]
    givenout.reporting_amount = disbursed
    givenout.save()


class UploadWithdraws(PermView):
    template_name = 'sacco/upload_withdraws.html'

    def get(self, request, *args, **kwargs):
        title = 'WITHDRAWS UPLOADS'

        allloans = Loans.objects.filter(loan_status=3, branch_id=branchdata(request))
        for loan in allloans:
            loanid = loan.id
            # updateloans(self, request, loanid)
            # updateloansTransactions(self, request, loanid)
        bankaccounts = Account.objects.filter(Q(business=businessdata(request)),
                                              (Q(category__name='Bank') | Q(category__name='Mobile Money') | Q(
                                                  category__name='Cash') | Q(category__name='Reserves')))

        return render(request, self.template_name, locals())

class UploadWithdrawsV2(PermView):
    def post(self, request, *args, **kwargs):
        values_submitted = get_withdraw_upload_submitted_values(request)

        try:
            data = pd.read_excel(values_submitted['upload_file'])
            data = data.to_dict('records')
            # check if field are there
            if len(data) > 0:
                fields_missing = check_withdraw_upload_fields_xlsx(trim_lower_case_dictionary_keys(data[0]),
                                                               values_submitted['apply_charges_from'])
                if len(fields_missing) > 0:
                    messages.error(request, 'error',
                                   extra_tags='Some required fields are missing. Please refer to sample template')
                    return HttpResponseRedirect(reverse_lazy('member_ind_w_accounts'))

                withdraws_made = []
                withdraws_failed = []
                business_data = businessdata(request)
                business_data = Business.objects.get(id=business_data)
                branch_data = branchdata(request)
                branch_data = Branch.objects.get(id=branch_data)
                user_data = userdata(request)
                transactions_added = []


                for withdraw in data:
                    withdraw = trim_lower_case_dictionary_keys(withdraw)
                    # print(withdraw)
                    try:
                        acc_bal = get_member_balance(withdraw['account number'].strip(), business_data)
                        if acc_bal == 'failed':
                            withdraws_failed.append({
                                'reason': 'Account does not exist',
                                'account number': withdraw['account number']
                            })
                        else:
                            # print('ACCOUNT BALANCE', acc_bal)
                            if acc_bal >= float(withdraw['amount'].replace(',','')):
                                with transaction.atomic():
                                    withdraw_transactions=handle_single_withdraw(withdraw['account number'].strip(), business_data, branch_data, user_data, values_submitted['credit_acc'] , withdraw, values_submitted)
                                    withdraws_made.append(withdraw['account number'])
                                    transactions_added = transactions_added + withdraw_transactions
                            else:
                                withdraws_failed.append({
                                    'reason': 'Insufficient balance',
                                    'account number': withdraw['account number']
                                })

                    except Exception as e:
                        print('ERROR', e)
                        traceback.print_exc(file=sys.stdout)
                        withdraws_failed.append({
                            'reason': 'account number doesnot exist or there is an issue with the account number',
                            'account number': withdraw['account number']
                        })


                WithdrawUpload.objects.create(
                    narration=values_submitted['narration'],
                    total_records_added=len(withdraws_made),
                    total_records_failed=len(withdraws_failed),
                    transactions_created=json.dumps({
                        'transactions_created': transactions_added,
                    }),
                    branch_id=branch_data,
                    file=values_submitted['upload_file'],
                    failed_withdraws=json.dumps({
                        'failed_withdraw': withdraws_failed
                    })
                )

                if len(withdraws_made) == 0 and len(withdraws_failed) > 0:
                    messages.warning(request, 'Warning',
                                     extra_tags=f'{len(withdraws_made)} withdraws made successfully and {len(withdraws_failed)} withdraws failed to be added')
                else:
                    messages.success(request, 'success',
                                     extra_tags=f'{len(withdraws_made)} withdraws made successfully and {len(withdraws_failed)} withdraws failed to be added')
                return HttpResponseRedirect(reverse_lazy('member_ind_w_accounts'))
            else:
                # there is no data -- ADD MESSAGE
                messages.error(request, 'error', extra_tags='Excel file is empty')
                return HttpResponseRedirect(reverse_lazy('member_ind_w_accounts'))

        except Exception as e:
            print('ERROR', e)
            # traceback.print_exc(file=sys.stdout)
            messages.error(request, 'error', extra_tags='Excel upload failed please try again later')
            return HttpResponseRedirect(reverse_lazy('member_ind_w_accounts'))
        return HttpResponseRedirect(request.META.get("HTTP_REFERER"))

class WithdrawUploadsView(PermView):
    template_name = 'sacco/withdraw_uploads.html'

    def get(self, request, *args, **kwargs):
        title = 'WITHDRAW UPLOADS'
        branch_data = branchdata(request)
        branch_data = Branch.objects.get(id=branch_data)
        all_uploads = WithdrawUpload.objects.filter(branch=branch_data)
        http = 'http://'
        if request.is_secure():
            http = 'https://'

        baseUrl = request.headers['HOST']
        baseUrl = http + baseUrl

        return render(request, self.template_name, locals())

class SavingsUploadsView(PermView):
    template_name = 'sacco/savingsupload.html'

    def get(self, request, *args, **kwargs):
        title = 'SAVINGS UPLOADS'
        branch_data = branchdata(request)
        branch_data = Branch.objects.get(id=branch_data)
        all_uploads = SavingUpload.objects.filter(branch=branch_data)
        http = 'http://'
        if request.is_secure():
            http = 'https://'

        baseUrl = request.headers['HOST']
        baseUrl = http + baseUrl

        return render(request, self.template_name, locals())

class ReverseSavingsUploadView(PermView):
    def post(self, request, pk, *args, **kwargs):
        upload = SavingUpload.objects.filter(id=pk)
        if upload.exists():
            upload_obj = upload.first()
            transactions_created = json.loads(upload_obj.transactions_created)['transactions_created']
            # print('TRANSACTIONS CREATED', transactions_created)
            Transactions.objects.filter(id__in = transactions_created).delete()
            upload.delete()
        else:
            messages.success(request, 'error', extra_tags='Savings upload nolonger exists')
        messages.success(request, 'success', extra_tags='Savings successfully reversed')
        return HttpResponseRedirect(reverse_lazy('savings_uploads'))


class ReverseWithdrawUploadView(PermView):
    def post(self, request, pk, *args, **kwargs):
        upload = WithdrawUpload.objects.filter(id=pk)
        if upload.exists():
            upload_obj = upload.first()
            transactions_created = json.loads(upload_obj.transactions_created)['transactions_created']
            print('TRANSACTIONS CREATED', transactions_created)
            for trans in transactions_created:
                print('trans', trans)
                old_transaction = Transactions.objects.filter(id=trans)
                if old_transaction.exists():
                    old_transaction = old_transaction.first()
                    print('OLD TRANS', old_transaction.id)
                    # create a reverse of the transaction
                    new_trans=Transactions.objects.create(
                        reporting_amount=old_transaction.reporting_amount,
                        narration=f"Reverse transaction for transaction:{old_transaction.txno}",
                        account_dr=old_transaction.account_cr,
                        account_cr=old_transaction.account_dr,
                        tx_date=datetime.datetime.today().date(),
                        transaction_type='Reverse transaction',
                        branch=old_transaction.branch
                    )
                    print('NEW TRANS', new_trans.id)
                    business_data = Business.objects.get(id=businessdata(request))
                    member_balance = get_member_balance(old_transaction.account_dr.member.acc_number, business_data)
                    acc_broker = AccountBroker.objects.filter(business=business_data,the_account__acc_number=old_transaction.account_dr.member.acc_number )

                    if acc_broker.exists():
                        mem_acc = acc_broker.first().the_account
                        current_balance = mem_acc.balance
                        new_balance = current_balance + old_transaction.reporting_amount
                        MemberAccount.objects.filter(id=mem_acc.id).update(
                            balance= new_balance
                        )
            upload.delete()
        messages.success(request, 'success', extra_tags='Withdraws successfully reversed')
        return HttpResponseRedirect(reverse_lazy('withdraw_uploads'))


class UploadTransactions(PermView):
    template_name = 'sacco/upload_transactions.html'

    def get(self, request, *args, **kwargs):
        title = 'TRANSACTIONS UPLOADS'
        bankaccounts = Account.objects.filter(business=businessdata(request), member_id__isnull=True)
        # bankaccounts = Account.objects.filter(Q(business=businessdata(request)),
        #                                       (Q(category__name='Bank') | Q(category__name='Mobile Money') | Q(
        #                                           category__name='Cash') | Q(category__name='Reserves')))
        # uplaods = UploadLoans.objects.filter(branch_id=branchdata(request))

        return render(request, self.template_name, locals())

    # ====WHEN THE POST IS MADE==========================

    def post(self, request, *args, **kwargs):
        formtype = request.POST['form_type']
        if formtype == 'upload':
            upload_file = request.FILES['proof']
            udatea = request.POST['udate']
            udate = datetime.datetime.strptime(udatea, '%Y-%m-%d')
            debited = request.POST['debited']
            credited = request.POST['credited']

            data = upload_file.read().decode('utf-8')
            n = 0

            # you can use the re library --> import re
            rows = re.split('\n', data)  # splits along new line

            nloans = 0
            # === RECORD THE UPLOAD=========================

            for index, row in enumerate(rows):
                n = n + 1

                cells = row.split(',')

                if n > 1:

                    try:
                        narration = cells[1]
                        approvedon = cells[0]
                        amount = cells[2]
                        approvedon = pd.to_datetime(approvedon, infer_datetime_format=True)
                        approvedon = approvedon.strftime('%Y-%m-%d')
                        amount = float(amount.replace(',', ''))
                        savetransaction = Transactions.objects.create(reporting_amount=amount,
                                                                      narration=narration,
                                                                      account_cr_id=credited,
                                                                      account_dr_id=debited,
                                                                      tx_date=approvedon,
                                                                      transaction_type='Transfer',
                                                                      branch_id=branchdata(request))
                    except Exception as lex:
                        print(str(lex))
                        # traceback.print_exc()
                        # print('THIS AT FFFFF %s' % str(lex))
            messages.success(request, 'success', extra_tags='Withdraws uploaded successfully')
            message = f"{request.user.staff.biodata.name} uploaded withdraws"
            ActivityLog.objects.create(actor=request.user,
                                       action_type=UPLOAD,
                                       title='withdraws upload',
                                       branch=branch_id(request.user),
                                       remarks=message)

        return HttpResponseRedirect(request.META.get("HTTP_REFERER"))


class UploadShares(PermView):
    template_name = 'sacco/upload_shares.html'

    def get(self, request, *args, **kwargs):
        business_context = get_business_loans_context_data(request)
        if business_context['branch'] is None:
            messages.error(
                request, "error",
                extra_tags="Action not allowed in the central view. Please logout and login into the respective branch"
            )
            return HttpResponseRedirect(request.META.get("HTTP_REFERER"))
        title = 'UPLOAD SHARES'
        bankaccounts = Account.objects.filter(Q(business=business_context['branch'].business),
                                              (Q(category__name='Bank') | Q(category__name='Mobile Money') | Q(
                                                  category__name='Cash') | Q(category__name='Reserves')))

        return render(request, self.template_name, locals())

    # ====WHEN THE POST IS MADE==========================

    def post(self, request, *args, **kwargs):
        business_context = get_business_loans_context_data(request)
        formtype = request.POST['form_type']
        if formtype == 'upload':
            upload_file = request.FILES['proof']
            udatea = request.POST['udate']
            udate = datetime.datetime.strptime(udatea, '%Y-%m-%d')
            debitedd = request.POST['debited']
            business_setting = OtherSettings.objects.filter(business=business_context['branch'].business).first()
            share_price = business_setting.share_price
            narration = request.POST['narration']
            data = upload_file.read().decode('utf-8')
            n = 0
            rows = re.split('\n', data)  # splits along new line

            record = 0
            # === RECORD THE UPLOAD=========================

            for index, row in enumerate(rows):
                n = n + 1

                cells = row.split(',')

                if n > 1:
                    try:
                        record = record + 1
                        member_acct = cells[0]
                        trans_date = cells[1]
                        trans_date = pd.to_datetime(trans_date, infer_datetime_format=True)
                        trans_date = trans_date.strftime('%Y-%m-%d')
                        amount = cells[2]
                        reference = cells[3]
                        amount = float(amount.replace(',', ''))

                        no_of_shares = floor(amount / share_price)

                        get_member_id = AccountBroker.objects.filter(the_account__acc_number=member_acct,
                                                                     business=business_context['branch'].business)[0]

                        member_ledger = Account.objects.filter(member_id=get_member_id.the_account_id)[0]

                        if debitedd == 'm':
                            debited = member_ledger.id
                        else:
                            debited = debitedd

                        share_cap = Account.objects.filter(name='Share Capital', business=business_context['branch'].business)[0]

                        save_shares = SharesTransactions.objects.create(
                            buyer_id=get_member_id.members_id,
                            shares=no_of_shares,
                            date=trans_date,
                            narration=f'Sale of {no_of_shares} by the SACCO',
                            branch_id=business_context['branch']
                        )

                        # ==========================GET TRANSACTION CHARGES===========================
                        Transactions.objects.create(reporting_amount=amount,
                                                    narration=narration,
                                                    receipt=reference,
                                                    account_cr_id=share_cap.id,
                                                    account_dr_id=debited,
                                                    tx_date=trans_date,
                                                    transaction_type='Sell of shares',
                                                    shares_id=save_shares.id,
                                                    branch_id=business_context['branch'])

                    except Exception as lex:
                        # print(str(lex))
                        traceback.print_exc()
                        # print('THIS AT FFFFF %s' % str(lex))
            messages.success(request, 'success', extra_tags='Shares uploaded successfully')
            message = f"{request.user.staff.biodata.name} uploaded shares"
            ActivityLog.objects.create(actor=request.user,
                                       action_type=UPLOAD,
                                       title='Shares upload',
                                       branch=business_context['branch'].id,
                                       remarks=message)

        # =================================EDITING LOAN TYPE===================================
        return HttpResponseRedirect(request.META.get("HTTP_REFERER"))


class UploadSharesSales(PermView):
    template_name = 'sacco/upload_shares_sales.html'

    def get(self, request, *args, **kwargs):
        title = 'SACCO BOUGHT SHARES FROM MEMBERS'
        return render(request, self.template_name, locals())

    def post(self, request, *args, **kwargs):
        formtype = request.POST['form_type']
        if formtype == 'upload':
            upload_file = request.FILES['proof']
            upload_date = request.POST['upload_date']
            upload_date = datetime.datetime.strptime(upload_date, '%Y-%m-%d')
            business_setting = OtherSettings.objects.filter(business=businessdata(request)).first()
            share_price = business_setting.share_price
            narration = request.POST['narration']
            data = upload_file.read().decode('utf-8')
            n = 0
            rows = re.split('\n', data)  # splits along new line
            record = 0
            # === RECORD THE UPLOAD=========================
            for index, row in enumerate(rows):
                n = n + 1
                cells = row.split(',')
                if n > 1:
                    try:
                        record = record + 1
                        member_acct = cells[0]
                        trans_date = cells[1]
                        trans_date = pd.to_datetime(trans_date, infer_datetime_format=True)
                        trans_date = trans_date.strftime('%Y-%m-%d')
                        amount = cells[2]
                        reference = cells[3]
                        amount = float(amount.replace(',', ''))

                        no_of_shares = floor(amount / share_price)

                        member_id = AccountBroker.objects.filter(the_account__acc_number=member_acct, business_id=businessdata(request)).first()

                        member_ledger = Account.objects.filter(member_id=member_id.the_account_id).first()

                        share_cap = Account.objects.filter(name='Share Capital', business=businessdata(request)).first()

                        save_shares = SharesTransactions.objects.create(
                            seller_id=member_id.members_id,
                            shares=no_of_shares,
                            date=trans_date,
                            narration=f'Sold shares ({no_of_shares}) back to the sacco',
                            branch_id=branchdata(request)
                        )

                        # ==========================GET TRANSACTION ===========================
                        Transactions.objects.create(reporting_amount=amount,
                                                    narration=narration,
                                                    receipt=reference,
                                                    account_cr_id=member_ledger.id,
                                                    account_dr_id=share_cap.id,
                                                    tx_date=trans_date,
                                                    transaction_type='Shares transfer',
                                                    shares_id=save_shares.id,
                                                    branch_id=branchdata(request))

                    except Exception as lex:
                        print(str(lex))
                        traceback.print_exc()
                        print('THIS AT FFFFF %s' % str(lex))
            messages.success(request, 'success', extra_tags='Shares uploaded successfully')
            message = f"{request.user.staff.biodata.name} uploaded shares"
            ActivityLog.objects.create(actor=request.user,
                                       action_type=UPLOAD,
                                       title='Shares upload',
                                       branch=branch_id(request.user),
                                       remarks=message)

        # =================================EDITING LOAN TYPE===================================
        return HttpResponseRedirect(request.META.get("HTTP_REFERER"))


# ========LOAN AMORTISATION FUNCTION=========================================

def repayloan(self, request, pk, amount, debited, approvedon, refeence, narration, interetacct, *args, **kwargs):
    print('ENTERERD THE repay loan')
    title = 'Loan Details '
    loanid = pk
    loansid = int(loanid)
    nowdate = today.strftime("%Y-%m-%d")
    this_business = Business.objects.filter(id=businessdata(request)).first()

    detail = Loans.objects.filter(id=loanid)[0]

    laonacct = Account.objects.filter(name='Loan Receivables', business=businessdata(request))[0]

    formula = detail.loan_type.formula
    approved_amount = detail.amount_approved

    memberledger = Account.objects.filter(member_id=detail.account_id)[0]

    if debited == 'm':
        debited = memberledger.id
    else:
        debited = debited

    try:
        paid = Transactions.objects.raw(
            "SELECT SUM(reporting_amount) as tpaid,id from transactions where (transaction_type='Loan repayment' OR transaction_type='Loan interest') AND loan_id= %s " % (
                loanid))[0]
        paidamount = paid.tpaid

    except:
        paidamount = 0

    #    ========================CLEARED INTERESTS============================================

    interestspaid = Transactions.objects.filter(loan_id=loanid, transaction_type='Loan interest',
                                                branch__business_id=businessdata(request))
    intpaid = interestspaid.count()

    # ===========================================================================================

    # ==================GET INTEREST IN RELATION TO SETTINGS=====================
    if detail.interval is not None:
        typeinterval = detail.interval

    else:
        typeinterval = detail.loan_type.interval
        detail.interval = typeinterval
        detail.save()

    interest = (detail.rate / 100) / 12

    if detail.loan_status > 2:
        repayments = Transactions.objects.raw(
            "SELECT sum(reporting_amount) as paidamount, id, receipt FROM transactions where loan_id= %s and (transaction_type='Loan repayment' or transaction_type='Loan interest' ) GROUP BY receipt" % (
                loanid))

    if detail.loan_status == 3:
        maccount = detail.account_id

        # ===================CHECK IF THE LOAN HAS A TOPUP APPLICATION ALREADY=========================
        sometopup = 0
        try:
            paidamount = round(paidamount, 2)
        except:
            paidamount = 0
        totalcharges = 0
        if int(detail.loan_status) > 1:
            actualchargesx = detail.charges
            try:
                actualcharges = json.loads(actualchargesx)
                for chg in actualcharges:
                    chargeamount = chg['amount']
                    totalcharges = totalcharges + chargeamount
            except:
                totalcharges = 0

        duration = detail.approved_duration
        appdate = detail.schedule_start
        principal = detail.amount_approved

        if detail.charges_paid == True:
            principal = float(principal)
            approved_amount = float(approved_amount) + float(totalcharges)
        else:
            principal = principal + float(totalcharges)
            approved_amount = float(approved_amount)

        if formula == 5:
            interest = (detail.rate / 100)

        if formula == 1:
            if typeinterval == 3:
                interest = (detail.rate / 100) / 12

            if typeinterval == 0:
                interest = (detail.rate / 100) / 365

            if typeinterval == 1:
                interest = (detail.rate / 100) / 52

            if typeinterval == 2:
                interest = (detail.rate / 100) / 26

            if typeinterval == 4:
                interest = (detail.rate / 100)

        if formula == 2:
            if typeinterval == 3:
                interest = (detail.rate / 100)

            if typeinterval == 0:
                interest = (detail.rate / 100) / 30

            if typeinterval == 1:
                interest = (detail.rate / 100) / 4

            if typeinterval == 2:
                interest = (detail.rate / 100) / 2

            if typeinterval == 4:
                interest = (detail.rate / 100) * 12

        if formula == 3:
            if typeinterval == 3:
                interest = (detail.rate / 100) * 4

            if typeinterval == 0:
                interest = (detail.rate / 100) * 7

            if typeinterval == 1:
                interest = (detail.rate / 100)

            if typeinterval == 2:
                interest = (detail.rate / 100) * 2

            if typeinterval == 4:
                interest = (detail.rate / 100) * 52

        if formula == 4:
            if typeinterval == 3:
                interest = (detail.rate / 100) * 30

            if typeinterval == 0:
                interest = (detail.rate / 100)

            if typeinterval == 1:
                interest = (detail.rate / 100) * 7

            if typeinterval == 2:
                interest = (detail.rate / 100) * 14

            if typeinterval == 4:
                interest = (detail.rate / 100) * 256

        # ===================GET LOAN REPAYMENTS========================================

        # =====================IF INTERVAL IS MONTHLY =========================
        if typeinterval == 3:
            to_add = relativedelta(months=1)
            all_duration = relativedelta(months=duration)

        # =====================IF INTERVAL IS DAILY =========================

        if typeinterval == 0:
            to_add = relativedelta(days=1)
            all_duration = relativedelta(days=duration)

        # =====================IF INTERVAL IS WEEKLY =========================

        if typeinterval == 1:
            to_add = relativedelta(weeks=1)
            all_duration = relativedelta(weeks=duration)

        # =====================IF INTERVAL IS BI-WEEKLY =========================

        if typeinterval == 2:
            to_add = relativedelta(weeks=2)
            all_duration = relativedelta(weeks=duration * 2)

        # =====================IF INTERVAL IS YEARLY =========================

        if typeinterval == 4:
            to_add = relativedelta(years=1)
            all_duration = relativedelta(years=duration)

        # ================================DETERMINING THE FINES AND ON WHICH SCHEDULES==========================
        nowdate = datetime.datetime.today().date()

        # get loan fines

        loanfines = ApplicationAccountOrLoanType.objects.filter(
            loan_type_id=detail.loan_type.id, general_charge__application='o', general_charge__is_fine=True)

        # loanfines=[]

        sfine = 0
        fine = 0
        # =======================IF RATE TYPE IS FLAT============================
        cumrative_payments = 0

        # =============================================IF THE RATE TYPE IS REDUCING=====================================
        if detail.rate_type == 2:
            in_date = ''
            loan_dict = {}
            data = []
            days = []

            edate = appdate + to_add
            # print(appdate)
            date1 = edate
            principals = 0
            date2 = date1 + all_duration
            runningbal = detail.amount_approved

            # interestperschedue = schedules * interest / 100;
            if interest > 0:
                numilator = principal * interest * (
                        (pow((1 + interest), duration)) / (pow((1 + interest), duration) - 1))

            else:
                numilator = principal / duration

            payable = numilator
            totalpayable = payable * duration

            totalpayable = totalpayable

            rprincipal = 0
            rbalance = principal
            # ========================================GET PAID SCHEDULES=========================

            paidschedules = paidamount / payable
            paidschedules = floor(paidschedules)

            nextschedule = paidschedules + 1
            # ====================================Balance for the next schedule=======================
            nextbal = paidamount - (payable * paidschedules)
            nextintallment = payable - nextbal

            m = 1
            isnext = 0
            sfine = 0
            sch_date = date1

            pbalance = principal
            sch_date = date1
            generalbalance = totalpayable - paidamount
            balance_after_paying = generalbalance - amount

            generalbalance = round(generalbalance, 2)
            detail.balance = balance_after_paying
            if balance_after_paying < 1:
                detail.loan_status = 4
            detail.save()
            while date1 < date2:
                sfine = 0
                sfines = 0
                days.append(date1.strftime("%Y-%m-%d"))
                interestperschedue = rbalance * interest
                interestperschedue = round(interestperschedue, 2)
                if intpaid == m or intpaid > m:
                    actualinterest = 0
                else:
                    actualinterest = interestperschedue
                try:
                    rbalance = principal * ((pow((1 + interest), duration) - pow((1 + interest), m)) / (
                            pow((1 + interest), duration) - 1))
                except:
                    rbalance = principal - paidamount

                rprincipal = payable - interestperschedue
                rprincipal = round(rprincipal, 2)

                rbalance = round(rbalance, 2)

                pbalance = pbalance - rprincipal

                if m == nextschedule:
                    isnext = 1
                    spaid = round(nextbal, 2)
                    sbalance = round(nextintallment, 2)

                    if amount > actualinterest:
                        principalamount = amount - actualinterest
                    else:
                        principalamount = amount
                        actualinterest = 0

                    if principalamount > (pbalance + rprincipal):
                        actualprincipal = pbalance + rprincipal
                        principaldifference = principalamount - actualprincipal
                        actualinterest = actualinterest + principaldifference
                        principalamount = actualprincipal
                    print('Before credited')
                    credited = Account.objects.filter(name='Loan Receivables', business=businessdata(request)).first()
                    print('After credited')

                    checkrecievables = Account.objects.filter(name='Loan Receivables',
                                                              business=businessdata(request)).exists()
                    checkinterest = Account.objects.filter(name='Loan interests',
                                                           business=businessdata(request)).exists()
                    if checkinterest:
                        pass
                    else:
                        rcategeory2 = AccountCategory.objects.filter(name='Loan incomes',
                                                                     business=businessdata(request)).first()
                        createleger2 = Account.objects.create(name='Loan interests',
                                                              business=businessdata(requests),
                                                              category_id=rcategeory2.id,
                                                              added_by_id=userdata(request))

                    if checkrecievables:
                        pass
                    else:
                        rcategeory = AccountCategory.objects.filter(name='Account Receivables',
                                                                    business=businessdata(request)).first()

                        Account.objects.create(name='Loan Receivables',
                                               business=businessdata(request),
                                               category_id=rcategeory.id,
                                               added_by_id=userdata(request))
                        print('After userdata')

                    trans = Transactions.objects.create(reporting_amount=principalamount,
                                                        narration=narration,
                                                        account_dr_id=debited,
                                                        account_cr_id=credited.id,
                                                        loan_id=loanid,
                                                        tx_date=approvedon,
                                                        receipt=refeence,
                                                        transaction_type='Loan repayment',
                                                        added_by_id=userdata(request),
                                                        branch_id=branchdata(request))
                    print('TRANSACTION 1', trans)

                    # =========================RECORD INTEREST======================================
                    if float(actualinterest) > 0:
                        Transactions.objects.create(reporting_amount=actualinterest,
                                                    narration=narration,
                                                    account_dr_id=debited,
                                                    account_cr_id=interetacct,
                                                    loan_id=loanid,
                                                    tx_date=approvedon,
                                                    receipt=refeence,
                                                    transaction_type='Loan interest',
                                                    added_by_id=userdata(
                                                        request),
                                                    branch_id=branchdata(request))
                        print('TRANSACTION 2')

                elif m < nextschedule:
                    isnext = 0
                    spaid = round(payable, 2)
                    sbalance = 0

                else:
                    isnext = 2
                    spaid = 0
                    sbalance = round(payable, 2)

                m = m + 1
                sfine = 0

                # date1 = date1 + to_add
                date1 = sch_date + m * to_add

                # //principal = rprincipal

            nowdate = datetime.datetime.today()
            print('Walahi Ndi wano neera wawo2')

            totalinterest = totalpayable - detail.amount_approved
            totalpayable = approved_amount + totalinterest

            messages.success(request, 'success', extra_tags='Loan payment recorded successfully')


class UploadRepyments(PermView):
    template_name = 'sacco/upload_loanrepayments.html'

    def get(self, request, *args, **kwargs):
        title = 'UPLOAD Repayments'
        bankaccounts = Account.objects.filter(Q(business=businessdata(request)),
                                              (Q(category__name='Bank') | Q(category__name='Mobile Money') | Q(
                                                  category__name='Cash') | Q(
                                                  category__name='Shares') |
                                               Q(category__name='Account Receivables') |
                                               Q(category__name='Reserves')))
        # uplaods = UploadLoans.objects.filter(branch_id=branchdata(request))

        return render(request, self.template_name, locals())

    # ====WHEN THE POST IS MADE==========================

    def post(self, request, *args, **kwargs):
        formtype = request.POST['form_type']
        if formtype == 'upload':
            debited = request.POST['debited']
            credited = Account.objects.filter(name='Loan Receivables', business=businessdata(request)).first()
            upload_file = request.FILES['proof']
            udatea = request.POST['udate']
            udate = datetime.datetime.strptime(udatea, '%Y-%m-%d')
            narration = request.POST['narration']
            data = upload_file.read().decode('utf-8')
            n = 0
            rows = re.split('\n', data)  # splits along new line

            checkrecievables = Account.objects.filter(name='Loan interest receivables',
                                                      business=businessdata(request)).exists()
            if checkrecievables:
                pass
            else:
                rcategeory = AccountCategory.objects.filter(name='Account Receivables', business=businessdata(request))[
                    0]
                createleger = Account.objects.create(name='Loan interest receivables',
                                                     business_id=businessdata(request),
                                                     category_id=rcategeory.id,
                                                     added_by_id=userdata(request))

            laonacct = Account.objects.filter(name='Loan interest receivables', business=businessdata(request))[0]

            nloans = 0
            # === RECORD THE UPLOAD=========================
            amount = 0
            refeence = 0
            for index, row in enumerate(rows):
                n = n + 1

                cells = row.split(',')

                if n > 1:

                    try:
                        nloans = nloans + 1
                        memberacct = cells[0]
                        approvedon = cells[1]
                        try:
                            issuedate = cells[5]

                        except:
                            pass
                        approvedon = pd.to_datetime(approvedon, infer_datetime_format=True)
                        approvedon = approvedon.strftime('%Y-%m-%d')
                        try:

                            issuedate = pd.to_datetime(issuedate, infer_datetime_format=True)
                            issuedate = issuedate.strftime('%Y-%m-%d')

                        except:
                            pass

                        amount = cells[2]
                        refeence = cells[3]
                        try:
                            loanamount = cells[4]
                            loanamount = float(loanamount.replace(',', ''))
                        except:
                            pass

                        amount = float(amount.replace(',', ''))

                        getmemberid = AccountBroker.objects.filter(the_account__acc_number=memberacct,
                                                                   business_id=businessdata(request))[0]
                        try:
                            getmemberloan = Loans.objects.filter(account_id=getmemberid.the_account_id, loan_status=3,
                                                                 approved_on=issuedate, amount_approved=loanamount)[0]
                        except:
                            getmemberloan = Loans.objects.filter(Q(account_id=getmemberid.the_account_id),
                                                                 Q(loan_status=3)).order_by('schedule_start').first()
                        pk = getmemberloan.id
                        # print('Walahi we reach here')
                        repayloan(self, request, pk, amount, debited, approvedon, refeence, narration, laonacct.id,
                                  *args, **kwargs)
                    except Exception as lex:
                        print(str(lex))
                        # traceback.print_exc()
                        print('NOT ADDED ARE ', memberacct, 'Amount ', amount, ' Ref-number ', refeence, 'date ',
                              approvedon)
        messages.success(request, 'success', extra_tags='Repayments uploaded successfully')
        # message = f"{request.user.staff.biodata.name} uploaded Repayments"
        # ActivityLog.objects.create(actor=request.user,
        #                            action_type=UPLOAD,
        #                            title='Loan Repayment upload',
        #                            branch=branch_id(request.user),
        #                            remarks=message)

        # =================================EDITING LOAN TYPE===================================

        return HttpResponseRedirect(request.META.get("HTTP_REFERER"))


class UploadRepaymentsVersion2(PermView):
    def post(self, request, *args, **kwargs):
        business_context = get_business_loans_context_data(request)
        if business_context['branch'] is None:
            messages.error(
                request, "error",
                extra_tags="Action not allowed in the central view. Please logout and login into the respective branch"
            )
            return HttpResponseRedirect(request.META.get("HTTP_REFERER"))
        values_submitted = get_loan_repayment_upload_submitted_values(request)

        data = pd.read_excel(values_submitted['upload_file'])
        # print(data)
        # data = data['Date'].apply(format_date_pd)
        the_columns = data.columns.tolist()
        fields_missing = check_loan_repayment_fields_xlsx(trim_lower_case_list_keys(the_columns))
        if len(fields_missing) > 0:
            messages.error(request, 'error',
                           extra_tags='Some required fields are missing. Please refer to sample template')
            return HttpResponseRedirect(reverse_lazy('upload_repayments'))
        the_date_field = get_date_key(the_columns)
        data[the_date_field] = data[the_date_field].apply(format_date_pd)

        data = data.to_dict('records')
        # print(data)
        # check if field are there
        if len(data) > 0:
            fields_missing = check_loan_repayment_fields_xlsx(trim_lower_case_dictionary_keys(data[0]))
            if len(fields_missing) > 0:
                messages.error(request, 'error',
                               extra_tags='Some required fields are missing. Please refer to sample template')
                return HttpResponseRedirect(reverse_lazy('upload_repayments'))

            loans_added = []
            loans_failed = []
            transactions_added=[]
            loans_closed = []
            business_data = business_context['branch'].business.id
            branch_data = business_context['branch'].id
            # user_data = userdata(request)

            count = 1
            for excel_loan in data:
                receipt = f'{datetime.datetime.now().strftime("%y%m%d%H%M%S")}{str(count)}'
                count +=1
                excel_loan = trim_lower_case_dictionary_keys(excel_loan)
                the_loan = Loans.objects.filter(loan_number = excel_loan['loan number'].strip())

                if the_loan.exists():
                    if the_loan.count() == 1:
                        the_loan = the_loan.first()
                        payment_info = determine_amount_paid_principal_and_interest(business_data, the_loan, excel_loan)
                        if values_submitted['debit_acc'] == 'member_acc':
                            debitted_acc = Account.objects.filter(member= the_loan.account).first()
                        else:
                            debitted_acc = Account.objects.filter(id=values_submitted['debit_acc']).first()
                        # #do all the transactions
                        # timestamp = Timestamp(excel_loan['date'])
                        # formatted_string = timestamp.strftime('%Y-%m-%d')
                        # excel_date = datetime.datetime.strptime(formatted_string, '%Y-%m-%d').date()

                        excel_date = excel_loan['date']

                        with transaction.atomic():
                            try:
                                if payment_info['principal_trans_amt'] > 0:
                                    trans_principal = Transactions.objects.create(
                                        account_cr=get_receivable_acc_and_loan_interest_receivables_acc(business_data)['receivable_acc'],
                                        account_dr=debitted_acc,
                                        reporting_amount=round(payment_info['principal_trans_amt'], 2),
                                        branch_id=branch_data,
                                        loan=the_loan,
                                        transaction_type='Loan repayment',
                                        tx_date= excel_date,
                                        receipt=receipt,
                                        reference=excel_loan['reference'],
                                        narration=values_submitted['narration']
                                    )
                                    transactions_added.append(trans_principal.id)
                                    # print('trans principal')

                                if payment_info['interest_trans_amt'] > 0:
                                    trans_interest = Transactions.objects.create(
                                        account_cr=get_receivable_acc_and_loan_interest_receivables_acc(business_data)['loan_interest_receivables_acc'],
                                        account_dr=debitted_acc,
                                        reporting_amount=round(payment_info['interest_trans_amt'], 2),
                                        branch_id=branch_data,
                                        loan=the_loan,
                                        transaction_type='Loan interest',
                                        tx_date=excel_date,
                                        receipt=receipt,
                                        reference=excel_loan['reference'],
                                        narration=values_submitted['narration']
                                    )
                                    #create also the expected interest transaction
                                    business_data = businessdata(request)
                                    ln_interest_rec_acc = Account.objects.filter(name='loan interest receivables',
                                                                                 business=business_data)
                                    if ln_interest_rec_acc:
                                        ln_interest_rec_acc = ln_interest_rec_acc.first()
                                    else:
                                        ln_interest_rec_acc = Account.objects.create(
                                            name='loan interest receivables', business=business_data,
                                            display_name='loan interest receivables',
                                            category=AccountCategory.objects.get(name='Account Receivables',
                                                                                 business=business_data),
                                        )

                                    ln_interest_revenue_acc = Account.objects.filter(name='Loan Interest',
                                                                                     business=businessdata(
                                                                                         request)).first()

                                    Exp_interest = Transactions.objects.create(reporting_amount=round(payment_info['interest_trans_amt'], 2),
                                                                               narration=f'Expected interest of {str(round(payment_info["interest_trans_amt"], 2))}',
                                                                               account_dr=ln_interest_rec_acc,
                                                                               account_cr=ln_interest_revenue_acc,
                                                                               loan=the_loan, tx_date=excel_date,
                                                                               transaction_type='Expected interest',
                                                                               added_by_id=userdata(request),
                                                                               branch_id=branchdata(request))
                                    # print('Exp_interest', Exp_interest)

                                    transactions_added.append(trans_interest.id)
                                    transactions_added.append(Exp_interest.id)
                                    # print('trans_interest', trans_interest)
                                if payment_info['excess_amt'] > 0:
                                    suspense_acc=get_or_create_excess_payment_acc(business_data)

                                    trans_excess_payment = Transactions.objects.create(
                                        account_cr=suspense_acc,
                                        account_dr=debitted_acc,
                                        reporting_amount=round(payment_info['excess_amt'], 2),
                                        branch_id=branch_data,
                                        loan=the_loan,
                                        transaction_type='Excess payment',
                                        narration=f'Excess payment received on the loan: {the_loan.loan_number}',
                                        tx_date=excel_date
                                    )
                                    transactions_added.append(trans_excess_payment.id)
                                    loans_closed.append(the_loan.id)

                                #if fines are there
                                # get fines acc
                                if excel_loan['fines'].strip() != 'nan':
                                    if float(excel_loan['fines'].strip().replace(',', '')) > 0:
                                        fines_acc = Account.objects.filter(name='Loan Fines', business=business_data)
                                        if fines_acc.exists():
                                            fines_acc=fines_acc.first()
                                        else:
                                            fines_acc = Account.objects.create(
                                                name='Loan Fines', business=business_data,
                                                display_name='Loan Fines',
                                                category=AccountCategory.objects.get(name='Loan incomes', business=business_data),
                                            )

                                        trans_fines = Transactions.objects.create(
                                            account_cr=fines_acc,
                                            account_dr=debitted_acc,
                                            reporting_amount=float(excel_loan['fines'].strip().replace(',', '')),
                                            branch_id=branch_data,
                                            loan=the_loan,
                                            transaction_type='Loan fines',
                                            tx_date=excel_date,
                                            receipt = receipt,
                                            reference=excel_loan['reference'],
                                            narration=values_submitted['narration']
                                        )
                                        transactions_added.append(trans_fines.id)
                                        # print('RECORED FINE', trans_fines)
                                loans_added.append(excel_loan['loan number'])
                            except Exception as e:
                                print('EXCEPTION', e)
                                loans_failed.append(
                                    {
                                        'reason': 'Please check if all fields are provided correctly or Contact system administrators',
                                        'loan number': excel_loan['loan number']
                                    }
                                )
                            #update the summary details
                            if the_loan.loan_status == 3:
                                update_loan_summary_details(the_loan)
                    else:
                        # print('NOT TRUE')
                        loans_failed.append(
                            {
                                'reason': 'Please check if all fields are provided correctly or Contact system administrators',
                                'loan number': excel_loan['loan number']
                            }
                        )
                else:
                    # print('LOAN DOESNOT EXISTS')
                    loans_failed.append(
                        {
                            'reason': 'loan doesnot exist',
                            'loan number': excel_loan['loan number']
                        }
                    )

            # print('failed loans', loans_failed )
            #record repayments record
            LoanRepaymentUpload.objects.create(
                narration=values_submitted['narration'],
                total_records_added = len(loans_added),
                total_records_failed = len(loans_failed),
                transactions_created = json.dumps({
                    'transactions_created': transactions_added,
                    'loans_closed': loans_closed
                }),
                branch_id = branch_data,
                file=values_submitted['upload_file'],
                failed_loans=json.dumps({
                    'failed_loans': loans_failed
                })
            )

            if len(loans_added) == 0 and len(loans_failed) > 0:
                messages.warning(request, 'Warning',
                                 extra_tags=f'{len(loans_added)} loans repayed successfully and {len(loans_failed)} loans failed to be repaid')
            else:
                messages.success(request, 'success',
                                 extra_tags=f'{len(loans_added)} loans repayed successfully and {len(loans_failed)} loans failed to be repaid')
            return HttpResponseRedirect(reverse_lazy('upload_repayments'))
        else:
            # there is no data -- ADD MESSAGE
            messages.error(request, 'error', extra_tags='Excel file is empty')
            return HttpResponseRedirect(reverse_lazy('upload_repayments'))





class UpdateRepayments(PermView):
    template_name = 'sacco/update_repayments.html'

    def get(self, request, *args, **kwargs):
        title = 'UPLOAD ADJUSTMENTS'
        bankaccounts = Account.objects.filter(Q(business=businessdata(request)),
                                              (Q(category__name='Bank') | Q(category__name='Mobile Money') | Q(
                                                  category__name='Cash') | Q(category__name='Reserves')))
        # uplaods = UploadLoans.objects.filter(branch_id=branchdata(request))

        return render(request, self.template_name, locals())

    # ====WHEN THE POST IS MADE==========================

    def post(self, request, *args, **kwargs):
        formtype = request.POST['form_type']
        if formtype == 'upload':

            debitedd = request.POST['debited']
            credited = Account.objects.filter(name='Loan Receivables', business=businessdata(request)).first()
            upload_file = request.FILES['proof']
            udatea = request.POST['udate']
            udate = datetime.datetime.strptime(udatea, '%Y-%m-%d')
            debited = request.POST['debited']

            narration = request.POST['narration']
            data = upload_file.read().decode('utf-8')
            n = 0
            rows = re.split('\n', data)  # splits along new line

            nloans = 0
            # === RECORD THE UPLOAD=========================
            amount = 0
            refeence = 0
            for index, row in enumerate(rows):
                n = n + 1

                cells = row.split(',')

                if n > 1:

                    try:
                        nloans = nloans + 1
                        memberacct = cells[0]
                        approvedon = cells[1]
                        pi = cells[6]
                        # approvedon = parse(cells[1]).date()
                        approvedon = pd.to_datetime(approvedon, infer_datetime_format=False)
                        approvedon = approvedon.strftime('%Y-%m-%d')

                        principal = cells[3]
                        interest = cells[4]

                        refeence = cells[2]

                        principal = float(principal.replace(',', ''))
                        interest = float(interest.replace(',', ''))

                        total = principal + interest

                        # =========================CHECK LOAN ID FROM THE LOAN DETAILS==========================

                        londetail = \
                            Transactions.objects.filter((Q(loan__account__acc_number=memberacct) | Q(receipt=refeence)),
                                                        Q(tx_date=approvedon))[0]
                        loanid = londetail.loan_id

                        lon = Loans.objects.filter(id=loanid)[0]

                        memberledger = Account.objects.filter(member_id=lon.account_id)[0]

                        if debitedd == 'm':
                            debited = memberledger.id

                            try:
                                transactions = Transactions.objects.filter(
                                    (Q(loan__account__acc_number=memberacct) | Q(receipt=refeence)),
                                    Q(account_dr=debited), Q(tx_date=approvedon)).aggregate(
                                    totalpaid=Sum('reporting_amount'))
                                totalpaid = transactions['totalpaid']

                            except Exception as ede:
                                print('EXEPTION IS ', str(ede))
                                totalpaid = 0

                            tt = 0
                        else:
                            debited = debitedd
                            tt = 1

                            transactions = Transactions.objects.filter(
                                (Q(loan__account__acc_number=memberacct) | Q(receipt=refeence)),
                                Q(account_dr=debited), Q(tx_date=approvedon)).aggregate(
                                totalpaid=Sum('reporting_amount'))

                            totalpaid = transactions['totalpaid']
                        credited = Account.objects.filter(name='Loan Receivables',
                                                          business=businessdata(request)).first()
                        laonacct = \
                            Account.objects.filter(name='Loan interest receivables', business=businessdata(request))[0]

                        # ==================DELETE OLD RECORDS TO INSERT NEW ONES=========================

                        if total == totalpaid or totalpaid == pi:

                            loand = Transactions.objects.filter(
                                (Q(loan__account__acc_number=memberacct) | Q(receipt=refeence)),
                                Q(account_dr=debited, tx_date=approvedon))

                            for ld in loand:
                                ld.delete()

                            if float(principal) > 0:
                                print(' PRINCIPAL IS GREATER THAN ZERO ')
                                trans = Transactions.objects.create(reporting_amount=principal,
                                                                    narration=narration,
                                                                    account_dr_id=debited,
                                                                    account_cr_id=credited.id,
                                                                    loan_id=loanid,
                                                                    tx_date=approvedon,
                                                                    receipt=refeence,
                                                                    transaction_type='Loan repayment',
                                                                    added_by_id=userdata(request),
                                                                    branch_id=branchdata(request))

                            # =========================RECORD INTEREST======================================

                            if float(interest) > 0:
                                print(' INTEREST IS GREATER THAN ZERO ')
                                Transactions.objects.create(reporting_amount=interest,
                                                            narration=narration,
                                                            account_dr_id=debited,
                                                            account_cr_id=laonacct.id,
                                                            loan_id=loanid,
                                                            tx_date=approvedon,
                                                            receipt=refeence,
                                                            transaction_type='Loan interest',
                                                            added_by_id=userdata(
                                                                request),
                                                            branch_id=branchdata(request))


                        else:
                            print('Total not equal to paid ', total, ' / ', totalpaid, ' refno: ', refeence,
                                  'MEMBER ACCOUNT ID', debited)

                    except Exception as lex:
                        print(str(lex))
                        traceback.print_exc()
                        print('NOT ADDED ARE ', memberacct, ' Ref-number ', refeence, 'date ',
                              approvedon)
        messages.success(request, 'success', extra_tags='Shares uploaded successfully')
        # message = f"{request.user.staff.biodata.name} uploaded shares"
        # ActivityLog.objects.create(actor=request.user,
        #                            action_type=UPLOAD,
        #                            title='Shares upload',
        #                            branch=branch_id(request.user),
        #                            remarks=message)

        # =================================EDITING LOAN TYPE===================================

        return HttpResponseRedirect(request.META.get("HTTP_REFERER"))


class UploadAdjustments(PermView):
    template_name = 'sacco/upload_adjustments.html'

    def get(self, request, *args, **kwargs):
        title = 'UPLOAD UDJUSTMENTS'
        bankaccounts = Account.objects.filter(Q(business=businessdata(request)),
                                              (Q(category__name='Bank') | Q(category__name='Mobile Money') | Q(
                                                  category__name='Cash') | Q(category__name='Reserves')))
        # uplaods = UploadLoans.objects.filter(branch_id=branchdata(request))

        return render(request, self.template_name, locals())

    # ====WHEN THE POST IS MADE==========================

    def post(self, request, *args, **kwargs):
        formtype = request.POST['form_type']
        if formtype == 'upload':

            debited = request.POST['debited']

            upload_file = request.FILES['proof']
            udatea = request.POST['udate']
            udate = datetime.datetime.strptime(udatea, '%Y-%m-%d')
            debited = request.POST['debited']
            narration = request.POST['narration']
            data = upload_file.read().decode('utf-8')
            n = 0
            rows = re.split('\n', data)  # splits along new line

            nloans = 0
            # === RECORD THE UPLOAD=========================
            amount = 0
            refeence = 0

            for index, row in enumerate(rows):
                n = n + 1

                cells = row.split(',')

                if n > 1:

                    try:
                        nloans = nloans + 1
                        memberacct = cells[0]
                        approvedon = cells[4]
                        amount = cells[3]
                        # approvedon = parse(cells[1]).date()
                        approvedon = pd.to_datetime(approvedon, infer_datetime_format=False)
                        approvedon = approvedon.strftime('%Y-%m-%d')

                        principal = cells[2]
                        refeence = cells[5]

                        principal = float(principal.replace(',', ''))

                        print(len(refeence))
                        try:
                            if len(refeence) > 2:
                                londetail = Transactions.objects.filter(receipt=refeence, loan_id__gt=1)[0]
                                loanid = londetail.loan_id

                            else:
                                londetail = \
                                    Loans.objects.filter(account__acc_number=memberacct, amount_approved=principal)[0]
                                loanid = londetail.id
                        except:
                            londetail = \
                                Loans.objects.filter(account__acc_number=memberacct, amount_approved=principal)[0]
                            loanid = londetail.id

                        credited = Account.objects.filter(name='Loan interests', business=businessdata(request)).first()
                        debited = \
                            Account.objects.filter(name='Loan interest receivables', business=businessdata(request))[0]
                        trans = Transactions.objects.create(reporting_amount=amount,
                                                            narration=narration,
                                                            account_dr_id=debited.id,
                                                            account_cr_id=credited.id,
                                                            loan_id=loanid,
                                                            tx_date=approvedon,
                                                            receipt=refeence,
                                                            transaction_type='Loan Adjustment',
                                                            added_by_id=userdata(request),
                                                            branch_id=branchdata(request))

                        # =========================RECORD INTEREST======================================
                    except Exception as lex:
                        print('ERROR IS ', str(lex))
                        # traceback.print_exc()
                        print('NOT ADDED ARE ', memberacct, ' Ref-number ', refeence, 'date ',
                              approvedon)
        messages.success(request, 'success', extra_tags='Shares uploaded successfully')
        message = f"{request.user.staff.biodata.name} uploaded shares"
        ActivityLog.objects.create(actor=request.user,
                                   action_type=UPLOAD,
                                   title='Shares upload',
                                   branch=branch_id(request.user),
                                   remarks=message)

        # =================================EDITING LOAN TYPE===================================

        return HttpResponseRedirect(request.META.get("HTTP_REFERER"))


# =================================UPLAOD LOANS==========================================
class InterestUpload(PermView):
    template_name = 'sacco/interest_upload.html'

    def get(self, request, *args, **kwargs):
        title = 'Loan Uploads'
        bankaccounts = Account.objects.filter(Q(business=businessdata(request)),
                                              (Q(category__name='Bank') | Q(category__name='Mobile Money') | Q(
                                                  category__name='Cash') | Q(category__name='Reserves')))
        uplaods = UploadLoans.objects.filter(branch_id=branchdata(request))

        return render(request, self.template_name, locals())

    # ====WHEN THE POST IS MADE==========================

    def post(self, request, *args, **kwargs):
        formtype = request.POST['form_type']
        if formtype == 'delete':
            pk = request.POST['uploadid']
            upload = UploadLoans.objects.filter(id=pk)[0]
            upload.delete()

            messages.success(request, 'success',
                             extra_tags=f'{upload.total_records} loans of {upload.loan_type.name} deleted successfully')
            message = f"{request.user.staff.biodata.name} has deleted {upload.total_records} loans of {upload.loan_type.name}"
            ActivityLog.objects.create(actor=request.user,
                                       action_type=DELETE,
                                       title='Loans record',
                                       branch=branch_id(request.user),
                                       remarks=message)

        if formtype == 'upload':
            upload_file = request.FILES['proof']
            udatea = request.POST['udate']
            udate = datetime.datetime.strptime(udatea, '%Y-%m-%d')
            data = upload_file.read().decode('utf-8')
            n = 0

            # ============TRY TO GET THE BALANCE=========================

            # you can use the re library --> import re
            rows = re.split('\n', data)  # splits along new line

            nloans = 0
            # === RECORD THE UPLOAD=========================
            # bupload = UploadLoans.objects.create(upload_date=udate, file=upload_file, loan_type_id=loantype,
            #                                      branch_id=branchdata(request), added_by_id=userdata(request))

            for index, row in enumerate(rows):
                n = n + 1

                cells = row.split(',')

                if n > 1:

                    try:
                        actualcharges = []
                        # accn = cells[0]
                        # date = cells[1]

                        memberacct = cells[0]
                        approvedon = cells[1]
                        # approvedon = parse(cells[1]).date()
                        # approvedon = cells[1]
                        approvedon = pd.to_datetime(approvedon, infer_datetime_format=True)
                        approvedon = approvedon.strftime('%Y-%m-%d')

                        amount = cells[2]
                        # print(amount)
                        amount = amount.replace(',', '')

                        # print(amount)
                        amount = float(amount)

                        approved = cells[5]
                        narration = 'Loan interest from account ', memberacct

                        principal = amount
                        # print(principal)

                        intrate = cells[3]

                        try:
                            intrat = [float(s) for s in re.findall(r'[0-9]+.[0-9]+', intrate)][0]
                            a = 1 + intrat
                        except:
                            intrat = int(re.findall(r'^\D*(\d+)', intrate)[0])
                            a = 2 + intrat

                        intrate = intrat

                        interestrate = intrate
                        duration = cells[4]

                        owingprincipal = cells[6]
                        owingprincipal = owingprincipal.replace(',', '')

                        owinginterest = cells[7]
                        owinginterest = owinginterest.replace(',', '')

                        getmemberid = MemberAccount.objects.filter(acc_number=memberacct,
                                                                   account_type__business_id=businessdata(request))[0]
                        applicant = AccountBroker.objects.filter(the_account__acc_number=memberacct,
                                                                 business_id=businessdata(request)).first()

                        # select the exact loan to update
                        toupdate = Loans.objects.filter(account_id=getmemberid.id, amount_requested=approved,
                                                        approved_on=approvedon)[0]

                        toupdate.principal = owingprincipal
                        toupdate.interest = owinginterest
                        toupdate.save()

                        # createinterestrecievables

                        nloans = nloans + 1

                        # actualchargesx = recordloan.charges
                        # print('THIS IS THE SAVE JASON %s' % actualchargesx)

                        #     RECORD TRANSACTION===================================

                        checkrecievables = Account.objects.filter(name='Loan interest receivables',
                                                                  business=businessdata(request)).exists()
                        if checkrecievables:
                            pass
                        else:
                            rcategeory = AccountCategory.objects.filter(name='Account Receivables',
                                                                        business=businessdata(request))[
                                0]
                            createleger = Account.objects.create(name='Loan interest receivables',
                                                                 business_id=businessdata(
                                                                     request),
                                                                 category_id=rcategeory.id,
                                                                 added_by_id=userdata(
                                                                     request)
                                                                 )

                        # =====================GET LEDGER ACCOUNTS============================

                        # laonacct = Account.objects.filter(category__name='Account Receivables', business=businessdata(request))[0]
                        laonacct = \
                            Account.objects.filter(name='Loan interest receivables', business=businessdata(request))[0]

                        loanr = Account.objects.filter(name='Loan Receivables', business=businessdata(request))[
                            0]

                        intrestaccount = Account.objects.filter(name='Loan interests',
                                                                business=businessdata(request)).first()

                        if float(owinginterest) > 0:
                            interest_trans = Transactions.objects.create(reporting_amount=owinginterest,
                                                                         narration=narration,
                                                                         account_dr_id=laonacct.id,
                                                                         account_cr_id=loanr.id,
                                                                         loan_id=toupdate.id,
                                                                         tx_date=approvedon,
                                                                         transaction_type='Interest on loan',
                                                                         added_by_id=userdata(request),
                                                                         branch_id=branchdata(request))

                        try:
                            principalpaid = Transactions.objects.filter(loan_id=toupdate.id,
                                                                        account_cr_id=1085).aggregate(
                                totalpaid=Sum('reporting_amount'))
                            totalpaid = principalpaid['totalpaid']

                            principaldr = Transactions.objects.filter(loan_id=toupdate.id,
                                                                      account_dr_id=1085).aggregate(
                                totalout=Sum('reporting_amount'))
                            totalout = principaldr['totalout']
                            if float(totalpaid) > float(totalout):
                                interestback = float(totalpaid) - float(totalout)

                                #             GET LAST PAYMENT DATE ===================

                                lastp = Transactions.objects.filter(loan_id=toupdate.id,
                                                                    transaction_type='Loan repayment').last()
                                lastdate = lastp.tx_date

                                #             REVERSE THE INTEREST ==================================
                                #
                                narr = 'Loan interest reversed from over paid loan principal for account ', memberacct
                                interest_trans = Transactions.objects.create(reporting_amount=interestback,
                                                                             narration=narr,
                                                                             account_dr_id=loanr.id,
                                                                             account_cr_id=intrestaccount.id,
                                                                             loan_id=toupdate.id,
                                                                             tx_date=lastdate,
                                                                             transaction_type='Interest on loan',
                                                                             added_by_id=userdata(request),
                                                                             branch_id=branchdata(request))
                        except Exception as iex:
                            print(str(iex))

                    except Exception as lex:
                        traceback.print_exc()

                        # print(str(lex))

            messages.success(request, 'success', extra_tags='uploaded successfully')
            message = f"{request.user.staff.biodata.name} uploaded members interest"
            ActivityLog.objects.create(actor=request.user,
                                       action_type=UPLOAD,
                                       title='Interest upload',
                                       branch=branch_id(request.user),
                                       remarks=message)

        # =================================EDITING LOAN TYPE===================================

        return HttpResponseRedirect(reverse_lazy('upload_interests'))


# ======================UPLOADING DEVINDENDS================================
class UploadDevidends(PermView):
    template_name = 'sacco/upload_devidends.html'

    def get(self, request, *args, **kwargs):
        title = 'UPLOAD SHARE DIVIDENDS'
        business_context = get_business_loans_context_data(request)
        if business_context['branch'] is None:
            messages.error(
                request, "error",
                extra_tags="Action not allowed in the central view. Please logout and login into the respective branch"
            )
            return HttpResponseRedirect(request.META.get("HTTP_REFERER"))
        bankaccounts = Account.objects.filter(business=business_context['branch'].business, category__name='Shares')
        liabity_accounts = Account.objects.filter(business=business_context['branch'].business, category__cat_type='Liability',member=None)

        return render(request, self.template_name, locals())

    # ====WHEN THE POST IS MADE==========================
    def post(self, request, *args, **kwargs):
        business_context = get_business_loans_context_data(request)
        formtype = request.POST['form_type']

        if formtype == 'upload':
            values_submitted = get_dividend_upload_submitted_values(request)
            business_setting = OtherSettings.objects.filter(business=business_context['branch'].business).first()
            share_price = business_setting.share_price
            narration = values_submitted['narration']
            debited = values_submitted['debited']


            try:
                data = pd.read_excel(values_submitted['upload_file'])
                data = data.to_dict('records')
                # check if field are there
                if len(data) > 0:
                    fields_missing = check_dividend_upload_fields_xlsx(trim_lower_case_dictionary_keys(data[0]))
                    if len(fields_missing) > 0:
                        messages.error(request, 'error',
                                       extra_tags='Some required fields are missing. Please refer to sample template')
                        return HttpResponseRedirect(reverse_lazy('upload_devidends'))


                    # business_data = businessdata(reque
                    business_data = business_context['branch'].business
                    branch_data = business_context['branch'].id
                    # user_data = userdata(request)
                    added_successfully = []
                    added_failed = []


                    for excel_dividend in data:
                        excel_dividend = trim_lower_case_dictionary_keys(excel_dividend)
                        memberacct = excel_dividend['account'].strip()
                        with transaction.atomic():
                            try:
                                approvedon = Timestamp(excel_dividend['date'])
                                approvedon = approvedon.strftime('%Y-%m-%d')
                                approvedon = datetime.datetime.strptime(approvedon, '%Y-%m-%d').date()
                                # print('approvedon', approvedon)

                                amount = excel_dividend['amount']
                                saving = excel_dividend['saving']
                                refeence = excel_dividend['reference']
                                amount = float(amount.replace(',', ''))
                                saving = float(saving.replace(',', ''))
                                no_of_shares = floor(amount / share_price)
                                # print('memberacct', memberacct.strip())

                                #put money on the person account
                                # then use the money to pay or shares

                                getmemberid = MemberAccount.objects.filter(acc_number=memberacct.strip(),
                                                                           account_type__business=business_context['branch'].business)
                                if getmemberid:
                                    getmemberid = getmemberid.first()
                                    # print('getmemberid', getmemberid)
                                else:
                                    # throw an error
                                    added_failed.append(memberacct)
                                    raise ValueError(f"Member account doesnot exist {memberacct}")

                                # print('getmemberid', getmemberid)
                                member = \
                                    AccountBroker.objects.filter(the_account_id=getmemberid.id,
                                                                 business=business_context['branch'].business)[
                                        0]
                                # print('member', member)

                                checkmember = Account.objects.filter(member=getmemberid.id,
                                                                     business=business_context['branch'].business).exists()
                                # print('checkmember', checkmember)

                                if checkmember:
                                    getmemberleger = Account.objects.filter(member=getmemberid, business=business_context['branch'].business)[
                                        0]
                                    # print('getmemberleger', getmemberleger)
                                else:
                                    membercat = AccountCategory.objects.filter(name='Member', business=business_context['branch'].business)[0]
                                    getmemberleger = Account.objects.create(name='',
                                                                            member_id=getmemberid.id,
                                                                            business=business_context['branch'].business,
                                                                            category_id=membercat.id,
                                                                            added_by_id=userdata(request)
                                                                            )

                                # ====================SAVE MEMBER SAVING =========================

                                savesaving = Transactions.objects.create(reporting_amount=saving+amount,
                                                                         narration=narration,
                                                                         receipt=refeence,
                                                                         account_cr_id=getmemberleger.id,
                                                                         account_dr_id=debited,
                                                                         tx_date=approvedon,
                                                                         transaction_type='Deposit',
                                                                         branch=business_context['branch'])

                                # print('acc Deposit', savesaving.id, 'REP AMT:',savesaving.reporting_amount )

                                sharecap = Account.objects.filter(name='Share Capital', business=business_context['branch'].business)[0]
                                # print('sharecap', sharecap)

                                saveshares = SharesTransactions.objects.create(
                                    buyer_id=member.members_id,
                                    shares=no_of_shares,
                                    date=approvedon,
                                    narration=narration,
                                    branch=business_context['branch']
                                )
                                # print('save shares', saveshares.id)

                                # ==========================GET TRANSCTION CHARHES===========================

                                savetransaction = Transactions.objects.create(reporting_amount=amount,
                                                                              narration=narration,
                                                                              receipt=refeence,
                                                                              account_cr_id=sharecap.id,
                                                                              account_dr_id=getmemberleger.id,
                                                                              tx_date=approvedon,
                                                                              transaction_type='Sell of shares',
                                                                              shares_id=saveshares.id,
                                                                              branch=business_context['branch'])
                                # print('Sell shares', savetransaction.id)


                                # print('savesaving', savesaving)
                                added_successfully.append(memberacct)
                                # print("approved on %s" % datetime.strptime(str(approvedon), '%Y-%m-%d'))
                            except Exception as e:
                                # print(e)
                                added_failed.append(memberacct)
                else:
                    messages.error(request, 'error', extra_tags='Excel file is empty')
                    return HttpResponseRedirect(reverse_lazy('upload_devidends'))

            except Exception as lex:
                # pass
                print(str(lex))

            # print('THE BRANCH:', branchdata(request))
            recalculate_shares(branchdata(request))
            recalculate_savings(businessdata(request))

            the_business = Business.objects.filter(id=business_context['branch'].business.id)
            if the_business:
                the_business=the_business.first().name
                print(f'FAILED DIVIDENDS for {the_business} ', added_failed)
                # print(f'Added DIVIDENDS for {the_business} ', added_successfully)

            if len(added_failed) > 1:
                messages.warning(request, 'warning', extra_tags=f'{len(added_successfully)} dividends uploaded successfully and {len(added_failed)} failed')
            else:
                messages.success(request, 'success', extra_tags=f'{len(added_successfully)} dividends uploaded successfully')

        # =================================EDITING LOAN TYPE===================================

        return HttpResponseRedirect(request.META.get("HTTP_REFERER"))


class UploadJvs(PermView):
    template_name = 'sacco/upload_jvs.html'

    def get(self, request, *args, **kwargs):
        title = 'JVS UPLOADS'
        bankaccounts = Account.objects.filter(business=businessdata(request), member_id__isnull=True)

        return render(request, self.template_name, locals())

    # ====WHEN THE POST IS MADE==========================
    def post(self, request, *args, **kwargs):
        formtype = request.POST['form_type']
        if formtype == 'delete':
            pk = request.POST['uploadid']

        if formtype == 'upload':
            upload_file = request.FILES['proof']
            udatea = request.POST['udate']
            udate = datetime.datetime.strptime(udatea, '%Y-%m-%d')
            credited = request.POST['credited']
            narration = request.POST['narration']

            data = upload_file.read().decode('utf-8')
            n = 0

            # you can use the re library --> import re
            rows = re.split('\n', data)  # splits along new line

            nloans = 0
            # === RECORD THE UPLOAD=========================

            for index, row in enumerate(rows):
                n = n + 1

                cells = row.split(',')

                if n > 1:

                    try:
                        nloans = nloans + 1
                        memberacct = cells[2]
                        approvedon = cells[0]
                        approvedon = pd.to_datetime(approvedon, infer_datetime_format=True)
                        approvedon = approvedon.strftime('%Y-%m-%d')

                        narration = cells[4]
                        amount = cells[5]
                        refeence = cells[3]
                        amount = float(amount.replace(',', ''))
                        getmemberid = MemberAccount.objects.filter(acc_number=memberacct,
                                                                   account_type__business_id=businessdata(request))[0]

                        acctype = getmemberid.account_type

                        checkmember = Account.objects.filter(member=getmemberid,
                                                             business=businessdata(request)).exists()

                        if checkmember:
                            getmemberleger = Account.objects.filter(member=getmemberid, business=businessdata(request))[
                                0]
                        else:
                            membercat = AccountCategory.objects.filter(name='Member', business=businessdata(request))[0]
                            getmemberleger = Account.objects.create(name='',
                                                                    member_id=getmemberid.id,
                                                                    business_id=businessdata(request),
                                                                    category_id=membercat.id,
                                                                    added_by_id=userdata(request)
                                                                    )

                        exists = Transactions.objects.filter(receipt=refeence, transaction_type='Withdraw',
                                                             branch_id=branchdata(request)).exists()
                        if exists:
                            pass
                        else:

                            savetransaction = Transactions.objects.create(reporting_amount=amount,
                                                                          narration=narration,
                                                                          receipt=refeence,
                                                                          account_cr_id=credited,
                                                                          account_dr_id=getmemberleger.id,
                                                                          tx_date=approvedon,
                                                                          transaction_type='Jvs',
                                                                          branch_id=branchdata(request))
                        # print("approved on %s" % datetime.strptime(str(approvedon), '%Y-%m-%d'))
                        newbalance = Transactions.objects.filter(
                            Q(account_dr=getmemberleger.id) | Q(account_cr=getmemberleger.id)).aggregate(
                            bal=Sum(
                                Case(
                                    When(account_cr=getmemberleger.id, then=F('reporting_amount')),
                                    default=0, output_field=FloatField()))
                                - Sum(
                                Case(
                                    When(account_dr=getmemberleger.id, then=F('reporting_amount')),
                                    default=0, output_field=FloatField()))
                        )

                        # newbalance = float(getmemberid.balance) - amount
                        getmemberid.balance = newbalance['bal']
                        getmemberid.save()

                    except Exception as lex:
                        print(str(lex))
                        traceback.print_exc()
                        print('SKIPPED', memberacct, 'AMOUNT', amount)
            messages.success(request, 'success', extra_tags='Withdraws uploaded successfully')

        # =================================EDITING LOAN TYPE===================================

        return HttpResponseRedirect(request.META.get("HTTP_REFERER"))


class CorrectLoans(PermView):
    template_name = 'sacco/correct_loans.html'

    def get(self, request, *args, **kwargs):
        title = 'CORRECT LOANS'
        bankaccounts = Account.objects.filter(business=businessdata(request), member_id__isnull=True)

        return render(request, self.template_name, locals())

    # ====WHEN THE POST IS MADE==========================

    def post(self, request, *args, **kwargs):
        formtype = request.POST['form_type']
        if formtype == 'delete':
            pk = request.POST['uploadid']
            #

        if formtype == 'upload':
            upload_file = request.FILES['proof']
            udatea = request.POST['udate']
            udate = datetime.datetime.strptime(udatea, '%Y-%m-%d')
            data = upload_file.read().decode('utf-8')
            n = 0

            # you can use the re library --> import re
            rows = re.split('\n', data)  # splits along new line

            nloans = 0
            # === RECORD THE UPLOAD=========================

            for index, row in enumerate(rows):
                n = n + 1

                cells = row.split(',')

                if n > 1:

                    try:
                        nloans = nloans + 1
                        loanid = cells[0]
                        amount = cells[5]
                        interest = cells[6]
                        acct = cells[2]
                        narration = 'Oppening loan inerest balance for account number ', acct

                        amount = float(amount.replace(',', ''))
                        interest = float(interest.replace(',', ''))
                        getloan = Loans.objects.filter(id=loanid)[0]
                        getloan.amount_approved = amount
                        getloan.rate = 0
                        getloan.save()

                        #     GET LOAN TRANSACTIONS ========================
                        ltransctions = Transactions.objects.filter(loan_id=loanid, transaction_type='give loan')[0]
                        ltransctions.reporting_amount = amount
                        opening = ltransctions.account_cr_id
                        ltransctions.save()

                        print('LAON ID ', loanid, ' amount ', amount, ' Interest :', interest)
                        #     change interests account
                        receivable = \
                            Account.objects.filter(name='Loan interest receivables', business=businessdata(request))[
                                0]
                        if interest > 0:
                            try:
                                trans = Transactions.objects.create(reporting_amount=interest,
                                                                    narration='Openning ',
                                                                    account_dr_id=receivable.id,
                                                                    account_cr_id=opening,
                                                                    loan_id=loanid,
                                                                    tx_date='2021-01-01',
                                                                    transaction_type=narration,
                                                                    added_by_id=userdata(request),
                                                                    branch_id=branchdata(request))
                            except Exception as lexs:
                                print(str(lexs))
                                traceback.print_exc()
                                print('SKIPPED', 'AMOUNT', amount)


                    except Exception as lex:
                        print(str(lex))
                        traceback.print_exc()
                        print('SKIPPED', 'AMOUNT', amount)
            messages.success(request, 'success', extra_tags='Withdraws uploaded successfully')

        # =================================EDITING LOAN TYPE===================================

        return HttpResponseRedirect(request.META.get("HTTP_REFERER"))


#     ======================================UPDATE ALL LOANS ACCORDING TO SETTINGS============


# =========================RECORD INTEREST======================================


class CorrectTopups(PermView):
    template_name = 'sacco/correct_topups.html'

    def get(self, request, *args, **kwargs):
        title = 'CORRECT TOPUPS'
        bankaccounts = Account.objects.filter(business=businessdata(request), member_id__isnull=True)

        return render(request, self.template_name, locals())

    # ====WHEN THE POST IS MADE==========================

    def post(self, request, *args, **kwargs):
        formtype = request.POST['form_type']
        if formtype == 'upload':
            upload_file = request.FILES['proof']

            data = upload_file.read().decode('utf-8')

            n = 0
            rows = re.split('\n', data)  # splits along new line

            nloans = 0
            # === RECORD THE UPLOAD=========================
            print(data)
            for index, row in enumerate(rows):

                n = n + 1

                cells = row.split(',')

                if n > 0:

                    try:
                        nloans = nloans + 1
                        memberacct = cells[0]
                        datetoped = cells[1]

                        approvedon = pd.to_datetime(datetoped, infer_datetime_format=True)
                        approvedon = approvedon.strftime('%Y-%m-%d')

                        try:
                            getmemberloan = Loans.objects.filter(account__acc_number=memberacct)[0]
                            loanid = getmemberloan.id

                            #     GET LOAN TRANSACTIONS ========================
                            ltransctions = Transactions.objects.filter(loan_id=loanid, tx_date__gt=approvedon)
                            for ltr in ltransctions:
                                print('DELETED ', memberacct, ' Date ', ltr.tx_date, ' ', ltr.reporting_amount)
                                ltr.delete()


                        except Exception as lexi:
                            print(str(lexi))
                            traceback.print_exc()


                    except Exception as lex:
                        print(str(lex))
                        traceback.print_exc()

            messages.success(request, 'success', extra_tags='Withdraws uploaded successfully')

        # =================================EDITING LOAN TYPE===================================

        return HttpResponseRedirect(request.META.get("HTTP_REFERER"))

#     ======================================UPDATE ALL LOANS ACCORDING TO SETTINGS============
