import re

from django.db.models import Sum, When, F, FloatField, Case, Value
from django.db.models import OuterRef, Subquery
from django.http import HttpResponse
from django.shortcuts import render
from django.test import TestCase
from django.core import serializers

# Create your tests here.
from loans.models import Loans
from transactions.models import Transactions
from transactions.reports import this_branch


# intrate = "18.5dfdf"
# intrat = [float(s) for s in re.findall(r'[0-9]+.[0-9]+', intrate)]
# print(intrat)

def TestLoans(request):
    loans = Loans.objects.filter(branch=this_branch(request.user), loan_status=3, loan_trans__transaction_type='Loan repayment').annotate(total=Sum('loan_trans__reporting_amount')).annotate(diff=F('amount_approved') - F('total')).values()
    print(loans)

    return render(request, 'sacco/tests.html', {'loans': loans})
    # return HttpResponse(loans.running_principle)
