from django.contrib.contenttypes.models import ContentType
from django.db.models.signals import post_save
from django.dispatch import receiver

from accounts.models import Position
from sacco.constants import CREATE
from sacco.models import ActivityLog


@receiver(post_save, sender=Position)
def add_role(sender, created, instance, **kwargs):
    if created:
        if instance.created_by:
            branch_id = instance.created_by.branch_id
            if instance.created_by.biodata:
                user = instance.created_by.biodata.name
            else:
                user = instance.created_by
            this_staff = instance.created_by.user
        else:
            branch_id = None
            user = None
            this_staff = None
        ct = ContentType.objects.get_for_model(instance)
        log_title = 'User role added'
        message = f"{user} added user role with {instance.title}"

        ActivityLog.objects.create(actor=this_staff, title=log_title, action_type=CREATE, remarks=message,
                                   branch=branch_id, content_type=ct)
