import json

from django.db.models import Sum
from django.shortcuts import render

from accounts.permission_mixin import BusinessUserMixin
from sacco.models import OtherSettings, CurrencySetting, Member
from sacco.utils import businessdata, branch_id
from django.views import View

from transactions.models import Transactions


class WithdrawReceipt(BusinessUserMixin, View):
    template_name = 'sacco/receipts/withdraw_receipt.html'

    def get(self, request, *args, **kwargs):
        business_setting = OtherSettings.objects.filter(business=businessdata(request)).first()
        currency = CurrencySetting.objects.filter(business=businessdata(request)).first()
        url = ''
        if 'data' in request.session:
            from_view = request.session.get('data')
            # print(from_view)
            dict_to_json = json.dumps(from_view)
            data = json.loads(dict_to_json)
            amount = data['amount']
            charges = data['charges']
            acc = data['acc']
            owner = data['owner']
            rec = data['rec']
            url = data['url']
            if 'received_by_acc' in data:
                received_by_acc = data['received_by_acc']
            else:
                received_by_acc = ''
            if 'received_by' in data:
                received_by = data['received_by']
            else:
                received_by = ''

        title = f'{url} Receipt'
        return render(request, self.template_name, locals())


class ReceiptDetail(BusinessUserMixin, View):
    template_name = 'sacco/receipts/deporeceipt.html'

    def get(self, request, pk, member_id, *args, **kwargs):
        title = "Transaction Receipt"
        currency = CurrencySetting.objects.filter(business=businessdata(request)).first()
        trans = Transactions.objects.filter(id=pk).first()
        member = Member.objects.filter(id=member_id).first().biodata.name
        print(member)
        trans_type = ''
        if 'deposit' in trans.transaction_type.lower():
            trans_type = 'Deposit'
        elif 'withdraw' in trans.transaction_type.lower():
            trans_type = 'Withdraw'
        elif 'transfer' in trans.transaction_type.lower():
            trans_type = 'Transfer'
        receipt = trans.receipt
        acct = trans
        title = f'{trans.transaction_type.title()}'
        branch = branch_id(request.user)
        tranzactions = Transactions.objects.filter(receipt=receipt, branch_id=branch)
        # receipt_detail = Transactions.objects.filter(receipt=receipt).aggregate(Sum('reporting_amount'))
        trans_total = tranzactions.exclude(transaction_type__icontains='charge').aggregate(Sum('reporting_amount', default=0.00))['reporting_amount__sum']
        total_paid = tranzactions.filter(transaction_type__icontains='charge').aggregate(Sum('reporting_amount', default=0.00))['reporting_amount__sum']

        context = {
            'acct': acct,
            'currency': currency,
            'title': title,
            'trans_type': trans_type,
            'trans_total': trans_total,
            'owner': member,
            'total_paid': total_paid,
            'receipt': trans.receipt,
        }
        return render(request, self.template_name, context)