import os
import logging

import requests

from django.conf import settings
from django.db import connections

from sacco.models import PaymentTransaction, gen_txt_ref, Sms
from settings.base import BASE_DIR

# Set the path for the log file
log_file_path = os.path.join(BASE_DIR, 'logs', 'django.log')

# Create a logging object
logging.basicConfig(filename=log_file_path, level=logging.ERROR)
connections.close_all()

# Add the logging handler to the logger
logger = logging.getLogger('django')


class Jpesa:

    @staticmethod
    def payment(amount: float, description: str, phone: str, base_site: str, staff_id: int):
        txid = gen_txt_ref()

        phone = phone.replace("+", "")
        xml = f"""<?xml version="1.0" encoding="ISO-8859-1"?>
                       <g7bill>
                       <_key_>{settings.JPESAKEY}</_key_>
                       <cmd>account</cmd>
                       <action>credit</action>
                       <pt>mm</pt>
                       <mobile>{phone}</mobile>
                       <amount>{amount}</amount>
                       <callback>{base_site}/payment-complete/?txn_id={txid}</callback>
                       <tx>{txid}</tx>
                       <description>{description}</description>
                     </g7bill>"""

        headers = {'Content-Type': 'application/xml'}  # set what your server accepts
        try:
            data = requests.post('https://my.jpesa.com/api/', data=xml.encode('iso-8859-1'), headers=headers)
            print(data.text)
            comm_status = data.json()
            if comm_status['api_status'] == 'success':
                jpesaid = comm_status['tid']
                PaymentTransaction.objects.create(created_by_id=staff_id,
                                                  phone=phone,
                                                  amount=amount,
                                                  txt_id=txid, jpesaid=jpesaid)
            else:
                print('failed')
                logger.error(str(data.json()))
        except Exception as e:
            logger.error(str(e))

    @staticmethod
    def check_status(jpesa_id: str):
        print('am starting')
        xml = f"""<?xml version="1.0" encoding="ISO-8859-1"?>
                             <g7bill>
                               <_key_>{settings.JPESAKEY}</_key_>
                               <cmd>account</cmd>
                               <action>info</action>
                               <tid>{jpesa_id}</tid>
                             </g7bill>"""
        headers = {'Content-Type': 'application/xml'}  # set what your server accepts
        try:
            data = requests.post('https://my.jpesa.com/api/', data=xml.encode('iso-8859-1'), headers=headers)
            print('my data')
            print(data.text)
            comm_status = data.json()['api_status']
            trans_status = data.json()['status']
            try:
                transaction = PaymentTransaction.objects.get(jpesaid=jpesa_id)
            except PaymentTransaction.DoesNotExist:
                transaction = None
            if comm_status == 'success' and trans_status == 'closed' and transaction is not None:
                print('am success')
                transaction.status = PaymentTransaction.SUCCESS
                sms = Sms.objects.filter()
            else:
                print('am failed')
                transaction.status = PaymentTransaction.FAILED
            print('saved')
            transaction.save()
        except Exception as e:
            logger.error(str(e))
