# Generated by Django 4.2.6 on 2023-12-09 13:27

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import utils.file_uploads


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('contenttypes', '0002_remove_content_type_name'),
        ('accounts', '0001_initial'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='AccountBroker',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_date', models.DateField(auto_now_add=True)),
                ('business', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='member_business', to='accounts.business')),
            ],
            options={
                'verbose_name': 'Account Broker',
                'db_table': 'account_broker',
            },
        ),
        migrations.CreateModel(
            name='AccountTypes',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255)),
                ('is_fixed', models.BooleanField(default=False)),
                ('min_balance', models.FloatField(default=0)),
                ('maturity', models.IntegerField(default=0)),
                ('dormancy_period', models.IntegerField(default=0)),
                ('deposit_charge', models.BooleanField(default=True)),
                ('withdraw_charge', models.BooleanField(default=True)),
                ('transfer_charge', models.BooleanField(default=True)),
                ('status', models.BooleanField(default=True)),
                ('deposit_charge_vary', models.BooleanField(default=True)),
                ('withdraw_charge_vary', models.BooleanField(default=True)),
                ('transfer_charge_vary', models.BooleanField(default=True)),
                ('synced', models.BooleanField(default=False, verbose_name='Synced to the portal')),
                ('business', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='accounts.business')),
            ],
            options={
                'verbose_name': 'Account Type',
                'verbose_name_plural': 'Account Types',
                'db_table': 'account_types',
            },
        ),
        migrations.CreateModel(
            name='BulkDepositTracker',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateField(auto_now_add=True)),
                ('group', models.IntegerField()),
                ('external_id', models.UUIDField(unique=True)),
            ],
        ),
        migrations.CreateModel(
            name='GroupMember',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('is_signatory', models.BooleanField(default=False)),
                ('role', models.CharField(choices=[('Chair', 'ChairPerson'), ('Secretary', 'Secretary'), ('Treasurer', 'Treasurer'), ('Ordinary', 'Ordinary')], default='Ordinary', max_length=20)),
                ('created_date', models.DateTimeField(auto_now_add=True)),
                ('added_by', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='accounts.staff')),
            ],
            options={
                'verbose_name': 'Group Members',
                'db_table': 'group_members',
            },
        ),
        migrations.CreateModel(
            name='Member',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(blank=True, max_length=255, null=True)),
                ('email', models.EmailField(blank=True, max_length=254, null=True)),
                ('contact', models.CharField(blank=True, max_length=40, null=True)),
                ('other_contact', models.CharField(blank=True, max_length=45, null=True)),
                ('photo', models.ImageField(blank=True, null=True, upload_to=utils.file_uploads.bio_photo)),
                ('location', models.TextField(blank=True, null=True)),
                ('member_type', models.CharField(choices=[('o', 'Ordinary'), ('s', 'Shareholder')], default='o', max_length=1)),
                ('shares', models.FloatField(blank=True, default=0.0, null=True)),
                ('created_date', models.DateField(auto_now_add=True)),
                ('is_group', models.BooleanField(default=False)),
                ('is_active', models.BooleanField(default=True)),
                ('desc', models.TextField(blank=True, null=True, verbose_name='Description')),
                ('date_joined', models.DateField(blank=True, null=True)),
                ('portal', models.BooleanField(default=False, verbose_name='Synced to the portal')),
            ],
            options={
                'ordering': ['-id', '-biodata__name'],
            },
        ),
        migrations.CreateModel(
            name='MessagePackage',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(blank=True, default='', max_length=255, null=True)),
                ('unit_cost', models.FloatField(default=0.0)),
                ('price', models.FloatField(default=500.0)),
                ('sms', models.IntegerField(default=10)),
                ('status', models.BooleanField(default=True)),
            ],
            options={
                'verbose_name': 'Message Package',
                'verbose_name_plural': 'Message Packages',
                'db_table': 'message_package',
            },
        ),
        migrations.CreateModel(
            name='WithdrawUpload',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('narration', models.TextField()),
                ('total_records_added', models.FloatField()),
                ('total_records_failed', models.FloatField()),
                ('transactions_created', models.TextField()),
                ('failed_withdraws', models.TextField()),
                ('date_added', models.DateField(auto_now_add=True)),
                ('file', models.FileField(upload_to='withdraws')),
                ('branch', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='withdraw_branch', to='accounts.branch')),
            ],
            options={
                'verbose_name': 'Withdraw upload',
                'verbose_name_plural': 'Withdraw uploads',
                'db_table': 'withdraw_upload',
            },
        ),
        migrations.CreateModel(
            name='UserMember',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('member', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, to='sacco.member')),
                ('user', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'db_table': 'user_member',
            },
        ),
        migrations.CreateModel(
            name='TransactionCharge',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('start', models.FloatField(blank=True, default=0, null=True)),
                ('end', models.FloatField(blank=True, default=0, null=True)),
                ('charge', models.FloatField(default=0)),
                ('charge_type', models.CharField(choices=[('d', 'Deposit'), ('w', 'Withdraw'), ('t', 'Transfer')], default='d', max_length=1)),
                ('status', models.BooleanField(default=True)),
                ('is_charge_percentage', models.BooleanField(default=False)),
                ('created_date', models.DateTimeField(auto_now_add=True)),
                ('deletion_date', models.DateTimeField(blank=True, null=True)),
                ('account_type', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='sacco.accounttypes')),
            ],
            options={
                'verbose_name': 'Transaction charge',
                'verbose_name_plural': 'Transaction charges',
                'db_table': 'transaction_charge',
            },
        ),
        migrations.CreateModel(
            name='SmsTransaction',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('quantity', models.IntegerField(blank=True, default=0, null=True)),
                ('trans_type', models.IntegerField(blank=True, choices=[(0, 'Purchase'), (1, 'Usage')], default=0, null=True)),
                ('price', models.FloatField(blank=True, default=0, null=True)),
                ('body', models.TextField(blank=True, null=True)),
                ('receiver', models.CharField(blank=True, max_length=255, null=True)),
                ('is_broadcast', models.BooleanField(default=False)),
                ('delivery_id', models.IntegerField(blank=True, null=True)),
                ('status', models.IntegerField(blank=True, choices=[(1, 'Pending'), (2, 'Sent'), (3, 'Failed')], default=1, null=True)),
                ('created_date', models.DateTimeField(auto_now_add=True)),
                ('message_id', models.IntegerField(blank=True, default=0, null=True)),
                ('added_by', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='accounts.staff')),
                ('branch', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='accounts.branch')),
            ],
            options={
                'verbose_name': 'SMS transaction',
                'verbose_name_plural': 'SMS transactions',
                'db_table': 'sms_transaction',
            },
        ),
        migrations.CreateModel(
            name='SMSCost',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('cost', models.FloatField(default=0.0)),
                ('business', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='accounts.business')),
            ],
            options={
                'db_table': 'sms_cost',
            },
        ),
        migrations.CreateModel(
            name='SmsBusinessPackage',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('branch', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='accounts.branch')),
                ('package', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='sacco.messagepackage')),
            ],
        ),
        migrations.CreateModel(
            name='Sms',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('quantity', models.IntegerField(blank=True, default=0, null=True)),
                ('branch', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='accounts.branch')),
            ],
            options={
                'verbose_name': 'SMS',
                'verbose_name_plural': 'SMSs',
                'db_table': 'sms',
            },
        ),
        migrations.CreateModel(
            name='SaccoSmsSettings',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('when_to_send', models.CharField(max_length=255)),
                ('section', models.CharField(max_length=255)),
                ('status', models.BooleanField(default=True)),
                ('business', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='accounts.business')),
            ],
            options={
                'verbose_name': 'Sacco sms setting',
                'verbose_name_plural': 'Sacco sms settings',
                'db_table': 'sacco_sms_setting',
            },
        ),
        migrations.CreateModel(
            name='ReasonMemberRemoval',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('reason', models.TextField()),
                ('member', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='sacco.groupmember')),
            ],
        ),
        migrations.CreateModel(
            name='PaymentTransaction',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('txt_id', models.CharField(max_length=200)),
                ('status', models.CharField(choices=[('PENDING', 'Pending'), ('SUCCESS', 'Success'), ('FAILED', 'Failed')], default='PENDING', max_length=200)),
                ('amount', models.FloatField()),
                ('phone', models.CharField(max_length=100)),
                ('description', models.TextField()),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('jpesaid', models.CharField(blank=True, max_length=200, null=True)),
                ('created_by', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='accounts.staff')),
            ],
            options={
                'db_table': 'subscription_transaction',
            },
        ),
        migrations.CreateModel(
            name='OtherSettings',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('dividends_sharing', models.BooleanField(default=True, verbose_name='Dividends are shared to only shareholders')),
                ('set_ordinary', models.BooleanField(default=True, verbose_name='Set ordinary(Default Ordinary user)')),
                ('share_price', models.FloatField(blank=True, default=0, null=True)),
                ('share_limit', models.IntegerField(blank=True, default=0, null=True)),
                ('business', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='accounts.business')),
            ],
            options={
                'verbose_name': 'Other Setting',
                'verbose_name_plural': 'Other Settings',
                'db_table': 'other_settings',
            },
        ),
        migrations.CreateModel(
            name='NotiSettings',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('notification_type', models.IntegerField(choices=[(1, 'SMS'), (2, 'Email'), (3, 'Both'), (0, 'None')], default=1)),
                ('faces_charge', models.CharField(choices=[('Business', 'Business'), ('Client', 'Client')], default='Business', max_length=20)),
                ('business', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='accounts.business')),
            ],
            options={
                'verbose_name': 'Notification Setting',
                'verbose_name_plural': 'Notification Settings',
                'db_table': 'notification_settings',
            },
        ),
        migrations.CreateModel(
            name='MemberUpload',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('uuid', models.UUIDField()),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('failed', models.CharField(blank=True, max_length=255, null=True)),
                ('reason', models.TextField(blank=True, null=True)),
                ('file', models.FileField(blank=True, null=True, upload_to='member_upload_files')),
                ('business', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='accounts.business')),
            ],
            options={
                'db_table': 'member_upload',
            },
        ),
        migrations.CreateModel(
            name='MemberAccount',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('acc_number', models.CharField(blank=True, max_length=255, null=True)),
                ('balance', models.FloatField(blank=True, null=True)),
                ('synced', models.BooleanField(default=False, verbose_name='Synced to the portal')),
                ('account_type', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='sacco.accounttypes')),
            ],
            options={
                'verbose_name': 'Member Account',
                'verbose_name_plural': 'Member Accounts',
                'db_table': 'member_accounts',
            },
        ),
        migrations.AddField(
            model_name='member',
            name='accounts',
            field=models.ManyToManyField(blank=True, related_name='members_account', through='sacco.AccountBroker', to='sacco.memberaccount'),
        ),
        migrations.AddField(
            model_name='member',
            name='biodata',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='accounts.biodata'),
        ),
        migrations.AddField(
            model_name='member',
            name='branch',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='accounts.branch'),
        ),
        migrations.AddField(
            model_name='member',
            name='created_by',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='accounts.staff'),
        ),
        migrations.AddField(
            model_name='member',
            name='member_upload',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='members', to='sacco.memberupload'),
        ),
        migrations.AddField(
            model_name='member',
            name='referee',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='referral', to='sacco.member'),
        ),
        migrations.CreateModel(
            name='LoanSettings',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('minimum_guarantors', models.IntegerField(blank=True, default=1, null=True)),
                ('decimals', models.IntegerField(blank=True, default=2, null=True)),
                ('top_up_limit', models.IntegerField(blank=True, default=0, null=True, verbose_name='Percentage paid on the running loan')),
                ('min_approvals', models.IntegerField(blank=True, default=1, null=True, verbose_name='Minimum number of loan approvals')),
                ('allow_others', models.BooleanField(blank=True, default=False, null=True, verbose_name='Allow non-member Guarantors')),
                ('upload_minutes', models.BooleanField(blank=True, default=False, null=True, verbose_name='Approving committee minutes must be uploaded')),
                ('loan_topup', models.IntegerField(blank=True, choices=[(1, 'Close running loan'), (2, 'Loans run concurrently'), (3, 'Not allowed')], default=1, null=True)),
                ('fines_on', models.BooleanField(blank=True, default=True, null=True, verbose_name='Automatically impose loan fines')),
                ('use_shares', models.BooleanField(blank=True, default=True, null=True, verbose_name='Consider savings and shares value')),
                ('business', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='accounts.business')),
            ],
            options={
                'verbose_name': 'Loan Setting',
                'verbose_name_plural': 'Loan Settings',
                'db_table': 'loan_settings',
            },
        ),
        migrations.CreateModel(
            name='LicenseKey',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('license_key', models.UUIDField(blank=True, null=True, unique=True)),
                ('expiry_date', models.DateField(blank=True, null=True)),
                ('date_created', models.DateField(auto_now_add=True)),
                ('status', models.BooleanField(default=True)),
                ('business', models.OneToOneField(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='licence', to='accounts.business')),
            ],
            options={
                'verbose_name': 'License Key',
                'verbose_name_plural': 'Licenses Keys',
                'db_table': 'license_keys',
            },
        ),
        migrations.CreateModel(
            name='GroupSettings',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('minimum_members', models.IntegerField(default=1)),
                ('minimum_signatories', models.IntegerField(default=1)),
                ('maximum_signatories', models.IntegerField(default=1)),
                ('maximum_members', models.IntegerField(default=1)),
                ('business', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='accounts.business')),
            ],
            options={
                'verbose_name': 'Group Setting',
                'verbose_name_plural': 'Group Settings',
                'db_table': 'group_settings',
            },
        ),
        migrations.AddField(
            model_name='groupmember',
            name='group',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='members', to='sacco.member'),
        ),
        migrations.AddField(
            model_name='groupmember',
            name='member',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='groups', to='sacco.member'),
        ),
        migrations.CreateModel(
            name='GeneratedPassword',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_date', models.DateTimeField(auto_now_add=True)),
                ('is_used', models.BooleanField(default=False)),
                ('password', models.CharField(max_length=8)),
                ('can_login', models.BooleanField(default=False)),
                ('staff', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, to='accounts.staff')),
            ],
            options={
                'db_table': 'generated_password',
            },
        ),
        migrations.CreateModel(
            name='FinancialYear',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(blank=True, max_length=20, null=True)),
                ('start_date', models.DateField()),
                ('end_date', models.DateField()),
                ('created_date', models.DateTimeField(auto_now_add=True)),
                ('status', models.BooleanField(default=True)),
                ('added_by', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='accounts.staff')),
                ('business', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='accounts.business')),
            ],
            options={
                'verbose_name': 'Financial Year',
                'db_table': 'financial_years',
                'ordering': ['-id', '-name'],
            },
        ),
        migrations.CreateModel(
            name='CustomBusiness',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('business_module', models.CharField(blank=True, choices=[('NAMAMYINGO', 'Namayingo Modules'), ('OTHERS', 'For others Modules')], max_length=255, null=True)),
                ('business', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='accounts.business')),
            ],
            options={
                'db_table': 'custom_business',
            },
        ),
        migrations.CreateModel(
            name='CurrencySetting',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('currency', models.CharField(blank=True, max_length=8)),
                ('show_currency', models.BooleanField(default=True)),
                ('business', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='accounts.business')),
            ],
            options={
                'verbose_name': 'currency setting',
                'verbose_name_plural': 'currency settings',
                'db_table': 'currency_setting',
            },
        ),
        migrations.CreateModel(
            name='ChargeSchedule',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('charge_date', models.DateField(blank=True, null=True)),
                ('account', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='sacco.memberaccount')),
            ],
            options={
                'db_table': 'charge_schedule',
            },
        ),
        migrations.CreateModel(
            name='BusinessShares',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('market_cap', models.FloatField(default=0)),
                ('sold', models.FloatField(default=0)),
                ('business_no', models.CharField(blank=True, max_length=8, null=True)),
                ('business', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='accounts.business')),
            ],
            options={
                'verbose_name': 'Business Shares',
                'db_table': 'business_shares',
            },
        ),
        migrations.CreateModel(
            name='ActivityLog',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('action_type', models.CharField(choices=[('Create', 'Create'), ('Read', 'Read'), ('Update', 'Update'), ('Delete', 'Delete'), ('Reverse', 'Reverse'), ('Login', 'Login'), ('Logout', 'Logout'), ('Login Failed', 'Login Failed'), ('Authentication', 'Authentication'), ('Upload', 'Upload'), ('Account', 'Account'), ('Share', 'Share'), ("Members' portal", "Members' portal"), ('Staff Payroll', 'Staff Payroll')], max_length=15)),
                ('action_time', models.DateTimeField(auto_now_add=True)),
                ('remarks', models.TextField(blank=True, null=True)),
                ('status', models.CharField(choices=[('Success', 'Success'), ('Failed', 'Failed')], default='Success', max_length=7)),
                ('data', models.JSONField(blank=True, default=dict, null=True)),
                ('branch', models.BigIntegerField(blank=True, null=True)),
                ('title', models.CharField(blank=True, max_length=255, null=True)),
                ('object_id', models.PositiveIntegerField(blank=True, null=True)),
                ('actor', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
                ('content_type', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='contenttypes.contenttype')),
            ],
            options={
                'verbose_name': 'Activity Log',
                'db_table': 'activity_logs',
                'ordering': ['-action_time'],
            },
        ),
        migrations.AddField(
            model_name='accountbroker',
            name='members',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='owners', to='sacco.member'),
        ),
        migrations.AddField(
            model_name='accountbroker',
            name='the_account',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='member_account', to='sacco.memberaccount'),
        ),
        migrations.AlterUniqueTogether(
            name='groupmember',
            unique_together={('group', 'member')},
        ),
    ]
