from datetime import date

from django.http import HttpResponseRedirect
from django.urls import reverse_lazy
from django.contrib import messages
from rest_framework.exceptions import ValidationError

from commons.logger import logger
from sacco.models import LicenseKey
from sacco.utils import biz_data


class SubscriptionMiddleware:
    def __init__(self, get_response):
        self.get_response = get_response

    def __call__(self, request):
        # The subscription is still active, so continue with the request
        response = self.get_response(request)
        # call after the view
        if not request.user.is_authenticated:
            # Do not perform any subscription checks if the user is not logged in
            return self.get_response(request)
        elif request.user.is_admin or request.user.is_superuser:
            return self.get_response(request)
        elif request.user.is_nugsoft:
            return self.get_response(request)
        if not '/api/' in request.path:
            try:
                bizness = biz_data(request.user)
                try:
                    subscription = LicenseKey.objects.get(business=bizness)
                    if subscription.expiry_date < date.today():
                        subscription.status = False
                        subscription.save()
                        messages.error(request, 'Your subscription has expired!')
                        return HttpResponseRedirect(reverse_lazy('logout'))
                except LicenseKey.DoesNotExist:
                    # User has no active subscription
                    messages.error(request, 'You got no running license!')
                    return HttpResponseRedirect(reverse_lazy('logout'))
            except AttributeError:
                messages.error(request, 'Are you sure you belong to a business')
                return HttpResponseRedirect(reverse_lazy('logout'))

        return response
