import time

import psutil  # For Linux

from commons.logger import logger


# import wmi  # For Windows

class CPUMonitorMiddleware:
    def __init__(self, get_response):
        self.get_response = get_response

    def __call__(self, request):
        # Get CPU usage
        cpu_percent = psutil.cpu_percent(interval=1)  # For Linux
        # cpu_percent = wmi.WMI().Win32_Processor()[0].LoadPercentage  # For Windows

        # Log or store the CPU usage value
        print(f"CPU Usage: {cpu_percent}%")
        logger.debug("CPU Usage: {cpu_percent}%")

        response = self.get_response(request)
        return response


class TimingMiddleware:
    def __init__(self, get_response):
        self.get_response = get_response

    def __call__(self, request):
        start_time = time.time()
        response = self.get_response(request)
        elapsed_time = time.time() - start_time
        logger(f"Request took {elapsed_time:.2f} seconds")
        return response