from urllib import request

import requests
from django.contrib import messages
from django.db import transaction
from django.http import HttpResponseRedirect, JsonResponse
from django.shortcuts import render, get_object_or_404
from django.urls import reverse_lazy
from django.views import View
from django.views.generic import TemplateView, FormView

from accounts.permission_mixin import BusinessUserMixin
from sacco.forms import SMSPlanForm
from sacco.mm_integration.jpesa import Jpesa, logger
from sacco.models import MessagePackage, PaymentTransaction
from sacco.utils import biz_staff


class SmsPackages(BusinessUserMixin, View):
    template_name = 'sacco/sms_packages.html'

    def get(self, request, *args, **kwargs):
        title = 'SMS Packages'
        sms_packages = MessagePackage.objects.filter(status=True)

        return render(request, self.template_name, locals())


# VIEW BUSINESS PROFILE -------------------------
class ChoicePlan(BusinessUserMixin, FormView):
    template_name = 'sacco/sms_plan.html'
    form_class = SMSPlanForm

    def site_url(self):
        http = 'http://' if not self.request.is_secure() else 'https://'

        baseUrl = self.request.headers['HOST']
        baseUrl = http + baseUrl
        return baseUrl


    def get_plan(self):
        pkey = self.kwargs.get("pk")
        plan = get_object_or_404(MessagePackage, id=pkey)
        return plan

    def get_context_data(self, **kwargs):
        context = super().get_context_data(**kwargs)
        sms_plan = self.get_plan()
        context['title'] = sms_plan
        context['sms_plan'] = sms_plan
        context['form'] = self.form_class
        return context

    # @transaction.atomic
    def form_valid(self, form):
        amount = form.cleaned_data['amount']
        phone = form.cleaned_data['phone']
        staff = biz_staff(self.request.user)
        msg = f'Success paid for {self.get_plan().name}'
        Jpesa.payment(amount, msg, phone, self.site_url(), staff.id)
        messages.success(self.request, 'success', extra_tags='Success')
        return super().form_valid(form)

    def form_invalid(self, form):
        messages.error(self.request, 'error', extra_tags='Error')
        return super().form_invalid(form)

    def get_success_url(self):
        return reverse_lazy('choice_plan', args=[self.get_plan().pk])

class PaymentCallBack(View):

    def get(self, *args, **kwargs):
        txt_id = self.request.GET.get('txn_id', None)
        print('have been called', txt_id)
        try:
            trans = PaymentTransaction.objects.get(txt_id=txt_id)
            Jpesa.check_status(trans.jpesaid)
            print('have been saved')
        except PaymentTransaction.DoesNotExist:
            print('not saved')
            return JsonResponse({'msg': 'failed'})
        return JsonResponse({'msg': 'success'}, safe=True)


# class CheckTransStatus(View):
#     def get(self, *args, **kwargs):
#         trans = ''
#
#         return JsonResponse()

