from datetime import date

from django.core.management import BaseCommand
from django.utils import timezone

from accounts.models import Business, Biz_status, Branch_status
from commons.logger import logger
from sacco.models import FinancialYear
from sacco.utils import ref_no, send_bulk_emails
from transactions.models import Account, Transactions, AccountCategory


class Command(BaseCommand):

    def handle(self, *args, **options):
        businesses = Business.objects.filter(status=Biz_status.Active).prefetch_related('branches', 'member_business',
                                                                                        'accounts', 'general_charges')
        logger.debug('starting')
        generate_charges = []
        recipientss = []
        users_data = []
        subject = 'Charge'
        # gen_dict = []
        for business in businesses:
            if business.licence.is_active:
                # print('yes am active', business.pk)
                acc_brokers = business.member_business.all().iterator()  # all broker accounts in business
                # print(acc_brokers)
                branch = business.branches.filter(status=Branch_status.Active).first()  # all active branches

                today = date.today()
                financial_year = FinancialYear.objects.filter(business=business, status=True).first()
                if financial_year is not None:
                    if financial_year.is_within_financial_year(input_date=today):
                        gen_cgs = business.general_charges.filter(execution_period='y', is_revenue='YES', is_fine=False)
                        # print('yeah am there', financial_year.first().name)

                        # if gen_cgs.exists():
                        # gen_dataframe = pd.DataFrame(gen_cgs.values())
                        # print(gen_dataframe)

                        # for gen in gen_cgs:
                        #     amount = gen.amount
                        #     # if gen.is_percentage:
                        #     #     amount = amount * (gen.amount / 100)
                        #     gen_dict.append(
                        #         {
                        #             'id': gen.id,
                        #             'amount': amount,
                        #             'rev_status': gen.is_revenue
                        #         }
                        #     )
                        # gen_charges_df = pd.DataFrame(gen_dict)
                        # print(gen_charges_df)
                        # gen_frame = pd.merge(gen_dataframe, gen_charges_df, on='id')
                        # print(gen_frame)

                        # summing general charges dataframe
                        # total_charges = gen_frame['amount'].sum()

                        if gen_cgs.exists():
                            for broker in acc_brokers:
                                users_data.append(
                                    {
                                        'name': broker.members.biodata.name,
                                        'email': broker.members.biodata.email,
                                        'business': business.name,
                                        'account_number': broker.the_account.acc_number,
                                    }
                                )
                                member_acc = Account.objects.filter(member=broker.the_account_id).first()
                                for ch in gen_cgs:
                                    for item in users_data:
                                        item['charge'] = ch.amount
                                    category = AccountCategory.objects.filter(name='Income', business=business).first()
                                    charged_acc, created = Account.objects.get_or_create(category=category,
                                                                                         name=f'{ch.charge}',
                                                                                         business=business)
                                    if not Transactions.objects.filter(branch=branch,
                                                                       transaction_type=f'{ch.charge}',
                                                                       account_dr=member_acc, account_cr=charged_acc,
                                                                       tx_date__range=[financial_year.start_date,
                                                                                       financial_year.end_date]).exists():
                                        rec_no = ref_no(branch.id)
                                        generate_charges.append(
                                            Transactions(
                                                txno=rec_no,
                                                branch=branch,
                                                transaction_type=f'{ch.charge}',
                                                account_dr=member_acc,
                                                account_cr=charged_acc,
                                                narration="{}".format(ch.charge),
                                                reporting_amount=ch.amount,
                                                receipt=rec_no + 'c',
                                                reference=rec_no + 'c',
                                                tx_date=timezone.now().date()
                                            )
                                        )
        Transactions.objects.bulk_create(generate_charges)
        if len(users_data) > 0:
            ...
            # send_bulk_emails(users_data, subject, 'emails')
