# update_shares_and_savings_balances

from django.core.management import BaseCommand
from datetime import date


from sacco.models import SavingsSharesRecalculate
from sacco.utils import recalculate_shares, recalculate_savings
from transactions.models import Transactions, Account


class Command(BaseCommand):
    def handle(self, *args, **options):
        # get all the records
        all_records = SavingsSharesRecalculate.objects.all()
        for row in all_records:
            if row.update_type == 'shares':
                recalculate_shares(row.branch.id)
            else:
                recalculate_savings(row.branch.business.id)
            SavingsSharesRecalculate.objects.filter(id=row.id).delete()

