from django.db.models import OuterRef, Subquery, Q

from django.core.management import BaseCommand
from datetime import date

from transactions.models import Transactions, Account


class Command(BaseCommand):
    def handle(self, *args, **options):
        # Moving transactions for TELLER 3
        acc_id = 8828
        new_acc_id = 11327

        the_date = date(2024, 1, 3)

        all_trans = Transactions.objects.filter(account_dr_id=acc_id, tx_date=the_date)
        # print('DEBIT',all_trans)
        for trans in all_trans:
            if trans.account_cr.business.id == 3:
                # get the alternate acc in the new business
                need_acc =Account.objects.get(name=trans.account_cr.name, business_id=4)
                Transactions.objects.filter(id=trans.id).update(
                    account_dr_id=new_acc_id,
                    account_cr=need_acc,
                    branch=4
                )
            else:
                Transactions.objects.filter(id=trans.id).update(
                    account_dr_id=new_acc_id,
                    branch=4
                )

        all_trans = Transactions.objects.filter(account_cr_id=acc_id, tx_date=the_date)
        # print('CREDIT',all_trans)
        for trans in all_trans:
            if trans.account_dr.business.id == 3:
                # get the alternate acc in the new business
                need_acc =Account.objects.get(name=trans.account_dr.name, business_id=4)
                Transactions.objects.filter(id=trans.id).update(
                    account_cr_id=new_acc_id,
                    account_dr=need_acc,
                    branch=4
                )
            else:
                Transactions.objects.filter(id=trans.id).update(
                    account_cr_id=new_acc_id,
                    branch=4
                )