from django.core.management import BaseCommand
from django.db.models import Sum, Q, Case, When, FloatField, F

from transactions.models import Transactions, Account


class Command(BaseCommand):
    def handle(self, *args, **options):
        # Money that is give loan

        print('Recalculate savings:')
        all_member_ledgers = Account.objects.filter(member_id=9347)
        for member_ledger in all_member_ledgers:
            try:
                # member_account = MemberAccount.objects.get(id=member_ledger.member_id)
                m_dt = Transactions.objects.filter(account_dr_id=member_ledger.id).aggregate(
                    bal=Sum('reporting_amount', default=0))['bal']
                m_ct = Transactions.objects.filter(account_cr_id=member_ledger.id).aggregate(
                    bal=Sum('reporting_amount', default=0))['bal']
                print('credits', m_ct)
                print('debits', m_dt)
                print(f'new', m_ct - m_dt)
                new_balance = Transactions.objects.filter(
                    Q(account_dr=member_ledger.id) | Q(account_cr=member_ledger.id)).aggregate(
                    bal=Sum(
                        Case(
                            When(account_cr=member_ledger.id, then=F('reporting_amount')),
                            default=0, output_field=FloatField()))
                        - Sum(
                        Case(
                            When(account_dr=member_ledger.id, then=F('reporting_amount')),
                            default=0, output_field=FloatField()))
                )
            finally:
                print('am done')
