# temporary_move_members
import time

from django.core.management import BaseCommand
from django.db.models import Sum

from sacco.models import Member, GroupMember, AccountBroker
from sacco.utils import migrate_single_member


class Command(BaseCommand):
    def handle(self, *args, **options):
        mem_ids = [7640]
        new_business_id = 3
        new_branch_id = 3
        old_branch_id = 4
        old_business_id = 4

        all_members = Member.objects.filter(id__in=mem_ids)
        print(list(all_members.values_list('biodata__name', flat=True)))
        # get the groups the belong to
        the_groups_record = GroupMember.objects.filter(member_id=7640, group__branch_id=old_branch_id ).delete()
        # the_groups_record = GroupMember.objects.filter(member_id=2317, group__branch_id=old_branch_id).delete()

        time.sleep(10)

        for member in all_members:
            # get the broker
            the_broker = AccountBroker.objects.filter(members=member).first()
            migrate_single_member(the_broker, new_branch_id, new_business_id, old_business_id)
