# set_shareholding_start
from django.core.management import BaseCommand
from datetime import datetime
import pandas as pd

from sacco.models import AccountBroker, Member
from sacco.views import Members
from transactions.models import Transactions, Account, SharesTransactions


class Command(BaseCommand):
    def handle(self, *args, **options):
        all_members = Member.objects.all()
        for member in all_members:
            first_share = SharesTransactions.objects.filter(buyer=member).order_by('id').first()
            if first_share is not None:
                Member.objects.filter(id=member.id).update(
                    share_holder_join_date=first_share.date
                )