from django.core.management import BaseCommand
from datetime import datetime
import pandas as pd

from sacco.models import AccountBroker, Member
from transactions.models import Transactions, Account, SharesTransactions


class Command(BaseCommand):
    def handle(self, *args, **options):
        branch_id = 27
        business_id = 26
        date_string = "2023-08-22"  # Replace this with your date string
        date_format = "%Y-%m-%d"  # This should match the format of your date string
        the_date = datetime.strptime(date_string, date_format).date()
        hour = 12
        minute_start = 20
        minute_end = 24

        data = pd.read_excel('sacco/fixtures/shares_correct.xlsx')
        data = data.to_dict('records')

        trans_count = 0
        # minutes_trans = 0

        for acc in data:
            the_account = acc['acc']
            the_ref = acc['ref']
            the_amount = acc['amt']
            print(the_account)
            get_member_id = AccountBroker.objects.filter(the_account__acc_number=the_account,
                                                         business_id=business_id)
            if get_member_id.exists():
                get_member_id = get_member_id.first()
                member_ledger = Account.objects.filter(member_id=get_member_id.the_account_id)[0]

                the_shares = SharesTransactions.objects.filter(
                    buyer_id=get_member_id.members_id,
                    branch_id=branch_id
                )
                print('save_shares', the_shares)

                for save_shares in the_shares:
                    trans = Transactions.objects.filter(shares_id=save_shares.id).first()
                    # print('trans', trans.id, trans.date_added ,trans.date_added.date() ,trans.date_added.time().minute, trans.date_added.time().hour, trans.reporting_amount )
                    trans_date = trans.date_added.date()
                    # trans_hour = trans.date_added.time().hour
                    # trans_minute = trans.date_added.time().minute
                    #
                    # # check date and time
                    # if the_date  == trans_date:
                    #     print('DATE IS THE SAME')
                    #     if trans_hour == hour:
                    #         print('HOUR=========')
                    #         hour_trans += 1
                    #         if trans_minute > minute_start and trans_minute < minute_end:
                    #             print('MINUTE=====')
                    #             minutes_trans += 1
                    # print(f'---TransRec:{trans.receipt}---')
                    # print(f'---Ref:{the_ref}---')
                    # print(f'---{the_ref}{the_ref==trans.receipt.strip()}{trans.receipt}---')
                    if the_date  == trans_date:
                        if str(trans.receipt).strip() == str(the_ref).strip():
                            if float(trans.reporting_amount) == float(the_amount):
                                trans_count = trans_count +1
                                print(f'================== start ===============')
                                print(trans.reporting_amount)
                                print(f'Buyer {save_shares.buyer.biodata.name}')
                                print('--=== End tras======================')
                                # rem trans
                                Transactions.objects.filter(id=trans.id).delete()
                                # reduce shares on member acc
                                the_buyer = Member.objects.filter(id=save_shares.buyer.id)
                                the_buyer.update(shares=(the_buyer.first().shares - save_shares.shares))
                                # rem shares
                                SharesTransactions.objects.filter(id=save_shares.id).delete()

        print(f'=============={trans_count}======================')
        # print(f'=============={minutes_trans}======================')