from django.core.management import BaseCommand
from loans.models import Loans, UploadLoans
from loans.utils.loan_number_creation import get_new_loan_number
from transactions.models import Transactions


class Command(BaseCommand):
    def handle(self, *args, **options):
        #saracen
        loan_upload_id = 363

        all_loans = Loans.objects.filter(upload_id=loan_upload_id)
        for ln in all_loans:
            # ++++++++++++++++++++++++++++  close old loan +++++++++++++++++++++++++++++++
            old_loan_id = ln.topped_up_loan
            old_loan_obj = Loans.objects.filter(id=old_loan_id)
            print('OLD LOAN ID', old_loan_id, old_loan_obj[0].loan_number)
            if old_loan_obj.exists():
                Loans.objects.filter(id=old_loan_id).update(loan_status=3)
                # delete the transaction that closes off the loan and interest
                # trans_type = Loan interest, Loan repayment, old loan - be for the same day
                trans_to_del = Transactions.objects.filter(
                    transaction_type = 'Loan repayment',
                    loan_id=old_loan_id,
                    # date_added__date=ln.created_date
                ).order_by('-id')[:1].values('id', 'reporting_amount')
                print('trans_to_del', trans_to_del)
                old_loan_transactions = Transactions.objects.filter(
                    transaction_type='Loan repayment',
                    loan_id=old_loan_id,
                    # date_added__date=ln.created_date.date()
                ).order_by('-id')[:1]
                if old_loan_transactions.exists():
                    Transactions.objects.filter(id=old_loan_transactions[0].id).delete()
                # containsLoanInterest = False
                # containsLoanRepayment = False
                # # check if both contains loan interest and Loan repayment
                # for trans in old_loan_transactions:
                #     if trans.transaction_type == 'Loan interest':
                #         containsLoanInterest = True
                #     if trans.transaction_type == 'Loan repayment':
                #         containsLoanRepayment = True
                # if containsLoanInterest and containsLoanRepayment:
                #     old_loan_transactions.delete()
                #     print('TRANSACTIONS DELETED', old_loan_id)
                # else:
                #     Transactions.objects.filter(
                #         transaction_type__in=['Loan repayment'],
                #         loan_id=old_loan_id,
                #         date_added=ln.created_date
                #     ).order_by('-id')[:1].delete()
            print('NEW LOAN DETAILS', ln.id, ln.loan_number)
            print('New transactions',Transactions.objects.filter(loan=ln).values('id', 'reporting_amount', 'transaction_type'))
            Transactions.objects.filter(loan=ln).delete()
            Loans.objects.filter(id=ln.id).delete()
            print('----------------- JUST END-----------------------------')
        UploadLoans.objects.filter(id=loan_upload_id).delete()

