from django.core.management import BaseCommand
import json

from loans.models import BouncedLoansUpload, Loans
from transactions.models import Transactions


class Command(BaseCommand):
    def handle(self, *args, **options):
        uploads = [3,6, 9]

        for upload in uploads:
            the_upload = BouncedLoansUpload.objects.get(id=upload)
            all_trans = json.loads(the_upload.transactions_created)['transactions_created']
            for trans in all_trans:
                #get loan
                the_loan = Transactions.objects.get(id=trans).loan
                #delete the the reverse transaction
                Transactions.objects.filter(loan=the_loan, transaction_type='Reverse transaction').delete()
                #change loan status to disbursed
                Loans.objects.filter(id=the_loan.id).update(
                    loan_status=3
                )
            BouncedLoansUpload.objects.filter(id=upload).delete()

