from django.core.management import BaseCommand
from datetime import datetime
import pandas as pd

from sacco.models import AccountBroker, Member
from transactions.models import Transactions, Account, SharesTransactions


class Command(BaseCommand):
    def handle(self, *args, **options):
        branch_id = 27
        business_id = 0

        data = pd.read_excel('sacco/fixtures/the_savings.xlsx')
        data = data.to_dict('records')

        for acc in data:
            acc_no = acc['ACCOUNT NUMBER']
            date_string = acc['DEPOSIT DATE']
            # date_string = "2023-08-22"  # Replace this with your date string
            # date_format = "%d-%m-%Y"  # This should match the format of your date string
            # the_date = datetime.strptime(date_string, date_format).date()
            the_date = pd.to_datetime(date_string, infer_datetime_format=True)
            the_date = the_date.strftime('%Y-%m-%d')
            the_amount = acc['AMOUNT']
            print(acc_no, type(the_date), the_date, the_amount)
            the_actual_acc = Account.objects.filter(member__acc_number =acc_no)
            if the_actual_acc.exists():
                the_trans = Transactions.objects.filter(
                    reporting_amount = float(the_amount),
                    tx_date = the_date,
                    account_cr = the_actual_acc.first()
                )
                print(the_actual_acc.count())
                the_trans.delete()
