from django.core.management import BaseCommand
from datetime import datetime
import pandas as pd

from sacco.models import AccountBroker, Member
from transactions.models import Transactions, Account, SharesTransactions


class Command(BaseCommand):
    def handle(self, *args, **options):
        branch_id = 30
        business_id = 29
        date_string = "2023-05-25"  # Replace this with your date string
        date_format = "%Y-%m-%d"  # This should match the format of your date string
        the_date = datetime.strptime(date_string, date_format).date()

        the_date_added = "2023-10-28"
        the_date_added = datetime.strptime(the_date_added, date_format).date()

        data = pd.read_excel('sacco/fixtures/share_data_tasso.xlsx')
        data = data.to_dict('records')

        trans_count = 0

        for acc in data:
            the_account = acc['acc']
            # the_ref = acc['ref']
            the_amount = acc['amt']
            # print(the_account)
            get_member_id = AccountBroker.objects.filter(the_account__acc_number=the_account,
                                                         business_id=business_id)
            if get_member_id.exists():
                get_member_id = get_member_id.first()
                member_ledger = Account.objects.filter(member_id=get_member_id.the_account_id)[0]

                the_shares = SharesTransactions.objects.filter(
                    buyer_id=get_member_id.members_id,
                    branch_id=branch_id,
                    date=the_date
                )
                print('the shares', the_shares.count())

                for save_shares in the_shares:
                    trans = Transactions.objects.filter(shares_id=save_shares.id).first()
                    trans_date = trans.date_added.date()

                    if the_date_added  == trans_date:
                        print(f'----------{save_shares.id}---------------')
                        # rem trans
                        Transactions.objects.filter(id=trans.id).delete()
                        # reduce shares on member acc
                        the_buyer = Member.objects.filter(id=save_shares.buyer.id)
                        the_buyer.update(shares=(the_buyer.first().shares - save_shares.shares))
                        # rem shares
                        SharesTransactions.objects.filter(id=save_shares.id).delete()

        print(f'=============={trans_count}======================')
